/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

class FolderStructureUtil {
    protected static WAdminResource bundle = new WAdminResource(FolderStructureUtil.class);
    protected static final String BIP_SERVICE_CLASSID = "E5F27790-2149-11D6-8828-AA0004006D06";
    protected static final String BIP_SERVICE_NAME = "BIP Service";
    protected static final String BIP_FOLDER_TYPE = "BIP Folder";
    private static final String SYSTEM_FOLDER = "System";

    FolderStructureUtil() {
    }

    public static List getRootFolders(String reposID, MdFactory factory, MdObjectStore store) throws MdException, RemoteException {
        int flags = 392;
        String options = "<XMLSELECT SEARCH=\"*[@Name='BIP Service' and @ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06']\" />";
        List objectList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposID, "SoftwareComponent", flags, options, false);
        return objectList;
    }

    public static SoftwareComponent getRootFolder(String reposID, MdFactory factory, MdObjectStore store) throws MdException, RemoteException {
        List rootFolders = FolderStructureUtil.getRootFolders(reposID, factory, store);
        if (rootFolders != null && rootFolders.size() > 0) {
            return (SoftwareComponent)rootFolders.get(0);
        }
        return null;
    }

    public static SoftwareComponent getServerRootFolder(MdFactory factory, MdObjectStore store) throws MdException, RemoteException {
        String foundationReposID = factory.getOMIUtil().getFoundationReposID();
        List rootFolders = FolderStructureUtil.getRootFolders(foundationReposID, factory, store);
        if (rootFolders != null && rootFolders.size() > 0) {
            return (SoftwareComponent)rootFolders.get(0);
        }
        return null;
    }

    public static void repairInvalidRootFolderType(SoftwareComponent rootFolder) throws MdException, RemoteException {
        String publicType;
        if (rootFolder != null && ((publicType = rootFolder.getPublicType()) == null || publicType.length() == 0)) {
            rootFolder.setPublicType("RootFolder");
            rootFolder.updateMetadataAll();
        }
    }

    public static void repairMultipleTopLevelFolders(OMIRepositoryInterface repos, SoftwareComponent rootFolder) throws RemoteException, MdException {
        String reposName = repos.getDefaultRepositoryName();
        AssociationList topLevelFolders = rootFolder.getSoftwareTrees();
        if (topLevelFolders.size() > 0) {
            Tree folder;
            int i;
            Tree mainFolder = null;
            Object[] folders = topLevelFolders.toArray();
            for (i = 0; i < folders.length; ++i) {
                folder = (Tree)folders[i];
                if (i == 0) {
                    mainFolder = folder;
                }
                if (!reposName.equalsIgnoreCase(folder.getName())) continue;
                mainFolder = folder;
                break;
            }
            if (mainFolder != null) {
                for (i = 0; i < folders.length; ++i) {
                    folder = (Tree)folders[i];
                    if (folder == mainFolder) continue;
                    folder.getSoftwareComponents().clear();
                }
            }
            MdObjectStore store = (MdObjectStore)rootFolder.getObjectStore();
            store.updatedMetadataAll();
        }
    }

    public static Map getTopLevelFolders(MdFactory factory, String rootFolderID) throws MdException, RemoteException {
        String template = "<Templates><SoftwareComponent><SoftwareTrees search=\"@PublicType='Folder'\"/></SoftwareComponent><Tree Name=\"\" TreeType=\"\" PublicType=\"\" /></Templates>";
        int flags = 260;
        Map treeMap = factory.getOMIUtil().getMetadataNoCache("SoftwareComponent", rootFolderID, template, flags);
        return treeMap;
    }

    public static Map getFolderContents(MdFactory factory, String folderID) throws MdException, RemoteException {
        StringBuffer templateBuffer = new StringBuffer();
        templateBuffer.append("<Templates><Tree Name=\"\" TreeType=\"\" PublicType=\"\" ><SubTrees search=\"@PublicType='Folder'\"/><Members/></Tree>");
        templateBuffer.append("<Root Name=\"\" PublicType=\"\" />");
        templateBuffer.append("</Templates>");
        int flags = 404;
        Map treeMap = factory.getOMIUtil().getMetadataNoCache("Tree", folderID, templateBuffer.toString(), flags);
        return treeMap;
    }

    public static Map getFolderDetails(MdFactory factory, String folderID) throws MdException, RemoteException {
        String template = "<Templates><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>";
        int flags = 396;
        Map treeMap = factory.getOMIUtil().getMetadataNoCache("Tree", folderID, template, flags);
        return treeMap;
    }

    public static List getAllFolders(MdFactory factory, String reposID) throws MdException, RemoteException {
        int flags = 392;
        String options = "<XMLSELECT SEARCH=\"*[@PublicType='Folder']\" />";
        List objectList = factory.getOMIUtil().getMetadataObjectsNoCache("Tree", reposID, options, flags);
        return objectList;
    }

    public static FolderInterface makeRepairObjectFolder(OMIRepositoryInterface repos) throws ServiceException, RemoteException {
        String REPAIR_FOLDER = "Repaired Objects";
        RootFolderInterface parentFolder = null;
        FolderInterface repairFolder = null;
        String reposType = repos.getRepositoryType();
        if ("FOUNDATION".equalsIgnoreCase(reposType)) {
            parentFolder = ((OMIServer)repos.getServer()).getRootFolder();
        } else if ("CUSTOM".equalsIgnoreCase(reposType)) {
            List folders = repos.getRootFolders();
            if (folders.size() <= 0) {
                throw new ServiceException(bundle.formatString("FolderStructureUtil.NoRootFolder.fmt.txt", (Object)repos.getDefaultRepositoryName()));
            }
            parentFolder = (FolderInterface)folders.get(0);
        } else {
            return null;
        }
        if (parentFolder != null) {
            FolderInterface systemFolder = FolderStructureUtil.getSystemFolder((FolderInterface)parentFolder);
            repairFolder = systemFolder.makeSubfolder("Repaired Objects");
            if (repairFolder.getState() == 1) {
                repairFolder.update();
            }
        }
        return repairFolder;
    }

    private static FolderInterface getSystemFolder(FolderInterface parent) throws ServiceException, RemoteException {
        FolderInterface systemFolder = parent.getSubfolder(SYSTEM_FOLDER);
        if (systemFolder == null) {
            systemFolder = parent.makeSubfolder(SYSTEM_FOLDER);
            Tree systemTree = (Tree)systemFolder.getRepositoryEntity();
            systemTree.setTreeType(SYSTEM_FOLDER);
        }
        return systemFolder;
    }
}

