/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.RepositoryComparator;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.management.metadata.tools.ToolsUtility;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.logical.batch.BatchDriverOptions;
import com.sas.metadata.mgmt.MetadataManager;
import com.sas.metadata.mgmt.MetadataManagerFactory;
import com.sas.metadata.remote.MdFactory;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.workspace.IdentityUtil;
import com.sas.workspace.Repository;
import com.sas.workspace.WAdminResource;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;

public final class AnalyzeMetadata
extends BatchDriver2 {
    private static WAdminResource bundle = new WAdminResource(AnalyzeMetadata.class);
    public static final String OPTION_REPAIR = "repair";
    public static final String OPTION_TOOL = "tool";
    public static final String OPTION_GROUP = "group";
    private boolean _repair = false;
    private String _tools = null;
    private String _groups = null;
    private Collection<?> _repositories = null;
    protected MetadataManager metadataManager = null;
    private int _analyzeWarnings = 0;
    private int _analyzeErrors = 0;
    private int _analyzeSteps = 0;

    public AnalyzeMetadata() {
        this._logTimestamps = true;
    }

    public void setRepair(boolean repair) {
        this._repair = repair;
    }

    public void setTools(String tools) {
        this._tools = tools;
    }

    public void setGroups(String groups) {
        this._groups = groups;
    }

    public void setRepositories(Collection<?> repositories) {
        this._repositories = repositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        MetadataManager.ServerState startState;
        block37: {
            startState = null;
            try {
                List<AnalyzeTool> tools;
                block36: {
                    tools = this._groups != null ? ToolsUtility.getInstance().getToolsListByGroup(this._groups) : ToolsUtility.getInstance().getToolsList(this._tools);
                    this.setInitializeLogicalTypes(false);
                    this.initialize();
                    this.logStart();
                    this.logConnectionInfo();
                    if (!IdentityUtil.isUnrestricted((MdFactory)this._factory)) {
                        throw new ServiceException(bundle.getString("AnalyzeMetadata.UserNotUnrestricted.error.txt"));
                    }
                    try {
                        this.metadataManager = this._session != null ? MetadataManagerFactory.getMetadataManager((SessionContextInterface)this._session) : MetadataManagerFactory.getMetadataManager((MdFactory)this._factory);
                        startState = this.metadataManager.getServerState();
                        if (startState.equals((Object)MetadataManager.ServerState.ADMIN)) break block36;
                        if (!startState.equals((Object)MetadataManager.ServerState.READONLY)) {
                            this._logger.info(bundle.getString("AnalyzeMetadata.SettingServerAdminMode.txt"));
                            this.metadataManager.setServerState(MetadataManager.ServerState.ADMIN);
                            break block36;
                        }
                        throw new Exception(bundle.getString("AnalyzeMetadata.ServerReadOnly.error.txt"));
                    }
                    catch (ServiceException e) {
                        if (this._debug) {
                            e.printStackTrace();
                        }
                        throw new ServiceException(bundle.getString("AnalyzeMetadata.GettingServerState.error.txt"));
                    }
                }
                Repository[] repositories = Repository.getRepositories((MdFactory)this._factory);
                if (this._repositories == null) {
                    this._repositories = new TreeSet<Object>(new RepositoryComparator());
                    this._repositories.addAll(this._server.getRepositories(true));
                }
                this._logger.info(bundle.getString("ToolHandler.AnalyzeTools.log.txt"));
                for (AnalyzeTool tool : tools) {
                    String toolInfo = bundle.formatString("ToolHandler.AnalyzeTool.log.fmt.txt", (Object)tool.getName(), (Object)tool.getDescription());
                    this._logger.info(toolInfo);
                }
                for (AnalyzeTool repo : this._repositories) {
                    String repositoryName;
                    OMIRepositoryInterface repository;
                    boolean toolAborted = false;
                    String abortedToolName = null;
                    if (repo instanceof OMIRepositoryInterface) {
                        repository = (OMIRepositoryInterface)repo;
                    } else if (repo instanceof String) {
                        repositoryName = (String)((Object)repo);
                        repository = (OMIRepositoryInterface)this._server.getRepository(repositoryName);
                        if (repository == null) {
                            this._logger.error(bundle.formatString("AnalyzeMetadata.RepositoryDoesNotExist.fmt.txt", (Object)repositoryName));
                            this._rc = 8;
                            continue;
                        }
                    } else {
                        this._logger.error(bundle.formatString("AnalyzeMetadata.InvalidRepository.fmt.txt", (Object)repo.toString()));
                        this._rc = 8;
                        continue;
                    }
                    repositoryName = repository.getDefaultRepositoryName();
                    String reposID = repository.getDefaultRepositoryId();
                    boolean isOffline = Repository.isRepositoryOffline((String)reposID, (Repository[])repositories);
                    if (isOffline) {
                        this._logger.info(bundle.formatString("AnalyzeMetadata.NoAnalysisOffline.fmt.txt", (Object)repositoryName));
                        continue;
                    }
                    Iterator<AnalyzeTool> toolIter = tools.iterator();
                    while (toolIter.hasNext()) {
                        AnalyzeTool tool = toolIter.next().newInstance(repository, this._logger);
                        String toolName = tool.getName();
                        try {
                            if (toolAborted) {
                                this._logger.warn(bundle.formatString("ToolHandler.AnalyzeToolNotRun.Log.txt", (Object)tool.getName(), (Object)repositoryName, abortedToolName));
                                continue;
                            }
                            this._logger.info(bundle.formatString("AnalyzeMetadata.StartToolAnalyze.fmt.txt", (Object)toolName, (Object)repositoryName));
                            ++this._analyzeSteps;
                            tool.analyze();
                            if (this._repair && tool.isRepairNeeded()) {
                                if (!tool.isRepairSupported()) {
                                    this._logger.info(bundle.formatString("AnalyzeMetadata.RepairNotSupported.fmt.txt", (Object)toolName));
                                } else {
                                    this._logger.info(bundle.formatString("AnalyzeMetadata.StartToolRepair.fmt.txt", (Object)toolName, (Object)repositoryName));
                                    tool.repair();
                                }
                            }
                            if (tool.getReturnCode() == 2) {
                                this._rc |= 4;
                                ++this._analyzeWarnings;
                                continue;
                            }
                            if (tool.getReturnCode() == 8) {
                                this._rc |= 8;
                                ++this._analyzeErrors;
                                continue;
                            }
                            if (tool.getReturnCode() != 16) continue;
                            this._rc |= 8;
                            ++this._analyzeErrors;
                            toolAborted = true;
                            abortedToolName = tool.getName();
                        }
                        catch (Throwable t) {
                            if (t.getCause() == null) {
                                this._logger.error(bundle.formatString("AnalyzeMetadata.ToolFailure.fmt.txt", (Object)toolName, (Object)t.getLocalizedMessage()));
                            } else {
                                this._logger.error(bundle.formatString("AnalyzeMetadata.ToolFailure.fmt.txt", (Object)toolName, (Object)t.getCause().getLocalizedMessage()));
                            }
                            if (this._debug) {
                                t.printStackTrace();
                            }
                            this._rc |= 8;
                            ++this._analyzeErrors;
                        }
                        finally {
                            tool.release();
                        }
                    }
                }
                if (this._analyzeErrors == 0 && this._analyzeWarnings == 0) {
                    this._logger.info(bundle.formatString("AnalyzeMetadata.AnalyzeSuccess.fmt.txt", (Object)new Integer(this._analyzeSteps)));
                    break block37;
                }
                if (this._analyzeErrors > 0) {
                    this._logger.info(bundle.formatString("AnalyzeMetadata.AnalyzeErrors.fmt.txt", (Object)new Integer(this._analyzeErrors), (Object)new Integer(this._analyzeSteps)));
                }
                if (this._analyzeWarnings <= 0) break block37;
                this._logger.info(bundle.formatString("AnalyzeMetadata.AnalyzeWarnings.fmt.txt", (Object)new Integer(this._analyzeWarnings), (Object)new Integer(this._analyzeSteps)));
            }
            catch (Throwable throwable) {
                if (startState != null && !startState.equals((Object)MetadataManager.ServerState.ADMIN) && !startState.equals((Object)MetadataManager.ServerState.READONLY)) {
                    this.metadataManager.setServerState(startState);
                }
                this.terminate();
                throw throwable;
            }
        }
        if (startState != null && !startState.equals((Object)MetadataManager.ServerState.ADMIN) && !startState.equals((Object)MetadataManager.ServerState.READONLY)) {
            this.metadataManager.setServerState(startState);
        }
        this.terminate();
        return this._rc;
    }

    protected void parse(String[] args) throws ParseException, MissingOptionException {
        String[] remainingArgs;
        this._options = new Options();
        super.parse(args);
        if (this._help) {
            return;
        }
        this._repair = this._commandLine.hasOption(OPTION_REPAIR);
        if (this._commandLine.hasOption(OPTION_TOOL)) {
            this._tools = this._commandLine.getOptionValue(OPTION_TOOL);
        }
        if (this._commandLine.hasOption(OPTION_GROUP)) {
            this._groups = this._commandLine.getOptionValue(OPTION_GROUP);
        }
        if ((remainingArgs = this._commandLine.getArgs()).length > 0) {
            this._repositories = Arrays.asList(remainingArgs);
        }
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        AnalyzeMetadata analyzer = new AnalyzeMetadata();
        try {
            analyzer.parse(args);
            if (analyzer._help) {
                AnalyzeMetadata.printUsage(analyzer);
                return;
            }
            analyzer.execute();
        }
        catch (Throwable t) {
            analyzer.logException(t);
        }
        analyzer.logCompletion();
        System.exit(analyzer.getReturnCode());
    }

    private static void printUsage(AnalyzeMetadata analyzer) {
        PrintWriter writer = new PrintWriter(System.out);
        HelpFormatter help = new HelpFormatter();
        String NEW_LINE = help.getNewLine();
        writer.println(bundle.getString("AnalyzeMetadata.HelpUsage.txt"));
        writer.println();
        writer.println(bundle.getString("AnalyzeMetadata.Options.txt"));
        help.printOptions(writer, 80, (org.apache.commons.cli.Options)analyzer._options, 3, 3);
        try {
            List<AnalyzeTool> tools = ToolsUtility.getInstance().getToolsList();
            writer.println();
            writer.println(bundle.getString("AnalyzeMetadata.AvailableTools.txt"));
            for (AnalyzeTool tool : tools) {
                writer.append("   ");
                String toolMnemonic = tool.getMnemonic();
                writer.append(toolMnemonic);
                if (toolMnemonic.length() < 12) {
                    writer.append("            ".substring(toolMnemonic.length()));
                }
                writer.append("   ");
                writer.append(tool.getName());
                writer.append(NEW_LINE);
            }
        }
        catch (ServiceException e) {
            writer.flush();
            analyzer.logException(e);
        }
        writer.flush();
    }

    protected class Options
    extends BatchDriverOptions {
        private static final long serialVersionUID = 1L;

        public Options() {
            Option option = new Option(AnalyzeMetadata.OPTION_REPAIR, bundle.getString("AnalyzeMetadata.Repair.Desc.txt"));
            this.addOption(option);
            option = new Option(AnalyzeMetadata.OPTION_TOOL, true, bundle.getString("AnalyzeMetadata.Tool.Desc.txt"));
            option.setArgName(bundle.getString("AnalyzeMetadata.Tool.ArgName.txt"));
            this.addOption(option);
            option = new Option(AnalyzeMetadata.OPTION_GROUP, true, bundle.getString("AnalyzeMetadata.Group.Desc.txt"));
            option.setArgName(bundle.getString("AnalyzeMetadata.Group.ArgName.txt"));
            this.addOption(option);
        }
    }
}

