/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata;

import com.sas.management.metadata.MetaUtility;
import com.sas.management.metadata.UpgradeResult;
import com.sas.management.metadata.UpgradeUtility;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SecurityRuleScheme;
import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.secureddata.SecuredDataFolderUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.Repository;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.mgmt.RepositoryUtil;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.PrototypeWizard;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

final class UpgradeMetadata {
    protected static WAdminResource bundle = new WAdminResource(UpgradeMetadata.class);
    private MdFactory m_MdFactory;
    private MdOMRConnection m_metadataWorkspace;
    private UserContextInterface _userContext;
    private InformationServiceInterface _infoService;
    private IOMI m_omiConnection;
    private Logger _log = null;
    private SessionContextInterface _session = null;
    private UpgradeUtility _upgradeUtility = null;
    private boolean warning = false;

    UpgradeMetadata(MdFactory factory, Logger log) {
        this.m_MdFactory = factory;
        try {
            this.m_metadataWorkspace = this.m_MdFactory.getConnection();
            this.m_omiConnection = this.m_metadataWorkspace.getCMRHandle();
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        this._log = log;
        this._upgradeUtility = UpgradeUtility.getInstance(this.m_MdFactory, this._log);
    }

    UpgradeMetadata(MdFactory factory, SessionContextInterface session, Logger log) {
        this.m_MdFactory = factory;
        try {
            this.m_metadataWorkspace = this.m_MdFactory.getConnection();
            this.m_omiConnection = this.m_metadataWorkspace.getCMRHandle();
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        this._log = log;
        this._session = session;
        this._upgradeUtility = UpgradeUtility.getInstance(this.m_MdFactory, this._log);
    }

    void setUserContext(UserContextInterface userContext) {
        this._userContext = userContext;
    }

    void setInformationService(InformationServiceInterface infoService) {
        this._infoService = infoService;
    }

    UpgradeResult upgradeRepositoryMetadata() {
        ArrayList<Repository> updateList = null;
        boolean upgradeInheritance = false;
        boolean problem = false;
        boolean failure = false;
        boolean nonFoundationFailure = false;
        boolean updateResourceTemplates = false;
        boolean updateTypeDefinitions = false;
        boolean createNewPublicObjects = false;
        boolean updatePublicObjects = false;
        boolean updatedBipTree = false;
        boolean applyAdminACT = false;
        UpgradeResult result = new UpgradeResult();
        int fixpack7FoundationsUpgraded = 0;
        this._log.info(bundle.getString("UpgradeMetadata.Start.txt"));
        try {
            int serverModelVersion;
            Repository[] upgradeReposArray;
            updateTypeDefinitions = true;
            updateResourceTemplates = true;
            createNewPublicObjects = true;
            updatePublicObjects = true;
            upgradeInheritance = true;
            int numFoundations = 0;
            updateList = new ArrayList<Repository>(0);
            for (Repository rep : upgradeReposArray = this._upgradeUtility.getAllRepositoriesAllowedforUpgrade(Repository.getRepositories((MdFactory)this.m_MdFactory))) {
                if (rep.getType().equalsIgnoreCase("FOUNDATION")) {
                    updateList.add(numFoundations, rep);
                    ++numFoundations;
                    continue;
                }
                updateList.add(rep);
            }
            String serverModelVerStr = this.m_MdFactory.getConnection().getServerModelVersion();
            int dotIndex = serverModelVerStr.indexOf(46);
            if (dotIndex == -1) {
                serverModelVersion = Integer.valueOf(serverModelVerStr);
            } else {
                String serverModelshortStr = serverModelVerStr.substring(0, dotIndex);
                serverModelVersion = Integer.valueOf(serverModelshortStr);
            }
            if (updateList.size() > 0) {
                for (int i = 0; i < updateList.size(); ++i) {
                    Repository repos = (Repository)updateList.get(i);
                    int reposModelVersion = RepositoryUtil.getRepositoryFormatVersion((MdFactory)this.m_MdFactory, (String)repos.getFQID());
                    if (reposModelVersion == serverModelVersion) continue;
                    this._log.error(bundle.formatString("UpgradeMetadata.RepositoryUpgradeRequired.Error.Msg1.txt", (Object)repos.getName(), (Object)repos.getFQID()));
                    this._log.error(bundle.getString("UpgradeMetadata.RepositoryUpgradeRequired.Error.Msg2.txt"));
                    result.setMethodResult(2);
                    return result;
                }
            }
            if (updateList != null && updateList.size() > 0) {
                if (!MetaUtility.isUnrestricted(this.m_MdFactory)) {
                    this._log.error(bundle.getString("UpgradeMetadata.UserNotUnrestricted.error.txt"));
                    result.setMethodResult(2);
                    return result;
                }
            } else {
                this._log.info(bundle.getString("UpgradeMetadata.UpToDate.txt"));
                result.setMethodResult(0);
                result.setAlreadyUpToDate(true);
                return result;
            }
            this._log.info(bundle.formatString("UpgradeMetadata.UpgradingRepositories.fmt.txt", (Object)updateList.size()));
            for (int i = 0; i < updateList.size() && !failure; ++i) {
                problem = false;
                boolean createdReposAct = false;
                updatedBipTree = false;
                Repository repos = (Repository)updateList.get(i);
                String type = repos.getType();
                String currentlevel = "9.1.0";
                String currentRelease = "9.1";
                String currentFixpack = "0";
                try {
                    boolean errors;
                    boolean success;
                    try {
                        currentRelease = RepositoryUtil.getCurrentRepositoryUpgradeLevel((MdFactory)this.m_MdFactory, (String)repos.getFQID(), (String)"RELEASE");
                        currentFixpack = RepositoryUtil.getCurrentRepositoryUpgradeLevel((MdFactory)this.m_MdFactory, (String)repos.getFQID(), (String)"FIXPACK");
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    catch (MdException e) {
                        this._log.error(bundle.formatString("UpgradeMetadata.GettingUpgradeLevel.Error.txt", (Object)repos.getFQID(), (Object)e.getMessage()));
                        continue;
                    }
                    catch (RemoteException re) {
                        this.handleRemoteException(re);
                    }
                    this._log.info(bundle.formatString("UpgradeMetadata.UpgradeRepositoryInfo.fmt.txt", (Object)repos.getType(), (Object)repos.getName(), (Object)repos.getFQID(), (Object)currentlevel));
                    if (!problem && (currentlevel.equals("9.1.0") || currentlevel.equals("9.1.2.1") || currentlevel.equals("9.1.3.2") || currentlevel.equals("9.1.3.3") || currentlevel.equals("9.1.3.4") || currentlevel.equals("9.1.3.5"))) {
                        if (type.equalsIgnoreCase("FOUNDATION")) {
                            upgradeInheritance = true;
                            updateResourceTemplates = true;
                            if (this.hasPreAssignedLibraries(repos)) {
                                this._log.warn(bundle.getString("UpgradeMetadata.PreAssignedLibraryFound.warning.txt"));
                                this.warning = true;
                            }
                            this._log.info(bundle.getString("UpgradeMetadata.FoundationPermissions.txt"));
                            RepositoryUtil.createDefaultPermissions((MdFactory)this.m_MdFactory, (String)repos.getFQID());
                        }
                        if (!RepositoryUtil.defaultRepositoryACTExists((MdFactory)this.m_MdFactory, (String)repos.getFQID())) {
                            int rc;
                            if (type.equalsIgnoreCase("FOUNDATION") && (rc = RepositoryUtil.createDefaultIdentityGroups((MdFactory)this.m_MdFactory, (String)repos.getFQID())) != 0) {
                                this._log.error(bundle.formatString("UpgradeMetadata.AddIdentityGroups.Error.txt", (Object)new Integer(rc)));
                                problem = true;
                            }
                            this._log.warn(bundle.formatString("UpgradeMetadata.MissingACT.Info.txt", (Object)repos.getName(), (Object)repos.getFQID()));
                            createdReposAct = RepositoryUtil.createRepositoryACTs((MdFactory)this.m_MdFactory, (Repository)repos);
                        }
                        currentRelease = "9.2.0";
                        currentFixpack = "6";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.2.0.6")) {
                        if (type.equalsIgnoreCase("FOUNDATION")) {
                            upgradeInheritance = true;
                            if (fixpack7FoundationsUpgraded == 0) {
                                int rc = RepositoryUtil.createDefaultIdentityGroups((MdFactory)this.m_MdFactory, (String)repos.getFQID());
                                if (rc != 0) {
                                    this._log.error(bundle.formatString("UpgradeMetadata.AddIdentityGroups.Error.txt", (Object)new Integer(rc)));
                                    problem = true;
                                }
                            } else {
                                this._log.warn(bundle.formatString("UpgradeMetadata.AddIdentityGroupsMultiFoundation.Warn.txt", (Object)repos.getName()));
                                this.warning = true;
                            }
                            ++fixpack7FoundationsUpgraded;
                        }
                        currentRelease = "9.2.0";
                        currentFixpack = "7";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.2.0.7")) {
                        if (type.equalsIgnoreCase("FOUNDATION")) {
                            this._log.info(bundle.getString("UpgradeMetadata.AddDefaultPolicies.txt"));
                            int rc = RepositoryUtil.upgradeToDefaultPolicies((MdFactory)this.m_MdFactory, (String)repos.getFQID());
                            if (rc != 0) {
                                this._log.error(bundle.formatString("UpgradeMetadata.AddPolicies.Error.txt", (Object)new Integer(rc)));
                                problem = true;
                            }
                        }
                        upgradeInheritance = true;
                        updateResourceTemplates = true;
                        currentRelease = "9.2.0";
                        currentFixpack = "8";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.2.0.8")) {
                        updateResourceTemplates = true;
                        updateTypeDefinitions = true;
                        updatePublicObjects = true;
                        applyAdminACT = true;
                        if (type.equalsIgnoreCase("Foundation")) {
                            this._log.info(bundle.getString("UpgradeMetadata.AddIdentityGroups.txt"));
                            int rc = RepositoryUtil.createDefaultIdentityGroups((MdFactory)this.m_MdFactory, (String)repos.getFQID());
                            if (rc != 0) {
                                this._log.error(bundle.formatString("UpgradeMetadata.AddIdentityGroups.Error.txt", (Object)new Integer(rc)));
                                problem = true;
                            }
                            this.upgradeFoundationBIPTree(repos);
                            updatedBipTree = true;
                        } else if (type.equalsIgnoreCase("Custom")) {
                            this.upgradeCustomBIPTree(repos);
                        }
                        this.upgradeto92ACTs(repos);
                        currentRelease = "9.2.0";
                        currentFixpack = "9";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.2.0.9")) {
                        updateResourceTemplates = true;
                        updateTypeDefinitions = true;
                        updatePublicObjects = true;
                        applyAdminACT = true;
                        currentRelease = "9.2.0";
                        currentFixpack = "10";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.2.0.10")) {
                        updateResourceTemplates = true;
                        updateTypeDefinitions = true;
                        updatePublicObjects = true;
                        if (type.equalsIgnoreCase("FOUNDATION")) {
                            try {
                                boolean errors2 = this._upgradeUtility.upgradeUsersFolderProperty(repos);
                                if (errors2) {
                                    problem = true;
                                }
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.UpgradeUsersFolderProperty.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                            try {
                                boolean errors3 = this._upgradeUtility.upgradeContentMappingDocuments(repos);
                                if (errors3) {
                                    problem = true;
                                }
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.UpgradeFolderDocuments.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                        }
                        currentRelease = "9.2.0";
                        currentFixpack = "11";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.2.0.11")) {
                        updateResourceTemplates = true;
                        updateTypeDefinitions = true;
                        updatePublicObjects = true;
                        upgradeInheritance = true;
                        try {
                            boolean errors4 = this._upgradeUtility.upgradePublicNotes(repos);
                            if (errors4) {
                                problem = true;
                            }
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.UpgradePublicNotes.Error.txt", (Object)e.getMessage()));
                            problem = true;
                        }
                        try {
                            boolean errors5 = this._upgradeUtility.upgradeResponsibleParty(repos);
                            if (errors5) {
                                problem = true;
                            }
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.UpgradeResponsibleParty.Error.txt", (Object)e.getMessage()));
                            problem = true;
                        }
                        currentRelease = "9.2.0";
                        currentFixpack = "12";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.2.0.12")) {
                        updateResourceTemplates = true;
                        updateTypeDefinitions = true;
                        updatePublicObjects = true;
                        if (type.equalsIgnoreCase("FOUNDATION")) {
                            this._log.info(bundle.getString("UpgradeMetadata.FoundationPermissions.txt"));
                            int rc = RepositoryUtil.createDefaultPermissions((MdFactory)this.m_MdFactory, (String)repos.getFQID());
                            if (rc != 0) {
                                this._log.error(bundle.formatString("UpgradeMetadata.CreatingDefaultPermissions.Error.txt", (Object)new Integer(rc)));
                                problem = true;
                            }
                        }
                        try {
                            boolean errors6 = this._upgradeUtility.updateMetadataServerClassId(repos);
                            if (errors6) {
                                problem = true;
                            }
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.UpgradeMSClassIdentifier.Error.txt", (Object)"SoftwareComponent", (Object)"ClassIdentifier", (Object)e.getMessage()));
                            problem = true;
                        }
                        if (!type.equalsIgnoreCase("PROJECT")) {
                            try {
                                this._upgradeUtility.adminMetadataPermissionCleanup(repos);
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.AdminMetadataCleanup.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                        }
                        currentRelease = "9.2.0";
                        currentFixpack = "13";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.2.0.13")) {
                        updateResourceTemplates = true;
                        updateTypeDefinitions = true;
                        updatePublicObjects = true;
                        if (type.equalsIgnoreCase("FOUNDATION")) {
                            try {
                                boolean setPermission = RepositoryUtil.setChannelsFolderPermissioninBIPTree((MdFactory)this.m_MdFactory, (Repository)repos);
                                if (!setPermission) {
                                    this._log.warn(bundle.getString("UpgradeMetadata.UpdateChannelFolder.NotFound.Warning.txt"));
                                }
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.UpdateChannelPermission.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                            try {
                                boolean updated = RepositoryUtil.updateTreeTypesinBIPTree((MdFactory)this.m_MdFactory, (Repository)repos);
                                if (!updated) {
                                    this._log.error(bundle.formatString("UpgradeMetadata.UpdateTreeTypes.NotFound.Error.txt", (Object)"TreeType"));
                                    problem = true;
                                }
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.UpdateTreeTypes.Error.txt", (Object)"TreeType", (Object)e.getMessage()));
                                problem = true;
                            }
                        }
                        try {
                            RepositoryUtil.upgradeSecurityDisplayNamesAndDescriptions((MdFactory)this.m_MdFactory, (Repository)repos);
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.UpdateSecurityInfo.Error.txt", (Object)e.getMessage()));
                            problem = true;
                        }
                        currentRelease = "9.2.0";
                        currentFixpack = "14";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.2.0.14")) {
                        updateResourceTemplates = true;
                        updateTypeDefinitions = true;
                        updatePublicObjects = true;
                        upgradeInheritance = true;
                        try {
                            boolean libUpgradeError = this._upgradeUtility.upgradeLibraryDirectory(repos);
                            if (libUpgradeError) {
                                problem = true;
                            }
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.UpdateLibraryDirectory.Error.txt", (Object)e.getMessage()));
                            problem = true;
                        }
                        try {
                            boolean olapUpgradeError = this._upgradeUtility.upgradeOLAPDirectory(repos);
                            if (olapUpgradeError) {
                                problem = true;
                            }
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.UpdateOLAPDirectory.Error.txt", (Object)e.getMessage()));
                            problem = true;
                        }
                        try {
                            boolean orphansError = this._upgradeUtility.removeOrphanedDirectories(repos);
                            if (orphansError) {
                                problem = true;
                            }
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.CleanupDirectoryOrphans.Error.txt", (Object)e.getMessage()));
                            problem = true;
                        }
                        currentRelease = "9.2.0";
                        currentFixpack = "15";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.2.0.15")) {
                        updateResourceTemplates = true;
                        updateTypeDefinitions = true;
                        updatePublicObjects = true;
                        upgradeInheritance = true;
                        if (type.equalsIgnoreCase("Foundation")) {
                            if (!updatedBipTree) {
                                this.upgradeFoundationBIPTree(repos);
                            }
                            try {
                                RepositoryUtil.upgradeSASAdminACT((MdFactory)this.m_MdFactory, (String)repos.getFQID());
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.UpgradeSASAdminACT.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                            try {
                                RepositoryUtil.upgradeSASAdminGroupRoleAssociations((MdFactory)this.m_MdFactory, (String)repos.getFQID(), (boolean)false);
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.upgradeSASAdminRoleAssociations.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                        }
                        if (!type.equalsIgnoreCase("PROJECT")) {
                            try {
                                if (!createdReposAct) {
                                    RepositoryUtil.upgradeRepositoryACT((MdFactory)this.m_MdFactory, (Repository)repos);
                                }
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.UpgradeRepositoryACT.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                        }
                        try {
                            boolean libSchemaUpgradeError = this._upgradeUtility.upgradeLibrarySchema(repos);
                            if (libSchemaUpgradeError) {
                                problem = true;
                            }
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.UpdateLibrarySchema.Error.txt", (Object)e.getMessage()));
                            problem = true;
                        }
                        currentRelease = "9.2.0";
                        currentFixpack = "16";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && (currentlevel.equals("9.2.0.16") || currentlevel.equals("9.2.0.17"))) {
                        updateResourceTemplates = true;
                        updateTypeDefinitions = true;
                        updatePublicObjects = true;
                        upgradeInheritance = true;
                        applyAdminACT = true;
                        if (type.equalsIgnoreCase("Foundation")) {
                            try {
                                RepositoryUtil.upgradeSASAdminACT((MdFactory)this.m_MdFactory, (String)repos.getFQID());
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.UpgradeSASAdminACT.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                            try {
                                RepositoryUtil.upgradePrivateUserFolderACT((MdFactory)this.m_MdFactory, (String)repos.getFQID());
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.UpgradePrivateFolderACT.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                        }
                        try {
                            boolean serverUpgradeError = this._upgradeUtility.upgradeSAPServer(repos);
                            if (serverUpgradeError) {
                                problem = true;
                            }
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.UpdateSAPServerDefinition.Error.txt", (Object)e.getMessage()));
                            problem = true;
                        }
                        currentRelease = "9.2.0";
                        currentFixpack = "18";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && (currentlevel.equals("9.2.0.18") || currentlevel.equals("9.3.0.19"))) {
                        try {
                            this._log.info(bundle.getString("UpgradeMetadata.UpdateNetezzaDefinitions.txt"));
                            boolean netezzaUpgradeError = this._upgradeUtility.upgradeNetezzaServersandLibraries(repos);
                            if (netezzaUpgradeError) {
                                problem = true;
                            }
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.UpdateNetezzaDefinitions.Error.txt", (Object)e.getMessage()));
                            problem = true;
                        }
                        if (currentlevel.equals("9.3.0.19")) {
                            currentRelease = "9.3.0";
                            currentFixpack = "20";
                        } else {
                            currentRelease = "9.2.0";
                            currentFixpack = "19";
                        }
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.2.0.19")) {
                        updateResourceTemplates = true;
                        updateTypeDefinitions = true;
                        updatePublicObjects = true;
                        if ("CUSTOM".equalsIgnoreCase(repos.getType())) {
                            try {
                                RepositoryUtil.createSystemFolder((MdFactory)this.m_MdFactory, (Repository)repos);
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.SystemFolder.Error.fmt.txt", (Object)repos.getName(), (Object)e.getMessage()));
                                problem = true;
                            }
                        }
                        currentRelease = "9.3.0";
                        currentFixpack = "20";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.3.0.20")) {
                        if (type.equalsIgnoreCase("FOUNDATION")) {
                            try {
                                boolean errors7 = this._upgradeUtility.upgradeContentMappingDocuments(repos);
                                if (errors7) {
                                    problem = true;
                                }
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.UpgradeFolderDocuments.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                        }
                        currentRelease = "9.3.0";
                        currentFixpack = "21";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.3.0.21")) {
                        if (type.equalsIgnoreCase("FOUNDATION")) {
                            try {
                                this._log.info(bundle.getString("UpgradeMetadata.RemoveTableServerMetadata.txt"));
                                this._upgradeUtility.removeTableServerMetadata(null);
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.RemoveTableServerMetadata.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                        }
                        ArrayList<String> typesToDelete = new ArrayList<String>(10);
                        typesToDelete.add("LogicalServer.TableServer");
                        typesToDelete.add("DataSourceName");
                        typesToDelete.add("TSNamespace.SQLCatalog");
                        typesToDelete.add("TSName");
                        typesToDelete.add("TSSourceTree");
                        typesToDelete.add("TSNamespace");
                        typesToDelete.add("TSNamespace.SQLSchema");
                        typesToDelete.add("TSNamespace.SQLRoot");
                        typesToDelete.add("TSNamespace.SQLTable");
                        typesToDelete.add("TSNamespace.SQLView");
                        this._log.info(bundle.getString("UpgradeMetadata.TableServerTypeDefinitionsDelete.txt"));
                        this._upgradeUtility.deleteTypeDefinitions(this.m_MdFactory, repos, typesToDelete);
                        currentRelease = "9.3.0";
                        currentFixpack = "22";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.3.0.22")) {
                        if (type.equalsIgnoreCase("FOUNDATION")) {
                            try {
                                this._log.info(bundle.getString("UpgradeMetadata.RemoveAnalyticsPlatformMetadata.txt"));
                                this._upgradeUtility.removeAnalyticsPlatformMetadata(null);
                            }
                            catch (Exception e) {
                                this._log.error(bundle.formatString("UpgradeMetadata.RemoveAnalyticsPlatformMetadata.Error.txt", (Object)e.getMessage()));
                                problem = true;
                            }
                        }
                        currentRelease = "9.3.0";
                        currentFixpack = "23";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (!problem && currentlevel.equals("9.3.0.23")) {
                        currentRelease = "9.3.0";
                        currentFixpack = "24";
                        currentlevel = currentRelease + "." + currentFixpack;
                    }
                    if (upgradeInheritance && type.equalsIgnoreCase("FOUNDATION") && !(success = this.upgradeInheritanceRules(repos))) {
                        problem = true;
                    }
                    if (updateTypeDefinitions && type.equalsIgnoreCase("FOUNDATION")) {
                        this._log.info(bundle.formatString("UpgradeMetadata.UpdateTypeDictionary.fmt.txt", (Object)repos.getName()));
                        ArrayList errorList = new ArrayList();
                        try {
                            RepositoryUtil.addTypeDictionaryDefinitions((MdFactory)this.m_MdFactory, (String)repos.getFQID(), (SessionContextInterface)this._session, errorList, (boolean)false);
                        }
                        catch (Exception e) {
                            this._log.error(e.getMessage());
                            for (int ind = 0; ind < errorList.size(); ++ind) {
                                this._log.error(errorList.get(ind));
                            }
                            problem = true;
                        }
                    }
                    if (createNewPublicObjects && (errors = this.createPublicObjects(repos))) {
                        problem = true;
                    }
                    if (updatePublicObjects && (errors = this.upgradePublicTypeUsageVersion(repos))) {
                        problem = true;
                    }
                    if (updateResourceTemplates) {
                        this._log.info(bundle.getString("UpgradeMetadata.ResourceTemplatesDelete.txt"));
                        try {
                            PrototypeUtil.deleteTemplates((MdFactory)this.m_MdFactory, (String)repos.getFQID(), (String)"All");
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.DeleteTemplates.Error.txt", (Object)e.getMessage()));
                            problem = true;
                        }
                        if (type.equalsIgnoreCase("FOUNDATION")) {
                            this._log.info(bundle.getString("UpgradeMetadata.AddGenericResourceTemplates.txt"));
                            try {
                                this.upgradeto92GenericTemplates(repos);
                            }
                            catch (Exception e) {
                                this._log.error(bundle.getString("UpgradeMetadata.AddGenericResourceTemplates.Error.txt"));
                                if (this._log.isDebugEnabled()) {
                                    this._log.debug("Exception adding Resource Templates", (Throwable)e);
                                }
                                problem = true;
                            }
                        }
                    }
                    if (!problem) {
                        try {
                            RepositoryUtil.createUpdateRecord((MdFactory)this.m_MdFactory, (Repository)repos, (String)currentRelease, (String)currentFixpack);
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.RepositoryId.Message.txt", (Object)repos.getFQID()) + " " + bundle.formatString("UpgradeMetadata.BreadcrumbFailed.txt", (Object)e.getLocalizedMessage()));
                            problem = true;
                        }
                    }
                    if (applyAdminACT) {
                        this._log.info(bundle.getString("UpgradeMetadata.ApplyAdminACT.txt"));
                        try {
                            RepositoryUtil.applyAdminACT((MdFactory)this.m_MdFactory, (Repository)repos);
                        }
                        catch (Exception e) {
                            this._log.error(bundle.formatString("UpgradeMetadata.ApplyAdminACT.Error.txt", (Object)e.getMessage()));
                            problem = true;
                        }
                    }
                    if (problem) {
                        if (repos.getType().equalsIgnoreCase("FOUNDATION")) {
                            failure = true;
                        } else {
                            nonFoundationFailure = true;
                        }
                        this._log.error(bundle.formatString("UpgradeMetadata.UpgradeRepository.CompletedWithErrors.txt", (Object)repos.getName()));
                        continue;
                    }
                    this._log.info(bundle.formatString("UpgradeMetadata.UpgradeRepository.Completed.txt", (Object)repos.getName()));
                    continue;
                }
                catch (Exception e) {
                    problem = true;
                    this._log.error(bundle.formatString("UpgradeMetadata.GenericException.txt", (Object)e.getMessage()));
                    if (repos.getType().equalsIgnoreCase("FOUNDATION")) {
                        failure = true;
                        throw e;
                    }
                    this._log.error(bundle.formatString("UpgradeMetadata.UpgradeRepository.AbortedWithErrors.txt", (Object)repos.getName()));
                    this._log.warn(bundle.getString("UpgradeMetadata.UpgradeRepository.StatusOffline.txt"));
                    nonFoundationFailure = true;
                    repos.setExtendedAccess(4);
                    try {
                        repos.persist();
                        continue;
                    }
                    catch (Exception exc) {
                        if (exc.getMessage().length() > 0) {
                            this._log.error(exc.getMessage());
                            continue;
                        }
                        exc.printStackTrace();
                    }
                }
            }
            if (!failure) {
                if (nonFoundationFailure) {
                    this._log.warn(bundle.getString("UpgradeMetadata.NonFoundationFailure.txt"));
                    this._log.warn(bundle.getString("UpgradeMetadata.NonFoundationFailure2.txt"));
                    this._log.warn(bundle.getString("UpgradeMetadata.NonFoundationFailure3.txt"));
                    result.setMethodResult(1);
                } else if (this.warning) {
                    this._log.info(bundle.getString("UpgradeMetadata.Warning.txt"));
                    result.setMethodResult(1);
                } else {
                    this._log.info(bundle.getString("UpgradeMetadata.Success.txt"));
                    result.setMethodResult(0);
                }
                return result;
            }
            this._log.error(bundle.getString("UpgradeMetadata.Failed.txt"));
            result.setMethodResult(2);
            return result;
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeMetadata.GenericException.txt", (Object)e.getMessage()));
            this._log.info("");
            this._log.error(bundle.getString("UpgradeMetadata.Failed.txt"));
            result.setMethodResult(2);
            return result;
        }
        catch (OutOfMemoryError me) {
            this._log.error(bundle.formatString("UpgradeMetadata.OutofMemoryError.txt", (Object)me.getMessage()));
            this._log.info("");
            this._log.error(bundle.getString("UpgradeMetadata.Failed.txt"));
            result.setMethodResult(2);
            return result;
        }
    }

    private boolean createPublicObjects(Repository repos) throws RemoteException, ServiceException {
        boolean error;
        block7: {
            error = false;
            String type = repos.getType();
            if ("FOUNDATION".equalsIgnoreCase(type) || "CUSTOM".equalsIgnoreCase(type)) {
                ServerInterface server;
                String BILINEAGE_REPOS_NAME = "BILineage";
                if ("CUSTOM".equalsIgnoreCase(type) && "BILineage".equalsIgnoreCase(repos.getName()) && "BILineage".equalsIgnoreCase(repos.getDesc())) {
                    return error;
                }
                if (this._userContext != null && this._infoService != null && (server = this._userContext.getAuthServer()) != null) {
                    RepositoryInterface ri;
                    if ("FOUNDATION".equalsIgnoreCase(type)) {
                        server.loadTypes(true);
                    }
                    if ((ri = server.getRepository(repos.getName())) instanceof OMIRepositoryInterface) {
                        try {
                            SecuredDataFolderUtil.makeSecuredLibrariesFolder((InformationServiceInterface)this._infoService, (OMIRepositoryInterface)((OMIRepositoryInterface)ri));
                        }
                        catch (ServiceException e) {
                            error = true;
                            this._log.error(bundle.formatString("UpgradeMetadata.AddSecuredLibrariesFolder.Error.fmt.txt", (Object)e.getMessage()));
                            if (!this._log.isDebugEnabled()) break block7;
                            this._log.debug("Exception creating objects", (Throwable)e);
                        }
                    }
                }
            }
        }
        return error;
    }

    private void upgradeto92GenericTemplates(Repository repos) throws Exception {
        String strReposid = repos.getFQID();
        PrototypeWizard.addAll((MdFactory)this.m_MdFactory, (String)strReposid);
    }

    private void upgradeto92ACTs(Repository repos) throws Exception {
        this._log.info(bundle.getString("UpgradeMetadata.UpgradeExistingDefaultACT.txt"));
        try {
            RepositoryUtil.upgradeRepositoryACT((MdFactory)this.m_MdFactory, (Repository)repos);
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeMetadata.UpgradeExistingDefaultACT.Error.txt", (Object)e.getMessage()));
            throw e;
        }
        if (repos.getType().equalsIgnoreCase("FOUNDATION")) {
            this._log.info(bundle.getString("UpgradeMetadata.AddAdditionalFoundationACTs.txt"));
            try {
                RepositoryUtil.addAdditionalFoundationRepositoryACTs((MdFactory)this.m_MdFactory, (Repository)repos);
            }
            catch (Exception e) {
                this._log.error(bundle.formatString("UpgradeMetadata.AddAdditionalFoundationACTs.Error.txt", (Object)e.getMessage()));
                throw e;
            }
        }
    }

    private void upgradeFoundationBIPTree(Repository repos) throws Exception {
        this._log.info(bundle.formatString("UpgradeMetadata.BIPSoftwareTree.txt", (Object)repos.getName()));
        try {
            RepositoryUtil.upgradeBIPTree((MdFactory)this.m_MdFactory, (Repository)repos);
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeMetadata.BIPSoftwareTree.Error.txt", (Object)e.getMessage()));
            throw e;
        }
    }

    private void upgradeCustomBIPTree(Repository repos) throws Exception {
        this._log.info(bundle.formatString("UpgradeMetadata.BIPSoftwareTree.txt", (Object)repos.getName()));
        try {
            RepositoryUtil.upgradeCustomBIPTree((MdFactory)this.m_MdFactory, (Repository)repos);
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeMetadata.BIPSoftwareTree.Error.txt", (Object)e.getMessage()));
            throw e;
        }
    }

    private boolean upgradeInheritanceRules(Repository repos) {
        SecurityRuleScheme defaultScheme = null;
        String strReposid = repos.getFQID();
        try {
            defaultScheme = RepositoryUtil.findDefaultInheritanceRule((MdFactory)this.m_MdFactory, (String)strReposid);
        }
        catch (Exception e) {
            this._log.info(bundle.getString("UpgradeMetadata.SecurityRuleFetchError.txt"), (Throwable)e);
        }
        try {
            this._log.info(bundle.getString("UpgradeMetadata.AddSecurityRules.txt"));
            RepositoryUtil.upgradeDefaultInheritanceRules((MdFactory)this.m_MdFactory, (String)strReposid);
        }
        catch (Exception e) {
            this._log.error(bundle.getString("UpgradeMetadata.SecurityRuleAddError.txt"), (Throwable)e);
            return false;
        }
        try {
            if (defaultScheme != null) {
                this._log.info(bundle.getString("UpgradeMetadata.DeleteSecurityRules.txt"));
                boolean success = RepositoryUtil.deleteInheritanceRules((MdFactory)this.m_MdFactory, (String)strReposid, (SecurityRuleScheme)defaultScheme);
                if (!success) {
                    this._log.warn(bundle.getString("UpgradeMetadata.SecurityRuleDeleteError.txt"));
                    this.warning = true;
                }
            } else {
                this._log.info(bundle.getString("UpgradeMetadata.NoSecurityRules.txt"));
            }
        }
        catch (Exception e) {
            this._log.warn(bundle.getString("UpgradeMetadata.SecurityRuleDeleteError.txt"), (Throwable)e);
            this.warning = true;
        }
        this.batchRefreshServer();
        return true;
    }

    private boolean upgradePublicTypeUsageVersion(Repository repos) {
        boolean problem = false;
        this._log.info(bundle.formatString("UpgradeMetadata.AddTypeVersion.txt", (Object)"UsageVersion", (Object)"PublicType"));
        try {
            int rc = this._upgradeUtility.addPublicTypeUsageVersion(repos);
            if (rc == 8) {
                problem = true;
            } else if (rc == 4) {
                this._log.warn(bundle.getString("UpgradeMetadata.PublicObjectTypeUsageRulesUpdate.Warning.txt"));
                this.warning = true;
            }
        }
        catch (Exception e) {
            this._log.error(bundle.formatString("UpgradeMetadata.AddTypeVersion.Error.txt", (Object)"UsageVersion", (Object)"PublicType", (Object)e.getMessage()));
            problem = true;
        }
        return problem;
    }

    private boolean hasPreAssignedLibraries(Repository repos) {
        MdObjectStore tempStore = this.createStore();
        this._log.info("Query PreAssigned Libraries.");
        String reposId = repos.getFQID();
        String options = "<XMLSELECT search=\"@IsPreAssigned='1'\"/>";
        int flags = 16512;
        try {
            List libraries = this.m_MdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)tempStore, reposId, "SASLibrary", flags, options, false);
            if (libraries.size() > 0) {
                tempStore.dispose();
                return true;
            }
        }
        catch (MdException e) {
            this._log.warn("Result of hasPreAssignedLibraries:" + e.getMessage());
            this.warning = true;
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        this.disposeStore(tempStore);
        return false;
    }

    protected void batchRefreshServer() {
        block4: {
            boolean paused = false;
            IServer m_server = null;
            try {
                m_server = this.m_metadataWorkspace.MakeIServerConnection(this.m_omiConnection);
                this._log.info(bundle.getString("UpgradeMetadata.RefreshServerForSecurityRules.txt"));
                paused = true;
                m_server.Refresh("<Server/> <CLUSTER/>");
                paused = false;
            }
            catch (Exception exc) {
                this._log.error(bundle.getString("UpgradeMetadata.ErrorRefreshingServer.txt"), (Throwable)exc);
                if (!paused) break block4;
                try {
                    m_server.Resume("<Server/> <CLUSTER/>");
                }
                catch (Exception exc2) {
                    this._log.error(bundle.getString("UpgradeMetadata.ErrorResumingServer.txt"), (Throwable)exc2);
                }
            }
        }
    }

    protected MdObjectStore createStore() {
        MdObjectStore newStore = null;
        try {
            newStore = this.m_MdFactory.createObjectStore();
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        return newStore;
    }

    protected void disposeStore(MdObjectStore store) {
        try {
            store.dispose();
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
    }

    private void handleRemoteException(RemoteException re) {
        this._log.error("Unexpected RemoteException.", (Throwable)re);
    }
}

