/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata;

import com.sas.management.metadata.ObjectUpgrade;
import com.sas.management.metadata.RepositoryUpgrade2;
import com.sas.management.metadata.UpgradeException;
import com.sas.management.metadata.UpgradeMetadata;
import com.sas.management.metadata.UpgradeResult;
import com.sas.management.metadata.tools.AnalyzeMetadata;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.logical.batch.BatchDriverOptions;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.workspace.WAdminResource;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;

public final class UpgradeDriver2
extends BatchDriver2 {
    private static WAdminResource bundle = new WAdminResource(UpgradeDriver2.class);
    public static final int METHOD_MODEL = 1;
    public static final int METHOD_METADATA = 2;
    public static final int METHOD_OBJECT = 4;
    public static final int METHOD_ALL = 7;
    public static final String OPTION_METHOD = "method";
    public static final String OPTION_MIGRATE = "migrate";
    public static final String ALL_METHOD = "ALL";
    public static final String OBJECT_METHOD = "OBJECT";
    public static final String METADATA_METHOD = "METADATA";
    public static final String MODEL_METHOD = "MODEL";
    public static final int FATAL = 16;
    protected int _method = 7;
    private boolean _migrate = false;

    public UpgradeDriver2() {
        this._utilityName = "UpgradeMetadata";
        this._logTimestamps = true;
    }

    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new Options();
        super.parse(args);
        if (this._help) {
            return;
        }
        String method = this._commandLine.getOptionValue(OPTION_METHOD);
        if (method != null) {
            String method2 = method.toUpperCase();
            if (method2.endsWith("UPGRADE")) {
                method2 = method2.substring(0, method2.length() - 7);
            }
            if (method2.equalsIgnoreCase("REPOSITORY") || method2.equalsIgnoreCase(ALL_METHOD)) {
                this._method = 7;
            } else if (method2.equalsIgnoreCase(MODEL_METHOD) || method2.equalsIgnoreCase("PHYSICAL")) {
                this._method = 1;
            } else if (method2.equalsIgnoreCase(METADATA_METHOD)) {
                this._method = 2;
            } else if (method2.equalsIgnoreCase(OBJECT_METHOD)) {
                this._method = 4;
            } else {
                throw new ParseException(bundle.formatString("UpgradeDriver2.InvalidMethod.fmt.log", (Object)method2));
            }
        }
        if (this._commandLine.hasOption(OPTION_MIGRATE)) {
            this.setMigrate(true);
        }
    }

    public void setMethod(int method) {
        if (method <= 0 || method > 7) {
            throw new IllegalArgumentException(bundle.formatString("UpgradeDriver2.InvalidMethod.fmt.log", (Object)Integer.toString(method)));
        }
        this._method = method;
    }

    public void setMigrate(boolean migrate) {
        this._migrate = migrate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int upgrade() throws Exception {
        block32: {
            try {
                Object upgrade;
                this.initializeNoConnection();
                InformationServiceInterface infoService = CorePlatformServices.getInformationService();
                if (infoService != null) {
                    infoService.setOption(3, (Object)new Boolean(false));
                }
                this.logStart();
                this.logConnectionInfo();
                if ((this._method & 3) != 0) {
                    this.setInitializeLogicalTypes(false);
                    this.connect();
                    try {
                        int analyzeRc;
                        if ((this._method & 1) != 0) {
                            upgrade = new RepositoryUpgrade2(this._factory, this._session, this._logger);
                            ((RepositoryUpgrade2)upgrade).upgradeRepositoryModel(this._migrate);
                        }
                        if ((this._method & 7) == 7 && (analyzeRc = this.analyze()) > this._rc) {
                            this._rc = analyzeRc;
                        }
                        if ((this._method & 2) != 0) {
                            upgrade = new UpgradeMetadata(this._factory, this._session, this._logger);
                            ((UpgradeMetadata)upgrade).setInformationService(infoService);
                            ((UpgradeMetadata)upgrade).setUserContext(this._user);
                            UpgradeResult result = new UpgradeResult();
                            result = ((UpgradeMetadata)upgrade).upgradeRepositoryMetadata();
                            int upgradeMetadataRc = result.getMethodResult();
                            if (upgradeMetadataRc == 2) {
                                this._rc = 16;
                            } else if (upgradeMetadataRc == 1) {
                                this._rc = 4;
                            }
                        }
                    }
                    finally {
                        this.disconnect();
                    }
                }
                if ((this._method & 4) == 0 || this._rc >= 8) break block32;
                try {
                    this.setInitializeLogicalTypes(true);
                    this.connect();
                    upgrade = new ObjectUpgrade(this._session, this._logger, this._loggersWithLogFileAppender);
                    try {
                        int objectUpgradeRc = ((ObjectUpgrade)upgrade).upgrade();
                        if (objectUpgradeRc > this._rc) {
                            this._rc = objectUpgradeRc;
                        }
                    }
                    finally {
                        ((ObjectUpgrade)upgrade).dispose();
                    }
                }
                catch (LogicalTypeException e) {
                    throw new UpgradeException(bundle.getString("UpgradeDriver2.ServicesDeploymentError.log"), e);
                }
                finally {
                    this.disconnect();
                }
            }
            catch (Throwable t) {
                this.logException(t);
                this._rc = 16;
            }
            finally {
                try {
                    this.terminate();
                }
                catch (Exception infoService) {}
            }
        }
        return this._rc;
    }

    private int analyze() throws Exception {
        AnalyzeMetadata analyzer = new AnalyzeMetadata();
        analyzer.setParent(this);
        analyzer.setGroups("Physical Security");
        analyzer.setRepair(true);
        analyzer.execute();
        return analyzer.getReturnCode();
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        UpgradeDriver2 upgrader = new UpgradeDriver2();
        try {
            upgrader.parse(args);
            if (upgrader._help) {
                HelpFormatter help = new HelpFormatter();
                help.printHelp(bundle.getString("UpgradeDriver2.HelpUsage.txt"), bundle.getString("UpgradeDriver2.Options.txt"), (org.apache.commons.cli.Options)upgrader._options, null);
                return;
            }
            upgrader.upgrade();
        }
        catch (Throwable t) {
            upgrader.logException(t);
        }
        upgrader.logCompletion();
        System.exit(upgrader.getReturnCode());
    }

    class Options
    extends BatchDriverOptions {
        private static final long serialVersionUID = 1L;

        public Options() {
            Option option = new Option(UpgradeDriver2.OPTION_METHOD, true, bundle.formatString("UpgradeDriver2.Method.Desc.fmt.txt", (Object)UpgradeDriver2.ALL_METHOD, (Object)UpgradeDriver2.MODEL_METHOD, (Object)UpgradeDriver2.METADATA_METHOD, (Object)UpgradeDriver2.OBJECT_METHOD));
            option.setArgName(bundle.getString("UpgradeDriver2.Method.ArgName.txt"));
            this.addOption(option);
            option = new Option(UpgradeDriver2.OPTION_MIGRATE, bundle.getString("UpgradeDriver2.Migrate.Desc.txt"));
            this.addOption(option);
        }
    }
}

