/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata;

import com.sas.management.metadata.UpgradeException;
import com.sas.management.metadata.UpgradeUtility;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.mgmt.MetadataManager;
import com.sas.metadata.mgmt.MetadataManagerFactory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.workspace.Repository;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

final class RepositoryUpgrade2 {
    MdFactory _factory;
    IServer _server = null;
    SessionContextInterface _session;
    Logger _log = null;
    protected static WAdminResource bundle = new WAdminResource(RepositoryUpgrade2.class);

    RepositoryUpgrade2(MdFactory factory, SessionContextInterface session, Logger log) {
        this._factory = factory;
        this._session = session;
        this._log = log;
    }

    void upgradeRepositoryModel() throws UpgradeException {
        this.upgradeRepositoryModel(false);
    }

    void upgradeRepositoryModel(boolean forceModelUpgrade) throws UpgradeException {
        boolean rmgrUpgrade;
        this._log.info(bundle.getString("RepositoryUpgrade2.Start.log"));
        try {
            MdOMRConnection workspace = this._factory.getConnection();
            this._server = workspace.MakeIServerConnection(workspace.getCMRHandle());
        }
        catch (RemoteException e) {
            throw new UpgradeException(bundle.formatString("RepositoryUpgrade2.ConnectionError.log", (Object)e.getLocalizedMessage()));
        }
        catch (MdException e) {
            throw new UpgradeException(bundle.formatString("RepositoryUpgrade2.ConnectionError.log", (Object)e.getLocalizedMessage()));
        }
        UpgradeUtility upgradeUtility = UpgradeUtility.getInstance(this._factory, this._log);
        Map<String, String> reposMgrMap = null;
        Repository[] reposArray = null;
        try {
            reposMgrMap = upgradeUtility.getRepositoryMgrInfo();
            if (reposMgrMap != null) {
                reposArray = Repository.getRepositories((MdFactory)this._factory);
            }
        }
        catch (Exception e) {
            throw new UpgradeException(bundle.formatString("RepositoryUpgrade2.GetRepositoriesError.log", (Object)e.getLocalizedMessage()));
        }
        if (reposMgrMap == null || reposArray == null || reposArray.length == 0) {
            throw new UpgradeException(bundle.getString("RepositoryUpgrade2.NoRepositories.log"));
        }
        Repository[] upgradeReposArray = null;
        if (forceModelUpgrade) {
            upgradeReposArray = upgradeUtility.getAllRepositoriesAllowedforUpgrade(reposArray);
            if (upgradeReposArray == null) {
                return;
            }
            rmgrUpgrade = true;
        } else {
            try {
                upgradeReposArray = upgradeUtility.getUpgradeableRepositories(this._factory.getConnection(), this._server, reposArray);
                if (upgradeReposArray == null) {
                    return;
                }
                rmgrUpgrade = upgradeUtility.checkRepositoryMgrNeedsUpgrade(this._server, "A0000001.A0000001");
            }
            catch (Exception e) {
                throw new UpgradeException(bundle.formatString("RepositoryUpgrade2.GetUpgradeableRepositoriesError.log", (Object)e.getLocalizedMessage()));
            }
        }
        if (rmgrUpgrade || upgradeReposArray.length > 0) {
            StringBuffer replicateXMLRequest = new StringBuffer();
            if (!upgradeUtility.buildUpgradeXMLRequest(replicateXMLRequest, reposMgrMap, upgradeReposArray, this._server, forceModelUpgrade)) {
                throw new UpgradeException(bundle.getString("RepositoryUpgrade2.UpgradeRequestBuildError.log"));
            }
            String strXML = replicateXMLRequest.toString();
            Document doc = null;
            try {
                MetadataManager m_metadataManager;
                if (this._log.isDebugEnabled()) {
                    try {
                        this._log.debug(bundle.formatString("RepositoryUpgrade2.UpgradeXML.fmt.log", (Object)this._factory.getOMIUtil().formatXML(strXML)));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                if ((doc = (m_metadataManager = this._session != null ? MetadataManagerFactory.getMetadataManager((SessionContextInterface)this._session) : MetadataManagerFactory.getMetadataManager((MdFactory)this._factory)).doRequestWithExclusiveServerLock(strXML)) == null) {
                    throw new UpgradeException(bundle.getString("RepositoryUpgrade2.ServerDoRequestError.log"));
                }
            }
            catch (ServiceException e) {
                String serverMsg = e.getLocalizedMessage();
                if (serverMsg != null) {
                    throw new UpgradeException(bundle.formatString("RepositoryUpgrade2.ServerUpgradeError.log", (Object)serverMsg));
                }
                throw new UpgradeException(bundle.getString("RepositoryUpgrade2.ServerUpgradeError.NoMsg.log"));
            }
            this.pauseResumeServer();
        } else {
            this._log.info(bundle.getString("RepositoryUpgrade2.NoConversionNeeded.log"));
        }
        this.removeDependencies();
        this._log.info(bundle.getString("RepositoryUpgrade2.Success.log"));
    }

    protected void pauseResumeServer() throws UpgradeException {
        try {
            this._log.info(bundle.getString("RepositoryUpgrade2.PausingServer.log"));
            this._server.Pause("<SERVER State=\"OFFLINE\"/> <CLUSTER/>");
            this._log.info(bundle.getString("RepositoryUpgrade2.ResumingServer.log"));
            this._server.Resume("<SERVER/> <CLUSTER/>");
        }
        catch (Exception e) {
            throw new UpgradeException(bundle.getString("RepositoryUpgrade2.PauseResumeServerError.log"), e);
        }
    }

    protected void removeDependencies() throws UpgradeException {
        NodeList reposNodes;
        try {
            IOMI omiConnection = this._factory.getConnection().getCMRHandle();
            StringHolder outXML = new StringHolder();
            omiConnection.GetMetadataObjects("A0000001.A0000001", "RepositoryBase", outXML, "REPOS", 128, "<XMLSelect search=\"RepositoryBase[DependencyUses/RepositoryBase]\"/>");
            String outXMLString = outXML.value;
            Document response = this._factory.getOMIUtil().parseXML(outXMLString);
            reposNodes = response.getElementsByTagName("RepositoryBase");
            if (reposNodes.getLength() <= 0) {
                return;
            }
        }
        catch (Exception e) {
            throw new UpgradeException(bundle.getString("RepositoryUpgrade2.CheckDependenciesError.log"), e);
        }
        this._log.info(bundle.getString("RepositoryUpgrade2.RemoveDependencies.log"));
        StringBuffer inXML = new StringBuffer();
        inXML.append("<UpdateMetadata><Metadata>\n");
        for (int i = 0; i < reposNodes.getLength(); ++i) {
            inXML.append("<RepositoryBase Id=\"");
            inXML.append(reposNodes.item(i).getAttributes().getNamedItem("Id").getNodeValue());
            inXML.append("\"><DependencyUses Function=\"REPLACE\"/></RepositoryBase>\n");
        }
        inXML.append("</Metadata><Reposid>A0000001.A0000001</Reposid><NS>REPOS</NS><Flags>268435456</Flags></UpdateMetadata>");
        try {
            MetadataManager m_metadataManager = this._session != null ? MetadataManagerFactory.getMetadataManager((SessionContextInterface)this._session) : MetadataManagerFactory.getMetadataManager((MdFactory)this._factory);
            m_metadataManager.doRequestWithExclusiveServerLock(inXML.toString());
        }
        catch (Exception e) {
            throw new UpgradeException(bundle.getString("RepositoryUpgrade2.RemoveDependenciesError.log"), e);
        }
    }
}

