/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata;

import com.sas.management.metadata.MetaUtility;
import com.sas.management.metadata.RepositoryInitialization;
import com.sas.management.util.MetaServerConnection;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Prototype;
import com.sas.services.ServiceException;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.deployment.Environment;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.security.ConnectionProfile;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.workspace.Repository;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.mgmt.RepositoryUtil;
import com.sas.workspace.mgmt.visuals.PrototypeWizard;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import org.omg.CORBA.StringHolder;

public class MetaMgrMain {
    protected static final int RETURN_CODE_SUCCESS = 0;
    protected static final int RETURN_CODE_WARNING = 1;
    protected static final int RETURN_CODE_ERROR = 2;
    protected static final boolean STORE_USER_DEFINITIONS = false;
    protected static final boolean USER_PATH_LOCATION = false;
    protected static String m_method = null;
    protected static String m_host = null;
    protected static String m_port = null;
    protected static String m_user = null;
    protected static char[] m_password = null;
    protected static String m_wsfile = null;
    private static boolean m_passwordOnStandardIn = false;
    protected static String m_createMethod = "createRepository";
    protected static String m_initializeMethod = "initializeRepository";
    protected static String m_deleteTemplateMethod = "deleteTemplates";
    protected static String m_repositoryUpgradeMethod = "repositoryUpgrade";
    protected static String m_metadataUpgradeMethod = "metadataUpgrade";
    protected static String m_registerMethod = "registerRepository";
    protected static int m_platformVersion;
    protected static int m_argsCount;
    protected static String m_serverlogline;
    protected static MdFactory m_MdFactory;
    protected static MdObjectStore m_store;
    protected static boolean foundDebug;
    protected static boolean foundHost;
    protected static boolean foundPort;
    protected static boolean foundUser;
    protected static boolean foundPass;
    protected static boolean foundWsfile;
    protected static SessionContextInterface _session;
    protected static ServerInterface _server;
    protected static UserContextInterface _user;
    private static ConnectionProfile _connectionProfile;
    protected boolean _remoteServicesDeployment = false;
    protected static FileOutputStream logFile;
    protected static MetaServerConnection ms;
    protected static WAdminResource bundle;
    protected static List m_itemsList;
    private static int _rc;

    private MetaMgrMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block48: {
            String error;
            MdOMRConnection metaws = null;
            try {
                m_MdFactory = new MdFactoryImpl(false);
                m_MdFactory.setDebug(false);
                m_MdFactory.setLoggingEnabled(false);
                m_MdFactory.getUtil().setLogStream((OutputStream)System.out);
                m_MdFactory.getUtil().setOutputStream((OutputStream)System.out);
                metaws = m_MdFactory.getConnection();
            }
            catch (Exception e) {
                String error2 = e.getLocalizedMessage();
                if (error2 != null) {
                    MetaUtility.MessageSet(m_MdFactory, error2);
                } else {
                    e.printStackTrace();
                }
                System.exit(2);
            }
            m_argsCount = args.length;
            for (int i = 0; i < m_argsCount; ++i) {
                if (args[i].equalsIgnoreCase("-method")) {
                    m_method = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-host")) {
                    String host = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                    if (host == null) continue;
                    m_host = host;
                    foundHost = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-port")) {
                    String port = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                    if (port == null) continue;
                    m_port = port;
                    foundPort = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-user")) {
                    String user = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                    if (user == null) continue;
                    m_user = user;
                    foundUser = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-password")) {
                    char[] pass = MetaUtility.getArgumentValue(i + 1, m_argsCount, args).toCharArray();
                    if (pass == null) continue;
                    m_password = pass;
                    foundPass = true;
                    pass = null;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-wsfile")) {
                    String wsfile = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                    if (wsfile == null) continue;
                    m_wsfile = wsfile;
                    foundWsfile = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-logfile")) {
                    String log = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                    if (log == null) continue;
                    logFile = MetaUtility.setOutputStream(m_MdFactory, log);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-password_on_stdin")) {
                    String stdinpass = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                    if (!stdinpass.equalsIgnoreCase("true")) continue;
                    m_passwordOnStandardIn = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-debug")) {
                    try {
                        foundDebug = true;
                        MetaUtility.setDebugOn(m_MdFactory, true);
                    }
                    catch (Exception e) {
                        error = e.getLocalizedMessage();
                        if (error != null) {
                            MetaUtility.MessageSet(m_MdFactory, error);
                        } else {
                            e.printStackTrace();
                        }
                        MetaMgrMain.clearPassword();
                        System.exit(2);
                    }
                    continue;
                }
                if (args[i].equalsIgnoreCase("-serverlogline")) {
                    m_serverlogline = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                    continue;
                }
                if (!args[i].equalsIgnoreCase("-help")) continue;
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.HelpText.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-method: " + bundle.getString("MetaMgrMain.HelpMethod.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-host: " + bundle.getString("MetaMgrMain.HelpHost.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-port: " + bundle.getString("MetaMgrMain.HelpPort.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-user: " + bundle.getString("MetaMgrMain.HelpUser.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-password: " + bundle.getString("MetaMgrMain.HelpPassword.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-wsfile: " + bundle.getString("MetaMgrMain.HelpWsfile.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-reposName: " + bundle.getString("MetaMgrMain.HelpName.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-reposPath: " + bundle.getString("MetaMgrMain.HelpPath.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-reposDesc: " + bundle.getString("MetaMgrMain.HelpDesc.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-reposEngine: " + bundle.getString("MetaMgrMain.HelpEngine.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-reposOptions: " + bundle.getString("MetaMgrMain.HelpOptions.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-reposType: " + bundle.getString("MetaMgrMain.HelpType.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-reposAccess: " + bundle.getString("MetaMgrMain.HelpAccess.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-reposIsCM: " + bundle.getString("MetaMgrMain.HelpIsCM.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-projectOwner: " + bundle.getString("MetaMgrMain.HelpProjectOwner.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-silentmode: " + bundle.getString("MetaMgrMain.HelpSilentMode.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-logfile: " + bundle.getString("MetaMgrMain.HelpLogFile.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-debug: " + bundle.getString("MetaMgrMain.HelpDebug.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-password_on_stdin: " + bundle.getString("MetaMgrMain.HelpPasswdStdIn.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-refreshTemplates: " + bundle.getString("MetaMgrMain.HelpRefresh.txt"));
                MetaUtility.MessageSet(m_MdFactory, "-help: " + bundle.getString("MetaMgrMain.HelpHelp.txt"));
                try {
                    m_MdFactory.dispose();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                MetaMgrMain.clearPassword();
                System.exit(0);
            }
            try {
                IOMI omiConnection = null;
                if (m_method != null) {
                    if (m_method.equalsIgnoreCase(m_createMethod) || m_method.equalsIgnoreCase(m_initializeMethod) || m_method.equalsIgnoreCase(m_registerMethod) || m_method.equalsIgnoreCase(m_deleteTemplateMethod)) {
                        omiConnection = MetaMgrMain.connecttoMetadataServer();
                        if (omiConnection != null) {
                            if (logFile != null) {
                                m_MdFactory.getUtil().setLogStream((OutputStream)logFile);
                                m_MdFactory.getUtil().setOutputStream((OutputStream)logFile);
                            } else {
                                m_MdFactory.getUtil().setLogStream((OutputStream)System.out);
                                m_MdFactory.getUtil().setOutputStream((OutputStream)System.out);
                            }
                            if (foundDebug) {
                                try {
                                    MetaUtility.setDebugOn(m_MdFactory, true);
                                }
                                catch (Exception e) {
                                    error = e.getLocalizedMessage();
                                    if (error != null) {
                                        MetaUtility.MessageSet(m_MdFactory, error);
                                    } else {
                                        e.printStackTrace();
                                    }
                                    System.exit(2);
                                }
                            }
                            if (m_serverlogline != null) {
                                int n = MetaMgrMain.setupLogInfoOnServer();
                            }
                            if (m_method.equalsIgnoreCase(m_deleteTemplateMethod)) {
                                MetaMgrMain.deleteResourceTemplates(args);
                            } else {
                                m_platformVersion = m_MdFactory.getConnection().getPlatformVersion();
                                MetaMgrMain.processCreateInitRegisterRepository(args);
                            }
                            break block48;
                        }
                        _rc = 2;
                        break block48;
                    }
                    if (m_method.equalsIgnoreCase(m_repositoryUpgradeMethod) || m_method.equalsIgnoreCase(m_metadataUpgradeMethod)) {
                        MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.UseUpgradeDriver.txt"));
                        _rc = 1;
                    } else {
                        MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.InvalidMethod.txt"));
                        _rc = 2;
                    }
                    break block48;
                }
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.MissingMethodParm.txt"));
                _rc = 2;
            }
            catch (Exception e) {
                MetaUtility.MessageSet(m_MdFactory, e.getLocalizedMessage());
                _rc = 2;
            }
            finally {
                MetaMgrMain.clearPassword();
                if (ms != null) {
                    ms.disconnect();
                }
                try {
                    m_MdFactory.dispose();
                }
                catch (RemoteException remoteException) {}
            }
        }
        System.exit(_rc);
    }

    protected static IOMI connecttoMetadataServer() {
        try {
            IOMI iOMI;
            block25: {
                if (m_passwordOnStandardIn) {
                    block24: {
                        String msg = bundle.getString("MetaMgrMain.SpecifyMetaPassword.txt");
                        m_password = MetaUtility.readValueFromStandardIn("-password", msg, "UTF-8").toCharArray();
                        if (m_password != null) break block24;
                        MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.StandardIn.MetaPassword.Error.txt"));
                        IOMI iOMI2 = null;
                        return iOMI2;
                    }
                    try {
                        foundPass = true;
                    }
                    catch (Exception e) {
                        String error = e.getLocalizedMessage();
                        if (error != null) {
                            MetaUtility.MessageSet(m_MdFactory, error);
                            break block25;
                        }
                        MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.StandardIn.MetaPassword.Error.txt"));
                    }
                }
            }
            if (foundHost && foundPort && foundUser && foundPass) {
                try {
                    _connectionProfile = ConnectionProfile.newProfile((String)m_host, (String)m_port, (String)m_user, (String)new String(m_password));
                    MetaMgrMain.startServices();
                }
                catch (Exception e) {
                    MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.MetaConnectionFailed.txt"));
                    iOMI = null;
                    MetaMgrMain.clearPassword();
                    return iOMI;
                }
            } else if (foundWsfile) {
                try {
                    _connectionProfile = ConnectionProfile.loadProfile((String)m_wsfile);
                    MetaMgrMain.startServices();
                }
                catch (Exception e) {
                    MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.MetaWsfileConnectionFailed.txt"));
                    iOMI = null;
                    MetaMgrMain.clearPassword();
                    return iOMI;
                }
            } else {
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.MetaConnectionInfoMissing.txt"));
                IOMI e = null;
                return e;
            }
            IOMI omiConnection = m_MdFactory.getConnection().getCMRHandle();
            if (omiConnection == null) {
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.MetaConnectionFailed.txt"));
                iOMI = null;
                return iOMI;
            }
            iOMI = omiConnection;
            return iOMI;
        }
        finally {
            MetaMgrMain.clearPassword();
        }
    }

    private static void startServices() throws ServiceException, RemoteException {
        UserServiceInterface userService;
        CorePlatformServices.setEnvironment((Environment)_connectionProfile.getEnvironment());
        CorePlatformServices.startLocalServices();
        InformationServiceInterface infoService = CorePlatformServices.getInformationService();
        if (infoService != null) {
            infoService.setIsolated();
        }
        if ((userService = CorePlatformServices.getUserService()) != null) {
            userService.setGroupLoginEnabled(true);
        }
        if (userService != null) {
            block11: {
                _user = null;
                try {
                    String userName = _connectionProfile.getProperty("userid");
                    if (userName == null || userName.length() == 0) {
                        _user = userService.newUser(null, null);
                    } else {
                        String domain = _connectionProfile.getDomain();
                        _user = userService.newUser(_connectionProfile.getProperty("userid"), _connectionProfile.getProperty("password"), domain);
                    }
                }
                catch (UserInitializationException e) {
                    _user = e.getUser();
                    if (!m_MdFactory.getDebug()) break block11;
                    Exception[] exceptions = e.getExceptions();
                    for (int i = 0; i < exceptions.length; ++i) {
                        Exception exception = exceptions[i];
                        exception.printStackTrace(System.out);
                    }
                }
            }
            if (_user == null) {
                throw new ServiceException(bundle.getString("MetaMgrMain.InitError.NoUser.txt"));
            }
            _session = CorePlatformServices.getSessionService().newSessionContext(_user);
            _server = _user.getAuthServer();
            if (_server == null) {
                throw new ServiceException(bundle.getString("MetaMgrMain.InitError.NoServer.txt"));
            }
            if (_server instanceof OMIServer && (m_MdFactory = ((OMIServer)_server).getMdFactory()) == null) {
                throw new ServiceException(bundle.getString("MetaMgrMain.InitError.NoFactory.txt"));
            }
        }
    }

    protected static void processCreateInitRegisterRepository(String[] args) {
        int finalAccess;
        boolean folderLocation = false;
        String m_createPath = null;
        try {
            m_store = m_MdFactory.createObjectStore();
        }
        catch (RemoteException re) {
            MetaUtility.MessageSet(m_MdFactory, re.getLocalizedMessage());
        }
        RepositoryInitialization riObj = new RepositoryInitialization(m_MdFactory);
        Repository repos = new Repository(m_MdFactory);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-repostype")) {
                MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                repos.setType(MetaUtility.getArgumentValue(i + 1, m_argsCount, args));
                continue;
            }
            if (args[i].equalsIgnoreCase("-reposname")) {
                repos.setName(MetaUtility.getArgumentValue(i + 1, m_argsCount, args));
                continue;
            }
            if (args[i].equalsIgnoreCase("-repospath")) {
                repos.setPath(MetaUtility.getArgumentValue(i + 1, m_argsCount, args));
                continue;
            }
            if (args[i].equalsIgnoreCase("-reposdesc")) {
                repos.setDesc(MetaUtility.getArgumentValue(i + 1, m_argsCount, args));
                continue;
            }
            if (args[i].equalsIgnoreCase("-reposengine")) {
                String repEngine = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                if (repEngine.equalsIgnoreCase("DEFAULT")) {
                    repos.setEngine("BASE");
                    continue;
                }
                repos.setEngine(repEngine);
                continue;
            }
            if (args[i].equalsIgnoreCase("-reposoptions")) {
                repos.setOptions(MetaUtility.getArgumentValue(i + 1, m_argsCount, args));
                continue;
            }
            if (args[i].equalsIgnoreCase("-reposaccess")) {
                String strAccess = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                if (m_platformVersion < 9200) {
                    repos.setAccess(strAccess.equalsIgnoreCase("readonly"));
                    continue;
                }
                repos.setExtendedAccess(strAccess.equalsIgnoreCase("online") ? 0 : (strAccess.equalsIgnoreCase("readonly") ? 1 : (strAccess.equalsIgnoreCase("admin") ? 2 : (strAccess.equalsIgnoreCase("offline") ? 4 : -1))));
                continue;
            }
            if (args[i].equalsIgnoreCase("-reposiscm")) {
                String isCM = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
                if (isCM.equalsIgnoreCase("NO")) {
                    repos.setIsChangeManaged(false);
                    continue;
                }
                repos.setIsChangeManaged(true);
                continue;
            }
            if (args[i].equalsIgnoreCase("-reposstoreusers")) {
                // empty if block
            }
            if (args[i].equalsIgnoreCase("-reposuserspath")) {
                // empty if block
            }
            if (args[i].equalsIgnoreCase("-projectowner")) {
                riObj.setProjectOwner(MetaUtility.getArgumentValue(i + 1, m_argsCount, args));
                continue;
            }
            if (!args[i].equalsIgnoreCase("-createReposPath")) continue;
            m_createPath = MetaUtility.getArgumentValue(i + 1, m_argsCount, args);
            riObj.setCreatePathLocation(m_createPath);
        }
        if (m_createPath == null) {
            riObj.setCreatePathLocation("No");
        }
        riObj.setMethod(m_method);
        if (repos.getType() == null || repos.getType().length() == 0) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.MissingReposType.txt"));
            _rc = 2;
            return;
        }
        riObj.setStoreUserDefinitions(repos.getType().equalsIgnoreCase("FOUNDATION") ? "Y" : "N");
        if (repos.getType().equalsIgnoreCase("FOUNDATION")) {
            riObj.setPathToUsersRootFolder("/" + bundle.getString("Common.DefaultFolderPolicy.txt"));
        }
        if (!repos.getType().equalsIgnoreCase("FOUNDATION")) {
            // empty if block
        }
        if (m_method.equalsIgnoreCase(m_createMethod)) {
            finalAccess = -1;
            int accessMode = repos.getExtendedAccess();
            switch (accessMode) {
                case 1: 
                case 4: {
                    finalAccess = accessMode;
                    repos.setExtendedAccess(2);
                }
            }
            boolean createSuccess = RepositoryInitialization.createRepository(m_store, repos);
            if (createSuccess) {
                boolean initSuccess = RepositoryInitialization.initializeRepository(repos, _session);
                if (!initSuccess) {
                    _rc = 2;
                }
            } else {
                _rc = 2;
            }
            if (finalAccess != -1 && finalAccess != repos.getExtendedAccess()) {
                String accessSetting = null;
                StringHolder outXML = new StringHolder();
                switch (finalAccess) {
                    case 0: {
                        accessSetting = " Access=\"0\"";
                        break;
                    }
                    case 1: {
                        accessSetting = " Access=\"1\"";
                        break;
                    }
                    case 2: {
                        accessSetting = " Access=\"2\"";
                        break;
                    }
                    case 4: {
                        accessSetting = " Access=\"4\"";
                    }
                }
                StringBuffer resetAccessXMLBuffer = new StringBuffer("<RepositoryBase ");
                resetAccessXMLBuffer.append(" ID=\"" + repos.getFQID() + "\"" + accessSetting + "/>");
                String resetAccessXML = resetAccessXMLBuffer.toString();
                try {
                    IOMI omiConnection = m_MdFactory.getConnection().getCMRHandle();
                    omiConnection.UpdateMetadata(resetAccessXML, outXML, "REPOS", 0x10000000, "");
                }
                catch (Exception e) {
                    MetaUtility.MessageSet(m_MdFactory, e.getLocalizedMessage());
                    _rc = 2;
                }
            }
        } else if (m_method.equalsIgnoreCase(m_initializeMethod)) {
            boolean initSuccess = RepositoryInitialization.initializeRepository(repos, _session);
            if (!initSuccess) {
                _rc = 2;
            }
        } else if (m_method.equalsIgnoreCase(m_registerMethod)) {
            finalAccess = -1;
            int accessMode = repos.getExtendedAccess();
            switch (accessMode) {
                case 1: 
                case 4: {
                    finalAccess = accessMode;
                    repos.setExtendedAccess(2);
                }
            }
            riObj.setCreatePathLocation("No");
            boolean createSuccess = RepositoryInitialization.createRepository(m_store, repos);
            if (!createSuccess) {
                _rc = 2;
            }
            if (finalAccess != -1 && finalAccess != repos.getExtendedAccess()) {
                String accessSetting = null;
                StringHolder outXML = new StringHolder();
                switch (finalAccess) {
                    case 0: {
                        accessSetting = " Access=\"0\"";
                        break;
                    }
                    case 1: {
                        accessSetting = " Access=\"1\"";
                        break;
                    }
                    case 2: {
                        accessSetting = " Access=\"2\"";
                        break;
                    }
                    case 4: {
                        accessSetting = " Access=\"4\"";
                    }
                }
                StringBuffer resetAccessXMLBuffer = new StringBuffer("<RepositoryBase ");
                resetAccessXMLBuffer.append(" ID=\"" + repos.getFQID() + "\"" + accessSetting + "/>");
                String resetAccessXML = resetAccessXMLBuffer.toString();
                try {
                    IOMI omiConnection = m_MdFactory.getConnection().getCMRHandle();
                    omiConnection.UpdateMetadata(resetAccessXML, outXML, "REPOS", 0x10000000, "");
                }
                catch (Exception e) {
                    MetaUtility.MessageSet(m_MdFactory, e.getLocalizedMessage());
                    _rc = 2;
                }
            }
            if (_rc == 2) {
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.RegisterRepository.NotSuccessful.txt"));
            } else {
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.RegisterRepository.Successful.txt"));
            }
        } else {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.InvalidMethod.txt"));
            _rc = 2;
        }
    }

    private static int setupLogInfoOnServer() {
        int iStatus = 0;
        IServer serverConn = null;
        try {
            serverConn = RepositoryInitialization.MakeIServerConnection(m_MdFactory.getConnection().getCMRHandle());
        }
        catch (Exception re) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.SetupLogInfo.NotSuccessful.txt"));
            return -1;
        }
        if (serverConn == null) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.SetupLogInfo.NotSuccessful.txt"));
            return -1;
        }
        try {
            StringHolder output = new StringHolder();
            String options = "";
            if (m_serverlogline.indexOf(44) > -1) {
                StringBuffer parsed = new StringBuffer();
                parsed.append("<Log text=\"");
                block7: for (int i = 0; i < m_serverlogline.length(); ++i) {
                    char c = m_serverlogline.charAt(i);
                    switch (c) {
                        case ',': {
                            parsed.append("\"/>");
                            parsed.append("<Log text=\"");
                            continue block7;
                        }
                        default: {
                            parsed.append(c);
                        }
                    }
                }
                parsed.append("\"/>");
                options = parsed.toString();
            } else {
                options = "<Log text=\"" + m_serverlogline + "\"/>";
            }
            options = StringEscapeUtils.escapeHtml((String)options);
            serverConn.Status("<State/>", output, options);
            String sStatus = output.value;
            String s1 = "<State>";
            String s2 = "</State>";
            sStatus = sStatus.substring(sStatus.indexOf(s1) + s1.length(), sStatus.indexOf(s2));
            iStatus = Integer.parseInt(sStatus);
        }
        catch (Exception e) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.SetupLogInfo.NotSuccessful.txt"));
            return -1;
        }
        return iStatus;
    }

    protected static void deleteResourceTemplates(String[] args) {
        Repository repos = new Repository(m_MdFactory);
        boolean refresh = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-repostype")) {
                repos.setType(MetaUtility.getArgumentValue(i + 1, m_argsCount, args));
                continue;
            }
            if (args[i].equalsIgnoreCase("-reposname")) {
                repos.setName(MetaUtility.getArgumentValue(i + 1, m_argsCount, args));
                continue;
            }
            if (!args[i].equalsIgnoreCase("-refreshTemplates")) continue;
            refresh = true;
        }
        String reposType = repos.getType();
        if (reposType == null || reposType.length() == 0) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.MissingReposType.txt"));
            _rc = 2;
            return;
        }
        if (!reposType.equalsIgnoreCase("FOUNDATION") && !reposType.equalsIgnoreCase("CUSTOM")) {
            if (reposType.equalsIgnoreCase("PROJECT")) {
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.ProjectDeleteNotAllowed.txt"));
                _rc = 2;
                return;
            }
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.InvalidReposType.txt"));
            _rc = 2;
            return;
        }
        repos.setAccess(false);
        String reposId = null;
        try {
            reposId = RepositoryUtil.getReposIdForName((MdFactory)m_MdFactory, (String)repos.getName());
        }
        catch (Exception exc) {
            String error = exc.getLocalizedMessage();
            if (error != null) {
                MetaUtility.MessageSet(m_MdFactory, error);
            } else {
                exc.printStackTrace();
            }
            _rc = 2;
            return;
        }
        if (reposId != null) {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.ResourceTemplatesDelete.txt"));
            MetaMgrMain.populateList(reposId);
            for (int index = 0; index < m_itemsList.size(); ++index) {
                String error;
                Prototype item = (Prototype)m_itemsList.get(index);
                if (item == null) continue;
                String strTemplate = bundle.getString("MetaMgrMain.PrototypeTemplate.notrans");
                String strAssocTemplate = bundle.getString("MetaMgrMain.AssocTemplate.notrans");
                try {
                    int i;
                    Vector<AssociationProperty> assocPropertyList = new Vector<AssociationProperty>();
                    Vector<Prototype> prototypeList = new Vector<Prototype>();
                    prototypeList.add(item);
                    for (i = 0; i < prototypeList.size(); ++i) {
                        AssociationProperty property;
                        int j;
                        String strAssocSelect;
                        Prototype p = (Prototype)prototypeList.get(i);
                        String strPrototypeID = p.getFQID();
                        String strAssocOptions = strAssocSelect = "<XMLSELECT search=\"*[OwningPrototype/*[@Id='" + strPrototypeID + "']]\" />";
                        int assocFlags = 392;
                        int assocIndex = assocPropertyList.size();
                        List assocObjectList = m_MdFactory.getOMIUtil().getMetadataObjectsSubset(item.getObjectStore(), reposId, "AssociationProperty", assocFlags, strAssocOptions);
                        for (j = 0; j < assocObjectList.size(); ++j) {
                            property = (AssociationProperty)assocObjectList.get(j);
                            if (assocPropertyList.contains(property)) continue;
                            assocPropertyList.add(property);
                        }
                        for (j = assocIndex; j < assocPropertyList.size(); ++j) {
                            String strSelect;
                            property = (AssociationProperty)assocPropertyList.get(j);
                            String strPropertyID = property.getFQID();
                            String strOptions = strSelect = "<XMLSELECT search=\"*[Associations/*[@Id='" + strPropertyID + "']]\" />";
                            int flags = 392;
                            List objectList = m_MdFactory.getOMIUtil().getMetadataObjectsSubset(item.getObjectStore(), reposId, "Prototype", flags, strOptions);
                            for (int k = 0; k < objectList.size(); ++k) {
                                Prototype prototype = (Prototype)objectList.get(k);
                                if (prototypeList.contains(prototype)) continue;
                                prototypeList.add(prototype);
                            }
                        }
                    }
                    for (i = 0; i < assocPropertyList.size(); ++i) {
                        AssociationProperty property = (AssociationProperty)assocPropertyList.get(i);
                        m_MdFactory.deleteMetadataObjects((CMetadata)property, strAssocTemplate);
                    }
                    for (i = 0; i < prototypeList.size(); ++i) {
                        Prototype prototype = (Prototype)prototypeList.get(i);
                        m_MdFactory.deleteMetadataObjects((CMetadata)prototype, strTemplate);
                    }
                    continue;
                }
                catch (MdException exc) {
                    error = exc.getLocalizedMessage();
                    if (error != null) {
                        MetaUtility.MessageSet(m_MdFactory, error);
                    } else {
                        exc.printStackTrace();
                    }
                    _rc = 2;
                    continue;
                }
                catch (RemoteException re) {
                    error = re.getLocalizedMessage();
                    if (error != null) {
                        MetaUtility.MessageSet(m_MdFactory, error);
                    } else {
                        re.printStackTrace();
                    }
                    _rc = 2;
                }
            }
            if (refresh && reposType.equalsIgnoreCase("FOUNDATION")) {
                MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.ResourceTemplatesRefresh.txt"));
                try {
                    PrototypeWizard.addAll((MdFactory)m_MdFactory, (String)reposId);
                }
                catch (Exception e) {
                    MetaUtility.MessageSet(m_MdFactory, bundle.getString("MetaMgrMain.AddResourceTemplates.Error.txt"));
                    _rc = 2;
                }
            }
        } else {
            MetaUtility.MessageSet(m_MdFactory, bundle.getString("RepositoryInitialization.ReposNotFound.txt"));
            _rc = 2;
        }
    }

    protected static void populateList(String reposId) {
        String strType = bundle.getString("MetaMgrMain.Type.notrans");
        String strTemplate = bundle.getString("MetaMgrMain.Template.notrans");
        String strSelect = bundle.getString("MetaMgrMain.Select.notrans");
        String strOptions = strTemplate + strSelect;
        int flags = 396;
        try {
            List objectList = m_MdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)m_MdFactory.createObjectStore(), reposId, strType, flags, strOptions);
            if (m_itemsList == null) {
                m_itemsList = new Vector();
            }
            m_itemsList.addAll(objectList);
        }
        catch (Exception exc) {
            String error = exc.getLocalizedMessage();
            if (error != null) {
                MetaUtility.MessageSet(m_MdFactory, error);
            } else {
                exc.printStackTrace();
            }
            _rc = 2;
        }
    }

    private static void clearPassword() {
        m_password = null;
    }

    static {
        m_serverlogline = null;
        foundDebug = false;
        foundHost = false;
        foundPort = false;
        foundUser = false;
        foundPass = false;
        foundWsfile = false;
        _session = null;
        _connectionProfile = null;
        logFile = null;
        ms = null;
        bundle = new WAdminResource(MetaMgrMain.class);
        _rc = 0;
    }
}

