/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.storedprocess.metadata.GenericStream;
import com.sas.services.storedprocess.metadata.RB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class XMLStream
extends GenericStream {
    private static final long serialVersionUID = -377521365401859744L;
    private boolean _schemaIsAvailable;
    private String _schemaURI;
    private String _referenceNameSpace;
    private String _referenceName;
    private boolean _referenceTypeIsForSchemaElement;
    private boolean _referenceTypeIsForSchemaElementHasBeenSet;
    private boolean _schemaIsToBeEmbeddedInWSDL;
    private boolean _schemaIsToBeEmbeddedInWSDLHasBeenSet;

    public XMLStream() {
        this.setExpectedContentType("text/xml");
    }

    public boolean isSchemaAvailable() {
        return this._schemaIsAvailable;
    }

    public void setIsSchemaAvailable(boolean schemaIsAvailable) {
        this._schemaIsAvailable = schemaIsAvailable;
    }

    public String getSchemaURI() throws IllegalStateException {
        if (!this._schemaIsAvailable) {
            throw new IllegalStateException(RB.getStringResource("XS.noSchema.ex.txt"));
        }
        return this._schemaURI;
    }

    public void setSchemaURI(String schemaURI) {
        this._schemaURI = schemaURI;
    }

    public String getReferenceNameSpace() {
        if (!this._schemaIsAvailable) {
            throw new IllegalStateException(RB.getStringResource("XS.noSchema.ex.txt"));
        }
        return this._referenceNameSpace;
    }

    public void setReferenceNameSpace(String referenceNameSpace) {
        this._referenceNameSpace = referenceNameSpace;
    }

    public String getReferenceName() {
        if (!this._schemaIsAvailable) {
            throw new IllegalStateException(RB.getStringResource("XS.noSchema.ex.txt"));
        }
        return this._referenceName;
    }

    public void setReferenceName(String referenceName) {
        this._referenceName = referenceName;
    }

    public boolean isReferenceTypeForSchemaElement() {
        if (!this._schemaIsAvailable) {
            throw new IllegalStateException(RB.getStringResource("XS.noSchema.ex.txt"));
        }
        if (!this._referenceTypeIsForSchemaElementHasBeenSet) {
            throw new IllegalStateException(RB.getStringResource("XS.valueNotSet.ex.txt"));
        }
        return this._referenceTypeIsForSchemaElement;
    }

    public void setIsReferenceTypeForSchemaElement(boolean referenceTypeIsForSchemaElement) {
        this._referenceTypeIsForSchemaElement = referenceTypeIsForSchemaElement;
        this._referenceTypeIsForSchemaElementHasBeenSet = true;
    }

    public boolean isSchemaToBeEmbeddedInWSDL() {
        if (!this._schemaIsAvailable) {
            throw new IllegalStateException(RB.getStringResource("XS.noSchema.ex.txt"));
        }
        if (!this._schemaIsToBeEmbeddedInWSDLHasBeenSet) {
            throw new IllegalStateException(RB.getStringResource("XS.valueNotSet.ex.txt"));
        }
        return this._schemaIsToBeEmbeddedInWSDL;
    }

    public void setIsSchemaToBeEmbeddedInWSDL(boolean schemaIsToBeEmbeddedInWSDL) {
        this._schemaIsToBeEmbeddedInWSDL = schemaIsToBeEmbeddedInWSDL;
        this._schemaIsToBeEmbeddedInWSDLHasBeenSet = true;
    }

    @Override
    public void validate() throws ServiceException {
        super.validate();
        if (!this._schemaIsAvailable) {
            return;
        }
        if (this._schemaURI == null || this._schemaURI.length() == 0) {
            throw new ServiceException(RB.getStringResource("XS.noURI.ex.txt"));
        }
        if (this._referenceName == null || this._referenceName.length() == 0) {
            throw new ServiceException(RB.getStringResource("XS.noRefNam.ex.txt"));
        }
        if (this._referenceNameSpace == null || this._referenceNameSpace.length() == 0) {
            throw new ServiceException(RB.getStringResource("XS.noRefNamSpc.ex.txt"));
        }
        if (!this._referenceTypeIsForSchemaElementHasBeenSet) {
            throw new ServiceException(RB.getStringResource("XS.noRefTyp.ex.txt"));
        }
        if (!this._schemaIsToBeEmbeddedInWSDLHasBeenSet) {
            throw new ServiceException(RB.getStringResource("XS.noWSDLGenOpt.ex.txt"));
        }
    }

    @Override
    void writeXML(Document document, Element element) {
        super.writeXML(document, element);
        element.setAttribute("Type", "XMLStream");
        if (this.isSchemaAvailable()) {
            Element schemaE = document.createElement("Schema");
            schemaE.setAttribute("URI", this.getSchemaURI());
            schemaE.setAttribute("Namespace", this.getReferenceNameSpace());
            schemaE.setAttribute("Name", this.getReferenceName());
            element.appendChild(schemaE);
            Element wsdlE = document.createElement("WSDL");
            wsdlE.setAttribute("Embed", this.isSchemaToBeEmbeddedInWSDL() ? "true" : "false");
            wsdlE.setAttribute("ReferenceType", this.isReferenceTypeForSchemaElement() ? "Element" : "Type");
            schemaE.appendChild(wsdlE);
        }
    }
}

