/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.metadata.KeywordFilter;
import java.util.Iterator;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class StoredProcessFilter
extends KeywordFilter {
    private static final long serialVersionUID = 6287422916493703689L;

    public StoredProcessFilter() {
        this.setType("StoredProcess");
        this.addProtocol("omi");
    }

    public StoredProcessFilter(String key, int relation, String value) {
        super(key, relation, value);
        this.setType("StoredProcess");
        this.addProtocol("omi");
    }

    public String getOMRType() {
        return "ClassifierMap";
    }

    public String getLDAPType() {
        return "sasStoredProcess";
    }

    public String getXMLSelectString() {
        StringBuffer buffer = new StringBuffer();
        String name = this.getName();
        FilterComponent compy = this._component;
        FilterComponent mycomp = new FilterComponent("PublicType", 0, "StoredProcess");
        if (compy != null) {
            mycomp.addComponent(compy);
        }
        mycomp.setAggregation(0);
        this._component = mycomp;
        if (name != null) {
            FilterComponent nameComp = new FilterComponent("Name", 0, name);
            mycomp.addComponent(nameComp);
        }
        if (this._component != null) {
            String compString = this.component2Select(this._component);
            if ("UNSUPPORTED".equals(compString)) {
                return compString;
            }
            buffer.append('[' + compString + ']');
        }
        if (this._keywords.size() > 0 && this._keywords.size() > 0) {
            buffer.append("[Keywords/*[");
            Iterator it = this._keywords.iterator();
            boolean firstName = true;
            while (it.hasNext()) {
                if (!firstName) {
                    buffer.append(" OR ");
                }
                buffer.append("@Name='" + (String)it.next() + '\'');
                firstName = false;
            }
            buffer.append(" ]]");
        }
        this._component = compy;
        if (buffer.length() > 0) {
            return new String("<XMLSelect Search=\"*" + buffer.toString() + "\"/>");
        }
        return "";
    }
}

