/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.GenericStream;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.storedprocess.OutputParameterInterface;
import com.sas.services.storedprocess.StoredProcessInterface;
import com.sas.services.storedprocess.StoredProcessServiceInterface;
import com.sas.services.storedprocess.metadata.DataSourceOrTarget;
import com.sas.services.storedprocess.metadata.DataTable;
import com.sas.services.storedprocess.metadata.MetadataManipulatorForUpgrade;
import com.sas.services.storedprocess.metadata.OutputParameter;
import com.sas.services.storedprocess.metadata.RB;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.storedprocess.metadata.StoredProcessOptions;
import com.sas.services.storedprocess.metadata.XMLStream;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.services.util.XMLUtil;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class StoredProcess
extends Metadata
implements com.sas.services.storedprocess.metadata.StoredProcessInterface,
MultiLocaleProperties,
Serializable {
    static final long serialVersionUID = 1117188391856400359L;
    static UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    static UsageVersion NINETHREE_VERSION = new UsageVersion(2, 0);
    public static String SUBSTITUTION_PROPERTY_ARCHIVE_PATH = "Archive.DirPath";
    private boolean _isLocalizationActive;
    private OMRPromptGroupInterface _promptGroupSmartObject;
    private PromptGroupInterface _promptGroup;
    private TextStore _textStore;
    private Document _document;
    private Element _storedProcessE;
    private boolean _attemptedToGetstoredProcessE;
    private Element _resultCapabilities;
    private boolean _attemptedToGetResultCapabilities;
    private Element _serverContextE;
    private List<OutputParameter> _outputParameters;
    private boolean _attemptedToGetOutputParameters;
    private List<DataSourceOrTarget> _dsdt;
    private boolean _attemptedToGetDSDT;
    private List<com.sas.services.storedprocess.metadata.GenericStream> _streams;
    private boolean _attemptedToGetStreams;
    private File _file;
    private boolean _attemptedToGet_file;
    private TextStore _textStoreForSourceCode;
    private boolean _attemptedToGet_textStoreForSourceCode;
    private double _version;
    private boolean _existingSP;
    private boolean _couldBeInvalid;
    private StoredProcessInterface.SourceCodeLocation _sourceCodeLocation;
    private boolean _sourceCodeLocationDetermined;

    public static StoredProcessServiceInterface getStoredProcessService() throws ServiceException {
        StoredProcessServiceInterface storedProcessService = null;
        try {
            storedProcessService = (StoredProcessServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{StoredProcessServiceInterface.class}, null));
        }
        catch (Throwable t) {
            if (t instanceof ServiceException) {
                throw (ServiceException)t;
            }
            storedProcessService = null;
        }
        if (storedProcessService == null) {
            throw new ServiceException(RB.getStringResource("StoredProcess.noservice.msg.txt"));
        }
        return storedProcessService;
    }

    private void obtainVersionInfo() throws RemoteException {
        Root root = (Root)this._repositoryObject;
        this._version = root.getUsageVersion();
    }

    public StoredProcess() throws RemoteException {
        super(StoredProcess.class);
    }

    public StoredProcess(Object o) throws RemoteException {
        super(o, StoredProcess.class);
        if (!(o instanceof ClassifierMap)) {
            throw new RuntimeException(Message.format((ResourceBundle)RB.getResources(), (String)"StoredProcess.badctorobject.msg.fmt.txt", (Object)o.getClass().getName()));
        }
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
        this.obtainVersionInfo();
        this._existingSP = true;
    }

    public StoredProcess(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this();
        if (repos == null || name == null || parent == null) {
            throw new IllegalArgumentException();
        }
        if (repos instanceof OMIRepositoryInterface) {
            Locale locale;
            Root root = (Root)parent.getRepositoryEntity();
            MdObjectStore store = (MdObjectStore)root.getObjectStore();
            MdFactory factory = store.getFactory();
            ClassifierMap map = (ClassifierMap)factory.createComplexMetadataObject(store, null, name, "ClassifierMap", root.getRepositoryID());
            map.setPublicType("StoredProcess");
            map.setUsageVersion(NINETWO_VERSION.encode());
            map.setTransformRole("StoredProcess");
            this._repositoryObject = map;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            try {
                parent.addItem((MetadataInterface)this);
            }
            catch (Exception ex) {
                store.removeElementFromStore((CMetadata)map);
                throw new RuntimeException(Message.format((ResourceBundle)RB.getResources(), (String)"SP.exists.ex.fmt.txt", (Object)name, (Object)parent.getName()));
            }
            PromptGroup pgi = new PromptGroup();
            UserContextInterface uci = repos.getUserContext();
            if (uci == null) {
                throw new RuntimeException(RB.getStringResource("SP.noUsrCtxt.ex.txt"));
            }
            try {
                locale = uci.getLocale();
            }
            catch (ServiceException e) {
                throw new RuntimeException(RB.getStringResource("SP.noLocale.ex.txt"), e);
            }
            String label = MetadataConstants.getLabelForParameterPromptGroup(locale);
            pgi.setPromptGroupLabel(label, locale);
            try {
                OMRPromptGroupInterface omrpgi = PromptsPersistUtil.newGroupSmartObject((PromptGroupInterface)pgi, (UserContextInterface)uci, (RepositoryInterface)repos, (String)label, null);
                this.addPrompt((BaseOMRPromptInterface)omrpgi);
            }
            catch (ServiceException e) {
                throw new RuntimeException(RB.getStringResource("SP.cantCreatPrmpt.ex.txt"), e);
            }
        }
        throw new IllegalArgumentException();
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
        this.obtainVersionInfo();
        this._existingSP = false;
    }

    public String getType() throws RemoteException {
        return "StoredProcess";
    }

    @Override
    public Object newServiceObject() throws ServiceException, RemoteException {
        StoredProcessOptions options = new StoredProcessOptions();
        return this.newServiceObject(options);
    }

    @Override
    public StoredProcessInterface newServiceObject(SessionContextInterface sessionContext) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    StoredProcessServiceInterface spService = StoredProcess.getStoredProcessService();
                    try {
                        return spService.newStoredProcess(sessionContext, this);
                    }
                    catch (Exception e) {
                        throw new ServiceException((Throwable)e, RB.getStringResource("StoredProcess.createerror.msg.txt"));
                    }
                }
                catch (ClassCastException cce) {
                    throw new ServiceException(RB.getStringResource("StoredProcess.needremote.msg.txt"));
                }
            }
        }
        return null;
    }

    @Override
    public Object newServiceObject(StoredProcessOptions options) throws ServiceException, RemoteException {
        switch (this._repositoryFlag) {
            case 0: {
                break;
            }
            case 2: {
                try {
                    StoredProcessServiceInterface spService = StoredProcess.getStoredProcessService();
                    try {
                        return spService.newStoredProcess(this, options);
                    }
                    catch (Exception e) {
                        throw new ServiceException((Throwable)e, RB.getStringResource("StoredProcess.createerror.msg.txt"));
                    }
                }
                catch (ClassCastException cce) {
                    throw new ServiceException(RB.getStringResource("StoredProcess.needremote.msg.txt"));
                }
            }
        }
        return null;
    }

    public void setName(String name) throws RemoteException {
        if (this._repositoryFlag == 2 && !Names.validateOMRObjectName((String)name, (boolean)true)) {
            throw new IllegalArgumentException(RB.getStringResource("StoredProcess.invalidName.msg.txt"));
        }
        super.setName(name);
    }

    public String mapNameToFilesystem(int hostOS, String prefix, String suffix) throws RemoteException, IllegalArgumentException {
        return Names.mapNameToFilesystem((String)this.getName(), (int)hostOS, (String)prefix, (String)suffix);
    }

    public String mapUrlToFilesystem(int hostOS, String prefix, String suffix) throws ServiceException, RemoteException, IllegalArgumentException {
        return Names.mapUrlToFilesystem((String)this.getPathUrl().toString(), (int)hostOS, (String)prefix, (String)suffix);
    }

    public MetadataInterface copyTo(FolderInterface folder, String name) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException(RB.getStringResource("StoredProcess.copyToUnsupported.msg.txt"));
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        this.checkReadCompatible();
        PropertyList list = this.getDefaultLocalizableProperties();
        try {
            list = MetadataConstants.getLocalizableProperties(this, list);
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return list;
    }

    public Collection getLocales() throws UnexpectedLocalizationException {
        try {
            PromptGroupInterface promptGroup;
            OMRPromptGroupInterface promptGroupSmartObject = (OMRPromptGroupInterface)this.getPrompt();
            if (promptGroupSmartObject != null && (promptGroup = promptGroupSmartObject.getPromptGroup()) != null) {
                return ((MultiLocaleProperties)promptGroupSmartObject).getLocales();
            }
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return new ArrayList();
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        this.checkReadCompatible();
        PropertyList list = new PropertyList();
        try {
            PromptGroupInterface promptGroup;
            OMRPromptGroupInterface promptGroupSmartObject = (OMRPromptGroupInterface)this.getPrompt();
            if (promptGroupSmartObject != null && (promptGroup = promptGroupSmartObject.getPromptGroup()) != null) {
                list.addProperty("Prompts", ((MultiLocaleProperties)promptGroup).getLocalizableProperties(locale));
            }
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return list;
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
        this.checkCompatible();
        try {
            this._promptGroupSmartObject = (OMRPromptGroupInterface)this.getPrompt();
            this._promptGroup = this._promptGroupSmartObject != null ? this._promptGroupSmartObject.getPromptGroup() : null;
            this._isLocalizationActive = true;
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        this.checkCompatible();
        if (map == null) {
            return;
        }
        this.setDefaultLocalizableProperties(map);
        boolean isLocalizationActiveCopy = this._isLocalizationActive;
        if (!this._isLocalizationActive) {
            this.beginLocalization();
        }
        try {
            PropertyMap promptMap;
            if (this._promptGroup != null && !this._promptGroup.getPromptDefinitionsAndSubgroups().isEmpty() && (promptMap = map.getNestedProperties("Prompts")) != null) {
                ((LocalizableProperties)this._promptGroup).setLocalizableProperties(promptMap);
            }
            MetadataConstants.setLocalizableProperties(this, map);
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        if (!isLocalizationActiveCopy) {
            this.endLocalization();
        }
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        PropertyMap promptMap;
        this.checkCompatible();
        if (map == null) {
            return;
        }
        boolean isLocalizationActiveCopy = this._isLocalizationActive;
        if (!this._isLocalizationActive) {
            this.beginLocalization();
        }
        if (this._promptGroup != null && (promptMap = map.getNestedProperties("Prompts")) != null) {
            ((MultiLocaleProperties)this._promptGroup).setLocalizableProperties(locale, promptMap);
        }
        if (!isLocalizationActiveCopy) {
            this.endLocalization();
        }
    }

    public void endLocalization() throws UnexpectedLocalizationException {
        this.checkCompatible();
        try {
            if (this._promptGroup != null) {
                PromptsPersistUtil.updateGroupSmartObject((PromptGroupInterface)this._promptGroup, (UserContextInterface)this.getRepository().getUserContext(), (OMRPromptGroupInterface)this._promptGroupSmartObject, null);
            }
            this._promptGroupSmartObject = null;
            this._promptGroup = null;
            this._isLocalizationActive = false;
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    private void checkReadCompatible() {
        try {
            this.checkIfReadCompatible();
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Remote exception is not supposed to occur: " + e);
        }
    }

    private void checkCompatible() {
        try {
            if (!this.isCompatible()) {
                throw new IllegalStateException(Message.format((ResourceBundle)RB.getResources(), (String)"SP.notSupp.ex.fmt.txt", (Object)this.getUsageVersion()));
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Remote exception is not supposed to occur: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        ClassifierMap cm = (ClassifierMap)this.getRepositoryEntity();
        MdFactory factory = cm.getObjectStore().getFactory();
        MdObjectStore childStore = factory.createObjectStore(cm.getObjectStore());
        try {
            ClassifierMap childCM = (ClassifierMap)factory.createComplexMetadataObject(childStore, (CMetadata)cm);
            MetadataManipulatorForUpgrade mm = new MetadataManipulatorForUpgrade(childCM, this._repository.getUserContext().getSessionContext());
            try {
                mm.convertTo92();
                childStore.updatedMetadataAll();
                cm.getObjectStore().updatedMetadataAll();
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        finally {
            childStore.dispose();
        }
    }

    private void checkIfReadCompatible() throws RemoteException {
        if (!this.isReadCompatible()) {
            throw new IllegalStateException(Message.format((ResourceBundle)RB.getResources(), (String)"SP.notReadCompat.ex.fmt.txt", (Object)this.getUsageVersion()));
        }
    }

    @Override
    public String getSourceFileName() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        this.getSourceFileJomaObject();
        if (this._file == null) {
            return null;
        }
        return this._file.getFileName();
    }

    private File getSourceFileJomaObject() throws ServiceException, RemoteException {
        try {
            if (!this._attemptedToGet_file) {
                ClassifierMap cm = (ClassifierMap)this._repositoryObject;
                Text sc = cm.getSourceCode();
                if (sc != null && !(sc instanceof File)) {
                    throw new ServiceException(RB.getStringResource("SP.badMetaNotFile.ex.txt"));
                }
                this._file = (File)sc;
            }
            if (this._file != null && this._file.getIsARelativeName() == 0) {
                throw new ServiceException(RB.getStringResource("SP.badMetaFileNotRelative.ex.txt"));
            }
            this._attemptedToGet_file = true;
            return this._file;
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
    }

    private void deleteSourceFileJomaObject() throws ServiceException, RemoteException {
        File file = this.getSourceFileJomaObject();
        if (file != null) {
            file.delete();
        }
        this._attemptedToGet_file = false;
        this._file = null;
    }

    private TextStore getSourceCodeJomaObject() throws ServiceException, RemoteException {
        if (!this._attemptedToGet_textStoreForSourceCode) {
            try {
                ClassifierMap cm = (ClassifierMap)this._repositoryObject;
                for (Object obj : cm.getNotes()) {
                    TextStore ts;
                    if (!(obj instanceof TextStore) || !(ts = (TextStore)obj).getName().equalsIgnoreCase("SourceCode") || !ts.getTextRole().equalsIgnoreCase("StoredProcessSourceCode")) continue;
                    this._textStoreForSourceCode = ts;
                    break;
                }
                this._attemptedToGet_textStoreForSourceCode = true;
            }
            catch (MdException mde) {
                throw new ServiceException((Throwable)mde, RB.getStringResource("SP.badMeta.ex.txt"));
            }
        }
        return this._textStoreForSourceCode;
    }

    private void deleteSourceCodeJomaObject() throws ServiceException, RemoteException {
        TextStore ts = this.getSourceCodeJomaObject();
        if (ts != null) {
            ts.delete();
        }
        this._textStoreForSourceCode = null;
        this._attemptedToGet_textStoreForSourceCode = false;
    }

    @Override
    public LogicalServerInterface getServer() throws ServiceException, RemoteException {
        LogicalServer ls;
        this.checkPulse(true);
        this.checkIfReadCompatible();
        if (this._version == NINETWO_VERSION.encode()) {
            ls = this.getLogicalServerJomaObject();
        } else {
            ServerContext serverContext = this.getServerContextJomaObject();
            StoredProcessInterface.LogicalServerType lst = this.getLogicalServerType();
            try {
                if (lst == StoredProcessInterface.LogicalServerType.ANY) {
                    ls = MetadataConstants.getLogicalServerFromServerContext(false, serverContext);
                    if (ls == null) {
                        ls = MetadataConstants.getLogicalServerFromServerContext(true, serverContext);
                    }
                } else {
                    boolean needWKS = lst == StoredProcessInterface.LogicalServerType.WORKSPACE;
                    ls = MetadataConstants.getLogicalServerFromServerContext(needWKS, serverContext);
                }
            }
            catch (MdException mde) {
                throw new ServiceException((Throwable)mde);
            }
        }
        if (ls == null) {
            return null;
        }
        return (LogicalServerInterface)this.getRepository().factoryProcess((Object)ls);
    }

    private LogicalServer getLogicalServerJomaObject() throws ServiceException, RemoteException {
        AssociationList al;
        ClassifierMap cm = (ClassifierMap)this._repositoryObject;
        try {
            al = cm.getComputeLocations();
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        int size = al.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new ServiceException(RB.getStringResource("SP.badMetaMultipleLogSrvrs.ex.txt"));
        }
        CMetadata metadata = (CMetadata)al.get(0);
        if (metadata instanceof LogicalServer) {
            return (LogicalServer)metadata;
        }
        throw new ServiceException(RB.getStringResource("SP.badMetaNotLogSrvr.ex.txt"));
    }

    private ServerContext getServerContextJomaObject() throws ServiceException, RemoteException {
        AssociationList al;
        ClassifierMap cm = (ClassifierMap)this._repositoryObject;
        try {
            al = cm.getComputeLocations();
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        int size = al.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new ServiceException(RB.getStringResource("SP.badMetaMultipleSrvrCtxts.ex.txt"));
        }
        CMetadata metadata = (CMetadata)al.get(0);
        if (metadata instanceof ServerContext) {
            return (ServerContext)metadata;
        }
        throw new ServiceException(RB.getStringResource("SP.badMetaNotSrvrCtxt.ex.txt"));
    }

    @Override
    public ServerContextInterface getServerContext() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        if (this._version == NINETWO_VERSION.encode()) {
            return this.doGetServerContextFrom92SP();
        }
        ServerContext sc = this.getServerContextJomaObject();
        if (sc == null) {
            return null;
        }
        return (ServerContextInterface)this.getRepository().factoryProcess((Object)sc);
    }

    private ServerContextInterface doGetServerContextFrom92SP() throws ServiceException, RemoteException {
        AssociationList al;
        LogicalServer ls = this.getLogicalServerJomaObject();
        if (ls == null) {
            return null;
        }
        try {
            al = ls.getUsedByComponents();
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        int size = al.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new ServiceException(RB.getStringResource("COM.badMetaMultipleSrvrCtxts.ex.txt"));
        }
        CMetadata metadata = (CMetadata)al.get(0);
        if (metadata instanceof ServerContext) {
            return (ServerContextInterface)this.getRepository().factoryProcess((Object)metadata);
        }
        throw new ServiceException(RB.getStringResource("COM.badMetaNotSrvrCtxt.ex.txt"));
    }

    @Override
    public DirectoryInterface getSourceCodeRepository() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        Directory dir = this.getSourceCodeRepositoryJomaObject();
        if (dir == null) {
            return null;
        }
        return (DirectoryInterface)this.getRepository().factoryProcess((Object)dir);
    }

    private Directory getSourceCodeRepositoryJomaObject() throws ServiceException, RemoteException {
        AssociationList al;
        this.getSourceFileJomaObject();
        if (this._file == null) {
            return null;
        }
        try {
            al = this._file.getDirectories();
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        int size = al.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new ServiceException(RB.getStringResource("SP.badMetaMultipleDir.ex.txt"));
        }
        CMetadata metadata = (CMetadata)al.get(0);
        if (metadata instanceof Directory) {
            return (Directory)metadata;
        }
        throw new ServiceException(RB.getStringResource("SP.badMetaNotDir.ex.txt"));
    }

    @Override
    public void setServer(LogicalServerInterface logicalServer) throws ServiceException, RemoteException {
        this.checkCompatible();
        if (this._version == NINETWO_VERSION.encode()) {
            if (logicalServer == null) {
                throw new NullPointerException();
            }
            String classid = logicalServer.getClassIdentifier();
            if (!(classid.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || classid.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c") || classid.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb"))) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SP.invalidSrvr.ex.fmt.txt", (Object)classid));
            }
            try {
                ClassifierMap cm = (ClassifierMap)this._repositoryObject;
                AssociationList al = cm.getComputeLocations();
                al.removeAllElements();
                al.add(logicalServer.getRepositoryEntity());
            }
            catch (MdException mde) {
                throw new ServiceException((Throwable)mde);
            }
        } else {
            throw new UnsupportedOperationException(RB.getStringResource("SP.notSupported.ex.txt"));
        }
        this._couldBeInvalid = true;
    }

    @Override
    public void setServerContext(ServerContextInterface serverContext) throws ServiceException, RemoteException {
        this.checkCompatible();
        if (this._version == NINETWO_VERSION.encode()) {
            throw new UnsupportedOperationException(RB.getStringResource("SP.notSupported.ex.txt"));
        }
        if (serverContext == null) {
            throw new NullPointerException();
        }
        try {
            ClassifierMap cm = (ClassifierMap)this._repositoryObject;
            AssociationList al = cm.getComputeLocations();
            al.removeAllElements();
            al.add(serverContext.getRepositoryEntity());
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        this._couldBeInvalid = true;
    }

    @Override
    public void setOtherServerContextAllowed(boolean isOtherServerContextAllowed) throws ServiceException, RemoteException {
        this.checkCompatible();
        if (this._version == NINETWO_VERSION.encode()) {
            throw new UnsupportedOperationException(RB.getStringResource("SP.notSupported.ex.txt"));
        }
        this.doSetOtherServerContextAllowed(isOtherServerContextAllowed);
        this._couldBeInvalid = true;
    }

    private void doSetOtherServerContextAllowed(boolean isOtherServerContextAllowed) throws ServiceException, RemoteException {
        this.getServerContextElement();
        this._serverContextE.setAttribute("OtherAllowed", isOtherServerContextAllowed ? "true" : "false");
    }

    @Override
    public boolean isOtherServerContextAllowed() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        if (this._version == NINETWO_VERSION.encode()) {
            return false;
        }
        this.getServerContextElement();
        String value = this._serverContextE.getAttribute("OtherAllowed");
        if (value == null) {
            throw new ServiceException(RB.getStringResource("SP.noOA.txt"));
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ServiceException(Message.format((String)RB.getStringResource("SP.invldOAVal.fmt.txt"), (Object)value));
    }

    @Override
    public void setLogicalServerType(StoredProcessInterface.LogicalServerType logicalServerType) throws ServiceException, RemoteException {
        this.checkCompatible();
        if (this._version == NINETWO_VERSION.encode()) {
            throw new UnsupportedOperationException(RB.getStringResource("SP.notSupported.ex.txt"));
        }
        this.doSetLogicalServerType(logicalServerType);
        this._couldBeInvalid = true;
    }

    private void doSetLogicalServerType(StoredProcessInterface.LogicalServerType logicalServerType) throws ServiceException, RemoteException {
        this.getServerContextElement();
        switch (logicalServerType) {
            case ANY: {
                this._serverContextE.setAttribute("LogicalServerType", "Any");
                break;
            }
            case STORED_PROCESS: {
                this._serverContextE.setAttribute("LogicalServerType", "Sps");
                break;
            }
            case WORKSPACE: {
                this._serverContextE.setAttribute("LogicalServerType", "Wks");
            }
        }
    }

    @Override
    public StoredProcessInterface.LogicalServerType getLogicalServerType() throws ServiceException, RemoteException {
        if (this._version == NINETWO_VERSION.encode()) {
            LogicalServerInterface lsi = this.getServer();
            if (lsi == null) {
                return null;
            }
            String classid = lsi.getClassIdentifier();
            if (classid.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || classid.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
                return StoredProcessInterface.LogicalServerType.WORKSPACE;
            }
            if (classid.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
                return StoredProcessInterface.LogicalServerType.STORED_PROCESS;
            }
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.unknwnClassid.ex.fmt.txt", (Object)classid);
            throw new ServiceException(msg);
        }
        this.getServerContextElement();
        String value = this._serverContextE.getAttribute("LogicalServerType");
        if (value == null) {
            throw new ServiceException(RB.getStringResource("SP.noLST.txt"));
        }
        if (value.equalsIgnoreCase("Any")) {
            return StoredProcessInterface.LogicalServerType.ANY;
        }
        if (value.equalsIgnoreCase("Wks")) {
            return StoredProcessInterface.LogicalServerType.WORKSPACE;
        }
        if (value.equalsIgnoreCase("Sps")) {
            return StoredProcessInterface.LogicalServerType.STORED_PROCESS;
        }
        throw new ServiceException(Message.format((String)RB.getStringResource("SP.invldLSTVal.fmt.txt"), (Object)value));
    }

    @Override
    public void setSourceCodeRepository(DirectoryInterface sourceCodeRepository) throws ServiceException, RemoteException {
        StoredProcessInterface.SourceCodeLocation scl;
        this.checkCompatible();
        if (sourceCodeRepository == null) {
            throw new NullPointerException();
        }
        if (this._version > NINETWO_VERSION.encode() && (scl = this.getSourceCodeLocation()) == StoredProcessInterface.SourceCodeLocation.METADATA) {
            throw new ServiceException(RB.getStringResource("SP.cantCallForMetaLoc.ex.txt"));
        }
        try {
            boolean isValid = false;
            Directory dir = (Directory)sourceCodeRepository.getRepositoryEntity();
            for (Property p : dir.getProperties()) {
                if (!p.getPropertyRole().equalsIgnoreCase("SPSourceCodeRepository")) continue;
                isValid = true;
                break;
            }
            if (!isValid) {
                throw new IllegalArgumentException(RB.getStringResource("SP.notSrcCodeRepos.ex.txt"));
            }
            this.create_FileIfNeeded();
            AssociationList al = this._file.getDirectories();
            al.removeAllElements();
            al.add((Object)dir);
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        this._couldBeInvalid = true;
    }

    @Override
    public void setSourceFileName(String sourceFileName) throws ServiceException, RemoteException {
        StoredProcessInterface.SourceCodeLocation scl;
        this.checkCompatible();
        if (sourceFileName == null) {
            throw new NullPointerException();
        }
        if (this._version > NINETWO_VERSION.encode() && (scl = this.getSourceCodeLocation()) == StoredProcessInterface.SourceCodeLocation.METADATA) {
            throw new ServiceException(RB.getStringResource("SP.cantCallForMetaLoc.ex.txt"));
        }
        this.create_FileIfNeeded();
        this._file.setFileName(sourceFileName.trim());
        this._file.setIsARelativeName(1);
        this._couldBeInvalid = true;
    }

    private void create_FileIfNeeded() throws ServiceException, RemoteException {
        this.getSourceFileJomaObject();
        if (this._file == null) {
            ClassifierMap cm = (ClassifierMap)this._repositoryObject;
            this._file = (File)StoredProcess.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)cm, "SP Source File", "File");
            this._file.setIsARelativeName(1);
            cm.setSourceCode((Text)this._file);
        }
    }

    private void createTextStoreForSourceIfNeeded() throws ServiceException, RemoteException {
        this.getSourceCodeJomaObject();
        if (this._textStoreForSourceCode == null) {
            ClassifierMap cm = (ClassifierMap)this._repositoryObject;
            this._textStoreForSourceCode = (TextStore)StoredProcess.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)cm, "SourceCode", "TextStore");
            this._textStoreForSourceCode.setTextRole("StoredProcessSourceCode");
            try {
                cm.getNotes().add((Object)this._textStoreForSourceCode);
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    @Override
    public void update() throws ServiceException, RemoteException {
        UsageVersion uv;
        if (this.isCompatible() && (uv = this.getUsageVersion()) != null && uv.encode() != 0.0) {
            this.validate();
            try {
                this.writeXML();
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        super.update();
        this._couldBeInvalid = false;
        this._existingSP = true;
    }

    private void validatePrompts() throws ServiceException, RemoteException {
        BaseOMRPromptInterface omrPI = this.getPrompt();
        if (omrPI instanceof OMRPromptGroupInterface) {
            OMRPromptGroupInterface omrPGI = (OMRPromptGroupInterface)omrPI;
            PromptGroupInterface promptGroup = omrPGI.getPromptGroup();
            Map dupMap = PromptUtil.getDuplicateDefintionsByName((PromptGroupInterface)promptGroup, (boolean)true);
            Set keyset = dupMap.keySet();
            int dupMapSize = keyset.size();
            if (dupMapSize > 0) {
                String separator = RB.getStringResource("SP.listItemSeparator.txt");
                String names = "";
                int i = 0;
                Iterator itt = keyset.iterator();
                while (itt.hasNext()) {
                    if (i++ > 0) {
                        names = names + separator;
                    }
                    names = names + itt.next().toString();
                }
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.dupPrompts.ex.fmt.txt", (Object)dupMapSize, (Object)names);
                throw new ServiceException(msg);
            }
        } else {
            throw new ServiceException(RB.getStringResource("SP.noOMRPGI.ex.txt"));
        }
    }

    private void validate92() throws ServiceException, RemoteException {
        try {
            boolean isWorkspaceServer;
            LogicalServer logicalServer = this.getLogicalServerJomaObject();
            if (logicalServer == null) {
                throw new ServiceException(RB.getStringResource("SP.noSrvr.ex.txt"));
            }
            Directory directory = this.getSourceCodeRepositoryJomaObject();
            if (directory == null) {
                throw new ServiceException(RB.getStringResource("SP.noSrcCodeRepos.ex.txt"));
            }
            String file = this.getSourceFileName();
            if (file == null || file.length() == 0) {
                throw new ServiceException(RB.getStringResource("SP.noSrcCodeFil.ex.txt"));
            }
            ServerContext lsSc = null;
            for (Object c : logicalServer.getUsedByComponents()) {
                if (!(c instanceof ServerContext)) continue;
                if (lsSc != null) {
                    throw new ServiceException(RB.getStringResource("SP.multplSrvrCtxtLS.ex.txt"));
                }
                lsSc = (ServerContext)c;
            }
            if (lsSc == null) {
                throw new ServiceException(RB.getStringResource("SP.noSrvrCtxtLS.ex.txt"));
            }
            ServerContext dirSc = null;
            for (Object c : directory.getDeployedComponents()) {
                if (!(c instanceof ServerContext)) continue;
                if (dirSc != null) {
                    throw new ServiceException(RB.getStringResource("SP.multplSrvrCtxtDir.ex.txt"));
                }
                dirSc = (ServerContext)c;
            }
            if (dirSc == null) {
                throw new ServiceException(RB.getStringResource("SP.noSrvrCtxtDir.ex.txt"));
            }
            if (!dirSc.getFQID().equalsIgnoreCase(lsSc.getFQID())) {
                throw new ServiceException(RB.getStringResource("SP.notSameSrvrCtxt.ex.txt"));
            }
            LogicalServerInterface lsi = this.getServer();
            String classID = lsi.getClassIdentifier();
            boolean bl = isWorkspaceServer = classID.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || classID.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb");
            if (isWorkspaceServer) {
                if (this.isStreamCapable()) {
                    throw new ServiceException(RB.getStringResource("SP.noStrmOnWks.ex.txt"));
                }
                List<OutputParameter> outputParameters = this.getOutputParameters();
                if (outputParameters != null && outputParameters.size() > 0) {
                    throw new ServiceException(RB.getStringResource("SP.noOPOnWks.ex.txt"));
                }
                List<com.sas.services.storedprocess.metadata.GenericStream> streams = this.getStreams();
                if (streams != null && streams.size() > 0) {
                    throw new ServiceException(RB.getStringResource("SP.noDSTOnWks.ex.txt"));
                }
            }
            this.validatePrompts();
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
    }

    private void validate93() throws ServiceException, RemoteException {
        try {
            ServerContext serverContext = this.getServerContextJomaObject();
            if (serverContext == null) {
                throw new ServiceException(RB.getStringResource("SP.noSrvrCtxtSP.ex.txt"));
            }
            StoredProcessInterface.SourceCodeLocation scl = this.getSourceCodeLocation();
            if (this.isOtherServerContextAllowed() && scl == StoredProcessInterface.SourceCodeLocation.FILE_SYSTEM) {
                throw new ServiceException(RB.getStringResource("SP.srcInMetaForOtherCtxts.ex.txt"));
            }
            if (scl == StoredProcessInterface.SourceCodeLocation.FILE_SYSTEM) {
                Directory directory = this.getSourceCodeRepositoryJomaObject();
                if (directory == null) {
                    throw new ServiceException(RB.getStringResource("SP.noSrcCodeRepos.ex.txt"));
                }
                String file = this.getSourceFileName();
                if (file == null || file.length() == 0) {
                    throw new ServiceException(RB.getStringResource("SP.noSrcCodeFil.ex.txt"));
                }
                ServerContext dirSc = null;
                for (Object c : directory.getDeployedComponents()) {
                    if (!(c instanceof ServerContext)) continue;
                    if (dirSc != null) {
                        throw new ServiceException(RB.getStringResource("SP.multplSrvrCtxtDir.ex.txt"));
                    }
                    dirSc = (ServerContext)c;
                }
                if (dirSc == null) {
                    throw new ServiceException(RB.getStringResource("SP.noSrvrCtxtDir.ex.txt"));
                }
                if (!dirSc.getFQID().equalsIgnoreCase(serverContext.getFQID())) {
                    throw new ServiceException(RB.getStringResource("SP.notSameSrvrCtxt1.ex.txt"));
                }
            }
            this.validatePrompts();
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
    }

    @Override
    public void validate() throws ServiceException, RemoteException {
        this.checkCompatible();
        if (this._version == NINETWO_VERSION.encode()) {
            this.validate92();
        } else {
            this.validate93();
        }
        this._couldBeInvalid = false;
    }

    @Override
    public boolean isPackageCapable() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        Element rc = this.getResultCapabilities();
        if (rc == null) {
            return false;
        }
        String value = rc.getAttribute("Package");
        return value != null && value.equalsIgnoreCase("true");
    }

    @Override
    public boolean isStreamCapable() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        Element rc = this.getResultCapabilities();
        if (rc == null) {
            return false;
        }
        String value = rc.getAttribute("Streaming");
        return value != null && value.equalsIgnoreCase("true");
    }

    @Override
    public void setResultCapabilities(boolean isPackageCapable, boolean isStreamCapable) throws ServiceException, RemoteException {
        this.checkCompatible();
        this.getResultCapabilities();
        if (this._resultCapabilities == null && !isPackageCapable && !isStreamCapable) {
            this._couldBeInvalid = true;
            return;
        }
        try {
            if (this._resultCapabilities == null) {
                this.getStoredProcessXMLElementCreatingItIfItDoesNotExist();
                this._resultCapabilities = this._document.createElement("ResultCapabilities");
                this._storedProcessE.appendChild(this._resultCapabilities);
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        this._resultCapabilities.setAttribute("Streaming", isStreamCapable ? "true" : "false");
        this._resultCapabilities.setAttribute("Package", isPackageCapable ? "true" : "false");
        this._couldBeInvalid = true;
    }

    private Element getResultCapabilities() throws ServiceException, RemoteException {
        if (!this._attemptedToGetResultCapabilities) {
            NodeList list;
            Element spE = this.getStoredProcessXMLElementIfExists();
            if (spE != null && (list = spE.getElementsByTagName("ResultCapabilities")).getLength() != 0) {
                if (list.getLength() > 1) {
                    throw new ServiceException(RB.getStringResource("SP.badXMLMultipleResCap.ex.txt"));
                }
                this._resultCapabilities = (Element)list.item(0);
            }
            this._attemptedToGetResultCapabilities = true;
        }
        return this._resultCapabilities;
    }

    private Element getServerContextElement() throws ServiceException, RemoteException {
        if (this._serverContextE == null) {
            Element spE = this.getStoredProcessXMLElementIfExists();
            if (spE == null) {
                throw new ServiceException(RB.getStringResource("SP.noXML.ex.txt"));
            }
            NodeList list = spE.getElementsByTagName("ServerContext");
            if (list.getLength() == 0) {
                throw new ServiceException(RB.getStringResource("SP.badXMLMissingSrvrCtxt.ex.txt"));
            }
            if (list.getLength() > 1) {
                throw new ServiceException(RB.getStringResource("SP.badXMLMultipleSrvrCtxt.ex.txt"));
            }
            this._serverContextE = (Element)list.item(0);
        }
        return this._serverContextE;
    }

    private Element getStoredProcessXMLElementCreatingItIfItDoesNotExist() throws ServiceException, MdException, RemoteException {
        this.getStoredProcessXMLElementIfExists();
        if (this._storedProcessE == null) {
            if (this._document == null) {
                DocumentBuilder builder;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new ServiceException((Throwable)e);
                }
                this._document = builder.newDocument();
            }
            this._storedProcessE = this._document.createElement("StoredProcess");
            this._document.appendChild(this._storedProcessE);
        }
        return this._storedProcessE;
    }

    private Element getStoredProcessXMLElementIfExists() throws ServiceException, RemoteException {
        if (!this._attemptedToGetstoredProcessE) {
            try {
                if (this.isReadCompatible()) {
                    String xml;
                    ClassifierMap cm = (ClassifierMap)this._repositoryObject;
                    for (Object obj : cm.getNotes()) {
                        TextStore ts;
                        if (!(obj instanceof TextStore) || !(ts = (TextStore)obj).getTextRole().equalsIgnoreCase("StoredProcessConfiguration") || !ts.getTextType().equalsIgnoreCase("XML")) continue;
                        this._textStore = ts;
                        break;
                    }
                    if (this._textStore != null && (xml = this._textStore.getStoredText()).length() > 0) {
                        this._document = XMLUtil.convertStringToDocument((String)xml);
                        NodeList list = this._document.getElementsByTagName("StoredProcess");
                        if (list.getLength() > 1) {
                            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SP.badXMLmutlipleSPElements.ex.fmt.txt", (Object)cm.getName()));
                        }
                        if (list.getLength() == 1) {
                            this._storedProcessE = (Element)list.item(0);
                        }
                    }
                }
            }
            catch (MdException mde) {
                throw new ServiceException((Throwable)mde, RB.getStringResource("SP.badMeta.ex.txt"));
            }
            this._attemptedToGetstoredProcessE = true;
        }
        return this._storedProcessE;
    }

    static CMetadata createANewComplexObjectToBeAssociatedWithGivenObject(CMetadata source, String name, String type) throws RemoteException {
        CMetadata newObject = source.getObjectStore().getFactory().createComplexMetadataObject((MdObjectStore)source.getObjectStore(), null, name, type, source.getRepositoryID());
        return newObject;
    }

    @Override
    public List<OutputParameter> getOutputParameters() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        if (!this._attemptedToGetOutputParameters) {
            this._outputParameters = new ArrayList<OutputParameter>();
            Element spE = this.getStoredProcessXMLElementIfExists();
            if (spE != null) {
                try {
                    List<OutputParameterInterface> list = MetadataConstants.getOutputParametersFromXML(spE);
                    if (list != null) {
                        for (OutputParameterInterface op : list) {
                            OutputParameter opl = new OutputParameter();
                            opl.setName(op.getName());
                            opl.setDescription(op.getDescription());
                            opl.setLabel(op.getLabel());
                            opl.setType(op.getType());
                            this._outputParameters.add(opl);
                        }
                    }
                }
                catch (MetadataConstants.MCException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            this._attemptedToGetOutputParameters = true;
        }
        return this._outputParameters;
    }

    @Override
    public void setOutputParameters(List<OutputParameter> outputParameters) throws ServiceException, RemoteException {
        this.checkCompatible();
        if (outputParameters == null) {
            outputParameters = new ArrayList<OutputParameter>();
        }
        HashSet<String> names = new HashSet<String>();
        for (OutputParameter o : outputParameters) {
            if (!(o instanceof OutputParameter)) {
                throw new ServiceException(RB.getStringResource("SP.notOP.ex.txt"));
            }
            OutputParameter op = o;
            op.validate();
            String name = op.getName();
            name = name.toLowerCase();
            if (names.contains(name)) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SP.dupOP.ex.fmt.txt", (Object)name));
            }
            names.add(name);
        }
        try {
            this.getStoredProcessXMLElementCreatingItIfItDoesNotExist();
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        NodeList list = this._storedProcessE.getElementsByTagName("OutputParameters");
        ArrayList<Node> tempList = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            tempList.add(list.item(i));
        }
        Iterator<OutputParameter> it = tempList.iterator();
        while (it.hasNext()) {
            this._storedProcessE.removeChild((Node)((Object)it.next()));
        }
        if (outputParameters.size() > 0) {
            Element outputParmsE = this._document.createElement("OutputParameters");
            for (OutputParameter opl : outputParameters) {
                boolean hasLabel;
                Element parmE = this._document.createElement("Parameter");
                parmE.setAttribute("Name", opl.getName());
                parmE.setAttribute("Type", opl.getType());
                String desc = opl.getDescription();
                String label = opl.getLabel();
                boolean hasDesc = desc != null && desc.length() > 0;
                boolean bl = hasLabel = label != null && label.length() > 0;
                if (hasDesc || hasLabel) {
                    Element cultureE = this._document.createElement("Culture");
                    if (hasLabel) {
                        Element labelE = this._document.createElement("Label");
                        labelE.appendChild(this._document.createTextNode(label));
                        cultureE.appendChild(labelE);
                    }
                    if (hasDesc) {
                        Element descriptionE = this._document.createElement("Description");
                        descriptionE.appendChild(this._document.createTextNode(desc));
                        cultureE.appendChild(descriptionE);
                    }
                    parmE.appendChild(cultureE);
                }
                outputParmsE.appendChild(parmE);
            }
            this._storedProcessE.appendChild(outputParmsE);
        }
        this._outputParameters = outputParameters;
        this._attemptedToGetOutputParameters = true;
        this._couldBeInvalid = true;
    }

    private void writeXML() throws RemoteException, MdException {
        if (this._textStore != null) {
            this._textStore.setStoredText("");
        }
        if (this._document == null) {
            return;
        }
        if (this._storedProcessE == null) {
            return;
        }
        if (this._textStore == null) {
            ClassifierMap cm = (ClassifierMap)this._repositoryObject;
            this._textStore = (TextStore)StoredProcess.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)cm, "Stored Process", "TextStore");
            this._textStore.setTextRole("StoredProcessConfiguration");
            this._textStore.setTextType("XML");
            cm.getNotes().add((Object)this._textStore);
        }
        this._document.normalize();
        this._textStore.setStoredText(XMLUtil.convertNodeToString((Node)this._document));
    }

    @Override
    public List<com.sas.services.storedprocess.metadata.GenericStream> getStreams() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        if (!this._attemptedToGetStreams) {
            this._streams = new ArrayList<com.sas.services.storedprocess.metadata.GenericStream>();
            Element spE = this.getStoredProcessXMLElementIfExists();
            if (spE != null) {
                try {
                    ArrayList listInServiceFormat = new ArrayList();
                    MetadataConstants.getDataSourcesAndTargetsFromXML(null, spE, listInServiceFormat);
                    for (Object o : listInServiceFormat) {
                        com.sas.services.storedprocess.XMLStream xs;
                        if (!(o instanceof GenericStream)) continue;
                        GenericStream gs = (GenericStream)o;
                        com.sas.services.storedprocess.metadata.GenericStream gsl = gs instanceof com.sas.services.storedprocess.XMLStream ? new XMLStream() : new com.sas.services.storedprocess.metadata.GenericStream();
                        gsl.setFileref(gs.getFileref());
                        gsl.setDescription(gs.getDescription());
                        gsl.setLabel(gs.getLabel());
                        gsl.setExpectedContentType(gs.getExpectedContentType());
                        gsl.setSource(gs.isSource());
                        if (gs.isSource()) {
                            gsl.setAllowRewinds(gs.allowsRewinds());
                        }
                        if (gsl instanceof XMLStream && (xs = (com.sas.services.storedprocess.XMLStream)gs).isSchemaAvailable()) {
                            XMLStream xsl = (XMLStream)gsl;
                            xsl.setIsSchemaAvailable(true);
                            xsl.setSchemaURI(xs.getSchemaURI());
                            xsl.setReferenceName(xs.getReferenceName());
                            xsl.setReferenceNameSpace(xs.getReferenceNameSpace());
                            xsl.setIsReferenceTypeForSchemaElement(xs.isReferenceTypeForSchemaElement());
                            xsl.setIsSchemaToBeEmbeddedInWSDL(xs.isSchemaToBeEmbeddedInWSDL());
                        }
                        this._streams.add(gsl);
                    }
                }
                catch (MetadataConstants.MCException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            this._attemptedToGetStreams = true;
        }
        return this._streams;
    }

    @Override
    public void setStreams(List<? extends com.sas.services.storedprocess.metadata.GenericStream> streams) throws ServiceException, RemoteException {
        this.checkCompatible();
        if (this._version > NINETWO_VERSION.encode()) {
            throw new UnsupportedOperationException(RB.getStringResource("SP.notSupported.ex.txt"));
        }
        if (streams == null) {
            streams = new ArrayList<com.sas.services.storedprocess.metadata.GenericStream>();
        }
        HashSet<String> filerefs = new HashSet<String>();
        for (com.sas.services.storedprocess.metadata.GenericStream genericStream : streams) {
            if (!(genericStream instanceof com.sas.services.storedprocess.metadata.GenericStream)) {
                throw new ServiceException(RB.getStringResource("SP.notStrm.ex.txt"));
            }
            com.sas.services.storedprocess.metadata.GenericStream gs = genericStream;
            gs.validate();
            String fileref = gs.getFileref();
            fileref = fileref.toLowerCase();
            if (filerefs.contains(fileref)) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SP.dupFilref.ex.fmt.txt", (Object)fileref));
            }
            filerefs.add(fileref);
        }
        try {
            this.getStoredProcessXMLElementCreatingItIfItDoesNotExist();
        }
        catch (MdException mdException) {
            throw new ServiceException((Throwable)mdException);
        }
        NodeList nodeList = this._storedProcessE.getElementsByTagName("Data");
        ArrayList<Node> tempList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            tempList.add(nodeList.item(i));
        }
        for (Node n : tempList) {
            this._storedProcessE.removeChild(n);
        }
        if (streams.size() > 0) {
            Element dataE = this._document.createElement("Data");
            for (com.sas.services.storedprocess.metadata.GenericStream genericStream : streams) {
                Element strmE = this._document.createElement(genericStream.isSource() ? "Source" : "Target");
                genericStream.writeXML(this._document, strmE);
                dataE.appendChild(strmE);
            }
            this._storedProcessE.appendChild(dataE);
        }
        if (this._streams == null) {
            this._streams = new ArrayList<com.sas.services.storedprocess.metadata.GenericStream>();
        } else {
            this._streams.clear();
        }
        this._streams.addAll(streams);
        this._attemptedToGetStreams = true;
        this._couldBeInvalid = true;
    }

    @Override
    public void convertToVersion(UsageVersion version) throws ServiceException, RemoteException {
        if (version.getMinorVersion() > 0 || version.getMicroVersion() > 0) {
            throw new UnsupportedOperationException("SP.onlyMajorConvSupp.ex.txt");
        }
        int newMajor = version.getMajorVersion();
        UsageVersion currentUV = UsageVersion.decode((double)this._version);
        if (currentUV.getMinorVersion() > 0 || currentUV.getMicroVersion() > 0) {
            throw new UnsupportedOperationException("SP.onlyMajorConvSupp.ex.txt");
        }
        int currentMajor = currentUV.getMajorVersion();
        if (this._couldBeInvalid) {
            throw new ServiceException(RB.getStringResource("SP.modifiedSPShouldBeValidated.ex.txt"));
        }
        if (currentMajor == NINETWO_VERSION.getMajorVersion() && newMajor == NINETHREE_VERSION.getMajorVersion()) {
            this.convertFrom92To93();
        } else if (currentMajor == NINETHREE_VERSION.getMajorVersion() && newMajor == NINETWO_VERSION.getMajorVersion()) {
            this.convertFrom93To92();
        } else {
            String msg = Message.format((String)RB.getStringResource("SP.versConvNotSupp.ex.fmt.txt"), (Object)this._version, (Object)version.encode());
            throw new UnsupportedOperationException(msg);
        }
        this.obtainVersionInfo();
    }

    private void convertFrom93To92() throws ServiceException, RemoteException {
        Root root = (Root)this._repositoryObject;
        if (!this._existingSP) {
            root.setUsageVersion(NINETWO_VERSION.encode());
            return;
        }
        if (this.isOtherServerContextAllowed()) {
            throw new VersionIncompatibleException(RB.getStringResource("SP.cantConvNonSpecAS.ex.txt"));
        }
        boolean isWorkspaceDesired = false;
        switch (this.getLogicalServerType()) {
            case ANY: {
                throw new VersionIncompatibleException(RB.getStringResource("SP.cantConvAnyLS.ex.txt"));
            }
            case WORKSPACE: {
                isWorkspaceDesired = true;
                break;
            }
            case STORED_PROCESS: {
                isWorkspaceDesired = false;
            }
        }
        this._storedProcessE.removeChild(this._serverContextE);
        try {
            this.writeXML();
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        try {
            ClassifierMap cm = (ClassifierMap)this._repositoryObject;
            AssociationList al = cm.getComputeLocations();
            if (al.size() == 0) {
                throw new MdException(RB.getStringResource("SP.missnSC.fmt.txt"));
            }
            if (al.size() > 1) {
                throw new VersionIncompatibleException(RB.getStringResource("SP.multiplSC.fmt.txt"));
            }
            ServerContext sc = (ServerContext)al.get(0);
            LogicalServer ls = MetadataConstants.getLogicalServerFromServerContext(isWorkspaceDesired, sc);
            if (ls == null) {
                throw new ServiceException(isWorkspaceDesired ? "SP.cantConvNoWKSSrvr.ex.txt" : "SP.cantConvNoSPSSrvr.ex.txt");
            }
            al.removeAllElements();
            al.add((Object)ls);
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        List<DataSourceOrTarget> dsots = this.getDataSourcesAndTargets();
        if (isWorkspaceDesired) {
            if (!dsots.isEmpty()) {
                throw new VersionIncompatibleException(RB.getStringResource("SP.cantConvDSOTPrsnt.ex.txt"));
            }
            if (this.isStreamCapable()) {
                throw new VersionIncompatibleException(RB.getStringResource("SP.cantConvStrmCapPrsnt.ex.txt"));
            }
            this.convertPackagePrompts(true);
        } else {
            for (DataSourceOrTarget dsot : dsots) {
                if (!(dsot instanceof DataTable)) continue;
                throw new VersionIncompatibleException(RB.getStringResource("SP.cantConvDTPrsnt.ex.txt"));
            }
        }
        root.setUsageVersion(NINETWO_VERSION.encode());
    }

    private void convertFrom92To93() throws RemoteException, ServiceException {
        boolean isWorkspaceServer;
        Root root = (Root)this._repositoryObject;
        try {
            this.getStoredProcessXMLElementCreatingItIfItDoesNotExist();
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        this._serverContextE = this._document.createElement("ServerContext");
        this._storedProcessE.appendChild(this._serverContextE);
        if (!this._existingSP) {
            try {
                this.doSetOtherServerContextAllowed(false);
                this.doSetLogicalServerType(StoredProcessInterface.LogicalServerType.ANY);
                this.writeXML();
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e);
            }
            root.setUsageVersion(NINETHREE_VERSION.encode());
            return;
        }
        LogicalServerInterface lsi = this.getServer();
        if (lsi == null) {
            throw new ServiceException(RB.getStringResource("SP.cantConvNoSrvrPrsnt.ex.txt"));
        }
        String classID = lsi.getClassIdentifier();
        boolean bl = isWorkspaceServer = classID.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || classID.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb");
        if (isWorkspaceServer) {
            this.convertPackagePrompts(false);
        }
        ServerContextInterface sci = this.doGetServerContextFrom92SP();
        try {
            ClassifierMap cm = (ClassifierMap)this._repositoryObject;
            AssociationList al = cm.getComputeLocations();
            al.removeAllElements();
            al.add(sci.getRepositoryEntity());
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        try {
            this.doSetOtherServerContextAllowed(false);
            this.doSetLogicalServerType(isWorkspaceServer ? StoredProcessInterface.LogicalServerType.WORKSPACE : StoredProcessInterface.LogicalServerType.STORED_PROCESS);
            this.writeXML();
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        root.setUsageVersion(NINETHREE_VERSION.encode());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertPackagePrompts(boolean toNineTwo) throws ServiceException, RemoteException {
        BaseOMRPromptInterface omrPI = this.getPrompt();
        if (!(omrPI instanceof OMRPromptGroupInterface)) {
            return;
        }
        OMRPromptGroupInterface omrPGI = (OMRPromptGroupInterface)omrPI;
        PromptGroupInterface promptGroup = omrPGI.getPromptGroup();
        List archivePathPDIList = PromptUtil.findPromptDefinitionsByName((PromptGroupInterface)promptGroup, (String)"_archive_path", (boolean)true, (boolean)true);
        if (archivePathPDIList.size() != 1) {
            return;
        }
        List resultPDIList = PromptUtil.findPromptDefinitionsByName((PromptGroupInterface)promptGroup, (String)"_result", (boolean)true, (boolean)true);
        if (resultPDIList.size() != 1) {
            return;
        }
        PromptDefinitionInterface pdi = (PromptDefinitionInterface)resultPDIList.get(0);
        if (!(pdi instanceof TextDefinitionInterface)) return;
        TextDefinitionInterface tdi = (TextDefinitionInterface)pdi;
        boolean updateNeeded = false;
        if (toNineTwo) {
            if (tdi.getDefaultValue().toString().equalsIgnoreCase("PACKAGE_TO_ARCHIVE")) {
                if (tdi instanceof SharedPromptDefinitionInterface) {
                    throw new ServiceException(RB.getStringResource("SP.cantConvResltShrd.ex.txt"));
                }
                if (!(tdi instanceof MutablePromptDefinitionInterface)) throw new ServiceException(RB.getStringResource("SP.cantConvResltNotMutbl.ex.txt"));
                ((MutablePromptDefinitionInterface)tdi).setDefaultValue((Object)"PACKAGE_TO_REQUESTER");
                updateNeeded = true;
            }
        } else if (tdi.getDefaultValue().toString().equalsIgnoreCase("PACKAGE_TO_REQUESTER")) {
            if (tdi instanceof SharedPromptDefinitionInterface) {
                throw new ServiceException(RB.getStringResource("SP.cantConvResltShrd.ex.txt"));
            }
            if (!(tdi instanceof MutablePromptDefinitionInterface)) throw new ServiceException(RB.getStringResource("SP.cantConvResltNotMutbl.ex.txt"));
            ((MutablePromptDefinitionInterface)tdi).setDefaultValue((Object)"PACKAGE_TO_ARCHIVE");
            updateNeeded = true;
        }
        if (!updateNeeded) return;
        PromptsPersistUtil.updateGroupSmartObject((PromptGroupInterface)promptGroup, (UserContextInterface)this._repository.getUserContext(), (OMRPromptGroupInterface)omrPGI, null);
    }

    @Override
    public StoredProcessInterface.SourceCodeLocation getSourceCodeLocation() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        if (this._sourceCodeLocationDetermined) {
            return this._sourceCodeLocation;
        }
        this.determineSourceCodeLocation();
        return this._sourceCodeLocation;
    }

    @Override
    public void setSourceCodeLocation(StoredProcessInterface.SourceCodeLocation sourceCodeLocation) throws ServiceException, RemoteException {
        this.checkCompatible();
        if (this._version == NINETWO_VERSION.encode()) {
            throw new UnsupportedOperationException(RB.getStringResource("SP.notSupported.ex.txt"));
        }
        this._sourceCodeLocationDetermined = true;
        this._sourceCodeLocation = sourceCodeLocation;
        this._couldBeInvalid = true;
        if (sourceCodeLocation == StoredProcessInterface.SourceCodeLocation.FILE_SYSTEM) {
            this.deleteSourceCodeJomaObject();
        } else {
            this.deleteSourceFileJomaObject();
            this.createTextStoreForSourceIfNeeded();
        }
    }

    private void determineSourceCodeLocation() throws ServiceException, RemoteException {
        if (this._existingSP) {
            if (this.getSourceFileJomaObject() != null) {
                this._sourceCodeLocationDetermined = true;
                this._sourceCodeLocation = StoredProcessInterface.SourceCodeLocation.FILE_SYSTEM;
                return;
            }
            if (this.getSourceCodeJomaObject() != null) {
                this._sourceCodeLocationDetermined = true;
                this._sourceCodeLocation = StoredProcessInterface.SourceCodeLocation.METADATA;
                return;
            }
            throw new ServiceException(RB.getStringResource("SP.badMetaMissnSrcCdeMeta.ex.txt"));
        }
        this._sourceCodeLocationDetermined = true;
        this._sourceCodeLocation = StoredProcessInterface.SourceCodeLocation.FILE_SYSTEM;
    }

    @Override
    public String getSourceCode() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        StoredProcessInterface.SourceCodeLocation scl = this.getSourceCodeLocation();
        if (scl == StoredProcessInterface.SourceCodeLocation.FILE_SYSTEM) {
            throw new UnsupportedOperationException(RB.getStringResource("SP.onlySCinMeta.ex.txt"));
        }
        return this._textStoreForSourceCode.getStoredText();
    }

    @Override
    public void setSourceCode(String sourceCode) throws ServiceException, RemoteException {
        this.checkCompatible();
        if (this._version == NINETWO_VERSION.encode()) {
            throw new UnsupportedOperationException(RB.getStringResource("SP.notSupported.ex.txt"));
        }
        if (sourceCode == null) {
            throw new NullPointerException();
        }
        StoredProcessInterface.SourceCodeLocation scl = this.getSourceCodeLocation();
        if (scl == StoredProcessInterface.SourceCodeLocation.FILE_SYSTEM) {
            throw new ServiceException(RB.getStringResource("SP.onlySCinMeta.ex.txt"));
        }
        this._textStoreForSourceCode.setStoredText(sourceCode);
    }

    @Override
    public List<DataSourceOrTarget> getDataSourcesAndTargets() throws ServiceException, RemoteException {
        this.checkPulse(true);
        this.checkIfReadCompatible();
        if (!this._attemptedToGetDSDT) {
            this._dsdt = new ArrayList<DataSourceOrTarget>();
            Element spE = this.getStoredProcessXMLElementIfExists();
            if (spE != null) {
                try {
                    RepositoryInterface ri = this.getRepository();
                    ServerInterface si = ri.getServer();
                    ArrayList listInServiceFormat = new ArrayList();
                    MetadataConstants.getDataSourcesAndTargetsFromXML(si, spE, listInServiceFormat);
                    if (listInServiceFormat.size() > 0) {
                        for (Object o : listInServiceFormat) {
                            if (o instanceof GenericStream) {
                                com.sas.services.storedprocess.XMLStream xs;
                                GenericStream gs = (GenericStream)o;
                                com.sas.services.storedprocess.metadata.GenericStream gsl = gs instanceof com.sas.services.storedprocess.XMLStream ? new XMLStream() : new com.sas.services.storedprocess.metadata.GenericStream();
                                gsl.setFileref(gs.getFileref());
                                gsl.setDescription(gs.getDescription());
                                gsl.setLabel(gs.getLabel());
                                gsl.setExpectedContentType(gs.getExpectedContentType());
                                gsl.setSource(gs.isSource());
                                if (gs.isSource()) {
                                    gsl.setAllowRewinds(gs.allowsRewinds());
                                }
                                if (gsl instanceof XMLStream && (xs = (com.sas.services.storedprocess.XMLStream)gs).isSchemaAvailable()) {
                                    XMLStream xsl = (XMLStream)gsl;
                                    xsl.setIsSchemaAvailable(true);
                                    xsl.setSchemaURI(xs.getSchemaURI());
                                    xsl.setReferenceName(xs.getReferenceName());
                                    xsl.setReferenceNameSpace(xs.getReferenceNameSpace());
                                    xsl.setIsReferenceTypeForSchemaElement(xs.isReferenceTypeForSchemaElement());
                                    xsl.setIsSchemaToBeEmbeddedInWSDL(xs.isSchemaToBeEmbeddedInWSDL());
                                }
                                this._dsdt.add(gsl);
                                continue;
                            }
                            if (!(o instanceof DataTable)) continue;
                            this._dsdt.add((DataTable)o);
                        }
                    }
                }
                catch (MetadataConstants.MCException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            this._attemptedToGetDSDT = true;
        }
        return this._dsdt;
    }

    @Override
    public void setDataSourcesAndTargets(List<? extends DataSourceOrTarget> dataSourcesAndTargets) throws ServiceException, RemoteException {
        String parameterName;
        DataTable dt;
        this.checkCompatible();
        if (this._version == NINETWO_VERSION.encode()) {
            throw new UnsupportedOperationException(RB.getStringResource("SP.notSupported.ex.txt"));
        }
        if (dataSourcesAndTargets == null) {
            dataSourcesAndTargets = new ArrayList<DataSourceOrTarget>();
        }
        HashSet<String> uniqueNames = new HashSet<String>();
        for (DataSourceOrTarget dataSourceOrTarget : dataSourcesAndTargets) {
            if (!(dataSourceOrTarget instanceof com.sas.services.storedprocess.metadata.GenericStream)) continue;
            com.sas.services.storedprocess.metadata.GenericStream gs = (com.sas.services.storedprocess.metadata.GenericStream)dataSourceOrTarget;
            gs.validate();
            String fileref = gs.getFileref();
            fileref = fileref.toLowerCase();
            if (uniqueNames.contains(fileref)) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SP.dupFilref.ex.fmt.txt", (Object)fileref));
            }
            uniqueNames.add(fileref);
        }
        uniqueNames.clear();
        for (DataSourceOrTarget dataSourceOrTarget : dataSourcesAndTargets) {
            if (!(dataSourceOrTarget instanceof DataTable) || !(dt = (DataTable)dataSourceOrTarget).isSource()) continue;
            dt.validate();
            parameterName = dt.getParameterName();
            parameterName = parameterName.toLowerCase();
            if (uniqueNames.contains(parameterName)) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SP.dupTable.ex.fmt.txt", (Object)parameterName));
            }
            uniqueNames.add(parameterName);
        }
        uniqueNames.clear();
        for (DataSourceOrTarget dataSourceOrTarget : dataSourcesAndTargets) {
            if (!(dataSourceOrTarget instanceof DataTable) || (dt = (DataTable)dataSourceOrTarget).isSource()) continue;
            dt.validate();
            parameterName = dt.getParameterName();
            parameterName = parameterName.toLowerCase();
            if (uniqueNames.contains(parameterName)) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SP.dupTable.ex.fmt.txt", (Object)parameterName));
            }
            uniqueNames.add(parameterName);
        }
        try {
            this.getStoredProcessXMLElementCreatingItIfItDoesNotExist();
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        NodeList list = this._storedProcessE.getElementsByTagName("Data");
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            arrayList.add(list.item(i));
        }
        for (Node n : arrayList) {
            this._storedProcessE.removeChild(n);
        }
        if (dataSourcesAndTargets.size() > 0) {
            Element dataE = this._document.createElement("Data");
            for (DataSourceOrTarget dataSourceOrTarget : dataSourcesAndTargets) {
                Element dstE = this._document.createElement(dataSourceOrTarget.isSource() ? "Source" : "Target");
                dataSourceOrTarget.writeXML(this._document, dstE);
                dataE.appendChild(dstE);
            }
            this._storedProcessE.appendChild(dataE);
        }
        if (this._dsdt == null) {
            this._dsdt = new ArrayList<DataSourceOrTarget>();
        } else {
            this._dsdt.clear();
        }
        this._dsdt.addAll(dataSourcesAndTargets);
        this._attemptedToGetDSDT = true;
        this._couldBeInvalid = true;
    }

    @Override
    public PromptValuesInterface getPromptValues() throws ServiceException, RemoteException {
        BaseOMRPromptInterface omrPI = this.getPrompt();
        if (omrPI instanceof OMRPromptGroupInterface) {
            OMRPromptGroupInterface omrPGI = (OMRPromptGroupInterface)omrPI;
            PromptGroupInterface promptGroup = omrPGI.getPromptGroup();
            PromptValues promptValues = new PromptValues(promptGroup, null);
            return promptValues;
        }
        throw new ServiceException(RB.getStringResource("SP.noOMRPGI.ex.txt"));
    }

    public void refresh() throws ServiceException, RemoteException {
        this.reset();
        ClassifierMap classifierMap = (ClassifierMap)this.getRepositoryEntity();
        int jomaOptions = 268;
        String template = "<Templates><ClassifierMap><ComputeLocations/><Keywords/><Notes/><Prompts/><ResponsibleParties/><SourceCode/><Trees/></ClassifierMap><Directory><Properties/></Directory><File><Directories/></File><ServerContext><UsingComponents/></ServerContext></Templates>";
        MdOMIUtil omiUtil = classifierMap.getObjectStore().getFactory().getOMIUtil();
        try {
            omiUtil.getOMIUtility().getMetadataAllDepths(classifierMap.getObjectStore(), classifierMap.getCMetadataType(), classifierMap.getFQID(), null, null, template, jomaOptions, false, false);
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        this.resetObject();
    }

    private void resetObject() throws RemoteException {
        this._textStore = null;
        this._document = null;
        this._storedProcessE = null;
        this._attemptedToGetstoredProcessE = false;
        this._resultCapabilities = null;
        this._attemptedToGetResultCapabilities = false;
        this._serverContextE = null;
        this._outputParameters = null;
        this._attemptedToGetOutputParameters = false;
        this._dsdt = null;
        this._attemptedToGetDSDT = false;
        this._streams = null;
        this._attemptedToGetStreams = false;
        this._file = null;
        this._attemptedToGet_file = false;
        this._textStoreForSourceCode = null;
        this._attemptedToGet_textStoreForSourceCode = false;
        this.obtainVersionInfo();
        this._couldBeInvalid = false;
        this._sourceCodeLocation = null;
        this._sourceCodeLocationDetermined = false;
    }
}

