/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess.metadata;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.storedprocess.metadata.RB;
import com.sas.services.storedprocess.metadata.StoredProcess;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SourceCodeRepositoryUtil {
    ServerContextInterface _serverContextInterface;
    ServerContext _serverContext;
    RepositoryInterface _repositoryInterface;

    public SourceCodeRepositoryUtil(ServerContextInterface serverContext) throws RemoteException {
        this.init(serverContext);
    }

    public SourceCodeRepositoryUtil(LogicalServerInterface logicalServer) throws RemoteException, ServiceException {
        AssociationList al;
        if (logicalServer == null) {
            throw new NullPointerException();
        }
        try {
            LogicalServer ls = (LogicalServer)logicalServer.getRepositoryEntity();
            if (ls == null) {
                throw new ServiceException(RB.getStringResource("SCRU.noLogSrvr.ex.txt"));
            }
            al = ls.getUsedByComponents();
        }
        catch (MdException mde) {
            throw new ServiceException((Throwable)mde);
        }
        int size = al.size();
        if (size == 0) {
            throw new ServiceException(RB.getStringResource("SCRU.badMetaNoSrvrCtxt.ex.txt"));
        }
        if (size > 1) {
            throw new ServiceException(RB.getStringResource("COM.badMetaMultipleSrvrCtxts.ex.txt"));
        }
        CMetadata metadata = (CMetadata)al.get(0);
        if (metadata instanceof ServerContext) {
            this.init((ServerContextInterface)logicalServer.getRepository().factoryProcess((Object)metadata));
            return;
        }
        throw new ServiceException(RB.getStringResource("COM.badMetaNotSrvrCtxt.ex.txt"));
    }

    private void init(ServerContextInterface serverContext) throws RemoteException {
        if (serverContext == null) {
            throw new NullPointerException();
        }
        this._serverContextInterface = serverContext;
        this._serverContext = (ServerContext)serverContext.getRepositoryEntity();
        this._repositoryInterface = serverContext.getRepository();
    }

    public DirectoryInterface createSourceCodeRepository(String path, String description) throws ServiceException, RemoteException {
        try {
            DirectoryInterface dir = this.locateSourceCodeRepository(path);
            if (dir != null) {
                throw new ServiceException(RB.getStringResource("SCRU.exists.ex.txt"));
            }
            Directory d = (Directory)StoredProcess.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._serverContext, "SP Source Directory", "Directory");
            Property property = (Property)StoredProcess.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._serverContext, "SP Source Directory", "Property");
            property.setPropertyRole("SPSourceCodeRepository");
            property.setSQLType(12);
            d.setDirectoryName(path);
            if (description != null && description.length() > 0) {
                d.setDesc(description);
            }
            d.getProperties().add((Object)property);
            d.getDeployedComponents().add((Object)this._serverContext);
            d.updateMetadataAll();
            return (DirectoryInterface)this._repositoryInterface.factoryProcess((Object)d);
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public DirectoryInterface locateSourceCodeRepository(String name) throws ServiceException, RemoteException {
        try {
            for (Object o : this._serverContext.getDataPackages()) {
                if (!(o instanceof Directory)) continue;
                Directory d = (Directory)o;
                Iterator itd = d.getProperties().iterator();
                boolean isSourceCodeRepository = false;
                while (itd.hasNext()) {
                    Property p = (Property)itd.next();
                    if (!p.getPropertyRole().equalsIgnoreCase("SPSourceCodeRepository")) continue;
                    isSourceCodeRepository = true;
                    break;
                }
                if (!isSourceCodeRepository || !d.getDirectoryName().equals(name)) continue;
                return (DirectoryInterface)this._repositoryInterface.factoryProcess((Object)d);
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        return null;
    }

    public List<DirectoryInterface> getSourceCodeRepositories() throws ServiceException, RemoteException {
        Iterator it = this._serverContextInterface.getDataPackages().iterator();
        ArrayList<DirectoryInterface> sourceRepositories = new ArrayList<DirectoryInterface>();
        block2: while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof DirectoryInterface)) continue;
            DirectoryInterface di = (DirectoryInterface)o;
            try {
                Directory dir = (Directory)di.getRepositoryEntity();
                for (Property p : dir.getProperties()) {
                    if (!p.getPropertyRole().equalsIgnoreCase("SPSourceCodeRepository")) continue;
                    sourceRepositories.add(di);
                    continue block2;
                }
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return sourceRepositories;
    }
}

