/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.storedprocess.metadata.RB;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class OutputParameter
implements Serializable {
    private static final long serialVersionUID = -8205069844387728439L;
    public static String TYPE_DATE = "Date";
    public static String TYPE_DOUBLE = "Double";
    public static String TYPE_INTEGER = "Integer";
    public static String TYPE_TIME = "Time";
    public static String TYPE_TIMESTAMP = "TimeStamp";
    public static String TYPE_STRING = "String";
    private String _name;
    private String _type;
    private String _label;
    private String _description;

    public String getDescription() {
        return this._description;
    }

    public String getLabel() {
        return this._label;
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void validate() throws ServiceException {
        String name = this.getName();
        if (name == null || name.length() == 0) {
            throw new ServiceException(RB.getStringResource("OP.noName.ex.txt"));
        }
        try {
            Names.validateSASVariableName((String)name, (boolean)true);
        }
        catch (Exception e) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"OP.badName.ex.fmt.txt", (Object)e.getMessage()));
        }
        String type = this.getType();
        if (type == null || type.length() == 0) {
            throw new ServiceException(RB.getStringResource("OP.noType.ex.txt"));
        }
        if (!(type.equalsIgnoreCase(TYPE_STRING) || type.equalsIgnoreCase(TYPE_DOUBLE) || type.equalsIgnoreCase(TYPE_INTEGER) || type.equalsIgnoreCase(TYPE_DATE) || type.equalsIgnoreCase(TYPE_TIME) || type.equalsIgnoreCase(TYPE_TIMESTAMP))) {
            throw new ServiceException(RB.getStringResource("OP.badType.ex.txt"));
        }
    }
}

