/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.storedprocess.metadata.DataSourceOrTarget;
import com.sas.services.storedprocess.metadata.RB;
import com.sas.services.util.Names;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.text.Message;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DataTable
extends DataSourceOrTarget
implements LocalizableProperties,
Serializable {
    private static final long serialVersionUID = -1592688346236618708L;
    private String _parameterName;
    private PhysicalTableInterface _templateTable;
    private String _templateTablePath;
    private ServiceException _exceptionConstructingTemplateTable;

    public DataTable() {
    }

    @SASScope
    public DataTable(ServerInterface serverInterface, Element element, boolean isSource) throws RemoteException, MetadataConstants.MCException {
        this.setSource(isSource);
        this._parameterName = element.getAttribute("Name");
        if (serverInterface != null) {
            String absolutePath = element.getAttribute("TemplateTableLocation");
            this.setTemplateTableFromAbsolutePath(serverInterface, absolutePath);
        }
        this.readXML(element);
    }

    public String getParameterName() {
        return this._parameterName;
    }

    public PhysicalTableInterface getTemplateTable() throws ServiceException {
        if (this._exceptionConstructingTemplateTable != null) {
            throw this._exceptionConstructingTemplateTable;
        }
        return this._templateTable;
    }

    public void setTemplateTable(PhysicalTableInterface templateTable) throws IllegalStateException, ServiceException, RemoteException {
        this._templateTablePath = templateTable == null ? null : templateTable.getPathUrl().getAbsolutePath();
        this._templateTable = templateTable;
    }

    private void setTemplateTableFromAbsolutePath(ServerInterface metadataServerInterface, String absolutePath) throws RemoteException {
        this._templateTable = null;
        if (absolutePath == null || absolutePath.length() == 0) {
            this._exceptionConstructingTemplateTable = null;
            return;
        }
        try {
            PathUrl pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)metadataServerInterface, (String)absolutePath);
            this._templateTable = (PhysicalTableInterface)metadataServerInterface.getObjectByPath(pathUrl);
            if (this._templateTable == null) {
                this._exceptionConstructingTemplateTable = new ServiceException(Message.format((String)RB.getStringResource("DT.NoTab.fmt.txt"), (Object)absolutePath));
            }
        }
        catch (ServiceException e) {
            this._exceptionConstructingTemplateTable = new ServiceException(Message.format((String)RB.getStringResource("DT.NoTabExcp.fmt.txt"), (Object)absolutePath, (Object)e.getMessage()));
        }
    }

    public void setParameterName(String parameterName) {
        this._parameterName = parameterName;
    }

    @Override
    public void validate() throws ServiceException {
        String parameterName = this.getParameterName();
        if (parameterName == null || parameterName.length() == 0) {
            throw new ServiceException(RB.getStringResource("DT.noName.ex.txt"));
        }
        try {
            parameterName = this.isSource() ? "_Source_" + parameterName : "_Target_" + parameterName;
            Names.validateSASVariableName((String)parameterName, (boolean)true);
        }
        catch (Exception e) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"DT.badName.ex.fmt.txt", (Object)e.getMessage()));
        }
    }

    @Override
    public void writeXML(Document document, Element element) {
        element.setAttribute("Type", "DataTable");
        element.setAttribute("Name", this.getParameterName());
        if (this._templateTable != null) {
            element.setAttribute("TemplateTableLocation", this._templateTablePath);
        }
        super.writeXML(document, element);
    }

    @SASScope
    public PropertyList getLocalizableProperties() {
        PropertyList list = new PropertyList();
        list.addProperty("Label", this.getLabel());
        list.addProperty("Description", this.getDescription());
        return list;
    }

    @SASScope
    public void setLocalizableProperties(PropertyMap map) {
        if (map == null) {
            return;
        }
        Document document = this._element.getOwnerDocument();
        if (map.containsProperty("Label")) {
            if (this._labelElement == null) {
                this.ensureCultureExists();
                this._labelElement = document.createElement("Label");
                this._cultureElement.appendChild(this._labelElement);
            }
            this._labelElement.setTextContent(map.getProperty("Label"));
        }
        if (map.containsProperty("Description")) {
            if (this._descElement == null) {
                this.ensureCultureExists();
                this._descElement = document.createElement("Description");
                this._cultureElement.appendChild(this._descElement);
            }
            this._descElement.setTextContent(map.getProperty("Description"));
        }
    }

    private void ensureCultureExists() {
        if (this._cultureElement != null) {
            return;
        }
        Document document = this._element.getOwnerDocument();
        this._cultureElement = document.createElement("Culture");
        this._element.appendChild(this._cultureElement);
    }
}

