/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.KeywordFilter;
import java.util.Iterator;

@SASScope
public class AlertFilter
extends KeywordFilter {
    private static final long serialVersionUID = -2292237465511373539L;
    private String _name;
    private ChannelInterface _channel;

    public AlertFilter() {
        this.setType("StoredProcessAlert");
        this._name = null;
        this._channel = null;
    }

    public AlertFilter(String key, int relation, String value) {
        super(key, relation, value);
        this.setType("StoredProcessAlert");
        this._name = null;
        this._channel = null;
    }

    public String getOMRType() {
        return "ITSubscriber";
    }

    public String getLDAPType() {
        return "storedprocessalert";
    }

    public String getDAVType() {
        return "storedprocessalert";
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public ChannelInterface getChannel() {
        return this._channel;
    }

    public void setChannel(ChannelInterface channel) {
        this._channel = channel;
    }

    public String getXMLSelectString() {
        StringBuffer buffer = new StringBuffer(250);
        if (this._name != null || this._keywords.size() > 0) {
            buffer.append("<XMLSelect Search=\"*");
            if (this._name != null) {
                buffer.append("[@Name='" + this._name + "']");
            }
            if (this._keywords.size() > 0) {
                buffer.append("[Keywords/*[");
                Iterator it = this._keywords.iterator();
                boolean firstName = true;
                while (it.hasNext()) {
                    if (!firstName) {
                        buffer.append(" OR ");
                    }
                    buffer.append("@Name='" + (String)it.next() + '\'');
                    firstName = false;
                }
                buffer.append(" ]]");
            }
            buffer.append("\" />\n");
        }
        return buffer.toString();
    }

    public String getDAVBasicSearchString() {
        FilterComponent compy = this._component;
        FilterComponent nameComp = new FilterComponent();
        FilterComponent keywordComp = null;
        if (this._channel != null) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><d:searchrequest xmlns:d=\"DAV:\"><d:basicsearch/></d:searchrequest>";
        }
        if (this._name != null) {
            nameComp.setFilter("{http://www.sas.com/xml/namespace/services.webdav-1.1}name", 0, this._name);
        }
        if (this._keywords.size() > 0) {
            keywordComp = new FilterComponent();
            Iterator it = this._keywords.iterator();
            while (it.hasNext()) {
                keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}saskeyword", 0, (String)it.next()));
            }
            keywordComp.setAggregation(1);
        }
        if (keywordComp != null) {
            nameComp.addComponent(keywordComp);
            nameComp.setAggregation(0);
        }
        if (compy != null) {
            nameComp.addComponent(compy);
            nameComp.setAggregation(0);
        }
        this.setFilterComponent(nameComp);
        String result = super.getDAVBasicSearchString();
        this.setFilterComponent(compy);
        return result;
    }

    public String getDAVSQLString() {
        FilterComponent compy = this._component;
        FilterComponent nameComp = new FilterComponent();
        FilterComponent keywordComp = null;
        if (this._channel != null) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><d:searchrequest xmlns:d=\"DAV:\"><d:sql/></d:searchrequest>";
        }
        if (this._name != null) {
            nameComp.setFilter("{http://www.sas.com/xml/namespace/services.webdav-1.1}name", 0, this._name);
        }
        if (this._keywords.size() > 0) {
            keywordComp = new FilterComponent();
            Iterator it = this._keywords.iterator();
            while (it.hasNext()) {
                keywordComp.addComponent(new FilterComponent("{http://www.sas.com/rnd/itech/WebDAV}saskeyword", 0, (String)it.next()));
            }
            keywordComp.setAggregation(1);
        }
        if (keywordComp != null) {
            nameComp.addComponent(keywordComp);
            nameComp.setAggregation(0);
        }
        if (compy != null) {
            nameComp.addComponent(compy);
            nameComp.setAggregation(0);
        }
        this.setFilterComponent(nameComp);
        String result = super.getDAVSQLString();
        this.setFilterComponent(compy);
        return result;
    }
}

