/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.services.storedprocess.Credentials;
import com.sas.services.storedprocess.GetIdentityByDomainAction;
import com.sas.services.storedprocess.InternalUseException;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.ResultHints;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Logger;

public class WebDAVPackageURLResultHints
extends ResultHints {
    static final long serialVersionUID = -48163079264756839L;
    String _proxyURL;
    String _userName;
    String _password;
    String _domainName;

    WebDAVPackageURLResultHints() {
    }

    public void setCollectionURL(String collectionURL) {
        this.setResultLocation(collectionURL);
    }

    public String getCollectionURL() {
        return (String)this.getResultLocation();
    }

    public void setProxyURL(String proxyURL) {
        this._proxyURL = proxyURL;
    }

    public String getProxyURL() {
        return this._proxyURL;
    }

    public void setCredentials(String userName, String password) {
        this._userName = userName;
        this._password = password;
    }

    public void setDomain(String domainName) {
        this._domainName = domainName;
    }

    String getDomain() {
        return this._domainName;
    }

    @Override
    void validate() throws InternalUseException {
        String resultLocation = (String)this.getResultLocation();
        if (resultLocation == null || resultLocation.length() == 0) {
            throw new InternalUseException(RB.getStringResource("WPURLRH.noColl.ex.txt"));
        }
        if (this.isNewInstanceCreated()) {
            throw new InternalUseException(RB.getStringResource("WPURLRH.noInstnc.ex.txt"));
        }
    }

    Credentials getCredentials(Logger logger, UserContextInterface userContext) throws RemoteException {
        Credentials credentials = new Credentials();
        if (this._userName != null && this._password != null) {
            credentials._userName = this._userName;
            credentials._password = this._password;
        } else if (userContext != null && this._domainName != null) {
            credentials._userIdentity = GetIdentityByDomainAction.getIdentity(userContext, this._domainName, logger);
            if (credentials._userIdentity != null) {
                credentials._userName = (String)credentials._userIdentity.getPrincipal();
                credentials._password = (String)credentials._userIdentity.getCredential();
            }
        }
        return credentials;
    }
}

