/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.DAVRepository;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PersonalRepositoryInterface;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.services.storedprocess.Credentials;
import com.sas.services.storedprocess.GetIdentityByDomainAction;
import com.sas.services.storedprocess.LocationHelper;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.URLUtil;
import com.sas.services.storedprocess.UniqueNameGenerator;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

@SASScope
class WebDAVPackagePRLocationHelper
extends LocationHelper {
    private String _collectionInPR;
    private String _relativePathToResultInstance;
    private PersonalRepositoryInterface _personalRepository;
    private FolderInterface _myResults;

    WebDAVPackagePRLocationHelper(String collectionInPR, boolean createNewInstance) {
        super(createNewInstance);
        this._collectionInPR = collectionInPR;
    }

    void setPersonalRepository(PersonalRepositoryInterface personalRepository) {
        this._personalRepository = personalRepository;
    }

    PackageInterface getSmartObject() throws ServiceException, RemoteException {
        this._myResults.refresh();
        PackageInterface pi = (PackageInterface)this._myResults.getItem(this._relativePathToResultInstance);
        if (pi == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)('\"' + this._relativePathToResultInstance + "\" should have been found in the MyResults area of the PR"));
            throw new ServiceException(msg);
        }
        return pi;
    }

    void determineResultsLocation(String suggestedName, Logger logger, String loggingId) throws ServiceException, RemoteException {
        this._myResults = this._personalRepository.getApplicationManager(3);
        final String URLofPR = DAVRepository.getUrlFromEntityKey((String)this._myResults.getEntityKey());
        final String myResultsReposKey = this._myResults.getReposKey();
        if (this.isNewInstanceCreated()) {
            UniqueNameGenerator.Callback callback = new UniqueNameGenerator.Callback(){

                @Override
                public Object isUnique(String leafName) throws Exception {
                    String relativePath = WebDAVPackagePRLocationHelper.this._collectionInPR == null ? leafName : URLUtil.concat(WebDAVPackagePRLocationHelper.this._collectionInPR, leafName);
                    DAVRepositoryInterface davRepository = (DAVRepositoryInterface)WebDAVPackagePRLocationHelper.this._personalRepository.getRepository();
                    relativePath = URLUtil.stripLeadingSlashes(relativePath);
                    int locationOfType = myResultsReposKey.lastIndexOf("/");
                    String reposKeyToTry = myResultsReposKey.substring(0, locationOfType + 1) + relativePath + myResultsReposKey.substring(locationOfType);
                    if (davRepository.fetch(reposKeyToTry, true) != null) {
                        return null;
                    }
                    return relativePath;
                }

                @Override
                public String metadataTypeForErrorMessage() {
                    return "package";
                }

                @Override
                public String repositoryForErrorMessage() {
                    return URLUtil.concat(URLofPR, WebDAVPackagePRLocationHelper.this._collectionInPR);
                }
            };
            try {
                this._relativePathToResultInstance = (String)UniqueNameGenerator.find(suggestedName, 100, true, callback, logger, loggingId);
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (RemoteException re) {
                throw re;
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e, RB.getStringResource("COM.noUniq.ex.txt"));
            }
        } else {
            this._relativePathToResultInstance = this._collectionInPR;
        }
        String resultURL = URLUtil.concat(URLofPR, this._relativePathToResultInstance);
        this.setResultLocation(resultURL);
    }

    Credentials getCredentials(Logger logger) throws RemoteException {
        Credentials credentials = new Credentials();
        RepositoryInterface ri = this._personalRepository.getRepository();
        UserContextInterface uc = ri.getUserContext();
        if (uc != null) {
            credentials._userIdentity = GetIdentityByDomainAction.getIdentity(uc, ri.getDomain(), logger);
            if (credentials._userIdentity != null) {
                credentials._userName = (String)credentials._userIdentity.getPrincipal();
                credentials._password = (String)credentials._userIdentity.getCredential();
            }
        }
        return credentials;
    }
}

