/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceProxy;
import com.sas.services.TransportException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.StoredProcessInterface;
import com.sas.services.storedprocess.StoredProcessServiceInterface;
import com.sas.services.storedprocess.metadata.StoredProcessOptions;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class StoredProcessServiceProxy
extends ServiceProxy
implements StoredProcessServiceInterface,
Serializable {
    private static final long serialVersionUID = 9219767871613409999L;

    public StoredProcessServiceProxy(StoredProcessServiceInterface storedProcessService) throws InitializationException {
        super((RemoteServiceInterface)storedProcessService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final StoredProcessInterface newStoredProcess(SessionContextInterface sessionContext, com.sas.services.storedprocess.metadata.StoredProcessInterface storedProcessSmartObject) throws InitializationException, TransportException, RemoteException {
        StoredProcessInterface storedProcess = null;
        StoredProcessServiceInterface service = this.getStoredProcessService();
        RemoteException remoteException = null;
        try {
            storedProcess = service.newStoredProcess(sessionContext, storedProcessSmartObject);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    storedProcess = this.findStoredProcessService().newStoredProcess(sessionContext, storedProcessSmartObject);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return storedProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object newStoredProcess(com.sas.services.storedprocess.metadata.StoredProcessInterface storedProcessSmartObject, StoredProcessOptions options) throws InitializationException, TransportException, RemoteException {
        Object storedProcess = null;
        StoredProcessServiceInterface service = this.getStoredProcessService();
        RemoteException remoteException = null;
        try {
            storedProcess = service.newStoredProcess(storedProcessSmartObject, options);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    storedProcess = this.findStoredProcessService().newStoredProcess(storedProcessSmartObject, options);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return storedProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final StoredProcessInterface newStoredProcess(SessionContextInterface sessionContext, int serverType, int resultType) throws IllegalArgumentException, RemoteException {
        StoredProcessInterface storedProcess = null;
        StoredProcessServiceInterface service = this.getStoredProcessService();
        RemoteException remoteException = null;
        try {
            storedProcess = service.newStoredProcess(sessionContext, serverType, resultType);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    storedProcess = this.findStoredProcessService().newStoredProcess(sessionContext, serverType, resultType);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return storedProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object newStoredProcess(int serverType, StoredProcessOptions options) throws IllegalArgumentException, InitializationException, RemoteException {
        Object storedProcess = null;
        StoredProcessServiceInterface service = this.getStoredProcessService();
        RemoteException remoteException = null;
        try {
            storedProcess = service.newStoredProcess(serverType, options);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    storedProcess = this.findStoredProcessService().newStoredProcess(serverType, options);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return storedProcess;
    }

    private final StoredProcessServiceInterface getStoredProcessService() {
        return (StoredProcessServiceInterface)this.getService();
    }

    private final StoredProcessServiceInterface findStoredProcessService() throws ServiceException, RemoteException {
        return (StoredProcessServiceInterface)this.findRemoteService();
    }

    @Override
    public String getClientName() throws RemoteException {
        return ((StoredProcessServiceInterface)this.getService()).getClientName();
    }

    @Override
    public void setClientName(String clientName) throws RemoteException {
        ((StoredProcessServiceInterface)this.getService()).setClientName(clientName);
    }
}

