/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.RemoteEntity;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.persist.PromptToEntityConverter;
import com.sas.metadata.remote.ArchiveFile;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.ContentLocation;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Report;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Stream;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.entities.MdOMAEntityUtility;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.metadata.HttpServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.OMRHttpServer;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.Execution;
import com.sas.services.storedprocess.ExecutionException;
import com.sas.services.storedprocess.ExecutionInterface;
import com.sas.services.storedprocess.ExecutionStatusListenerInterface;
import com.sas.services.storedprocess.GenericStream;
import com.sas.services.storedprocess.InternalUseException;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.storedprocess.PermanentPackageResultHints;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.ResultHints;
import com.sas.services.storedprocess.StoredProcessInterface;
import com.sas.services.storedprocess.StoredProcessService;
import com.sas.services.storedprocess.StreamDefinition;
import com.sas.services.storedprocess.TransientPackageResultHints;
import com.sas.services.storedprocess.WebDAVPackageDAVServerLocationHelper;
import com.sas.services.storedprocess.WebDAVPackageDAVServerResultHints;
import com.sas.services.storedprocess.WebDAVPackagePRResultHints;
import com.sas.services.storedprocess.WebDAVPackageURLResultHints;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@SASScope
final class StoredProcess
extends RemoteEntity
implements StoredProcessInterface {
    static final int CREATED_BY_USER = 0;
    static final int CREATED_FROM_METADATA = 1;
    static final int CREATED_FROM_METADATA_BUT_SETTYPE_INVOKED = 2;
    static final char PARM_SEPARATOR = '\u001f';
    ResultHints _resultHints;
    StoredProcessService _service;
    SessionContextInterface _sessionContext;
    UserContextInterface _userContext;
    String _privilegedUser;
    Logger _logger;
    com.sas.services.storedprocess.metadata.StoredProcessInterface _storedProcessSmartObject;
    String _seqNum;
    private int _howCreated;
    private int _serverType;
    private String _description;
    private String _directory = "";
    private String _name;
    private String _fileName;
    private int _resultType;
    HashMap _streams;
    private LogicalServerInterface _smartObjectLogicalServer;
    private boolean _alreadyDestroyed;
    private int _executionCount;
    private static int _instanceCount;

    synchronized void incrementExecutionCount() {
        ++this._executionCount;
    }

    static synchronized String getNextId() {
        return Integer.toString(++_instanceCount);
    }

    private StoredProcess(int howCreated, SessionContextInterface sessionContext, StoredProcessService service) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, StoredProcess.class), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(StoredProcess.class), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(StoredProcess.class));
        this._howCreated = howCreated;
        this._sessionContext = sessionContext;
        this._service = service;
        this._seqNum = StoredProcess.getNextId();
        if (this._sessionContext != null) {
            this._userContext = this._sessionContext.getUserContext();
        }
        this._logger = LogManager.getLogger(StoredProcess.class);
    }

    StoredProcess(SessionContextInterface sessionContext, int serverType, int resultType, StoredProcessService service) throws IllegalArgumentException, RemoteException {
        this(0, sessionContext, service);
        String invalid;
        if (serverType != 1 && serverType != 2) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.illSrvrVal.ex.fmt.txt", (Object)Integer.toString(serverType));
            this.logMessageAndThrowIllegalStateException(msg);
        }
        if ((invalid = this.validateServerAndResultTypes(serverType, resultType)) != null) {
            this.logMessageAndThrowIllegalStateException(invalid);
        }
        this._serverType = serverType;
        this._resultType = resultType;
        if (this._serverType == 1) {
            this._streams = new HashMap();
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.manCrtd.fmt.txt", (Object)Integer.toString(this._serverType), (Object)Integer.toString(this._resultType), (Object)this._seqNum);
            this._logger.debug(msg);
        }
    }

    StoredProcess(SessionContextInterface sessionContext, com.sas.services.storedprocess.metadata.StoredProcessInterface storedProcessSmartObject, StoredProcessService service) throws InitializationException, TransportException, RemoteException {
        this(0, sessionContext, service);
        this._storedProcessSmartObject = storedProcessSmartObject;
        ClassifierMap classifierMap = (ClassifierMap)storedProcessSmartObject.getRepositoryEntity();
        int options = 269;
        String template = "<Templates><ClassifierMap><ClassifierSources/><ClassifierTargets/><ComputeLocations/><Keywords/><Notes/><Properties/><SourceCode/><Trees/></ClassifierMap><ArchiveFile><Directories/></ArchiveFile><Directory><Parent/><Properties/><DeployedComponents/></Directory><File><Directories/></File><Report><Properties/><ReportLocation/></Report><Stream><Properties/></Stream><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>";
        try {
            String msg;
            String publicType;
            boolean convertV1ToV0 = false;
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.omrCrtng.fmt.txt", (Object)classifierMap.getName(), (Object)classifierMap.getFQID(), (Object)this._seqNum);
                this._logger.debug(msg2);
            }
            if ((publicType = classifierMap.getPublicType()).equalsIgnoreCase("StoredProcess")) {
                double ver = classifierMap.getUsageVersion();
                if (ver != 0.0) {
                    UsageVersion uv = UsageVersion.decode((double)ver);
                    if (!uv.isReadCompatible(MetadataConstants.OLDEST_VERSION, com.sas.services.storedprocess.metadata.StoredProcessInterface.NINETWO_VERSION)) {
                        String msg3 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.invldVer.ex.fmt.txt", (Object)classifierMap.getName(), (Object)uv.toString());
                        this.logMessageAndThrowInitializationException(msg3);
                    }
                    convertV1ToV0 = true;
                }
            } else if (publicType.length() > 0) {
                String msg4 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.invldPubTyp.ex.fmt.txt", (Object)classifierMap.getName(), (Object)publicType);
                this.logMessageAndThrowInitializationException(msg4);
            } else {
                String transformRole = classifierMap.getTransformRole();
                if (!transformRole.equalsIgnoreCase("StoredProcess")) {
                    String msg5 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.invldTransRole.ex.fmt.txt", (Object)classifierMap.getName(), (Object)transformRole);
                    this.logMessageAndThrowInitializationException(msg5);
                }
            }
            MdOMIUtil omiUtil = classifierMap.getObjectStore().getFactory().getOMIUtil();
            classifierMap = (ClassifierMap)omiUtil.getMetadataAllDepths((CMetadata)classifierMap, null, null, template, options);
            this.setName(classifierMap.getName());
            this.setDescription(classifierMap.getDesc());
            boolean seenAssociatedObject = false;
            LogicalServer logicalServer = null;
            AssociationList v = classifierMap.getComputeLocations();
            int count = v.size();
            String classid = null;
            for (int i = 0; i < count; ++i) {
                String msg6;
                CMetadata server = (CMetadata)v.get(i);
                if (!(server instanceof LogicalServer)) continue;
                LogicalServerInterface srvr = null;
                try {
                    srvr = (LogicalServerInterface)storedProcessSmartObject.getRepository().factoryProcess((Object)server);
                }
                catch (ServiceException se) {
                    this.logMessageAndThrowInitializationException(se.getMessage());
                }
                classid = srvr.getClassIdentifier();
                if (logicalServer == null) {
                    if (classid.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || classid.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
                        this._serverType = 2;
                    } else if (classid.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
                        this._serverType = 1;
                    } else {
                        msg6 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.unsupClsid.ex.fmt.txt", (Object)classid);
                        this.logMessageAndThrowInitializationException(msg6);
                    }
                    logicalServer = (LogicalServer)server;
                    this._smartObjectLogicalServer = srvr;
                    if (this._logger == null || !this._logger.isDebugEnabled()) continue;
                    msg6 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.logSrvr.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)logicalServer.getName(), (Object)logicalServer.getFQID());
                    this._logger.debug(msg6);
                    continue;
                }
                if (this._logger != null) {
                    msg6 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.mulSrvers.fmt.txt", (Object)this.getName(), (Object)srvr.getName());
                    this._logger.warn(msg6);
                }
                if (classid.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || classid.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
                    if (this._serverType != 1) continue;
                    msg6 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.mulClsid.ex.fmt.txt", (Object)this.getName());
                    this.logMessageAndThrowInitializationException(msg6);
                    continue;
                }
                if (classid.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
                    if (this._serverType != 2) continue;
                    msg6 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.mulClsid.ex.fmt.txt", (Object)this.getName());
                    this.logMessageAndThrowInitializationException(msg6);
                    continue;
                }
                msg6 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.unsupClsid.ex.fmt.txt", (Object)classid);
                this.logMessageAndThrowInitializationException(msg6);
            }
            if (logicalServer == null) {
                int numOfServers = MetadataConstants.getCountNoSecurity(this._sessionContext, (Root)classifierMap, "ComputeLocations");
                if (numOfServers > count) {
                    this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.noPermissnSrvr.ex.txt"));
                }
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.missnSrvr.ex.txt"));
            }
            if (this._serverType == 1) {
                this._streams = new HashMap();
            }
            v = classifierMap.getProperties();
            count = v.size();
            for (int k = 0; k < count; ++k) {
                Property p = (Property)v.get(k);
                String role = p.getPropertyRole();
                if (!role.equalsIgnoreCase("SPCustomizer")) continue;
                String context = p.getPropertyName();
                String value = p.getDefaultValue();
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg7 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.hasCus.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)value, (Object)context);
                    this._logger.debug(msg7);
                }
                this.setCustomizer(context, value);
            }
            if (convertV1ToV0) {
                this.convertV1toV0Parms(classifierMap);
            } else {
                MdOMAEntityUtility.populateEntityFromOMRObject((RemoteEntityInterface)this, (Root)classifierMap);
            }
            Text sc = classifierMap.getSourceCode();
            if (sc instanceof File) {
                File f = (File)sc;
                this.setFileName(f.getFileName());
                this.setDirectory("");
                if (f.getIsARelativeName() == 0) {
                    if (this._serverType == 2 && this._logger != null) {
                        String msg8 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.noRepos.fmt.txt", (Object)this.getName());
                        this._logger.warn(msg8);
                    }
                } else {
                    seenAssociatedObject = false;
                    v = f.getDirectories();
                    for (int i = 0; i < v.size(); ++i) {
                        Directory d = (Directory)v.get(i);
                        AssociationList vv = d.getProperties();
                        boolean isASourceCodeRepository = false;
                        for (int ii = 0; ii < vv.size(); ++ii) {
                            Property p = (Property)vv.get(ii);
                            if (!p.getPropertyRole().equalsIgnoreCase("SPSourceCodeRepository")) continue;
                            isASourceCodeRepository = true;
                            break;
                        }
                        if (!isASourceCodeRepository) continue;
                        if (seenAssociatedObject) {
                            if (this._logger == null) continue;
                            String msg9 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.mulAssoc.fmt.txt", (Object)"Directories", (Object)"File", (Object)d.getName());
                            this._logger.warn(msg9);
                            continue;
                        }
                        seenAssociatedObject = true;
                        this.setDirectory(d.getDirectoryName());
                    }
                }
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg10 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.dirNFile.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)this.getDirectory(), (Object)this.getFileName());
                    this._logger.debug(msg10);
                }
            } else if (sc == null) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noFil1.ex.txt"));
            } else {
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.noFil2.ex.fmt.txt", (Object)sc.getCMetadataType());
                this.logMessageAndThrowInitializationException(msg);
            }
            if (convertV1ToV0) {
                this.convertV1toV0ResultTypesAndStreams(classifierMap);
            } else {
                ContentLocation location;
                String reportType;
                v = classifierMap.getClassifierSources();
                count = v.size();
                if (count > 0 && this._logger != null && this._logger.isDebugEnabled()) {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.clSou.fmt.txt", (Object)this.getName(), (Object)this._seqNum);
                    this._logger.debug(msg);
                }
                for (int k = 0; k < count; ++k) {
                    Report report;
                    if (!(v.get(k) instanceof Report) || !(reportType = (report = (Report)v.get(k)).getReportType()).equalsIgnoreCase("SPInputStream")) continue;
                    location = report.getReportLocation();
                    if (location instanceof Stream) {
                        Stream st = (Stream)location;
                        String name = st.getName();
                        if (name.length() <= 0) {
                            this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noStreamName.ex.txt"));
                        }
                        boolean multipass = StoredProcess.checkPropertyNamePresence((Root)st, "MultiPass", "0", false);
                        this.addOutputStream(name, multipass);
                        if (this._logger == null || !this._logger.isDebugEnabled()) continue;
                        String msg11 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.hasIStream.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)name);
                        this._logger.debug(msg11);
                        continue;
                    }
                    this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noStream.ex.txt"));
                }
                seenAssociatedObject = false;
                this._resultType = 1;
                v = classifierMap.getClassifierTargets();
                count = v.size();
                if (count > 0 && this._logger != null && this._logger.isDebugEnabled()) {
                    String msg12 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.clTrg.fmt.txt", (Object)this.getName(), (Object)this._seqNum);
                    this._logger.debug(msg12);
                }
                for (int k = 0; k < count; ++k) {
                    Directory d;
                    ResultHints hints;
                    if (!(v.get(k) instanceof Report)) continue;
                    Report report = (Report)v.get(k);
                    reportType = report.getReportType();
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        String msg13 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.clTrgRptTyp.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)reportType);
                        this._logger.debug(msg13);
                    }
                    location = report.getReportLocation();
                    if (reportType.equalsIgnoreCase("SPResultsTransientPackage")) {
                        this._resultType = 2;
                        seenAssociatedObject = true;
                        this._resultHints = new TransientPackageResultHints();
                        continue;
                    }
                    if (reportType.equalsIgnoreCase("SPResultsPermanentFilePackage")) {
                        if (location instanceof ArchiveFile || location instanceof Directory) {
                            String dirName = null;
                            hints = new PermanentPackageResultHints();
                            if (location instanceof ArchiveFile) {
                                ArchiveFile af = (ArchiveFile)location;
                                String fileName = af.getFileName();
                                if (fileName == null || fileName.length() == 0) {
                                    this.logMessageAndThrowInitializationException(RB.getStringResource("SP.missnArcFil.ex.txt"));
                                }
                                if (af.getIsARelativeName() == 0) {
                                    this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noAbsPaths.ex.txt"));
                                }
                                boolean seenAssociatedObject1 = false;
                                AssociationList vv = af.getDirectories();
                                for (int i = 0; i < vv.size(); ++i) {
                                    Directory d2 = (Directory)vv.get(i);
                                    AssociationList vvv = d2.getProperties();
                                    boolean isAFileRepository = false;
                                    for (int ii = 0; ii < vvv.size(); ++ii) {
                                        Property p = (Property)vvv.get(ii);
                                        if (!p.getPropertyRole().equalsIgnoreCase("SPPackageFileRepository")) continue;
                                        isAFileRepository = true;
                                        break;
                                    }
                                    if (!isAFileRepository) continue;
                                    if (seenAssociatedObject1) {
                                        if (this._logger == null) continue;
                                        String msg14 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.mulAssoc.fmt.txt", (Object)"Directories", (Object)"ArchiveFile", (Object)d2.getName());
                                        this._logger.warn(msg14);
                                        continue;
                                    }
                                    seenAssociatedObject1 = true;
                                    dirName = d2.getDirectoryName();
                                }
                                ((PermanentPackageResultHints)hints).setArchiveName(fileName);
                                hints.setNewInstanceCreated(false);
                            } else {
                                d = (Directory)location;
                                dirName = d.getDirectoryName();
                                hints.setNewInstanceCreated(true);
                            }
                            if (dirName == null || dirName.length() == 0) {
                                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.missnArcDir.ex.txt"));
                            }
                            ((PermanentPackageResultHints)hints).setArchivePath(dirName);
                            try {
                                ((PermanentPackageResultHints)hints).validate();
                            }
                            catch (InternalUseException iue) {
                                this.logMessageAndThrowInitializationException(iue._message);
                            }
                            this._resultType = 4;
                            seenAssociatedObject = true;
                            this._resultHints = hints;
                            continue;
                        }
                        this.logMessageAndThrowInitializationException(RB.getStringResource("SP.missnArc.ex.txt"));
                        continue;
                    }
                    if (reportType.equalsIgnoreCase("SPResultsPermanentWebdavPackage")) {
                        boolean newInstance = StoredProcess.checkPropertyNamePresence((Root)report, "SPNewInstance", "0", false);
                        if (location instanceof Directory) {
                            Directory d3 = (Directory)location;
                            WebDAVPackageDAVServerResultHints hints2 = new WebDAVPackageDAVServerResultHints();
                            if (StoredProcess.checkPropertyNamePresence((Root)d3, "FileSystemType", "WebDAV", true)) {
                                hints2.setCollectionUnderDAVServerBasePath(d3.getDirectoryName());
                                d3 = d3.getParent();
                            }
                            if (d3 == null) {
                                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.missnDAVSrvrBP.ex.txt"));
                            }
                            hints2.setDAVServerBasePath(d3.getDirectoryName());
                            hints2.setNewInstanceCreated(newInstance);
                            Iterator it = d3.getDeployedComponents().iterator();
                            OMRHttpServer webDAVServer = null;
                            while (it.hasNext()) {
                                Root root = (Root)it.next();
                                if (!(root instanceof ServerComponent)) continue;
                                if (webDAVServer != null) {
                                    if (this._logger == null) continue;
                                    String msg15 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.mulAssoc.fmt.txt", (Object)"ServerComponents", (Object)"Directory", (Object)root.getName());
                                    this._logger.warn(msg15);
                                    continue;
                                }
                                webDAVServer = new OMRHttpServer((ServerComponent)root);
                                hints2.setDAVServer((HttpServerInterface)webDAVServer);
                            }
                            if (webDAVServer == null) {
                                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.missnDAVSrvr.ex.txt"));
                            }
                            try {
                                hints2.validate();
                            }
                            catch (InternalUseException iue) {
                                this.logMessageAndThrowInitializationException(iue._message);
                            }
                            this._resultType = 8;
                            seenAssociatedObject = true;
                            this._resultHints = hints2;
                            continue;
                        }
                        this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noDir.ex.txt"));
                        continue;
                    }
                    if (reportType.equalsIgnoreCase("SPResultsPermanentWebdavPRPackage")) {
                        boolean newInstance = StoredProcess.checkPropertyNamePresence((Root)report, "SPNewInstance", "0", false);
                        hints = new WebDAVPackagePRResultHints();
                        hints.setNewInstanceCreated(newInstance);
                        if (location instanceof Directory) {
                            d = (Directory)location;
                            String relativeURL = d.getDirectoryName();
                            ((WebDAVPackagePRResultHints)hints).setCollectionInPR(relativeURL);
                        } else if (location != null || !newInstance) {
                            this.logMessageAndThrowInitializationException(RB.getStringResource("SP.invPRObj.ex.txt"));
                        }
                        try {
                            ((WebDAVPackagePRResultHints)hints).validate();
                        }
                        catch (InternalUseException iue) {
                            this.logMessageAndThrowInitializationException(iue._message);
                        }
                        this._resultType = 8;
                        seenAssociatedObject = true;
                        this._resultHints = hints;
                        continue;
                    }
                    if (!reportType.equalsIgnoreCase("SPResultsStream")) continue;
                    if (location instanceof Stream) {
                        Stream st = (Stream)location;
                        String name = st.getName();
                        if (name.length() <= 0) {
                            this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noStreamName.ex.txt"));
                        }
                        this.addInputStream(name);
                        seenAssociatedObject = true;
                        this._resultType = 16;
                        if (this._logger == null || !this._logger.isDebugEnabled()) continue;
                        String msg16 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.hasOStream.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)name);
                        this._logger.debug(msg16);
                        continue;
                    }
                    this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noStream.ex.txt"));
                }
                if (!seenAssociatedObject && this._logger != null && this._logger.isDebugEnabled()) {
                    String msg17 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.missReslt.fmt.txt", (Object)this.getName(), (Object)this._seqNum);
                    this._logger.debug(msg17);
                }
            }
            String invalid = this.validateServerAndResultTypes(this._serverType, this._resultType);
            if (invalid != null) {
                this.logMessageAndThrowInitializationException(invalid);
            }
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg18 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.omrCrtd.fmt.txt", (Object)this.getName(), (Object)this._seqNum);
                this._logger.debug(msg18);
            }
            this._howCreated = 1;
        }
        catch (MdException e) {
            String msg = RB.getStringResource("SP.omrCr.ex.txt");
            if (this._logger != null) {
                this._logger.error(msg, (Throwable)e);
            }
            throw new TransportException((Throwable)e, msg);
        }
        catch (ServiceException e) {
            String msg = RB.getStringResource("SP.omrCr.ex.txt");
            if (this._logger != null) {
                this._logger.error(msg, (Throwable)e);
            }
            throw new TransportException((Throwable)e, msg);
        }
    }

    private void convertV1toV0Parms(ClassifierMap classifierMap) throws InitializationException, RemoteException {
        try {
            BaseOMRPromptInterface omrPI = this._storedProcessSmartObject.getPrompt();
            if (omrPI instanceof OMRPromptGroupInterface) {
                OMRPromptGroupInterface omrPGI = (OMRPromptGroupInterface)omrPI;
                PromptGroupInterface promptGroup = omrPGI.getPromptGroup();
                PromptToEntityConverter.convertPromptGroupToEntity((RemoteEntityInterface)this, (PromptGroupInterface)promptGroup);
            } else {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.noOMRPGI.ex.txt"));
            }
        }
        catch (ServiceException e) {
            this.logMessageAndThrowInitializationException((Exception)((Object)e), RB.getStringResource("SP2.prmptGet.ex.txt"));
        }
    }

    private void convertV1toV0ResultTypesAndStreams(ClassifierMap classifierMap) throws RemoteException, MdException, ServiceException {
        PermanentPackageResultHints hints;
        String archiveNameValue;
        String archivePathValue;
        String resultValue;
        boolean streamCapable = false;
        boolean packageCapable = false;
        String textStoreXML = null;
        for (Object o : classifierMap.getNotes()) {
            TextStore ts;
            if (!(o instanceof TextStore) || !(ts = (TextStore)o).getTextRole().equalsIgnoreCase("StoredProcessConfiguration") || !ts.getTextType().equalsIgnoreCase("XML")) continue;
            textStoreXML = ts.getStoredText();
            break;
        }
        if (textStoreXML != null && textStoreXML.length() > 0) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP2.txtStorXML.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)textStoreXML);
            this._logger.debug(msg);
            Document document = null;
            try {
                document = XMLUtil.convertStringToDocument((String)textStoreXML);
            }
            catch (Exception e) {
                this.logMessageAndThrowInitializationException(e.getMessage());
            }
            NodeList list = document.getElementsByTagName("StoredProcess");
            if (list.getLength() > 1) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.multplSPTag.txt"));
            }
            if (list.getLength() == 1) {
                Element spE = (Element)list.item(0);
                NodeList list2 = spE.getElementsByTagName("ResultCapabilities");
                if (list2.getLength() > 1) {
                    this.logMessageAndThrowInitializationException(RB.getStringResource("SP2.multplRCTag.txt"));
                }
                if (list2.getLength() == 1) {
                    Element rcE = (Element)list2.item(0);
                    String val = rcE.getAttribute("Package");
                    if (val != null) {
                        packageCapable = val.equalsIgnoreCase("true");
                    }
                    if ((val = rcE.getAttribute("Streaming")) != null) {
                        streamCapable = val.equalsIgnoreCase("true");
                    }
                }
                try {
                    ArrayList sourcesAndtargets = new ArrayList();
                    MetadataConstants.getDataSourcesAndTargetsFromXML(null, spE, sourcesAndtargets);
                    for (int i = 0; i < sourcesAndtargets.size(); ++i) {
                        GenericStream gs = (GenericStream)sourcesAndtargets.get(i);
                        if (gs._isSource) {
                            this.addOutputStream(gs._fileref, gs._allowsRewinds);
                            continue;
                        }
                        this.addInputStream(gs._fileref);
                    }
                }
                catch (MetadataConstants.MCException e) {
                    this.logMessageAndThrowInitializationException(e.getMessage());
                }
            }
        }
        if ((resultValue = this.getReservedParmValue("_result")).length() == 0) {
            if (packageCapable) {
                this._resultHints = new TransientPackageResultHints();
                this._resultType = 2;
                return;
            }
            if (streamCapable) {
                this._resultType = 16;
                this.addInputStream("_webout");
                return;
            }
            this._resultType = 1;
            return;
        }
        if (resultValue.equalsIgnoreCase("PACKAGE_TO_REQUESTER")) {
            if (!packageCapable) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noPkgCapReq.ex.txt"));
            }
            if (this._serverType != 2) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noWksSrvrReq.ex.txt"));
            }
            if ((archivePathValue = this.getReservedParmValue("_archive_path")).length() == 0) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noArcPathReq.ex.txt"));
            }
            archiveNameValue = this.getReservedParmValue("_archive_name");
            hints = new PermanentPackageResultHints();
            hints.setArchivePath(archivePathValue);
            if (archiveNameValue.length() == 0) {
                hints.setNewInstanceCreated(true);
            } else {
                hints.setArchiveName(archiveNameValue);
                hints.setNewInstanceCreated(false);
            }
            try {
                hints.validate();
            }
            catch (InternalUseException iue) {
                this.logMessageAndThrowInitializationException(iue._message);
            }
            this._resultHints = hints;
            this._resultType = 4;
            return;
        }
        if (resultValue.equalsIgnoreCase("PACKAGE_TO_ARCHIVE")) {
            if (!packageCapable) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noPkgCapArc.ex.txt"));
            }
            if (this._serverType != 1) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noSpsSrvrReq.ex.txt"));
            }
            if ((archivePathValue = this.getReservedParmValue("_archive_path")).length() == 0) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noArcPathArc.ex.txt"));
            }
            archiveNameValue = this.getReservedParmValue("_archive_name");
            hints = new PermanentPackageResultHints();
            hints.setArchivePath(archivePathValue);
            if (archiveNameValue.length() == 0) {
                hints.setNewInstanceCreated(true);
            } else {
                hints.setArchiveName(archiveNameValue);
                hints.setNewInstanceCreated(false);
            }
            try {
                hints.validate();
            }
            catch (InternalUseException iue) {
                this.logMessageAndThrowInitializationException(iue._message);
            }
            this._resultHints = hints;
            this._resultType = 4;
            return;
        }
        if (resultValue.equalsIgnoreCase("PACKAGE_TO_WEBDAV")) {
            WebDAVPackageDAVServerLocationHelper locationHelper;
            HttpServerInterface davServer;
            boolean createNewInstance;
            String publishToPRValue;
            if (!packageCapable) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noPkgCapDav.ex.txt"));
            }
            boolean publishToPR = (publishToPRValue = this.getReservedParmValue("_publish_to_pr")) != null && publishToPRValue.equalsIgnoreCase("true");
            String createNewInstanceValue = this.getReservedParmValue("_create_new_package_instance");
            boolean bl = createNewInstance = createNewInstanceValue != null && createNewInstanceValue.equalsIgnoreCase("true");
            if (publishToPR) {
                String prCollectionPath = this.getReservedParmValue("_pr_collection_path");
                WebDAVPackagePRResultHints hints2 = new WebDAVPackagePRResultHints();
                hints2.setNewInstanceCreated(createNewInstance);
                hints2.setCollectionInPR(prCollectionPath);
                try {
                    hints2.validate();
                }
                catch (InternalUseException iue) {
                    this.logMessageAndThrowInitializationException(iue._message);
                }
                this._resultHints = hints2;
                this._resultType = 8;
                return;
            }
            WebDAVPackageDAVServerResultHints hints3 = new WebDAVPackageDAVServerResultHints();
            String collectionURLvalue = this.getReservedParmValue("_collection_url");
            if (collectionURLvalue.length() == 0) {
                this.logMessageAndThrowInitializationException(RB.getStringResource("SP.noCollURLDAV.ex.txt"));
            }
            if ((davServer = (locationHelper = WebDAVPackageDAVServerLocationHelper.createInstance(collectionURLvalue, createNewInstance, (Root)classifierMap)).getDAVServer()) == null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.noDavSrvr.ex.fmt.txt", (Object)collectionURLvalue);
                this.logMessageAndThrowInitializationException(msg);
            }
            hints3.setDAVServer(davServer);
            hints3.setDAVServerBasePath(locationHelper.getBasePath());
            hints3.setCollectionUnderDAVServerBasePath(locationHelper.getCollectionUnderBasePath());
            hints3.setNewInstanceCreated(createNewInstance);
            try {
                hints3.validate();
            }
            catch (InternalUseException iue) {
                this.logMessageAndThrowInitializationException(iue._message);
            }
            this._resultHints = hints3;
            this._resultType = 8;
            return;
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.unsupReslt.ex.fmt.txt", (Object)resultValue);
        this.logMessageAndThrowInitializationException(msg);
    }

    private String getReservedParmValue(String parmName) throws RemoteException {
        try {
            AttributeDescriptorInterface ad = this.getAttributeDescriptor(parmName);
            if (ad == null) {
                return "";
            }
            String stringValueOfParm = this.getStringAttribute(parmName, ad.getStringDefault());
            if (stringValueOfParm == null) {
                return "";
            }
            return stringValueOfParm;
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }

    private void logMessageAndThrowInitializationException(Exception e, String message) throws InitializationException {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(message, (Throwable)e);
        }
        throw new InitializationException((Throwable)e, message);
    }

    private void logMessageAndThrowInitializationException(String message) throws InitializationException {
        if (this._logger != null) {
            this._logger.error(message);
        }
        throw new InitializationException(message);
    }

    private void logMessageAndThrowIllegalStateException(String message) {
        if (this._logger != null) {
            this._logger.error(message);
        }
        throw new IllegalStateException(message);
    }

    @Override
    public void setDescription(String description) {
        this.checkIfDestroyed();
        if (this._howCreated != 0) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.cantModify.ex.txt"));
        }
        this._description = description;
    }

    private void setDirectory(String directory) {
        if (this._howCreated != 0) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.cantModify.ex.txt"));
        }
        this._directory = directory;
    }

    @Override
    public void setSourceFromFile(String directory, String fileName) {
        this.checkIfDestroyed();
        if (this._howCreated != 0) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.cantModify.ex.txt"));
        }
        this._directory = directory;
        this._fileName = fileName;
    }

    @Override
    public void setName(String name) {
        this.checkIfDestroyed();
        if (this._howCreated != 0) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.cantModify.ex.txt"));
        }
        this._name = name;
    }

    private void setFileName(String fileName) {
        if (this._howCreated != 0) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.cantModify.ex.txt"));
        }
        this._fileName = fileName;
    }

    @Override
    public void setPrivilegedUser(String privilegedUser) {
        this.checkIfDestroyed();
        this._privilegedUser = privilegedUser;
    }

    @Override
    public int getResultType() {
        this.checkIfDestroyed();
        return this._resultType;
    }

    @Override
    public void setResultType(int resultType) throws IllegalStateException {
        this.checkIfDestroyed();
        if (this._resultType == resultType) {
            return;
        }
        String msg = this.validateServerAndResultTypes(this._serverType, resultType);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        if (this._resultType == 16) {
            Set set = this._streams.entrySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                StreamDefinition sd = (StreamDefinition)me.getValue();
                if (!sd._isInput) continue;
                it.remove();
            }
        }
        this._howCreated = 2;
        this._resultHints = null;
        this._resultType = resultType;
    }

    @Override
    public int getServerType() {
        this.checkIfDestroyed();
        return this._serverType;
    }

    @Override
    public LogicalServerInterface getServer() {
        this.checkIfDestroyed();
        return this._smartObjectLogicalServer;
    }

    @Override
    public void setResultHints(ResultHints resultHints) throws ServiceException, RemoteException {
        this.checkIfDestroyed();
        boolean invalidTypeOfHintsObject = true;
        switch (this._resultType) {
            case 2: {
                if (!(resultHints instanceof TransientPackageResultHints)) break;
                invalidTypeOfHintsObject = false;
                break;
            }
            case 4: {
                if (!(resultHints instanceof PermanentPackageResultHints)) break;
                invalidTypeOfHintsObject = false;
                break;
            }
            case 8: {
                if (!(resultHints instanceof WebDAVPackagePRResultHints) && !(resultHints instanceof WebDAVPackageDAVServerResultHints) && !(resultHints instanceof WebDAVPackageURLResultHints)) break;
                invalidTypeOfHintsObject = false;
                break;
            }
        }
        if (invalidTypeOfHintsObject) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.invSrvrResTyp.ex.fmt.txt", (Object)Integer.toString(this._serverType), (Object)Integer.toString(this._resultType));
            this.logMessageAndThrowIllegalStateException(msg);
        }
        try {
            resultHints.validate();
        }
        catch (InternalUseException e) {
            if (this._logger != null) {
                this._logger.error(e._message);
            }
            throw new ServiceException(e._message);
        }
        this._resultHints = (ResultHints)resultHints.clone();
    }

    @Override
    public void setParameterValue(String name, Object value) throws RemoteException, AttributeSetException {
        Object valueToBeSavedInEntity;
        this.checkIfDestroyed();
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = value == null ? Message.format((ResourceBundle)RB.getResources(), (String)"SP.noParmValSet.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)name) : Message.format((ResourceBundle)RB.getResources(), (String)"SP.parmValSet.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)name, (Object)value.getClass().getName(), (Object)value.toString());
            this._logger.debug(msg);
        }
        if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            if (this._serverType == 2) {
                if (arr.length != 1) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.invArrayParm.ex.fmt.txt", (Object)name, (Object)Integer.toString(arr.length));
                    if (this._logger != null) {
                        this._logger.error(msg);
                    }
                    throw new AttributeSetException(msg);
                }
                valueToBeSavedInEntity = arr[0];
            } else {
                StringBuffer valueString = new StringBuffer();
                int arrayLength = arr.length;
                for (int j = 0; j < arrayLength; ++j) {
                    if (j > 0) {
                        valueString.append('\u001f');
                    }
                    valueString.append(arr[j].toString());
                }
                valueToBeSavedInEntity = valueString.toString();
            }
        } else {
            valueToBeSavedInEntity = value;
        }
        try {
            name = name.toLowerCase(Locale.ENGLISH);
            Names.validateSASVariableName((String)name, (boolean)true);
        }
        catch (Exception ex) {
            throw new AttributeSetException(ex.getMessage());
        }
        this.setAttribute(name, valueToBeSavedInEntity);
    }

    @Override
    public void setParameterValues(Map map) throws RemoteException, AttributeSetException {
        this.checkIfDestroyed();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            this.setParameterValue((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean addInputStream(String streamKey) throws RemoteException, IllegalStateException {
        this.checkIfDestroyed();
        if (this._howCreated == 1) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.cantModify.ex.txt"));
        }
        if (this._serverType != 1) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.noStreamSup.ex.txt"));
        }
        try {
            Names.validateSASFilerefName((String)streamKey, (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            this.logMessageAndThrowIllegalStateException(ex.getMessage());
        }
        StreamDefinition sd = new StreamDefinition(streamKey, false, true);
        StreamDefinition sdOld = (StreamDefinition)this._streams.get(sd._normalizedName);
        if (sdOld == null) {
            this._streams.put(sd._normalizedName, sd);
            return true;
        }
        if (sdOld.equals(sd)) {
            return false;
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.strmDefAsOutput.ex.fmt.txt", (Object)streamKey);
        this.logMessageAndThrowIllegalStateException(msg);
        return false;
    }

    @Override
    public boolean addOutputStream(String streamKey, boolean isMultiPass) throws RemoteException, IllegalStateException {
        this.checkIfDestroyed();
        if (this._serverType != 1) {
            throw new IllegalStateException(RB.getStringResource("SP.noStreamSup.ex.txt"));
        }
        try {
            Names.validateSASFilerefName((String)streamKey, (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            this.logMessageAndThrowIllegalStateException(ex.getMessage());
        }
        StreamDefinition sd = new StreamDefinition(streamKey, isMultiPass, false);
        StreamDefinition sdOld = (StreamDefinition)this._streams.get(sd._normalizedName);
        if (sdOld == null) {
            this._streams.put(sd._normalizedName, sd);
            return true;
        }
        if (sdOld.equals(sd)) {
            return false;
        }
        String msg = sdOld._isInput != sd._isInput ? Message.format((ResourceBundle)RB.getResources(), (String)"SP.strmDefAsInput.ex.fmt.txt", (Object)streamKey) : Message.format((ResourceBundle)RB.getResources(), (String)"SP.strmDefWithDiffOpt.ex.fmt.txt", (Object)streamKey);
        this.logMessageAndThrowIllegalStateException(msg);
        return false;
    }

    @Override
    public String[] getInputStreamNames() throws RemoteException, IllegalStateException {
        this.checkIfDestroyed();
        return this.getInputOutputStreamNames(true);
    }

    @Override
    public String[] getOutputStreamNames() throws RemoteException, IllegalStateException {
        this.checkIfDestroyed();
        return this.getInputOutputStreamNames(false);
    }

    private String[] getInputOutputStreamNames(boolean input) throws IllegalStateException {
        if (this._serverType != 1) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.noStreamSup.ex.txt"));
        }
        ArrayList<String> names = new ArrayList<String>(this._streams.size());
        Set set = this._streams.entrySet();
        for (Map.Entry me : set) {
            StreamDefinition sd = (StreamDefinition)me.getValue();
            if (sd._isInput != input) continue;
            names.add(sd._normalizedName);
        }
        return names.toArray(new String[0]);
    }

    @Override
    public String getDescription() {
        this.checkIfDestroyed();
        return this._description;
    }

    @Override
    public String getDirectory() {
        this.checkIfDestroyed();
        return this._directory;
    }

    @Override
    public String getName() {
        this.checkIfDestroyed();
        return this._name;
    }

    @Override
    public String getFileName() {
        this.checkIfDestroyed();
        return this._fileName;
    }

    @Override
    public ResultHints getResultHintsInstance(int hintSubType) {
        this.checkIfDestroyed();
        ResultHints retHints = null;
        if (hintSubType == 4) {
            if (this._resultHints == null) {
                this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.noHints.ex.txt"));
            } else {
                retHints = (ResultHints)this._resultHints.clone();
            }
            return retHints;
        }
        block0 : switch (this._resultType) {
            case 2: {
                if (this._resultHints == null) {
                    retHints = new TransientPackageResultHints();
                    break;
                }
                retHints = (ResultHints)this._resultHints.clone();
                break;
            }
            case 4: {
                if (this._resultHints == null) {
                    retHints = new PermanentPackageResultHints();
                    break;
                }
                retHints = (ResultHints)this._resultHints.clone();
                break;
            }
            case 8: {
                switch (hintSubType) {
                    case 1: {
                        if (this._resultHints instanceof WebDAVPackagePRResultHints) {
                            retHints = (ResultHints)this._resultHints.clone();
                            break block0;
                        }
                        retHints = new WebDAVPackagePRResultHints();
                        break block0;
                    }
                    case 2: {
                        if (this._resultHints instanceof WebDAVPackageDAVServerResultHints) {
                            retHints = (ResultHints)this._resultHints.clone();
                            break block0;
                        }
                        retHints = new WebDAVPackageDAVServerResultHints();
                        break block0;
                    }
                    case 3: {
                        if (this._resultHints instanceof WebDAVPackageURLResultHints) {
                            retHints = (ResultHints)this._resultHints.clone();
                            break block0;
                        }
                        retHints = new WebDAVPackageURLResultHints();
                        break block0;
                    }
                }
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.invSubTyp.ex.fmt.txt", (Object)new Integer(hintSubType), (Object)new Integer(this._resultType));
                this.logMessageAndThrowIllegalStateException(msg);
            }
        }
        return retHints;
    }

    @Override
    public boolean isResultPackageReturned() {
        this.checkIfDestroyed();
        return this._resultType == 2 || this._resultType == 4 || this._resultType == 8;
    }

    @Override
    public boolean hasParameters() throws RemoteException {
        this.checkIfDestroyed();
        AttributeDescriptorInterface[] parmList = this.getParameters();
        return parmList.length > 0;
    }

    @Override
    public AttributeDescriptorInterface[] getParameters() throws RemoteException {
        this.checkIfDestroyed();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("isProperty", Boolean.FALSE);
        AttributeDescriptorInterface[] parmList = null;
        try {
            parmList = this.getBooleanSpecifiedAttributeDescriptors(map);
        }
        catch (NoSuchMethodException e) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("COM.incon.ex.txt"));
        }
        return parmList;
    }

    @Override
    public void destroy() {
        this.checkIfDestroyed();
        this._alreadyDestroyed = true;
        try {
            StoredProcess.unexportObject((Remote)this, (boolean)true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Override
    public ExecutionInterface execute(boolean synchronous, ExecutionStatusListenerInterface listener, boolean createAlert, Object connection) throws IllegalStateException, ExecutionException, RemoteException {
        Execution execution;
        this.incrementExecutionCount();
        this.checkIfDestroyed();
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.exeInvk.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)new Integer(synchronous ? 1 : 0), (Object)new Integer(createAlert ? 1 : 0));
            this._logger.debug(msg);
        }
        if (this._userContext == null && createAlert) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.userCtxtNeededForAlrt.ex.txt"));
        }
        try {
            if (connection == null) {
                execution = new Execution(this, this._smartObjectLogicalServer, createAlert, this._executionCount);
            } else if (connection instanceof String) {
                String sessionID = (String)connection;
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.exeSessnID.fmt.txt", (Object)this.getName(), (Object)this._seqNum, (Object)sessionID);
                    this._logger.debug(msg);
                }
                if (this._serverType != 1) {
                    this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.sessnIDOnlyForSPSrvr.ex.txt"));
                }
                if (sessionID == null || sessionID.length() == 0) {
                    this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.noSessnID.ex.txt"));
                }
                execution = new Execution(this, sessionID, createAlert, this._executionCount);
            } else {
                execution = new Execution(this, connection, createAlert, this._executionCount);
            }
            execution.execute(this, synchronous, listener);
        }
        catch (ExecutionException ee) {
            if (this._logger != null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.exeExcp.fmt.txt", (Object)this.getName());
                this._logger.error(msg, (Throwable)ee);
            }
            throw ee;
        }
        return execution;
    }

    private String validateServerAndResultTypes(int serverType, int resultType) {
        if (serverType == 2 && (resultType == 1 || resultType == 2 || resultType == 4 || resultType == 8)) {
            return null;
        }
        if (serverType == 1 && (resultType == 1 || resultType == 16 || resultType == 2 || resultType == 4 || resultType == 8)) {
            return null;
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.inconSrvrRsltVals.ex.fmt.txt", (Object)Integer.toString(resultType), (Object)Integer.toString(serverType));
        return msg;
    }

    private void checkIfDestroyed() {
        if (this._alreadyDestroyed) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("COM.destryCalld.ex.txt"));
        }
    }

    static boolean checkPropertyRolePresence(Root object, String propertyRole, String defaultValue, boolean equals) throws MdException, RemoteException {
        for (Property p : object.getProperties()) {
            if (!p.getPropertyRole().equalsIgnoreCase(propertyRole)) continue;
            if (defaultValue == null) {
                return true;
            }
            if (equals) {
                return defaultValue.equals(p.getDefaultValue());
            }
            return !defaultValue.equals(p.getDefaultValue());
        }
        return false;
    }

    static boolean checkPropertyNamePresence(Root object, String propertyName, String defaultValue, boolean equals) throws MdException, RemoteException {
        for (Property p : object.getProperties()) {
            if (!p.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            if (defaultValue == null) {
                return true;
            }
            if (equals) {
                return defaultValue.equals(p.getDefaultValue());
            }
            return !defaultValue.equals(p.getDefaultValue());
        }
        return false;
    }
}

