/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.deployment.Environment;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonalRepositoryInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.security.ConnectionProfile;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.CaseNeutralLookup;
import com.sas.services.storedprocess.Credentials;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.ResultTypeDeterminer;
import com.sas.services.storedprocess.WebDAVPackageDAVServerLocationHelper;
import com.sas.services.storedprocess.WebDAVPackagePRLocationHelper;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.user.GlobalProfileInterface;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class ProcSTP {
    private String _host;
    private String _port;
    private String _userName;
    private String _password;
    private String _fqid;
    private UserContextInterface _userContext;
    private SessionContextInterface _sessionContext;
    private ServerInterface _serverInterface;
    private StoredProcessInterface _storedProcessSmartObject;
    private PromptGroupInterface _promptGroup;
    private Locale _locale;
    private Logger _logger;
    private boolean _useDefaultDataProvider;
    private PersonalRepositoryInterface _personalRepository;
    private String _loggingID;
    private String _domain;
    private static final String CLIENT_NAME = "PROCSTP; TKESTP";
    private static final String CLIENT = "_client";
    private static final String METAPERSON = "_metaperson";
    private static final String METAUSER = "_metauser";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String UNIQUE_DOMAIN_NAME = "!*(generatedpassworddomain)*!";

    public static synchronized String[] getConsolidatedInputParameters(String fqid, String host, int port, String userid, String password, boolean useDefaultDataProvider, String[] names, String[] values) throws ServiceException, InvalidPromptValueException, RemoteException {
        ProcSTP procSTP = new ProcSTP(host, Integer.toString(port), userid, password, fqid, useDefaultDataProvider);
        String[] retArr = procSTP.getConsolidatedInputParameters(names, values);
        procSTP.destroy();
        return retArr;
    }

    private ProcSTP(String host, String port, String userName, String password, String fqid, boolean useDefaultDataProvider) throws RemoteException, ServiceException {
        this._host = host;
        this._port = port;
        this._userName = userName;
        this._password = password;
        this._fqid = fqid;
        this._locale = Locale.getDefault();
        this._loggingID = "ProcSTP " + fqid;
        this._domain = UNIQUE_DOMAIN_NAME;
        this._useDefaultDataProvider = useDefaultDataProvider;
        this.connect();
        this.locateStoredProcessAndPromptGroup();
    }

    private void connect() throws RemoteException, ServiceException {
        ConnectionProfile profile = ConnectionProfile.newProfile((String)this._host, (String)this._port, (String)this._userName, (String)this._password, (String)this._domain);
        CorePlatformServices.setEnvironment((Environment)profile.getEnvironment());
        CorePlatformServices.startLocalServices();
        UserServiceInterface userService = CorePlatformServices.getUserService();
        userService.setGroupLoginEnabled(true);
        if (userService != null) {
            UserContextInterface user = null;
            try {
                user = userService.newUser(this._userName, this._password, this._domain);
            }
            catch (UserInitializationException e) {
                Exception[] exceptions = e.getExceptions();
                for (int i = 0; i < exceptions.length; ++i) {
                    Exception exception = exceptions[i];
                    exception.printStackTrace(System.out);
                }
                user = e.getUser();
            }
            if (user != null) {
                this._userContext = user;
                this._sessionContext = CorePlatformServices.getSessionService().newSessionContext(user);
                if (this._sessionContext == null) {
                    throw new ServiceException(RB.getStringResource("PROC.noSC.ex.txt"));
                }
                this._serverInterface = user.getAuthServer();
                if (this._serverInterface == null) {
                    throw new ServiceException(RB.getStringResource("PROC.noSI.ex.txt"));
                }
                this._logger = LogManager.getLogger(ProcSTP.class);
            }
        } else {
            throw new ServiceException(RB.getStringResource("PROC.noUS.ex.txt"));
        }
    }

    private void locateStoredProcessAndPromptGroup() throws RemoteException, ServiceException {
        MetadataInterface mi = this._serverInterface.fetch(this._fqid + "/ClassifierMap", true);
        if (mi == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"PROC.noSP.ex.fmt.txt", (Object)this._fqid, (Object)this._host);
            if (this._logger != null) {
                this._logger.error(msg);
            }
            throw new ServiceException(msg);
        }
        this._storedProcessSmartObject = (StoredProcessInterface)mi;
        BaseOMRPromptInterface omrPI = this._storedProcessSmartObject.getPrompt();
        if (!(omrPI instanceof OMRPromptGroupInterface)) {
            throw new ServiceException(RB.getStringResource("PROC.noPG.ex.txt"));
        }
        OMRPromptGroupInterface omrPGI = (OMRPromptGroupInterface)omrPI;
        this._promptGroup = omrPGI.getPromptGroup();
    }

    private String[] getConsolidatedInputParameters(String[] names, String[] values) throws ServiceException, InvalidPromptValueException, RemoteException {
        String osStuff;
        String valueMETAUSER;
        String valueMETAPERSON;
        ResultTypeDeterminer.ResultType _result;
        Locale locale;
        String separator;
        Map dupMap;
        Set keyset;
        int dupMapSize;
        PromptValues promptValues = new PromptValues(this._promptGroup, null);
        if (names != null && values != null) {
            String value;
            if (names.length != values.length) {
                throw new ServiceException("names.length != values.length");
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(names.length);
            for (int i = 0; i < names.length; ++i) {
                Object existingValue;
                String name = names[i];
                try {
                    Names.validateSASVariableName((String)name, (boolean)true);
                }
                catch (Exception ex) {
                    String msg = ex.getMessage();
                    throw new ServiceException(msg);
                }
                value = values[i];
                if (value == null) {
                    value = "";
                }
                if ((existingValue = map.get(name)) == null) {
                    map.put(name, value);
                    continue;
                }
                if (existingValue instanceof String) {
                    String[] arr = new String[]{(String)existingValue, value};
                    map.put(name, arr);
                    continue;
                }
                String[] existingArr = (String[])existingValue;
                int currentLength = existingArr.length;
                String[] arr = new String[currentLength + 1];
                System.arraycopy(existingArr, 0, arr, 0, currentLength);
                arr[currentLength] = value;
                map.put(name, arr);
            }
            for (String name : map.keySet()) {
                value = map.get(name);
                PromptDefinitionInterface pd = PromptUtil.findPromptDefinitionByName((PromptValuesInterface)promptValues, (String)name, (boolean)true, (boolean)false, (boolean)true);
                if (pd == null) {
                    TextDefinition td = new TextDefinition(name);
                    if (value instanceof String[]) {
                        td.setMaximumValueCount(Integer.MAX_VALUE);
                    }
                    pd = td;
                    this._promptGroup.addPromptDefinition(pd);
                }
                promptValues.setPromptValue(pd, (Object)value);
            }
        }
        if ((dupMapSize = (keyset = (dupMap = PromptUtil.getDuplicateDefintionsByName((PromptGroupInterface)this._promptGroup, (boolean)true)).keySet()).size()) > 0) {
            String separator2 = RB.getStringResource("COM.listItemSeparator.txt");
            String errNames = "";
            int i = 0;
            Iterator it = keyset.iterator();
            while (it.hasNext()) {
                if (i++ > 0) {
                    errNames = errNames + separator2;
                }
                errNames = errNames + it.next().toString();
            }
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.dupPrompts.ex.fmt.txt", (Object)dupMapSize, (Object)errNames);
            if (this._logger != null) {
                this._logger.error(msg);
            }
            throw new ServiceException(msg);
        }
        List valueless = PromptUtil.getRequiredPromptsWithoutValues((PromptValuesInterface)promptValues);
        int valuelessSize = valueless.size();
        if (valuelessSize > 0) {
            separator = RB.getStringResource("COM.listItemSeparator.txt");
            String errNames = "";
            int i = 0;
            for (PromptDefinitionInterface pdi : valueless) {
                if (i++ > 0) {
                    errNames = errNames + separator;
                }
                errNames = errNames + pdi.getPromptName();
            }
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.reqPromptsNoVal.ex.fmt.txt", (Object)valuelessSize, (Object)errNames);
            if (this._logger != null) {
                this._logger.error(msg);
            }
            throw new ServiceException(msg);
        }
        dupMap = PromptUtil.getDuplicateMacrosByName((PromptValuesInterface)promptValues, (Locale)this._locale, (boolean)true);
        keyset = dupMap.keySet();
        dupMapSize = keyset.size();
        if (dupMapSize > 0) {
            separator = RB.getStringResource("COM.listItemSeparator.txt");
            String errNames = "";
            int i = 0;
            Iterator it = keyset.iterator();
            while (it.hasNext()) {
                if (i++ > 0) {
                    errNames = errNames + separator;
                }
                errNames = errNames + it.next().toString();
            }
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.dupPromptsAfterExpn.ex.fmt.txt", (Object)dupMapSize, (Object)errNames);
            if (this._logger != null) {
                this._logger.error(msg);
            }
            throw new ServiceException(msg);
        }
        try {
            locale = this._userContext.getLocale();
        }
        catch (ServiceException e) {
            String message = RB.getStringResource("COM.noLocale.txt");
            if (this._logger != null && this._logger.isInfoEnabled()) {
                this._logger.info(message, (Throwable)e);
            }
            locale = Locale.getDefault();
        }
        PromptUtil.validateDynamicPromptValues((PromptValuesInterface)promptValues, null, (Locale)locale);
        Map nameValues = PromptUtil.getMacroVariableValues((PromptValuesInterface)promptValues, null, (boolean)false, (Locale)this._locale);
        CaseNeutralLookup cnl = null;
        try {
            cnl = new CaseNeutralLookup(nameValues);
        }
        catch (ResultTypeDeterminer.InconsistencyException e2) {
            throw new ServiceException("Consistency check.  " + e2.getLocalizedMessage());
        }
        int numberOfParms = nameValues.size();
        for (Object key : nameValues.keySet()) {
            if (key == null) {
                throw new ServiceException(RB.getStringResource("COM.noPromptNam.ex.txt"));
            }
            String name = (String)key;
            if (name.length() <= 32) continue;
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.prmptTooLong.ex.fmt.txt", (Object)name, (Object)name.length(), (Object)32);
            throw new ServiceException(msg);
        }
        try {
            _result = ResultTypeDeterminer.getType(this._storedProcessSmartObject, (PromptValuesInterface)promptValues);
        }
        catch (ResultTypeDeterminer.InconsistencyException e1) {
            throw new ServiceException(e1.getMessage());
        }
        String resultValue = cnl.get("_result");
        if (resultValue != null) {
            resultValue = resultValue.toUpperCase();
        }
        switch (_result) {
            case STATUS: {
                if (resultValue != null && resultValue.length() != 0) break;
                cnl.put("_result", "STATUS");
                break;
            }
            case STREAM: {
                if (resultValue != null && resultValue.length() != 0) break;
                cnl.put("_result", "STREAM");
                break;
            }
            case TRANSIENT_PACKAGE: {
                if (this._storedProcessSmartObject.isStreamCapable()) {
                    cnl.put("_result", "STREAM");
                    break;
                }
                throw new ServiceException("Transient package result not supported");
            }
            case PR_PACKAGE: {
                boolean hasWebDAV = CorePlatformServices.addContentServerRepository((UserContextInterface)this._userContext);
                if (!hasWebDAV) {
                    throw new ServiceException("Personal repository package result not supported as no Personal Repository is available.");
                }
                String newInstance = cnl.get("_create_new_package_instance");
                boolean createNewInstance = newInstance != null && newInstance.equalsIgnoreCase("true");
                String webDAVCollectionURL = null;
                String webDAVuserid = null;
                String webDAVpassword = null;
                Credentials _webDAVCredentialsUsedForParameters = null;
                String prCollPath = cnl.get("_pr_collection_path");
                if (!(createNewInstance || prCollPath != null && prCollPath.length() != 0)) {
                    throw new ServiceException(RB.getStringResource("COM.collNameReqd.ex.txt"));
                }
                WebDAVPackagePRLocationHelper lh = new WebDAVPackagePRLocationHelper(prCollPath, createNewInstance);
                this.findPersonalRepository();
                lh.setPersonalRepository(this._personalRepository);
                lh.determineResultsLocation(null, this._logger, this._loggingID);
                webDAVCollectionURL = lh.getResultLocation();
                _webDAVCredentialsUsedForParameters = lh.getCredentials(this._logger);
                this.setParmValueInLocalMapWarningIfParmExists(cnl, "_collection_url", webDAVCollectionURL);
                webDAVuserid = _webDAVCredentialsUsedForParameters._userName;
                webDAVpassword = webDAVuserid.contains(UNIQUE_DOMAIN_NAME) ? UNIQUE_DOMAIN_NAME : _webDAVCredentialsUsedForParameters._password;
                if (webDAVuserid == null || webDAVpassword == null) break;
                this.setParmValueInLocalMapWarningIfParmExists(cnl, "_http_user", webDAVuserid);
                cnl.put("_http_password", webDAVpassword);
                break;
            }
            case DAVSERVER_PACKAGE: {
                String newInstance = cnl.get("_create_new_package_instance");
                boolean createNewInstance = newInstance != null && newInstance.equalsIgnoreCase("true");
                String webDAVCollectionURL = null;
                String webDAVuserid = cnl.get("_http_user");
                String webDAVpassword = cnl.get("_http_password");
                String proxyURL = null;
                Credentials _webDAVCredentialsUsedForParameters = null;
                String collURL = cnl.get("_collection_url");
                if (collURL == null || collURL.length() == 0) {
                    throw new ServiceException(RB.getStringResource("COM.missnCollURL.ex.txt"));
                }
                ClassifierMap cm = (ClassifierMap)this._storedProcessSmartObject.getRepositoryEntity();
                WebDAVPackageDAVServerLocationHelper lh = new WebDAVPackageDAVServerLocationHelper(collURL, createNewInstance, (Root)cm, this._logger, webDAVuserid, webDAVpassword);
                try {
                    lh.determineResultsLocation(null, this._logger, this._userContext, this._loggingID);
                }
                catch (MdException e) {
                    throw new ServiceException((Throwable)e, "Exception occurred accessing WebDAV server metadata.");
                }
                webDAVCollectionURL = lh.getResultLocation();
                _webDAVCredentialsUsedForParameters = lh.getCredentials(this._logger, this._userContext);
                proxyURL = lh.getProxyURL();
                cnl.put("_collection_url", webDAVCollectionURL);
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"PROC.DAVResltLoc.fmt.txt", (Object)this._loggingID, (Object)webDAVCollectionURL);
                    this._logger.debug(msg);
                }
                if (!_webDAVCredentialsUsedForParameters._consumerSupplied) {
                    webDAVuserid = _webDAVCredentialsUsedForParameters._userName;
                    webDAVpassword = webDAVuserid.contains(UNIQUE_DOMAIN_NAME) ? UNIQUE_DOMAIN_NAME : _webDAVCredentialsUsedForParameters._password;
                    if (webDAVuserid != null && webDAVpassword != null) {
                        this.setParmValueInLocalMapWarningIfParmExists(cnl, "_http_user", webDAVuserid);
                        cnl.put("_http_password", webDAVpassword);
                    }
                }
                if (proxyURL == null || proxyURL.length() <= 0) break;
                this.setParmValueInLocalMapWarningIfParmExists(cnl, "_http_proxy_url", proxyURL);
                break;
            }
        }
        if (this._userContext == null) {
            valueMETAPERSON = UNKNOWN;
            valueMETAUSER = UNKNOWN;
        } else {
            valueMETAPERSON = this._userContext.getName();
            if (valueMETAPERSON == null || valueMETAPERSON.length() == 0) {
                valueMETAPERSON = UNKNOWN;
            }
            try {
                valueMETAUSER = this._userContext.getResolvedUserId();
                if (valueMETAUSER == null || valueMETAUSER.length() == 0) {
                    valueMETAUSER = UNKNOWN;
                }
            }
            catch (Exception e) {
                if (this._logger != null) {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"COM.metauserVal.ex.fmt.txt", (Object)valueMETAPERSON), (Throwable)e);
                }
                valueMETAUSER = UNKNOWN;
            }
        }
        this.setParmValueInLocalMapWarningIfParmExists(cnl, METAPERSON, valueMETAPERSON);
        this.setParmValueInLocalMapWarningIfParmExists(cnl, METAUSER, valueMETAUSER);
        String client = CLIENT_NAME;
        client = client + "; ";
        String jvm = "JVM ";
        try {
            jvm = jvm + System.getProperty("java.version");
        }
        catch (SecurityException se) {
            jvm = jvm + ' ';
        }
        client = client + jvm + "; ";
        try {
            osStuff = System.getProperty("os.name");
        }
        catch (SecurityException se) {
            osStuff = " ";
        }
        osStuff = osStuff + " (";
        try {
            osStuff = osStuff + System.getProperty("os.arch");
        }
        catch (SecurityException se) {
            osStuff = osStuff + " ";
        }
        osStuff = osStuff + ") ";
        try {
            osStuff = osStuff + System.getProperty("os.version");
        }
        catch (SecurityException se) {
            osStuff = osStuff + " ";
        }
        client = client + osStuff;
        this.setParmValueInLocalMapWarningIfParmExists(cnl, CLIENT, client);
        numberOfParms = nameValues.size();
        String[] returnArr = new String[2 * numberOfParms];
        int i = 0;
        for (Object key : nameValues.keySet()) {
            String name = (String)key;
            String value = (String)nameValues.get(key);
            returnArr[i++] = name;
            returnArr[i++] = value;
        }
        return returnArr;
    }

    private void findPersonalRepository() throws RemoteException, ServiceException {
        if (this._personalRepository != null) {
            return;
        }
        ProfileInterface po2 = this._userContext.getProfile();
        if (po2 == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noProf.ex.fmt.txt", (Object)this._userContext.getName());
            throw new ServiceException(msg);
        }
        if (!(po2 instanceof GlobalProfileInterface)) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E2.profNotGlbl.ex.fmt.txt", (Object)po2.getClass().getName());
            throw new ServiceException(msg);
        }
        try {
            this._personalRepository = ((GlobalProfileInterface)po2).getPersonalRepository();
        }
        catch (ServiceException se) {
            throw new ServiceException((Throwable)se, RB.getStringResource("COM.prAcc.ex.txt"));
        }
        if (this._personalRepository == null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noPRfromGP.ex.fmt.txt", (Object)this._userContext.getName());
            throw new ServiceException(msg);
        }
    }

    private void setParmValueInLocalMapWarningIfParmExists(CaseNeutralLookup cnl, String name, String value) {
        String val = cnl.get(name);
        if (val != null && !val.toString().equals(value) && this._logger != null && this._logger.isEnabled(Level.WARN)) {
            if (name.toLowerCase().contains("password")) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"PROC.parmValReplcd.fmt.txt", (Object)this._loggingID, (Object)"****", (Object)name, (Object)"****");
                this._logger.warn(msg);
            } else {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"PROC.parmValReplcd.fmt.txt", (Object)this._loggingID, (Object)val.toString(), (Object)name, (Object)value);
                this._logger.warn(msg);
            }
        }
        cnl.put(name, value);
    }

    private void destroy() throws IllegalStateException, RemoteException, ServiceException {
        this._host = null;
        this._port = null;
        this._userName = null;
        this._password = null;
        this._fqid = null;
        this._serverInterface = null;
        this._storedProcessSmartObject = null;
        this._promptGroup = null;
        this._locale = null;
        this._logger = null;
        this._personalRepository = null;
        this._loggingID = null;
        this._domain = null;
        this._userContext = null;
        if (this._sessionContext != null) {
            this._sessionContext.destroy();
        }
        this._sessionContext = null;
        CorePlatformServices.terminateServices();
    }
}

