/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DateType;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.storedprocess.OutputParameterInterface;
import com.sas.services.storedprocess.RB;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import java.io.Serializable;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
class OutputParameter
implements OutputParameterInterface,
Serializable,
Cloneable,
LocalizableProperties {
    private static final long serialVersionUID = -7021317069765866717L;
    private String _name;
    private String _type;
    private String _label = "";
    private String _description = "";
    private String _stringValue = "";
    private Object _typedValue;
    private boolean _typedValueValid;
    private boolean _valuesSet;
    private transient Element _descElement;
    private transient Element _labelElement;
    private transient Element _parmElement;
    private transient Element _cultureElement;
    private transient Document _document;

    public OutputParameter(Element parmE) throws MetadataConstants.MCException {
        this._parmElement = parmE;
        this._document = this._parmElement.getOwnerDocument();
        this._name = parmE.getAttribute("Name");
        this._type = parmE.getAttribute("Type");
        NodeList cultureElements = parmE.getElementsByTagName("Culture");
        boolean seenValidCulture = false;
        for (int j = 0; j < cultureElements.getLength(); ++j) {
            Element cultureE = (Element)cultureElements.item(j);
            String xmlLangValue = cultureE.getAttribute("xml:lang");
            if (xmlLangValue.length() != 0) continue;
            if (seenValidCulture) {
                throw new MetadataConstants.MCException(RB.getStringResource("MC.MultplVldCultr.ex.txt"));
            }
            this._cultureElement = cultureE;
            seenValidCulture = true;
            NodeList cultureChildren = cultureE.getChildNodes();
            for (int k = 0; k < cultureChildren.getLength(); ++k) {
                Element labelOrDesc;
                Node nn = cultureChildren.item(k);
                if (nn.getNodeType() != 1 || !(labelOrDesc = (Element)nn).getTagName().equals("Label") && !labelOrDesc.getTagName().equals("Description")) continue;
                if (labelOrDesc.getTagName().equals("Label")) {
                    this._labelElement = labelOrDesc;
                    this._label = this._labelElement.getTextContent();
                    continue;
                }
                this._descElement = labelOrDesc;
                this._description = this._descElement.getTextContent();
            }
        }
    }

    public OutputParameter(String name, String type) {
        this._name = name;
        this._type = type;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getType() {
        return this._type;
    }

    private void setDescription(String description) {
        this._description = description;
        if (this._descElement == null) {
            this.ensureCultureExists();
            this._descElement = this._document.createElement("Description");
            this._cultureElement.appendChild(this._descElement);
        }
        this._descElement.setTextContent(description);
    }

    private void setLabel(String label) {
        this._label = label;
        if (this._labelElement == null) {
            this.ensureCultureExists();
            this._labelElement = this._document.createElement("Label");
            this._cultureElement.appendChild(this._labelElement);
        }
        this._labelElement.setTextContent(label);
    }

    private void ensureCultureExists() {
        if (this._cultureElement != null) {
            return;
        }
        this._cultureElement = this._document.createElement("Culture");
        this._parmElement.appendChild(this._cultureElement);
    }

    @Override
    public Object getTypedValue() {
        if (!this._valuesSet) {
            throw new IllegalStateException(RB.getStringResource("OP.noOP.ex.txt"));
        }
        if (!this._typedValueValid) {
            throw new IllegalStateException(RB.getStringResource("OP.typValuInvld.ex.txt"));
        }
        return this._typedValue;
    }

    @Override
    public String getStringValue() {
        if (!this._valuesSet) {
            throw new IllegalStateException(RB.getStringResource("OP.noOP.ex.txt"));
        }
        return this._stringValue;
    }

    @Override
    public boolean isTypedValueValid() {
        if (!this._valuesSet) {
            throw new IllegalStateException(RB.getStringResource("OP.noOP.ex.txt"));
        }
        return this._typedValueValid;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone is supported (Object should be able to clone all members of this class) and this exception should never be thrown.");
        }
    }

    void setValue(String value) {
        this._stringValue = value;
        this._typedValue = null;
        this._typedValueValid = false;
        DateType dti = null;
        if (this._type.equals("Date")) {
            dti = DateType.DEFAULT_INSTANCE;
        } else if (this._type.equals("Double")) {
            dti = DoubleType.DEFAULT_INSTANCE;
        } else if (this._type.equals("Integer")) {
            dti = IntegerType.DEFAULT_INSTANCE;
        } else if (this._type.equals("String")) {
            dti = StringType.DEFAULT_INSTANCE;
        } else if (this._type.equals("Time")) {
            dti = TimeType.DEFAULT_INSTANCE;
        } else if (this._type.equals("TimeStamp")) {
            dti = TimeStampType.DEFAULT_INSTANCE;
        }
        if (dti != null) {
            try {
                this._typedValue = dti.coerceValue((Object)this._stringValue, Locale.US);
                if (this._typedValue != null) {
                    this._typedValueValid = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._valuesSet = true;
    }

    public PropertyList getLocalizableProperties() {
        PropertyList list = new PropertyList();
        list.addProperty("Label", this.getLabel());
        list.addProperty("Description", this.getDescription());
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) {
        if (map == null) {
            return;
        }
        if (map.containsProperty("Label")) {
            this.setLabel(map.getProperty("Label"));
        }
        if (map.containsProperty("Description")) {
            this.setDescription(map.getProperty("Description"));
        }
    }
}

