/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.services.storedprocess.RB;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.security.AccessController;
import java.util.ResourceBundle;

@SASScope
class LogFormatter {
    static final int TEXT = 17;
    static final int HTML = 23;
    static final int DEFAULT = 0;
    static final int ERROR = 1;
    static final int NOTE = 2;
    static final int WARNING = 3;
    private static char[] specialChars = new char[]{'&', '<', '>'};
    private static String[] escapeSequences = new String[]{"&amp;", "&lt;", "&gt;"};

    LogFormatter() {
    }

    static String format(int flag, int[] lineTypeArray, String[] lines) {
        StringBuffer sb = new StringBuffer();
        String lineSep = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        int count = lines.length;
        if (flag == 17) {
            for (int i = 0; i < count; ++i) {
                sb.append(lines[i]);
                sb.append(lineSep);
            }
        } else if (flag == 23) {
            sb.append("<pre>");
            int previousTag = 0;
            for (int i = 0; i < count; ++i) {
                int thisLineTag = lineTypeArray[i];
                if (previousTag != thisLineTag) {
                    LogFormatter.closePreviousTag(previousTag, sb);
                    switch (thisLineTag) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            sb.append("<strong><font color=red>");
                            break;
                        }
                        case 2: {
                            sb.append("<font color=blue>");
                            break;
                        }
                        case 3: {
                            sb.append("<em><font color=green>");
                        }
                    }
                }
                String escapedString = Strings.replace((String)lines[i], (char[])specialChars, (String[])escapeSequences);
                sb.append(escapedString);
                sb.append(lineSep);
                previousTag = thisLineTag;
            }
            LogFormatter.closePreviousTag(previousTag, sb);
            sb.append("</pre>");
            sb.append(lineSep);
        } else {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (Object)Integer.toString(flag));
            throw new IllegalStateException(msg);
        }
        return sb.toString();
    }

    static void closePreviousTag(int previousTag, StringBuffer sb) {
        switch (previousTag) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("</font></strong>");
                break;
            }
            case 2: {
                sb.append("</font>");
                break;
            }
            case 3: {
                sb.append("</font></em>");
            }
        }
    }
}

