/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.io.InputStreamAdapter;
import com.sas.io.InputStreamHeaderInterface;
import com.sas.io.OutputStreamHeaderInterface;
import com.sas.io.OutputStreamProxy;
import com.sas.iom.InputStream;
import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.IResultPackage;
import com.sas.iom.SAS.IResultPackageHolder;
import com.sas.iom.SAS.IResultPackageService;
import com.sas.iom.SAS.IResultPackageServiceHelper;
import com.sas.iom.SAS.IStoredProcessService;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IUtilitiesHelper;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SASCache.ICacheReader;
import com.sas.iom.SASCache.ICacheService;
import com.sas.iom.SASCache.ICacheWriter;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASStoredProcess.IStoredProcessContext;
import com.sas.iom.SASStoredProcess.IStoredProcessContextPackage.InvalidFileref;
import com.sas.iom.SASStoredProcess.IStoredProcessContextPackage.LineTypeSeqHolder;
import com.sas.iom.SASStoredProcess.IStoredProcessContextPackage.StreamFilerefFail;
import com.sas.iom.SASStoredProcess.IStoredProcessServer;
import com.sas.iom.SASStoredProcess.IStoredProcessServerHelper;
import com.sas.iom.SASStoredProcess.IStoredProcessServerPackage.BadSessionID;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.MyInbox;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PersonalRepositoryInterface;
import com.sas.services.publish.EventDataInterface;
import com.sas.services.publish.ResultPackageInterface;
import com.sas.services.publish.TransportFactory;
import com.sas.services.publish.archive.ArchiveTransport;
import com.sas.services.publish.metadata.DavBinaryPackageInterface;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.services.publish.requester.RequesterTransportInterface;
import com.sas.services.publish.webdav.DAVTransportInterface;
import com.sas.services.session.LockingException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.AlertProcessingException;
import com.sas.services.storedprocess.Credentials;
import com.sas.services.storedprocess.Event;
import com.sas.services.storedprocess.ExecutionException;
import com.sas.services.storedprocess.ExecutionInterface;
import com.sas.services.storedprocess.ExecutionStatusListenerException;
import com.sas.services.storedprocess.ExecutionStatusListenerInterface;
import com.sas.services.storedprocess.InternalUseException;
import com.sas.services.storedprocess.InvalidParameterValueException;
import com.sas.services.storedprocess.LogFormatter;
import com.sas.services.storedprocess.MissingParameterException;
import com.sas.services.storedprocess.PermanentPackageResultHints;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.ResultHints;
import com.sas.services.storedprocess.ResultsBindingException;
import com.sas.services.storedprocess.SASServerException;
import com.sas.services.storedprocess.SessionNotAvailableException;
import com.sas.services.storedprocess.SessionNotFoundException;
import com.sas.services.storedprocess.StoredProcess;
import com.sas.services.storedprocess.StoredProcessBaseInterface;
import com.sas.services.storedprocess.StoredProcessService;
import com.sas.services.storedprocess.StreamDefinition;
import com.sas.services.storedprocess.TransientPackageResultHints;
import com.sas.services.storedprocess.UniqueNameGenerator;
import com.sas.services.storedprocess.WebDAVPackageDAVServerResultHints;
import com.sas.services.storedprocess.WebDAVPackagePRResultHints;
import com.sas.services.storedprocess.WebDAVPackageURLResultHints;
import com.sas.services.storedprocess.metadata.StoredProcessAlertItemInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.user.GlobalProfileInterface;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import com.sas.util.ChainedException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

@SASScope
final class Execution
extends UnicastRemoteObject
implements ExecutionInterface {
    static final String RESULT = "_result";
    static final String ARCHIVE_PATH = "_archive_path";
    static final String ARCHIVE_NAME = "_archive_name";
    static final String HTTP_USER = "_http_user";
    static final String HTTP_PASSWORD = "_http_password";
    static final String HTTP_PROXY_URL = "_http_proxy_url";
    static final String METAPERSON = "_metaperson";
    static final String METAUSER = "_metauser";
    static final String UNKNOWN = "UNKNOWN";
    static final int NUMBER_OF_TRIES = 100;
    private ExecutionStatusListenerInterface _listener;
    private boolean _synchronous;
    private boolean _createAlert;
    private IResultPackage _iResultPackage;
    private ResultPackageInterface _resultPackage;
    private volatile int _status = -1;
    private final String[] _parmsNames;
    private final String[] _parmsValues;
    private final String[] _parmsNamesForAlert;
    private final java.lang.Object[] _parmsValuesForAlert;
    private int _numberOfParms;
    private IResultPackageService _resultPackageService;
    private IStoredProcessContext _storedProcessContext;
    private IStoredProcessServer _storedProcessServer;
    private String _resultPackageFilePath;
    private HashMap _streamsMap = new HashMap();
    private ILanguageService _languageService;
    private java.lang.Object _completionStatusLock = new java.lang.Object();
    private int _SASCondtionCode;
    private String _sessionID;
    private StoredProcessAlertItemInterface _alert;
    private PersonalRepositoryInterface _personalRepository;
    private ArrayList _exceptionList;
    private AlertEvent _alertEvent;
    private String _eId;
    private ResultHints _resultHints;
    private Credentials _webDAVCredentialsUsedForParameters;
    private boolean _completionStatusSet = false;
    private Logger _logger;
    private boolean _addedSessionIDWhichShouldBeRemovedIfNotCreated;
    private String _sessionIDWhichMayHaveToBeRemoved;
    private static final int CONNECTION_TYPE_SESSIONID = 1;
    private static final int CONNECTION_TYPE_USER_SPECIFIED_SERVER = 2;
    private static final int CONNECTION_TYPE_SERVICE_OBTAINED_FROM_METADATA = 3;
    private int _connectionType;
    private String _connectionSessionID;
    private java.lang.Object _connectionServer;
    private ConnectionInterface _createdConnection;
    private PlatformConnectionFactoryInterface _connectionFactory;
    private boolean _alreadyDestroyed;
    private SessionContextInterface _sessionContext;
    private java.lang.Object _sessionLock;
    private UserContextInterface _userContext;
    private int _serverType;
    private int _resultType;
    private String _storedProcessName;
    private StoredProcessService _service;
    private String _storedProcessDirectory;
    private String _storedProcessFileName;
    private String _storedProcessNameForMonitoring;
    private boolean _isResultPackageReturned;
    private boolean _isResultPackageLifeCycleBound;

    private void logMessageAndThrowIllegalStateException(String message) {
        if (this._logger != null) {
            this._logger.error(message);
        }
        throw new IllegalStateException(message);
    }

    Execution(StoredProcess storedProcess, String sessionID, boolean createAlert, int executionCount) throws RemoteException, ExecutionException {
        this(storedProcess, createAlert, executionCount);
        if (storedProcess.getServerType() != 1) {
            String text = "Inconsistent server type " + storedProcess.getServerType() + " used with sessionID constructor.";
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (java.lang.Object)text);
            this.logMessageAndThrowIllegalStateException(msg);
        }
        this._connectionType = 1;
        this._connectionSessionID = sessionID;
    }

    Execution(StoredProcess storedProcess, java.lang.Object userSpecifiedServer, boolean createAlert, int executionCount) throws RemoteException, ExecutionException {
        this(storedProcess, createAlert, executionCount);
        this._connectionType = 2;
        this._connectionServer = this.setConnection(userSpecifiedServer);
    }

    Execution(StoredProcess storedProcess, LogicalServerInterface logicalServer, boolean createAlert, int executionCount) throws RemoteException, ExecutionException {
        this(storedProcess, createAlert, executionCount);
        if (this._userContext == null) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.userCtxtNeededForCnxn.ex.txt"));
        }
        PlatformConnectionFactoryConfiguration cxfConfig = storedProcess._privilegedUser != null && storedProcess._privilegedUser.length() > 0 ? new PlatformConnectionFactoryConfiguration(logicalServer, storedProcess._privilegedUser) : new PlatformConnectionFactoryConfiguration(logicalServer);
        try {
            this._connectionFactory = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            this._createdConnection = this._connectionFactory.getConnection(this._userContext);
        }
        catch (ConnectionFactoryException cfe) {
            if (this._logger != null) {
                this._logger.error(RB.getStringResource("COM.noConn.ex.txt"), (Throwable)cfe);
            }
            throw new ExecutionException(RB.getStringResource("COM.noConn.ex.txt"), cfe);
        }
        this._connectionServer = this.setConnection(this._createdConnection);
        this._connectionType = 3;
    }

    private Execution(StoredProcess storedProcess, boolean createAlert, int executionCount) throws RemoteException, ExecutionException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, Execution.class), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(Execution.class), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(Execution.class));
        String valueMETAUSER;
        String valueMETAPERSON;
        String msg;
        String msg2;
        this._createAlert = createAlert;
        this._sessionContext = storedProcess._sessionContext;
        this._userContext = storedProcess._userContext;
        this._serverType = storedProcess.getServerType();
        this._resultType = storedProcess.getResultType();
        this._storedProcessName = storedProcess.getName();
        this._service = storedProcess._service;
        this._storedProcessDirectory = storedProcess.getDirectory();
        this._storedProcessFileName = storedProcess.getFileName();
        this._eId = executionCount == 1 ? storedProcess._seqNum : storedProcess._seqNum + '-' + Integer.toString(executionCount);
        this._isResultPackageReturned = storedProcess.isResultPackageReturned();
        this.setSPNameForMonitoring(storedProcess, storedProcess._storedProcessSmartObject);
        if (this._resultType == 2 || this._resultType == 4 || this._resultType == 8) {
            ResultHints rh = storedProcess._resultHints;
            if (rh == null && this._resultType == 2) {
                rh = new TransientPackageResultHints();
            }
            if (rh == null) {
                String msg3 = Message.format((ResourceBundle)RB.getResources(), (String)"E.noRHSpec.ex.fmt.txt", (java.lang.Object)Integer.toString(this._resultType));
                this.logMessageAndThrowIllegalStateException(msg3);
            }
            this._resultHints = (ResultHints)rh.clone();
            this._isResultPackageLifeCycleBound = this._resultHints.isLifecycleBound();
        }
        this._logger = LogManager.getLogger(Execution.class);
        AttributeDescriptorInterface[] parmList = storedProcess.getParameters();
        int numberOfParms = parmList.length;
        HashMap<String, String> nameValues = new HashMap<String, String>(numberOfParms + 5);
        ArrayList<String> namesForAlert = new ArrayList<String>(numberOfParms);
        ArrayList<String> valuesForAlert = new ArrayList<String>(numberOfParms);
        for (int i = 0; i < numberOfParms; ++i) {
            String stringValueOfParm;
            String parmName = parmList[i].getName();
            java.lang.Object value = parmList[i].isDefaultValueHasBeenSet() || storedProcess.containsAttributeNamed(parmName) ? storedProcess.getAttribute(parmName) : null;
            if (value == null) {
                stringValueOfParm = null;
            } else if (value instanceof java.lang.Object[]) {
                java.lang.Object[] arr = (java.lang.Object[])value;
                if (this._serverType == 2) {
                    if (arr.length != 1) {
                        msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"COM.invArrayParm.ex.fmt.txt", (java.lang.Object)parmName, (java.lang.Object)Integer.toString(arr.length));
                        if (this._logger != null) {
                            this._logger.error(msg2);
                        }
                        throw new InvalidParameterValueException(msg2);
                    }
                    stringValueOfParm = arr[0].toString();
                } else {
                    StringBuffer valueString = new StringBuffer();
                    int arrayLength = arr.length;
                    for (int j = 0; j < arrayLength; ++j) {
                        if (j > 0) {
                            valueString.append('\u001f');
                        }
                        valueString.append(arr[j].toString());
                    }
                    stringValueOfParm = valueString.toString();
                }
            } else {
                stringValueOfParm = storedProcess.getStringAttribute(parmName, parmList[i].getStringDefault());
            }
            if (parmList[i].isRequired() && stringValueOfParm == null) {
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.missnReqdParm.ex.fmt.txt", (java.lang.Object)parmName);
                if (this._logger != null) {
                    this._logger.error(msg);
                }
                throw new MissingParameterException(msg);
            }
            if (stringValueOfParm == null) continue;
            namesForAlert.add(parmName);
            valuesForAlert.add(stringValueOfParm);
            nameValues.put(parmName, stringValueOfParm);
        }
        if (this._createAlert) {
            this.createAlertItem();
        }
        try {
            switch (this._resultType) {
                case 1: {
                    nameValues.put(RESULT, "STATUS");
                    break;
                }
                case 2: {
                    if (this._serverType == 2) {
                        nameValues.put(RESULT, "PACKAGE_TO_REQUESTER");
                        break;
                    }
                    nameValues.put(RESULT, "PACKAGE_TO_ARCHIVE");
                    nameValues.put(ARCHIVE_PATH, "TEMPFILE");
                    break;
                }
                case 16: {
                    nameValues.put(RESULT, "STREAM");
                    break;
                }
                case 4: {
                    PermanentPackageResultHints hints = (PermanentPackageResultHints)this._resultHints;
                    String hintVal = hints.getArchivePath();
                    nameValues.put(ARCHIVE_PATH, hintVal);
                    if (hints.isNewInstanceCreated()) {
                        nameValues.remove(ARCHIVE_NAME);
                    } else {
                        hintVal = hints.getArchiveName();
                        nameValues.put(ARCHIVE_NAME, hintVal);
                    }
                    if (this._serverType == 2) {
                        nameValues.put(RESULT, "PACKAGE_TO_REQUESTER");
                        break;
                    }
                    nameValues.put(RESULT, "PACKAGE_TO_ARCHIVE");
                    break;
                }
                case 8: {
                    ResultHints hints;
                    String webDAVCollectionURL = null;
                    String webDAVuserid = null;
                    String webDAVpassword = null;
                    String proxyURL = null;
                    if (this._resultHints instanceof WebDAVPackagePRResultHints) {
                        hints = (WebDAVPackagePRResultHints)this._resultHints;
                        this.findPersonalRepository();
                        ((WebDAVPackagePRResultHints)hints).setPersonalRepository(this._personalRepository);
                        ((WebDAVPackagePRResultHints)hints).determineResultsLocation(this._alert == null ? null : this._alert.getName(), this._logger, this._eId);
                        webDAVCollectionURL = (String)hints.getResultLocation();
                        this._webDAVCredentialsUsedForParameters = ((WebDAVPackagePRResultHints)hints).getCredentials(this._logger);
                    } else if (this._resultHints instanceof WebDAVPackageDAVServerResultHints) {
                        hints = (WebDAVPackageDAVServerResultHints)this._resultHints;
                        ((WebDAVPackageDAVServerResultHints)hints).determineResultsLocation(this._alert == null ? null : this._alert.getName(), this._logger, this._userContext, this._eId);
                        webDAVCollectionURL = (String)hints.getResultLocation();
                        this._webDAVCredentialsUsedForParameters = ((WebDAVPackageDAVServerResultHints)hints).getCredentials(this._logger, this._userContext);
                        proxyURL = ((WebDAVPackageDAVServerResultHints)hints).getProxyURL();
                    } else if (this._resultHints instanceof WebDAVPackageURLResultHints) {
                        hints = (WebDAVPackageURLResultHints)this._resultHints;
                        webDAVCollectionURL = ((WebDAVPackageURLResultHints)hints).getCollectionURL();
                        if (webDAVCollectionURL == null || webDAVCollectionURL.length() == 0) {
                            msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"E.noCollURL.ex.fmt.txt", (java.lang.Object)this._storedProcessName);
                            if (this._logger != null) {
                                this._logger.error(msg2);
                            }
                            throw new ExecutionException(msg2);
                        }
                        this._webDAVCredentialsUsedForParameters = ((WebDAVPackageURLResultHints)hints).getCredentials(this._logger, this._userContext);
                        proxyURL = ((WebDAVPackageURLResultHints)hints).getProxyURL();
                    }
                    nameValues.put("_collection_url", webDAVCollectionURL);
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.DAVResltLoc.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)webDAVCollectionURL);
                        this._logger.debug(msg);
                    }
                    webDAVuserid = this._webDAVCredentialsUsedForParameters._userName;
                    webDAVpassword = this._webDAVCredentialsUsedForParameters._password;
                    if (webDAVuserid != null && webDAVpassword != null) {
                        nameValues.put(HTTP_USER, webDAVuserid);
                        nameValues.put(HTTP_PASSWORD, webDAVpassword);
                    } else {
                        nameValues.remove(HTTP_USER);
                        nameValues.remove(HTTP_PASSWORD);
                    }
                    if (proxyURL != null && proxyURL.length() > 0) {
                        nameValues.put(HTTP_PROXY_URL, proxyURL);
                    } else {
                        nameValues.remove(HTTP_PROXY_URL);
                    }
                    nameValues.put(RESULT, "PACKAGE_TO_WEBDAV");
                    break;
                }
            }
        }
        catch (ServiceException se) {
            SASServerException ee = new SASServerException(se);
            throw ee;
        }
        if (this._userContext == null) {
            valueMETAPERSON = UNKNOWN;
            valueMETAUSER = UNKNOWN;
        } else {
            valueMETAPERSON = this._userContext.getName();
            if (valueMETAPERSON == null || valueMETAPERSON.length() == 0) {
                valueMETAPERSON = UNKNOWN;
            }
            try {
                valueMETAUSER = this._userContext.getResolvedUserId();
                if (valueMETAUSER == null || valueMETAUSER.length() == 0) {
                    valueMETAUSER = UNKNOWN;
                }
            }
            catch (Exception e) {
                if (this._logger != null) {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"COM.metauserVal.ex.fmt.txt", (java.lang.Object)valueMETAPERSON), (Throwable)e);
                }
                valueMETAUSER = UNKNOWN;
            }
        }
        nameValues.put(METAPERSON, valueMETAPERSON);
        nameValues.put(METAUSER, valueMETAUSER);
        ArrayList<String> names = new ArrayList<String>(numberOfParms);
        ArrayList<String> values = new ArrayList<String>(numberOfParms);
        for (Map.Entry me : nameValues.entrySet()) {
            String parmName = (String)me.getKey();
            String value = (String)me.getValue();
            if (value.indexOf(31) != -1) {
                String[] valueArr = this.getParameterValues(value);
                for (int i = 0; i < valueArr.length; ++i) {
                    names.add(parmName);
                    values.add(valueArr[i]);
                }
                continue;
            }
            names.add(parmName);
            values.add(value);
        }
        this._numberOfParms = names.size();
        if (this._serverType == 2) {
            for (int i = 0; i < this._numberOfParms; ++i) {
                java.lang.Object parmVal = values.get(i);
                if (!(parmVal instanceof String)) continue;
                String val = (String)parmVal;
                if (val.matches(".*[%&'\";].*")) {
                    val = val.replaceAll("%", "%%");
                    val = val.replaceAll("'", "%'");
                    val = val.replaceAll("\"", "%\"");
                    val = val.replaceAll("\\(", "%(");
                    val = val.replaceAll("\\)", "%)");
                    val = "%nrstr(" + val + ')';
                }
                if (val.indexOf(34) == -1) {
                    val = '\"' + val + '\"';
                } else if (val.indexOf(39) == -1) {
                    val = '\'' + val + '\'';
                } else {
                    String msg4 = Message.format((ResourceBundle)RB.getResources(), (String)"SP.invldParmVal.ex.fmt.txt", (java.lang.Object)names.get(i).toString(), (java.lang.Object)val);
                    throw new InvalidParameterValueException(msg4);
                }
                values.set(i, val);
            }
        }
        this._parmsNames = names.toArray(new String[0]);
        this._parmsValues = values.toArray(new String[0]);
        this._parmsNamesForAlert = namesForAlert.toArray(new String[0]);
        this._parmsValuesForAlert = valuesForAlert.toArray();
        if (this._serverType == 1) {
            Set set = storedProcess._streams.entrySet();
            for (Map.Entry me : set) {
                String streamName = (String)me.getKey();
                StreamDefinition sd = (StreamDefinition)me.getValue();
                sd = (StreamDefinition)sd.clone();
                this._streamsMap.put(streamName, sd);
            }
        }
        this._exceptionList = new ArrayList();
        if (this._logger != null && this._logger.isDebugEnabled()) {
            int count = this._parmsNames.length;
            String msg5 = Message.format((ResourceBundle)RB.getResources(), (String)"E.parmLst.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)new Integer(count));
            this._logger.debug(msg5);
            for (int i = 0; i < count; ++i) {
                msg5 = Message.format((ResourceBundle)RB.getResources(), (String)"E.parmNV.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)this._parmsNames[i], (java.lang.Object)(this._parmsNames[i].toLowerCase().contains("password") ? "****" : this._parmsValues[i]));
                this._logger.debug(msg5);
            }
        }
    }

    private String[] getParameterValues(String valueString) {
        ArrayList<String> values = new ArrayList<String>();
        int fromPos = 0;
        while (true) {
            int nextPos;
            String thisValue = (nextPos = valueString.indexOf(31, fromPos)) == -1 ? valueString.substring(fromPos) : valueString.substring(fromPos, nextPos);
            values.add(thisValue);
            if (nextPos == -1) break;
            fromPos = nextPos + 1;
        }
        return values.toArray(new String[0]);
    }

    @Override
    public int getSASConditionCode() {
        this.checkIfDestroyed();
        if (this._status == 1 || this._status == 2) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noCC.ex.txt"));
        }
        return this._SASCondtionCode;
    }

    @Override
    public ResultPackageInterface getResultPackage() {
        this.checkIfDestroyed();
        if (this._status == 1 || this._status == 2) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noRP.ex.txt"));
        }
        return this._resultPackage;
    }

    @Override
    public ResultHints getResultHints() {
        this.checkIfDestroyed();
        if (this._status == 1 || this._status == 2) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noRHAval.ex.txt"));
        }
        if (this._resultHints == null) {
            return null;
        }
        return (ResultHints)this._resultHints.clone();
    }

    @Override
    public StoredProcessAlertItemInterface getStoredProcessAlert() {
        this.checkIfDestroyed();
        return this._alert;
    }

    @Override
    public String getSessionID() throws IllegalStateException {
        this.checkIfDestroyed();
        if (this._status == 1 || this._status == 2) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noSessnID.ex.txt"));
        }
        return this._sessionID;
    }

    @Override
    public boolean isSynchronous() {
        this.checkIfDestroyed();
        return this._synchronous;
    }

    @Override
    public synchronized int getStatus() {
        this.checkIfDestroyed();
        return this.realGetStatus();
    }

    private int realGetStatus() {
        return this._status;
    }

    @Override
    public ExecutionException[] getExceptions() {
        this.checkIfDestroyed();
        return this._exceptionList.toArray(new ExecutionException[0]);
    }

    @Override
    public String readSASLog(int flag, int maxLines) throws IllegalStateException, TransportException {
        int i;
        int[] lineTypeArray;
        java.lang.Object[] ltArr;
        int count;
        java.lang.Object lineTypes;
        java.lang.Object carriageControls;
        this.checkIfDestroyed();
        boolean valid = true;
        switch (this._status) {
            case 1: {
                valid = false;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                valid = true;
            }
        }
        if (!valid) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noLog.ex.txt"));
        }
        if (maxLines == -1) {
            maxLines = Integer.MAX_VALUE;
        }
        StringSeqHolder logLines = new StringSeqHolder();
        if (this._serverType == 2) {
            carriageControls = new CarriageControlSeqHolder();
            lineTypes = new com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder();
            try {
                this._languageService.FlushLogLines(maxLines, carriageControls, lineTypes, logLines);
            }
            catch (Exception ex) {
                if (this._logger != null) {
                    this._logger.error("COM.genIOM.ex.txt", (Throwable)ex);
                }
                throw new TransportException((Throwable)ex, RB.getStringResource("COM.genIOM.ex.txt"));
            }
            if (logLines.value.length == 0) {
                return "";
            }
            count = logLines.value.length;
            ltArr = lineTypes.value;
            if (count != ltArr.length) {
                String text = count + " " + ltArr.length;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (java.lang.Object)text);
                if (this._logger != null) {
                    this._logger.error(msg);
                }
                throw new IllegalStateException(msg);
            }
            lineTypeArray = new int[count];
            for (i = 0; i < count; ++i) {
                int temp;
                switch (ltArr[i].value()) {
                    case 6: {
                        temp = 1;
                        break;
                    }
                    case 8: {
                        temp = 2;
                        break;
                    }
                    case 7: {
                        temp = 3;
                        break;
                    }
                    default: {
                        temp = 0;
                    }
                }
                lineTypeArray[i] = temp;
            }
        } else {
            carriageControls = new com.sas.iom.SASStoredProcess.IStoredProcessContextPackage.CarriageControlSeqHolder();
            lineTypes = new LineTypeSeqHolder();
            try {
                this._storedProcessContext.GetSasLog(maxLines, (com.sas.iom.SASStoredProcess.IStoredProcessContextPackage.CarriageControlSeqHolder)carriageControls, (LineTypeSeqHolder)lineTypes, logLines);
            }
            catch (Exception ex) {
                if (this._logger != null) {
                    this._logger.error("COM.genIOM.ex.txt", (Throwable)ex);
                }
                throw new TransportException((Throwable)ex, RB.getStringResource("COM.genIOM.ex.txt"));
            }
            if (logLines.value.length == 0) {
                return "";
            }
            count = logLines.value.length;
            ltArr = lineTypes.value;
            if (count != ltArr.length) {
                String text = count + " " + ltArr.length;
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.incon.ex.fmt.txt", (java.lang.Object)text);
                this.logMessageAndThrowIllegalStateException(msg);
            }
            lineTypeArray = new int[count];
            for (i = 0; i < count; ++i) {
                int temp;
                switch (ltArr[i].value()) {
                    case 6: {
                        temp = 1;
                        break;
                    }
                    case 8: {
                        temp = 2;
                        break;
                    }
                    case 7: {
                        temp = 3;
                        break;
                    }
                    default: {
                        temp = 0;
                    }
                }
                lineTypeArray[i] = temp;
            }
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.logLnHdr.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)new Integer(count));
            this._logger.debug(msg);
            for (int i2 = 0; i2 < count; ++i2) {
                msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.logLn.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)new Integer(i2), (java.lang.Object)new Integer(lineTypeArray[i2]), (java.lang.Object)logLines.value[i2]);
                this._logger.debug(msg);
            }
        }
        return LogFormatter.format(flag == 1 ? 17 : 23, lineTypeArray, logLines.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitForCompletion() throws InterruptedException {
        java.lang.Object object = this._completionStatusLock;
        synchronized (object) {
            while (!this._completionStatusSet) {
                this._completionStatusLock.wait();
            }
        }
        return this.realGetStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitForCompletion(long milliSecondTimeout) throws InterruptedException {
        java.lang.Object object = this._completionStatusLock;
        synchronized (object) {
            if (!this._completionStatusSet) {
                this._completionStatusLock.wait(milliSecondTimeout);
            }
        }
        return this.realGetStatus();
    }

    @Override
    public synchronized void destroy() throws ConnectionFactoryException, TransportException, RemoteException {
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.dstry.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
            this._logger.debug(msg);
        }
        if (this._status == 1) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.cantDstry.ex.txt"));
        }
        if (this._alreadyDestroyed) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("COM.destryCalld.ex.txt"));
        }
        this._alreadyDestroyed = true;
        this._status = 5;
        try {
            Execution.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.doDestroy();
    }

    private void doDestroy() throws ConnectionFactoryException, TransportException, RemoteException {
        String msg2;
        if (this._isResultPackageLifeCycleBound) {
            block25: {
                if (this._resultPackage != null) {
                    try {
                        if (this._logger != null && this._logger.isDebugEnabled()) {
                            msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"E.closRP.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                            this._logger.debug(msg2);
                        }
                        this._resultPackage.close();
                    }
                    catch (IllegalStateException msg2) {
                        // empty catch block
                    }
                    if (this._iResultPackage != null) {
                        block24: {
                            try {
                                this._iResultPackage.Close();
                            }
                            catch (Exception e) {
                                if (this._logger == null) break block24;
                                this._logger.warn(RB.getStringResource("COM.genIOM.ex.txt"), (Throwable)e);
                            }
                        }
                        this._iResultPackage = null;
                    }
                }
                if (this._serverType == 1 && this._resultType == 2 && this._resultPackage != null) {
                    try {
                        if (this._logger != null && this._logger.isDebugEnabled()) {
                            msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"E.delTmpArc.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                            this._logger.debug(msg2);
                        }
                        this._resultPackageService.DeleteResultPackage("ARCHIVE", this._resultPackageFilePath, new String[0][0]);
                    }
                    catch (Exception e) {
                        if (this._logger == null) break block25;
                        this._logger.warn(RB.getStringResource("COM.genIOM.ex.txt"), (Throwable)e);
                    }
                }
            }
            this._resultPackage = null;
        }
        if (this._serverType == 1) {
            try {
                if (this._storedProcessContext != null) {
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"E.closCtxt.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                        this._logger.debug(msg2);
                    }
                    this._storedProcessContext.Close();
                }
            }
            catch (Exception e) {
                if (this._logger != null) {
                    this._logger.error(RB.getStringResource("COM.genIOM.ex.txt"), (Throwable)e);
                }
                throw new TransportException((Throwable)e, RB.getStringResource("COM.genIOM.ex.txt"));
            }
        }
        boolean okToCloseConnection = false;
        if (this._connectionType == 3) {
            okToCloseConnection = true;
            if (this._serverType == 1 && this._sessionID != null) {
                okToCloseConnection = false;
                this._service._sessionMap.decrementSPUseCount(this._sessionID);
            }
        } else if (this._connectionType == 1) {
            this._service._sessionMap.decrementSPUseCount(this._sessionID);
        }
        if (okToCloseConnection) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg3 = Message.format((ResourceBundle)RB.getResources(), (String)"E.closCnxn.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                this._logger.debug(msg3);
            }
            this._createdConnection.close();
        }
    }

    private void checkIfDestroyed() {
        if (this._alreadyDestroyed) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("COM.destryCalld.ex.txt"));
        }
    }

    @Override
    public java.io.InputStream getInputStream(java.lang.Object streamKey) {
        this.checkIfDestroyed();
        StreamDefinition sd = this.getInputOutputStream(streamKey);
        if (sd == null || !sd._isInput) {
            return null;
        }
        return sd._inputStreamAdapter;
    }

    @Override
    public OutputStream getOutputStream(java.lang.Object streamKey) {
        this.checkIfDestroyed();
        StreamDefinition sd = this.getInputOutputStream(streamKey);
        if (sd == null || sd._isInput) {
            return null;
        }
        return sd._outputStreamProxy;
    }

    private StreamDefinition getInputOutputStream(java.lang.Object streamKey) {
        String streamName = streamKey.toString().toLowerCase(Locale.US);
        StreamDefinition sd = (StreamDefinition)this._streamsMap.get(streamName);
        return sd;
    }

    @Override
    public InputStreamHeaderInterface getInputStreamHeader(String streamKey) {
        this.checkIfDestroyed();
        StreamDefinition sd = this.getInputOutputStream(streamKey);
        if (sd == null || !sd._isInput) {
            return null;
        }
        return sd._inputStream.getHeader();
    }

    @Override
    public OutputStreamHeaderInterface getOutputStreamHeader(String streamKey) {
        this.checkIfDestroyed();
        StreamDefinition sd = this.getInputOutputStream(streamKey);
        if (sd == null || sd._isInput) {
            return null;
        }
        return sd._outputStream.getHeader();
    }

    void execute(StoredProcess storedProcess, boolean synchronous, ExecutionStatusListenerInterface listener) throws RemoteException, ExecutionException {
        this._status = 1;
        this._synchronous = synchronous;
        this._listener = listener;
        if (this._createAlert) {
            this.initializeAlertItem(storedProcess, storedProcess._storedProcessSmartObject);
        }
        if (this._listener != null) {
            try {
                this._listener.executionStatusChanged(this);
            }
            catch (Throwable t) {
                if (this._logger != null) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.exeExcp.fmt.txt", (java.lang.Object)this._storedProcessName);
                    this._logger.error(msg, t);
                }
                throw new ExecutionStatusListenerException(t);
            }
        }
        if (this._serverType == 2) {
            this.executeWorkspaceServerStoredProcess();
        } else {
            this.executeStoredProcessServerStoredProcess();
        }
    }

    private String formatExecutionException(Exception e) {
        StringBuffer exceptionText = new StringBuffer();
        Throwable t = e;
        while (t.getCause() != null) {
            exceptionText.append(t.toString());
            exceptionText.append('\n');
            t = t.getCause();
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        exceptionText.append(sw.toString());
        return exceptionText.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCompletion() throws RemoteException {
        if (this._createAlert) {
            this.setCompletionInfoInAlertItem();
        }
        if (this._listener != null) {
            try {
                this._listener.executionStatusChanged(this);
            }
            catch (Throwable t) {
                ExecutionStatusListenerException esle = new ExecutionStatusListenerException(t);
                this.addExceptionToListAndSetStatus(esle);
            }
        }
        if ((this._status == 4 || this._status == 2) && this._logger != null) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.exeEnd.ex.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
            this._logger.error(msg);
            int numberOfExceptions = this._exceptionList.size();
            for (int i = 0; i < numberOfExceptions; ++i) {
                this._logger.error("", (Throwable)((ExecutionException)this._exceptionList.get(i)));
            }
        }
        if (this._sessionLock != null) {
            this._sessionContext.unlock(this._sessionLock);
            try {
                this._sessionContext.destroy();
            }
            catch (LockingException lockingException) {
                // empty catch block
            }
        }
        java.lang.Object object = this._completionStatusLock;
        synchronized (object) {
            this._completionStatusSet = true;
            this._completionStatusLock.notifyAll();
        }
    }

    private void setSPNameForMonitoring(StoredProcessBaseInterface storedProcess, StoredProcessInterface smartObject) throws RemoteException {
        String objName = null;
        try {
            objName = smartObject.getPathUrl().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objName == null) {
            objName = storedProcess.getName();
        }
        this._storedProcessNameForMonitoring = objName;
    }

    private String getSPNameForMonitoring() {
        return this._storedProcessNameForMonitoring;
    }

    private void replaceServerResultPackageWithJVMTierCopyAndCleanup() throws RemoteException, IllegalStateException, IOException, TransportException, IllegalArgumentException {
        ResultPackageInterface copyOfResultPackage;
        block5: {
            block4: {
                java.io.InputStream is = this._resultPackage.getInputStream();
                ArchiveTransport transport = new ArchiveTransport(is, this._sessionContext);
                copyOfResultPackage = transport.getResultPackage();
                try {
                    this._resultPackage.close();
                }
                catch (Exception e) {
                    if (this._logger == null) break block4;
                    this._logger.warn(RB.getStringResource("COM.genIOM.ex.txt"), (Throwable)e);
                }
            }
            try {
                this._iResultPackage.Close();
            }
            catch (Exception e) {
                if (this._logger == null) break block5;
                this._logger.warn(RB.getStringResource("COM.genIOM.ex.txt"), (Throwable)e);
            }
        }
        this._iResultPackage = null;
        this._resultPackage = copyOfResultPackage;
    }

    private void executeWorkspaceServerStoredProcess() throws RemoteException {
        if (this._sessionContext != null) {
            this._sessionLock = this._sessionContext.lock("com.sas.services.storedprocess");
        }
        if (this._synchronous) {
            this.doExecuteWorkspaceServerStoredProcess();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            Execution.this.doExecuteWorkspaceServerStoredProcess();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            if (Execution.this._logger == null) break block2;
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.exeExcp.fmt.txt", (java.lang.Object)Execution.this._storedProcessName);
                            Execution.this._logger.error(msg, t);
                        }
                    }
                }
            };
            Thread t = new Thread(r);
            t.setName(Message.format((String)"{0}_{1}", (java.lang.Object)this.getClass().getName(), (java.lang.Object)t.getName()));
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.newThrd.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                this._logger.debug(msg);
            }
            t.start();
        }
    }

    private void doExecuteWorkspaceServerStoredProcess() throws RemoteException {
        boolean languageServiceAsyncSettingSavedForRestorationPurposes = false;
        try {
            StringBuffer nameValues = new StringBuffer();
            boolean subsequent = false;
            for (int i = 0; i < this._numberOfParms; ++i) {
                if (subsequent) {
                    nameValues.append(' ');
                }
                nameValues.append(this._parmsNames[i]);
                nameValues.append('=');
                nameValues.append(this._parmsValues[i]);
                subsequent = true;
            }
            String nv = nameValues.toString();
            IResultPackageHolder resultPackageHolder = null;
            try {
                String msg;
                IWorkspace ws = null;
                switch (this._connectionType) {
                    case 2: 
                    case 3: {
                        ws = (IWorkspace)this._connectionServer;
                        break;
                    }
                    default: {
                        this.logMessageAndThrowIllegalStateException(RB.getStringResource("COM.incon.ex.txt"));
                    }
                }
                this._languageService = ws.LanguageService();
                languageServiceAsyncSettingSavedForRestorationPurposes = this._languageService.Async();
                this._languageService.Async(false);
                IStoredProcessService sps = this._languageService.StoredProcessService();
                sps.Repository("file:" + this._storedProcessDirectory);
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.exeStrt.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)this._storedProcessFileName, (java.lang.Object)this._storedProcessDirectory);
                    this._logger.debug(msg);
                }
                switch (this._resultType) {
                    case 1: {
                        sps.Execute(this._storedProcessFileName, nv);
                        break;
                    }
                    case 2: {
                        resultPackageHolder = new IResultPackageHolder();
                        sps.ResultPackageArchivePath("TEMPFILE");
                        sps.ExecuteWithResults(this._storedProcessFileName, nv, resultPackageHolder);
                        break;
                    }
                    case 4: {
                        resultPackageHolder = new IResultPackageHolder();
                        sps.ExecuteWithResults(this._storedProcessFileName, nv, resultPackageHolder);
                        break;
                    }
                    case 8: {
                        sps.Execute(this._storedProcessFileName, nv);
                    }
                }
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.exeEndNoSrvrExcp.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                    this._logger.debug(msg);
                }
            }
            catch (GenericError ge) {
                SASServerException sse = new SASServerException(ge);
                throw sse;
            }
            this._webDAVCredentialsUsedForParameters = null;
            if (this._resultType == 2 || this._resultType == 4 || this._resultType == 8) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.getRP.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                    this._logger.debug(msg);
                }
                try {
                    if (this._resultType == 8) {
                        ResultHints hints;
                        String webDAVCollectionURL = null;
                        String webDAVuserid = null;
                        String webDAVpassword = null;
                        Credentials credentials = null;
                        if (this._resultHints instanceof WebDAVPackagePRResultHints) {
                            hints = (WebDAVPackagePRResultHints)this._resultHints;
                            webDAVCollectionURL = (String)hints.getResultLocation();
                            credentials = ((WebDAVPackagePRResultHints)hints).getCredentials(this._logger);
                        } else if (this._resultHints instanceof WebDAVPackageDAVServerResultHints) {
                            hints = (WebDAVPackageDAVServerResultHints)this._resultHints;
                            webDAVCollectionURL = (String)hints.getResultLocation();
                            credentials = ((WebDAVPackageDAVServerResultHints)hints).getCredentials(this._logger, this._userContext);
                        } else if (this._resultHints instanceof WebDAVPackageURLResultHints) {
                            hints = (WebDAVPackageURLResultHints)this._resultHints;
                            webDAVCollectionURL = (String)hints.getResultLocation();
                            credentials = ((WebDAVPackageURLResultHints)hints).getCredentials(this._logger, this._userContext);
                        }
                        webDAVuserid = credentials._userName;
                        webDAVpassword = credentials._password;
                        TransportFactory factory = new TransportFactory();
                        DAVTransportInterface dt = factory.getDAVTransportWithCredentials(webDAVCollectionURL, webDAVuserid, webDAVpassword, this._sessionContext);
                        this._resultPackage = dt.getResultPackage();
                    } else {
                        TransportFactory factory = new TransportFactory();
                        this._iResultPackage = resultPackageHolder.value;
                        RequesterTransportInterface rt = factory.getRequesterTransport(this._iResultPackage, this._sessionContext);
                        this._resultPackage = rt.getResultPackage();
                        if (this._resultType == 4) {
                            this._resultHints.setResultLocation(this._iResultPackage.TransportInformation());
                        }
                        if (!this._isResultPackageLifeCycleBound) {
                            this.replaceServerResultPackageWithJVMTierCopyAndCleanup();
                        }
                    }
                }
                catch (Exception e) {
                    ResultsBindingException rbe = new ResultsBindingException(e);
                    throw rbe;
                }
            }
            this._status = 3;
        }
        catch (Exception e) {
            ExecutionException ee = e instanceof ExecutionException ? (ExecutionException)e : new ExecutionException(RB.getStringResource("E.execerr.ex.txt"), e);
            this.addExceptionToListAndSetStatus(ee);
        }
        if (this._languageService != null) {
            this._languageService.Async(languageServiceAsyncSettingSavedForRestorationPurposes);
        }
        this.notifyCompletion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeStoredProcessServerStoredProcess() throws ExecutionException, RemoteException {
        try {
            ICacheService cs;
            block27: {
                cs = null;
                String sessionID = null;
                switch (this._connectionType) {
                    case 1: {
                        sessionID = this._connectionSessionID;
                        try {
                            this._storedProcessServer = this._service._sessionMap.getServerIncrementingSPUseCount(sessionID, this._sessionContext);
                            break;
                        }
                        catch (InternalUseException iue) {
                            if (iue._type != 1) throw new SessionNotFoundException(sessionID);
                            throw new SessionNotAvailableException(sessionID);
                        }
                    }
                    case 2: 
                    case 3: {
                        sessionID = "";
                        this._storedProcessServer = (IStoredProcessServer)this._connectionServer;
                        break;
                    }
                }
                try {
                    if (this._streamsMap.size() > 0) {
                        try {
                            cs = this._storedProcessServer.CacheService();
                        }
                        catch (Exception e) {
                            ExecutionException ee = new ExecutionException(RB.getStringResource("E.noCachSvc.ex.txt"), e);
                            throw ee;
                        }
                        if (cs == null) {
                            throw new ExecutionException(RB.getStringResource("E.noCachSvc.ex.txt"));
                        }
                    }
                    this._storedProcessContext = this._storedProcessServer.CreateContext(this._storedProcessDirectory, this._storedProcessFileName, this._parmsNames, this._parmsValues, sessionID);
                    if (this._connectionType != 3 && this._connectionType != 2) break block27;
                    this._sessionIDWhichMayHaveToBeRemoved = this._storedProcessContext.SessionID();
                    try {
                        this._service._sessionMap.add(this._sessionIDWhichMayHaveToBeRemoved, this._sessionContext, this._storedProcessServer, this._createdConnection, this._connectionType == 2);
                    }
                    catch (InternalUseException isse) {
                        throw new ExecutionException(RB.getStringResource("E.sessnIDMgmt.ex.txt"));
                    }
                    this._addedSessionIDWhichShouldBeRemovedIfNotCreated = true;
                }
                catch (BadSessionID bsid) {
                    this._service._sessionMap.removeExpiredSession(sessionID);
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.sessnInvld.ex.fmt.txt", (java.lang.Object)sessionID);
                    throw new SASServerException(msg, (Throwable)((java.lang.Object)bsid));
                }
            }
            if (this._streamsMap.size() > 0) {
                Set set = this._streamsMap.entrySet();
                for (Map.Entry me : set) {
                    StreamDefinition sd = (StreamDefinition)me.getValue();
                    try {
                        if (sd._isInput) {
                            ICacheReader cr = this._storedProcessContext.CreateStreamReader(sd._normalizedName, "");
                            sd._inputStream = new InputStream(cr, cs);
                            sd._inputStreamAdapter = new InputStreamAdapter((java.io.InputStream)sd._inputStream);
                            continue;
                        }
                        ICacheWriter cw = this._storedProcessContext.CreateStreamWriter(sd._normalizedName, sd._isMultiPass ? "MULTIPASS" : "");
                        sd._outputStream = new com.sas.iom.OutputStream(cw, cs);
                        sd._outputStreamProxy = new OutputStreamProxy((OutputStream)sd._outputStream);
                    }
                    catch (InvalidFileref ifr) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.invldStrm.ex.fmt.txt", (java.lang.Object)sd._normalizedName);
                        throw new SASServerException(msg, (Throwable)((java.lang.Object)ifr));
                    }
                    catch (StreamFilerefFail ifr) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noAssnFilref.ex.fmt.txt", (java.lang.Object)sd._normalizedName);
                        throw new SASServerException(msg, (Throwable)((java.lang.Object)ifr));
                    }
                }
            }
        }
        catch (GenericError ge) {
            SASServerException sse = new SASServerException(ge);
            throw sse;
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                throw (ExecutionException)e;
            }
            ExecutionException ee = new ExecutionException(RB.getStringResource("E.execerr.ex.txt"), e);
            throw ee;
        }
        if (this._sessionContext != null) {
            this._sessionLock = this._sessionContext.lock("com.sas.services.storedprocess");
        }
        if (this._synchronous) {
            this.doExecuteStoredProcessServerStoredProcess();
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        Execution.this.doExecuteStoredProcessServerStoredProcess();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        if (Execution.this._logger == null) break block2;
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.exeExcp.fmt.txt", (java.lang.Object)Execution.this._storedProcessName);
                        Execution.this._logger.error(msg, t);
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.setName(Message.format((String)"{0}_{1}", (java.lang.Object)this.getClass().getName(), (java.lang.Object)t.getName()));
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.newThrd.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
            this._logger.debug(msg);
        }
        t.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doExecuteStoredProcessServerStoredProcess() throws RemoteException {
        block28: {
            try {
                ResultHints hints;
                String msg;
                String sessionID;
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    String msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"E.exeStrt.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)this._storedProcessFileName, (java.lang.Object)this._storedProcessDirectory);
                    this._logger.debug(msg2);
                }
                boolean executeWasClean = true;
                StringHolder sessionIDHolder = new StringHolder();
                try {
                    this._storedProcessContext.Execute(sessionIDHolder);
                }
                catch (Exception e) {
                    SASServerException sse = new SASServerException(e);
                    this.addExceptionToListAndSetStatus(sse);
                    executeWasClean = false;
                }
                this._webDAVCredentialsUsedForParameters = null;
                if (executeWasClean && this._logger != null && this._logger.isDebugEnabled()) {
                    String msg3 = Message.format((ResourceBundle)RB.getResources(), (String)"E.exeEndNoSrvrExcp.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                    this._logger.debug(msg3);
                }
                if ((sessionID = sessionIDHolder.value) == null || sessionID.length() == 0) {
                    this._sessionID = null;
                    if (this._addedSessionIDWhichShouldBeRemovedIfNotCreated) {
                        this._service._sessionMap.remove(this._sessionIDWhichMayHaveToBeRemoved);
                    }
                } else {
                    this._sessionID = sessionID;
                    String timeOut = this.doGetOutputParameter("_SESSION_TIMEOUT");
                    this._service._sessionMap.updateWithTimes(sessionID, timeOut, this._storedProcessName);
                }
                if (!executeWasClean) break block28;
                this._SASCondtionCode = this._storedProcessContext.SASConditionCode();
                this._status = 3;
                if (this._resultType != 2 && this._resultType != 4 && this._resultType != 8) break block28;
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.getRP.fmt.txt", (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                    this._logger.debug(msg);
                }
                if (this._resultType == 2 || this._resultType == 4) {
                    Object obj;
                    this._resultPackageFilePath = this.doGetOutputParameter("_ARCHIVE_FULLPATH");
                    if (this._resultPackageFilePath.length() == 0) {
                        throw new ResultsBindingException(RB.getStringResource("E.noGenRP.ex.txt"));
                    }
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        msg = Message.format((ResourceBundle)RB.getResources(), (String)(this._resultType == 2 ? "E.arcPthTmp.fmt.txt" : "E.arcPth.fmt.txt"), (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId, (java.lang.Object)this._resultPackageFilePath);
                        this._logger.debug(msg);
                    }
                    if ((obj = this._storedProcessContext.Workspace()) == null) {
                        throw new ResultsBindingException(RB.getStringResource("E.noWrks.ex.txt"));
                    }
                    IWorkspace workspace = IWorkspaceHelper.narrow((Object)obj);
                    if ((obj = workspace.Utilities()) == null) {
                        throw new ResultsBindingException(RB.getStringResource("E.noUtil.ex.txt"));
                    }
                    IUtilities utilities = IUtilitiesHelper.narrow((Object)obj);
                    if ((obj = utilities.ResultPackageService()) == null) {
                        throw new ResultsBindingException(RB.getStringResource("E.noRPS.ex.txt"));
                    }
                    this._resultPackageService = IResultPackageServiceHelper.narrow((Object)obj);
                    this._iResultPackage = this._resultPackageService.BrowseResultPackage("ARCHIVE", this._resultPackageFilePath, new String[0][0]);
                    if (obj == null) {
                        String msg4 = Message.format((ResourceBundle)RB.getResources(), (String)"E.cantBind.ex.fmt.txt", (java.lang.Object)this._resultPackageFilePath);
                        throw new ResultsBindingException(msg4);
                    }
                    TransportFactory factory = new TransportFactory();
                    RequesterTransportInterface rt = factory.getRequesterTransport(this._iResultPackage, this._sessionContext);
                    this._resultPackage = rt.getResultPackage();
                    if (this._resultType == 4) {
                        this._resultHints.setResultLocation(this._iResultPackage.TransportInformation());
                    }
                    if (this._isResultPackageLifeCycleBound) break block28;
                    this.replaceServerResultPackageWithJVMTierCopyAndCleanup();
                    if (this._resultType != 2) break block28;
                    try {
                        this._resultPackageService.DeleteResultPackage("ARCHIVE", this._resultPackageFilePath, new String[0][0]);
                    }
                    catch (Exception e) {
                        if (this._logger != null) {
                            this._logger.warn(RB.getStringResource("COM.genIOM.ex.txt"), (Throwable)e);
                        }
                        break block28;
                    }
                }
                String webDAVCollectionURL = null;
                String webDAVuserid = null;
                String webDAVpassword = null;
                Credentials credentials = null;
                if (this._resultHints instanceof WebDAVPackagePRResultHints) {
                    hints = (WebDAVPackagePRResultHints)this._resultHints;
                    webDAVCollectionURL = (String)hints.getResultLocation();
                    credentials = ((WebDAVPackagePRResultHints)hints).getCredentials(this._logger);
                } else if (this._resultHints instanceof WebDAVPackageDAVServerResultHints) {
                    hints = (WebDAVPackageDAVServerResultHints)this._resultHints;
                    webDAVCollectionURL = (String)hints.getResultLocation();
                    credentials = ((WebDAVPackageDAVServerResultHints)hints).getCredentials(this._logger, this._userContext);
                } else if (this._resultHints instanceof WebDAVPackageURLResultHints) {
                    hints = (WebDAVPackageURLResultHints)this._resultHints;
                    webDAVCollectionURL = (String)hints.getResultLocation();
                    credentials = ((WebDAVPackageURLResultHints)hints).getCredentials(this._logger, this._userContext);
                }
                webDAVuserid = credentials._userName;
                webDAVpassword = credentials._password;
                try {
                    TransportFactory factory = new TransportFactory();
                    DAVTransportInterface dt = factory.getDAVTransportWithCredentials(webDAVCollectionURL, webDAVuserid, webDAVpassword, this._sessionContext);
                    this._resultPackage = dt.getResultPackage();
                }
                catch (Exception e) {
                    ResultsBindingException rbe = new ResultsBindingException(e);
                    throw rbe;
                }
            }
            catch (Exception e) {
                ExecutionException ee = e instanceof ExecutionException ? (ExecutionException)e : new ExecutionException(RB.getStringResource("E.execerr.ex.txt"), e);
                this.addExceptionToListAndSetStatus(ee);
            }
        }
        this.notifyCompletion();
    }

    @Override
    public String getOutputParameter(String name) throws TransportException {
        this.checkIfDestroyed();
        if (this._status == 1 || this._status == 2) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("E.noOP.ex.txt"));
        }
        if (this._serverType == 2) {
            return null;
        }
        return this.doGetOutputParameter(name);
    }

    private String doGetOutputParameter(String name) throws TransportException {
        StringSeqHolder stringSeqHolder = new StringSeqHolder();
        String[] names = new String[]{name};
        try {
            this._storedProcessContext.GetOutputParameters(names, stringSeqHolder);
        }
        catch (Exception e) {
            if (this._logger != null) {
                this._logger.error("COM.genIOM.ex.txt", (Throwable)e);
            }
            throw new TransportException((Throwable)e, RB.getStringResource("COM.genIOM.ex.txt"));
        }
        return stringSeqHolder.value[0];
    }

    protected void finalize() throws Throwable {
        try {
            if (!this._alreadyDestroyed) {
                this.doDestroy();
            }
        }
        finally {
            super.finalize();
        }
    }

    private java.lang.Object setConnection(java.lang.Object connection) {
        java.lang.Object retConnection;
        if (connection instanceof ConnectionInterface) {
            Object obj = ((ConnectionInterface)connection).getObject();
            retConnection = this.setConnectionFromCorbaObj(this._serverType, obj);
        } else if (connection instanceof Object) {
            Object obj = (Object)connection;
            retConnection = this.setConnectionFromCorbaObj(this._serverType, obj);
        } else if (connection instanceof IWorkspace) {
            if (this._serverType == 1) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.wrngConnForSPSrvr.ex.fmt.txt", (java.lang.Object)"IWorkspace");
                this.logMessageAndThrowIllegalStateException(msg);
            }
            retConnection = connection;
        } else if (connection instanceof IStoredProcessServer) {
            if (this._serverType == 2) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SP.wrngConnForWksSrvr.ex.fmt.txt", (java.lang.Object)"IStoredProcessServer");
                this.logMessageAndThrowIllegalStateException(msg);
            }
            retConnection = connection;
        } else {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.invConn.ex.txt"));
            retConnection = null;
        }
        return retConnection;
    }

    private java.lang.Object setConnectionFromCorbaObj(int serverType, Object obj) {
        java.lang.Object retConnection = null;
        if (serverType == 2) {
            retConnection = IWorkspaceHelper.narrow((Object)obj);
        } else if (serverType == 1) {
            retConnection = IStoredProcessServerHelper.narrow(obj);
        }
        if (retConnection == null) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("SP.invConn.ex.txt"));
        }
        return retConnection;
    }

    private void addExceptionToListAndSetStatus(ExecutionException ee) {
        this._exceptionList.add(ee);
        if (ee instanceof SASServerException) {
            this._status = 2;
        } else if (this._status != 2) {
            this._status = 4;
        }
    }

    private void findPersonalRepository() throws RemoteException, ExecutionException {
        String msg;
        if (this._personalRepository != null) {
            return;
        }
        ProfileInterface po2 = this._userContext.getProfile();
        if (po2 == null) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noProf.ex.fmt.txt", (java.lang.Object)this._userContext.getName());
            this.logMessageAndThrowIllegalStateException(msg);
        }
        if (!(po2 instanceof GlobalProfileInterface)) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.profNotGlbl.ex.fmt.txt", (java.lang.Object)this._userContext.getName());
            this.logMessageAndThrowIllegalStateException(msg);
        }
        try {
            this._personalRepository = ((GlobalProfileInterface)po2).getPersonalRepository();
        }
        catch (ServiceException se) {
            throw new ExecutionException(RB.getStringResource("COM.prAcc.ex.txt"), se);
        }
        if (this._personalRepository == null) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noPRfromGP.ex.fmt.txt", (java.lang.Object)this._userContext.getName());
            this.logMessageAndThrowIllegalStateException(msg);
        }
    }

    private void createAlertItem() throws ExecutionException, RemoteException {
        try {
            this.findPersonalRepository();
            FolderInterface myInbox = this._personalRepository.getApplicationManager(1);
            if (myInbox == null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noInbox.ex.fmt.txt", (java.lang.Object)MyInbox.applicationExtension, (java.lang.Object)this._userContext.getName());
                this.logMessageAndThrowIllegalStateException(msg);
            }
            this._alert = (StoredProcessAlertItemInterface)this.createNewItem(null, "", "storedprocessalert", myInbox);
        }
        catch (ServiceException se) {
            throw new AlertProcessingException(se);
        }
    }

    private void initializeAlertItem(StoredProcessBaseInterface storedProcess, StoredProcessInterface smartObject) throws ExecutionException, RemoteException {
        try {
            this._alertEvent = new AlertEvent();
            this._alertEvent.initialize(storedProcess, smartObject);
            String eventString = this._alertEvent.serialize();
            this._alert.setEventDocumentFromString(eventString);
            this._alert.update();
            if (this._logger != null && this._logger.isDebugEnabled()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.alertCrtd.fmt.txt", (java.lang.Object)this._alert.getName(), (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
                this._logger.debug(msg);
            }
        }
        catch (ParserConfigurationException pce) {
            throw new AlertProcessingException(pce);
        }
        catch (ServiceException se) {
            throw new AlertProcessingException(se);
        }
    }

    private void setCompletionInfoInAlertItem() throws RemoteException {
        if (this._personalRepository == null) {
            return;
        }
        try {
            if (this._status == 3 && this._isResultPackageReturned) {
                PackageInterface pi = null;
                EventDataInterface edi = null;
                boolean canConnect = false;
                if (this._resultType == 2 || this._resultType == 4) {
                    FolderInterface myDocuments = this._personalRepository.getApplicationManager(2);
                    DavBinaryPackageInterface dbp = (DavBinaryPackageInterface)this.createNewItem(this._alert.getName(), ".spk", "binarypackage", myDocuments);
                    ResultPackageInterface rpi = this.getResultPackage();
                    java.io.InputStream is = rpi.getInputStream();
                    edi = dbp.publish(rpi, is);
                    is.close();
                    pi = dbp;
                    canConnect = true;
                } else if (this._resultType == 8) {
                    ResultPackageInterface rpi = this.getResultPackage();
                    edi = rpi.getEventData();
                    if (this._resultHints instanceof WebDAVPackagePRResultHints) {
                        WebDAVPackagePRResultHints hints = (WebDAVPackagePRResultHints)this._resultHints;
                        pi = hints.getSmartObject();
                        canConnect = true;
                    } else if (this._resultHints instanceof WebDAVPackageDAVServerResultHints || this._resultHints instanceof WebDAVPackageURLResultHints) {
                        String url = (String)this._resultHints.getResultLocation();
                        InformationServiceInterface is = this.discoverInformationService();
                        if (is == null) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noInfoSvc.ex.fmt.txt", (java.lang.Object)this._storedProcessName);
                            AlertProcessingException ape = new AlertProcessingException(msg);
                            this.addExceptionToListAndSetStatus(ape);
                        } else {
                            String domain;
                            ResultHints hints;
                            if (this._resultHints instanceof WebDAVPackageDAVServerResultHints) {
                                hints = (WebDAVPackageDAVServerResultHints)this._resultHints;
                                domain = ((WebDAVPackageDAVServerResultHints)hints).getDomain(this._logger);
                            } else {
                                hints = (WebDAVPackageURLResultHints)this._resultHints;
                                domain = ((WebDAVPackageURLResultHints)hints).getDomain();
                            }
                            MetadataInterface mi = is.fetchEntityByUrl(this._userContext, url, domain);
                            if (mi instanceof PackageInterface) {
                                pi = (PackageInterface)mi;
                                canConnect = true;
                            } else {
                                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.noEntityKey.ex.fmt.txt", (java.lang.Object)url, (java.lang.Object)domain, (java.lang.Object)this._userContext.getName());
                                AlertProcessingException ape = new AlertProcessingException(msg);
                                this.addExceptionToListAndSetStatus(ape);
                            }
                        }
                    }
                }
                if (canConnect) {
                    this._alertEvent.setPackageEvent(edi.getBodyAsString(), pi.getEntityKey());
                }
            }
        }
        catch (Exception e) {
            AlertProcessingException ape = new AlertProcessingException(e);
            this.addExceptionToListAndSetStatus(ape);
        }
        this._alertEvent.updateStatusDescriptionEndTimeExceptions();
        String eventString = this._alertEvent.serialize();
        this._alert.setEventDocumentFromString(eventString);
        try {
            this._alert.update();
        }
        catch (Exception e) {
            AlertProcessingException ape = new AlertProcessingException(e);
            this.addExceptionToListAndSetStatus(ape);
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.alertUpdtd.fmt.txt", (java.lang.Object)this._alert.getName(), (java.lang.Object)this._storedProcessName, (java.lang.Object)this._eId);
            this._logger.debug(msg);
        }
    }

    private java.lang.Object createNewItem(String suggestedName, final String extension, final String metadataType, final FolderInterface folder) throws ServiceException, RemoteException {
        if (extension == null) {
            this.logMessageAndThrowIllegalStateException(RB.getStringResource("COM.incon.ex.txt"));
        }
        UniqueNameGenerator.Callback callback = new UniqueNameGenerator.Callback(){

            @Override
            public java.lang.Object isUnique(String leafName) throws Exception {
                String nameToTry = leafName + extension;
                try {
                    return folder.addNewItem(nameToTry, metadataType);
                }
                catch (ServiceException se) {
                    if (ChainedException.chainContains((Throwable)se, ItemAlreadyExistsException.class)) {
                        return null;
                    }
                    throw se;
                }
            }

            @Override
            public String metadataTypeForErrorMessage() {
                return "collection";
            }

            @Override
            public String repositoryForErrorMessage() {
                String s;
                try {
                    s = folder.getEntityKey();
                }
                catch (Exception e) {
                    s = e.getMessage();
                }
                return s;
            }
        };
        try {
            return UniqueNameGenerator.find(suggestedName, 100, true, callback, this._logger, this._eId);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, RB.getStringResource("COM.noUniq.ex.txt"));
        }
    }

    private InformationServiceInterface discoverInformationService() {
        InformationServiceInterface is;
        try {
            is = (InformationServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
        }
        catch (Throwable t) {
            is = null;
        }
        return is;
    }

    @SASScope
    private class AlertEvent
    extends Event {
        private static final String NS = "http://www.sas.com/xml/namespace/services.alerts.sp-1.1";
        private static final String NS_COLON = "http://www.sas.com/xml/namespace/services.alerts.sp-1.1:";
        private static final String NS_PREFIX_BARE = "sas-alerts-sp";
        private static final String NS_PREFIXX = "sas-alerts-sp:";
        private static final String TAG_SP_NAME = "StoredProcessName";
        private static final String TAG_STATUS = "Status";
        private static final String TAG_RESULT_TYPE = "ResultType";
        private static final String E_ROOT_NAME = "sas-alerts-sp:StoredProcessAlert";
        private static final String A_VERSION = "sas-alerts-sp:version";
        private static final String A_NAME = "sas-alerts-sp:name";
        private static final String A_START_TIME = "sas-alerts-sp:startTime";
        private static final String A_END_TIME = "sas-alerts-sp:endTime";
        private static final String E_ALERT_ENTITY_KEY = "sas-alerts-sp:AlertEntityKey";
        private static final String E_DESCRIPTION = "sas-alerts-sp:Description";
        private static final String E_SP_NAME = "sas-alerts-sp:StoredProcessName";
        private static final String E_SP_DESCRIPTION = "sas-alerts-sp:StoredProcessDescription";
        private static final String E_STATUS = "sas-alerts-sp:Status";
        private static final String E_RESULT_TYPE = "sas-alerts-sp:ResultType";
        private static final String E_SP_ENTITY_KEY = "sas-alerts-sp:StoredProcessEntityKey";
        private static final String E_SP_PATH = "sas-alerts-sp:StoredProcessPath";
        private static final String E_SP_PARAMETERS = "sas-alerts-sp:StoredProcessParameters";
        private static final String E_PARAMETER = "sas-alerts-sp:Parameter";
        private static final String E_PARM_NAME = "sas-alerts-sp:ParmName";
        private static final String E_PARM_VALUES = "sas-alerts-sp:ParmValues";
        private static final String E_PARM_VALUE = "sas-alerts-sp:ParmValue";
        private static final String E_PACKAGE = "sas-alerts-sp:Package";
        private static final String E_PACKAGE_ENTITY_KEY = "sas-alerts-sp:PackageEntityKey";
        private static final String E_EXCEPTIONS = "sas-alerts-sp:ExecutionExceptions";
        private static final String E_EXCEPTION = "sas-alerts-sp:Exception";
        Element _root;
        Text _description;
        Text _statusText;
        Element _package;
        Element _exceptions;
        Element _packageEntityKey;
        Document _document;
        Map _propertyMap;

        AlertEvent() {
            super("com.sas.services.storedprocess.ExecutionStatusEvent");
            this._propertyMap = new HashMap();
        }

        void setPackageEvent(String event, String packageURL) {
            Text text = this._document.createTextNode(packageURL);
            this._packageEntityKey.appendChild(text);
            Document doc = XMLUtil.convertStringToDocument((String)event);
            Element root = doc.getDocumentElement();
            this._package.appendChild(this._document.importNode(root, true));
        }

        void initialize(StoredProcessBaseInterface storedProcess, StoredProcessInterface smartObject) throws ParserConfigurationException, ServiceException, RemoteException {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this._document = builder.newDocument();
            this._root = this._document.createElementNS(NS, E_ROOT_NAME);
            this._document.appendChild(this._root);
            String statusStr = Integer.toString(Execution.this._status);
            String resultTypeStr = Integer.toString(Execution.this._resultType);
            this._root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sas-alerts-sp", NS);
            this._root.setAttributeNS(NS, A_VERSION, "1.0");
            this._root.setAttributeNS(NS, A_NAME, Execution.this._alert.getName());
            this._root.setAttributeNS(NS, A_START_TIME, this.getCurrentTime());
            this._root.setAttributeNS(NS, A_END_TIME, "");
            Element e = this._document.createElementNS(NS, E_ALERT_ENTITY_KEY);
            e.appendChild(this._document.createTextNode(Execution.this._alert.getEntityKey()));
            this._root.appendChild(e);
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.alertDescStrt.fmt.txt", (java.lang.Object)Execution.this._storedProcessName);
            e = this._document.createElementNS(NS, E_DESCRIPTION);
            this._description = this._document.createTextNode(msg);
            e.appendChild(this._description);
            this._root.appendChild(e);
            e = this._document.createElementNS(NS, E_SP_NAME);
            e.appendChild(this._document.createTextNode(Execution.this._storedProcessName));
            this._root.appendChild(e);
            e = this._document.createElementNS(NS, E_SP_DESCRIPTION);
            e.appendChild(this._document.createTextNode(storedProcess.getDescription()));
            this._root.appendChild(e);
            e = this._document.createElementNS(NS, E_STATUS);
            this._statusText = this._document.createTextNode(statusStr);
            e.appendChild(this._statusText);
            this._root.appendChild(e);
            e = this._document.createElementNS(NS, E_RESULT_TYPE);
            e.appendChild(this._document.createTextNode(resultTypeStr));
            this._root.appendChild(e);
            e = this._document.createElementNS(NS, E_SP_ENTITY_KEY);
            e.appendChild(this._document.createTextNode(smartObject.getEntityKey()));
            this._root.appendChild(e);
            PathUrl pathURL = smartObject.getPathUrl();
            if (pathURL != null) {
                e = this._document.createElementNS(NS, E_SP_PATH);
                e.appendChild(this._document.createTextNode(pathURL.toString()));
                this._root.appendChild(e);
            }
            e = this._document.createElementNS(NS, E_SP_PARAMETERS);
            this._root.appendChild(e);
            for (int i = 0; i < Execution.this._parmsNamesForAlert.length; ++i) {
                Element parm = this._document.createElementNS(NS, E_PARAMETER);
                e.appendChild(parm);
                Element parmName = this._document.createElementNS(NS, E_PARM_NAME);
                parmName.appendChild(this._document.createTextNode(Execution.this._parmsNamesForAlert[i]));
                parm.appendChild(parmName);
                java.lang.Object value = Execution.this._parmsValuesForAlert[i];
                if (value instanceof String && ((String)value).indexOf(31) != -1) {
                    Element parmValues = this._document.createElementNS(NS, E_PARM_VALUES);
                    parm.appendChild(parmValues);
                    String[] valueArr = Execution.this.getParameterValues((String)value);
                    int numberForThisEntry = valueArr.length;
                    for (int j = 0; j < numberForThisEntry; ++j) {
                        Element parmValue = this._document.createElementNS(NS, E_PARM_VALUE);
                        parmValue.appendChild(this._document.createTextNode(valueArr[j]));
                        parmValues.appendChild(parmValue);
                    }
                    continue;
                }
                Element parmValue = this._document.createElementNS(NS, E_PARM_VALUE);
                parmValue.appendChild(this._document.createTextNode(value.toString()));
                parm.appendChild(parmValue);
            }
            if (Execution.this._resultType == 2 || Execution.this._resultType == 4 || Execution.this._resultType == 8) {
                this._package = this._document.createElementNS(NS, E_PACKAGE);
                this._packageEntityKey = this._document.createElementNS(NS, E_PACKAGE_ENTITY_KEY);
                this._package.appendChild(this._packageEntityKey);
                this._root.appendChild(this._package);
            }
            this._exceptions = this._document.createElementNS(NS, E_EXCEPTIONS);
            this._root.appendChild(this._exceptions);
            this._document.normalize();
            this._propertyMap.put("http://www.sas.com/xml/namespace/services.alerts.sp-1.1:StoredProcessName", Execution.this._storedProcessName);
            this._propertyMap.put("http://www.sas.com/xml/namespace/services.alerts.sp-1.1:Status", statusStr);
            this._propertyMap.put("http://www.sas.com/xml/namespace/services.alerts.sp-1.1:ResultType", resultTypeStr);
            this.setProperties(this._propertyMap);
            this.setBody(this._root);
        }

        void updateStatusDescriptionEndTimeExceptions() {
            this.setExecutionStatus();
            this.setCompletionDescription();
            this.setEndTime();
            this.setProperties(this._propertyMap);
            if (Execution.this._status == 2 || Execution.this._status == 4) {
                int numberOfExceptions = Execution.this._exceptionList.size();
                for (int i = 0; i < numberOfExceptions; ++i) {
                    String s = Execution.this.formatExecutionException((ExecutionException)Execution.this._exceptionList.get(i));
                    Element exception = this._document.createElementNS(NS, E_EXCEPTION);
                    Text text = this._document.createTextNode(s);
                    exception.appendChild(text);
                    this._exceptions.appendChild(exception);
                }
            }
        }

        private void setExecutionStatus() {
            this._statusText.setData(Integer.toString(Execution.this._status));
            this._propertyMap.put("http://www.sas.com/xml/namespace/services.alerts.sp-1.1:Status", Integer.toString(Execution.this._status));
        }

        private void setCompletionDescription() {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"E.alertDescEnd.fmt.txt", (java.lang.Object)Execution.this._storedProcessName, (java.lang.Object)this.getCurrentTime());
            this._description.setData(msg);
        }

        private void setEndTime() {
            this._root.setAttributeNS(NS, A_END_TIME, this.getCurrentTime());
        }

        private String getCurrentTime() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            simpleDateFormat.applyPattern("ddMMMyyyy:HH:mm:ss");
            Date creationDate = new Date();
            return simpleDateFormat.format(creationDate);
        }
    }
}

