/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.services.util.XMLUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.w3c.dom.Node;

@SASScope
class Event {
    String _eventName = null;
    double _version = 1.0;
    String _responseType = "none";
    HashMap _properties = new HashMap();
    Node _body = null;
    static final String NS_URI = "http://www.sas.com/xml/namespace/services.events-1.1";
    static final String NS_PREFIX = "sas-event";
    static final String NS_PREFIX_COLON = "sas-event:";

    Event(String eventName) {
        this._eventName = eventName;
    }

    final void setProperties(Map map) {
        this._properties.putAll(map);
    }

    final void setBody(Node body) {
        this._body = body;
    }

    String serialize() {
        StringBuffer buf = new StringBuffer();
        if (this._eventName != null) {
            buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            buf.append("<sas-event:Event xmlns:sas-event=\"http://www.sas.com/xml/namespace/services.events-1.1\" sas-event:name=\"" + this._eventName + "\">");
            buf.append("<sas-event:Header>");
            buf.append("<sas-event:Version>" + String.valueOf(this._version) + "</" + NS_PREFIX_COLON + "Version>");
            String gmt = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            TimeZone utc = TimeZone.getTimeZone("UTC");
            formatter.setTimeZone(utc);
            gmt = formatter.format(new Date());
            buf.append("<sas-event:SentAt>" + gmt + "</" + NS_PREFIX_COLON + "SentAt>");
            buf.append("<sas-event:Response sas-event:type=\"" + this._responseType + "\"/>");
            if (!this._properties.isEmpty()) {
                buf.append("<sas-event:Properties>");
                Set keys = this._properties.keySet();
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    Object value;
                    String strKey = null;
                    String strPropValue = null;
                    Object key = iter.next();
                    if (!(key instanceof String)) continue;
                    strKey = (String)key;
                    String strPropName = "";
                    String strNS = "";
                    int index = strKey.lastIndexOf(":");
                    if (index == -1) {
                        strPropName = strKey;
                    } else {
                        strNS = strKey.substring(0, index);
                        strPropName = strKey.substring(index + 1);
                    }
                    if (!((value = this._properties.get(key)) instanceof String)) continue;
                    strPropValue = (String)value;
                    buf.append('<' + strPropName);
                    if (strNS.length() > 0) {
                        buf.append(" xmlns=\"" + strNS + '\"');
                    }
                    buf.append(">");
                    buf.append(strPropValue);
                    buf.append("</" + strPropName + '>');
                }
                buf.append("</sas-event:Properties>");
            }
            buf.append("</sas-event:Header>");
            if (this._body != null) {
                buf.append("<sas-event:Body>");
                String body = "";
                try {
                    String result = XMLUtil.convertNodeToString((Node)this._body, (boolean)true);
                    if (result != null) {
                        body = result;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                buf.append(body);
                buf.append("</sas-event:Body>");
            }
            buf.append("</sas-event:Event>");
        }
        return buf.toString();
    }
}

