/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.storedprocess.MetadataConstants;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;

@SASScope
class ConnectionMaker {
    private final String _privilegedUser;
    private final UserContextInterface _userContext;
    private final boolean _isNineTwo;
    private final LogicalServerInterface _logicalServer;
    private final ServerContext _serverContext;
    private final StoredProcessInterface.LogicalServerType _logicalServerType;
    private final RepositoryInterface _ri;

    ConnectionMaker(String privilegedUser, UserContextInterface userContext, LogicalServerInterface logicalServer) {
        this._privilegedUser = privilegedUser;
        this._userContext = userContext;
        this._isNineTwo = true;
        this._logicalServer = logicalServer;
        this._serverContext = null;
        this._logicalServerType = null;
        this._ri = null;
    }

    ConnectionMaker(String privilegedUser, UserContextInterface userContext, ServerContext serverContext, StoredProcessInterface.LogicalServerType logicalServerType, RepositoryInterface ri) {
        this._privilegedUser = privilegedUser;
        this._userContext = userContext;
        this._isNineTwo = false;
        this._logicalServer = null;
        this._serverContext = serverContext;
        this._logicalServerType = logicalServerType;
        this._ri = ri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ConnectionInterface makeConnection() throws ConnectionFactoryException, MdException, ServiceException, RemoteException {
        boolean needWorkspace;
        LogicalServerInterface lsi;
        LogicalServer ls;
        block10: {
            block11: {
                if (this._isNineTwo) {
                    return this.doMakeConnection(this._logicalServer);
                }
                ls = null;
                lsi = null;
                if (this._logicalServerType != StoredProcessInterface.LogicalServerType.ANY) break block11;
                ls = MetadataConstants.getLogicalServerFromServerContext(false, this._serverContext);
                if (ls == null) {
                    needWorkspace = true;
                    break block10;
                } else {
                    try {
                        lsi = (LogicalServerInterface)this._ri.factoryProcess((Object)ls);
                    }
                    catch (ServiceException se) {
                        throw new ServiceException(Message.format((String)RB.getStringResource("CM.noLSFromFacPro1.ex.fmt.txt"), (Object)ls, (Object)se.getMessage()));
                    }
                    if (lsi == null) {
                        throw new ServiceException(Message.format((String)RB.getStringResource("CM.noLSFromFacPro.ex.fmt.txt"), (Object)ls));
                    }
                    try {
                        return this.doMakeConnection(lsi);
                    }
                    catch (ConnectionFactoryException cfe) {
                        needWorkspace = true;
                        break block10;
                    }
                }
            }
            needWorkspace = this._logicalServerType == StoredProcessInterface.LogicalServerType.WORKSPACE;
        }
        ls = MetadataConstants.getLogicalServerFromServerContext(needWorkspace, this._serverContext);
        if (ls == null) {
            throw new ServiceException(Message.format((String)RB.getStringResource("CM.noLSFromSC.ex.fmt.txt"), (Object)ls));
        }
        lsi = (LogicalServerInterface)this._ri.factoryProcess((Object)ls);
        if (lsi == null) {
            throw new ServiceException(Message.format((String)RB.getStringResource("CM.noLSFromFacPro.ex.fmt.txt"), (Object)ls));
        }
        return this.doMakeConnection(lsi);
    }

    private ConnectionInterface doMakeConnection(LogicalServerInterface logicalServer) throws ConnectionFactoryException {
        PlatformConnectionFactoryConfiguration cxfConfig = this._privilegedUser != null && this._privilegedUser.length() > 0 ? new PlatformConnectionFactoryConfiguration(logicalServer, this._privilegedUser) : new PlatformConnectionFactoryConfiguration(logicalServer);
        PlatformConnectionFactoryInterface connectionFactory = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
        return connectionFactory.getConnection(this._userContext);
    }
}

