/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.services.storedprocess.RB;
import com.sas.services.storedprocess.ResultTypeDeterminer;
import com.sas.text.Message;
import java.util.HashMap;
import java.util.Map;

@SASScope
class CaseNeutralLookup {
    Map<String, String> _nameValues;
    Map<String, String> _nameMap;

    CaseNeutralLookup(Map<String, String> nameValues) throws ResultTypeDeterminer.InconsistencyException {
        this._nameValues = nameValues;
        this._nameMap = new HashMap<String, String>();
        for (String actualKey : nameValues.keySet()) {
            if (actualKey == null) continue;
            String lowercaseName = actualKey.toLowerCase();
            if (this._nameMap.containsKey(lowercaseName)) {
                throw new ResultTypeDeterminer.InconsistencyException(Message.format((String)RB.getStringResource("RTD.multplParm.ex.fmt.txt"), (Object)actualKey));
            }
            this._nameMap.put(lowercaseName, actualKey);
        }
    }

    String get(String name) {
        String lowerCaseName = name.toLowerCase();
        String actualKey = this._nameMap.get(lowerCaseName);
        if (actualKey == null) {
            return null;
        }
        return this._nameValues.get(actualKey);
    }

    void put(String actualKey, String value) {
        String lowercaseName = actualKey.toLowerCase();
        String oldActualKey = this._nameMap.get(lowercaseName);
        if (oldActualKey != null) {
            this._nameValues.put(oldActualKey, value);
        } else {
            this._nameMap.put(lowercaseName, actualKey);
            this._nameValues.put(actualKey, value);
        }
    }
}

