/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IOptionService;
import com.sas.iom.SAS.IOptionServicePackage.SetErrorSeqHolder;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.orb.DelegateRemote;
import com.sas.services.connection.AuthServer;
import com.sas.services.connection.BadLocaleException;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionEnvelope;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryEvent;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.ConnectionImpl;
import com.sas.services.connection.ConnectionImpl2;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ConnectionRequest;
import com.sas.services.connection.Credential;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.PuddleEnvelope;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;

@SASScope
public final class PoolingKernel
extends ConnectionFactoryKernel {
    private static final String[] _optionNameArr = new String[]{"LOCALE"};
    private PuddleEnvelope[] envs = null;
    private AuthServer authServer = null;
    private List domains = new ArrayList();

    public PoolingKernel(ConnectionFactoryRequest cxfReq, PuddleEnvelope[] envs, AuthServer authServer) {
        super(cxfReq);
        int i;
        if (envs == null || envs.length == 0) {
            throw new IllegalArgumentException("\"envs\" cannot be null or empty.");
        }
        for (i = 0; i < envs.length; ++i) {
            PuddleEnvelope env = envs[i];
            if (env == null) {
                throw new IllegalArgumentException("Element " + i + " of \"envs\" cannot be null.");
            }
            Puddle puddle = env.getPuddle();
            int minSize = puddle.getMinSize();
            Cluster[] clusters = puddle.getClusterArray();
            int globalMaxClients = 0;
            for (int j = 0; j < clusters.length; ++j) {
                Cluster cluster = clusters[j];
                int maxClients = cluster.getMaxClients();
                globalMaxClients += maxClients;
            }
            if (globalMaxClients < minSize) {
                throw new IllegalArgumentException("\"minSize\" of puddle " + i + " must be less than the sum of \"maxClients\" over all clusters in the puddle.");
            }
            env.setLock(this);
            env.setPuddleIndex(i);
        }
        if (authServer == null) {
            throw new IllegalArgumentException("\"authServer\" cannot be null.");
        }
        this.domains.addAll(authServer.getDomains());
        this.envs = envs;
        this.authServer = authServer;
        for (i = 0; i < envs.length; ++i) {
            envs[i].init();
        }
        if (cxfReq.isLoggableFINE()) {
            Puddle[] puddleArr = new Puddle[envs.length];
            for (int i2 = 0; i2 < envs.length; ++i2) {
                PuddleEnvelope env = envs[i2];
                puddleArr[i2] = env.getPuddle();
            }
            String configStr = ConnectionFactoryUtil.puddleArrayToString(puddleArr);
            cxfReq.logFINE("resolved configuration: " + configStr);
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        ConnectionFactoryRequest cxfReq = this.getRequest();
        cxfReq.logFINE("commencing factory destruction");
        for (int i = 0; i < this.envs.length; ++i) {
            this.envs[i].destroy();
        }
        this.destroyKernel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConnectionInterface doGetConnection(ConnectionRequest cxReq) throws ConnectionFactoryException {
        ObjectImpl obj;
        ConnectionEnvelope cxEnv;
        int clientNumber;
        block26: {
            Credential userCred = cxReq.getCredential();
            int[] authPuddles = this.authServer.authorizeUser(userCred);
            clientNumber = 0;
            cxEnv = null;
            PoolingKernel poolingKernel = this;
            synchronized (poolingKernel) {
                if (this.isShutdown() || this.isDestroyed()) {
                    throw new IllegalStateException("\"getConnection()\" cannot be called on a factory after \"shutdown()\" or \"destroy()\" has been called.");
                }
                int puddleIndex = this.authServer.findBestPuddle(authPuddles);
                if (cxReq.isLoggableFINE()) {
                    String msg = "connection request routed to puddle " + puddleIndex;
                    cxReq.logFINE(msg);
                }
                PuddleEnvelope pdEnv = this.envs[puddleIndex];
                try {
                    cxEnv = pdEnv.getConnection(cxReq);
                    cxEnv.setPuddleIndex(puddleIndex);
                }
                catch (FatalConnectionFactoryException e) {
                    ConnectionFactoryEvent event = null;
                    event = new ConnectionFactoryEvent(2, e);
                    this.shutdownKernel(event);
                    throw e;
                }
                clientNumber = cxEnv.getNextClientNumber();
            }
            obj = (ObjectImpl)cxEnv.getUserObject();
            Object rootObject = cxEnv.getRootObject();
            if (obj == null || obj == rootObject) {
                try {
                    String lang;
                    IWorkspace rootWorkspace = IWorkspaceHelper.narrow(rootObject);
                    if (rootWorkspace != rootObject) {
                        cxEnv.setRootObject(rootWorkspace);
                    }
                    IWorkspace userWorkspace = rootWorkspace.GetNewWorkspace();
                    cxEnv.setUserObject(userWorkspace);
                    Locale rootLocale = this.getRootLocale(cxEnv);
                    Locale credLocale = userCred.getLocale();
                    if (credLocale == null || credLocale.equals(rootLocale)) break block26;
                    String credLocaleS = credLocale.toString();
                    if (cxReq.isLoggableFINE()) {
                        cxReq.logFINE("setting locale for workspace to " + credLocaleS);
                    }
                    LongSeqHolder errIndexArrHolder = new LongSeqHolder();
                    SetErrorSeqHolder setErrArrHolder = new SetErrorSeqHolder();
                    StringSeqHolder errMsgArrHolder = new StringSeqHolder();
                    IUtilities iUtil = userWorkspace.Utilities();
                    IOptionService iOpts = iUtil.OptionService();
                    String[] optionValArr = new String[]{credLocaleS};
                    iOpts.SetOptions(_optionNameArr, optionValArr, errIndexArrHolder, setErrArrHolder, errMsgArrHolder);
                    if (errIndexArrHolder.value == null || errIndexArrHolder.value.length <= 0) break block26;
                    int errIndex = errIndexArrHolder.value[0];
                    String msg = errMsgArrHolder.value[errIndex];
                    if (setErrArrHolder.value[errIndex].value() == 0) {
                        if (cxReq.isLoggableWARNING()) {
                            String m = "setting locale for workspace to " + credLocaleS + " produced this message: " + msg;
                            cxReq.logWARNING(m);
                        }
                        break block26;
                    }
                    if (cxReq.isLoggableFINE()) {
                        cxReq.logFINE("unable to set locale: " + msg);
                    }
                    if ((lang = credLocale.getDisplayLanguage()) == null) break block26;
                    if (cxReq.isLoggableFINE()) {
                        cxReq.logFINE("setting locale for workspace to: " + lang);
                    }
                    LongSeqHolder errIndexArrHolder2 = new LongSeqHolder();
                    SetErrorSeqHolder setErrArrHolder2 = new SetErrorSeqHolder();
                    StringSeqHolder errMsgArrHolder2 = new StringSeqHolder();
                    String[] optionValArr2 = new String[]{lang};
                    iOpts.SetOptions(_optionNameArr, optionValArr2, errIndexArrHolder2, setErrArrHolder2, errMsgArrHolder2);
                    if (errIndexArrHolder2.value == null || errIndexArrHolder2.value.length <= 0) break block26;
                    int errIndex2 = errIndexArrHolder2.value[0];
                    String msg2 = errMsgArrHolder2.value[errIndex2];
                    if (setErrArrHolder2.value[errIndex2].value() == 0) {
                        if (cxReq.isLoggableWARNING()) {
                            String m = "setting locale for workspace to " + lang + " produced this message: " + msg2;
                            cxReq.logWARNING(m);
                        }
                        break block26;
                    }
                    if (cxReq.isLoggableFINE()) {
                        cxReq.logFINE("unable to set locale: " + msg2);
                    }
                    throw new BadLocaleException(msg);
                }
                catch (NO_PERMISSION np) {
                    cxEnv.setBogus(false, np);
                    this.reactivateConnection(cxEnv, clientNumber, 3);
                    ConnectionInterface cx = this.doGetConnection(cxReq);
                    return cx;
                }
                catch (BadLocaleException le) {
                    this.reactivateConnection(cxEnv, clientNumber, 4);
                    throw le;
                }
                catch (Exception e) {
                    this.reactivateConnection(cxEnv, clientNumber, 2);
                    ConnectionInterface cx = this.doGetConnection(cxReq);
                    return cx;
                }
            }
        }
        ConnectionImpl cx = null;
        Delegate delegate = obj._get_delegate();
        DelegateRemote delegateRemote = null;
        try {
            delegateRemote = (DelegateRemote)delegate;
            String normUserName = delegateRemote.getNormUserName();
            String normDomain = delegateRemote.getNormDomain();
            cx = new ConnectionImpl2(cxEnv, this, clientNumber, normUserName, normDomain);
        }
        catch (ClassCastException classCastException) {
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            // empty catch block
        }
        if (cx == null) {
            cx = new ConnectionImpl(cxEnv, this, clientNumber);
        }
        if (delegateRemote != null) {
            delegateRemote.addReference(cx);
        }
        return cx;
    }

    @Override
    protected ConnectionFactoryAdminInterface getAdminInterface(Credential adminLogin) throws ConnectionFactoryException {
        this.authServer.authorizeAdmin(adminLogin);
        return this;
    }

    @Override
    protected List getDomains() {
        return ConnectionFactoryUtil.copyList(this.domains);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reactivateConnection(ConnectionEnvelope cxEnv, int clientNumber, int reason) {
        Object userObject = cxEnv.getUserObject();
        if (userObject != null && userObject != cxEnv.getRootObject()) {
            cxEnv.setUserObject(null);
            IWorkspace userWorkspace = IWorkspaceHelper.narrow(userObject);
            try {
                userWorkspace.Close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PoolingKernel poolingKernel = this;
        synchronized (poolingKernel) {
            if (this.isDestroyed()) {
                return;
            }
            PuddleEnvelope env = cxEnv.getPuddleEnvelope();
            env.reactivateConnection(cxEnv, reason);
            ObjectImpl root = (ObjectImpl)cxEnv.getRootObject();
            Delegate del = root._get_delegate();
            if (del instanceof DelegateRemote) {
                DelegateRemote delegate = (DelegateRemote)del;
                delegate.removeAllReferences();
            }
            if (this.isShutdown() && !this.isDestroyed()) {
                int totalClients = 0;
                for (int i = 0; i < this.envs.length; ++i) {
                    totalClients += this.envs[i].getClients();
                }
                if (totalClients == 0) {
                    this.destroy();
                }
            }
        }
    }

    @Override
    protected synchronized void shutdownKernel(ConnectionFactoryEvent event) {
        ConnectionFactoryRequest cxfReq = this.getRequest();
        if (event.getType() == 0) {
            cxfReq.logFINE("factory shutdown commencing");
        } else {
            cxfReq.logFINE("fatal error detected; factory shutting down");
        }
        for (int i = 0; i < this.envs.length; ++i) {
            this.envs[i].shutdown();
        }
        super.shutdownKernel(event);
        if (!this.isDestroyed()) {
            int totalClients = 0;
            for (int i = 0; i < this.envs.length; ++i) {
                totalClients += this.envs[i].getClients();
            }
            if (totalClients == 0) {
                this.destroy();
            }
        }
    }

    @Override
    protected void removeUserFromCache(Credential user) {
        this.authServer.removeUserFromCache(user);
    }

    private Locale getRootLocale(ConnectionEnvelope cxEnv) {
        PuddleEnvelope pdEnv = cxEnv.getPuddleEnvelope();
        Puddle pd = pdEnv.getPuddle();
        Credential pdCred = pd.getServerCredential();
        Locale pdLocale = pdCred.getLocale();
        if (pdLocale != null) {
            return pdLocale;
        }
        Locale loc = Locale.getDefault();
        return loc;
    }
}

