/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SASURI;
import com.sas.net.crypto.SealedString;
import com.sas.services.connection.AuthenticationTicketCredential;
import com.sas.services.connection.Credential;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.TCPIPServer;
import com.sas.services.connection.TrustedPeerCredential;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class BridgeServer
extends TCPIPServer {
    public static final String ENCRYPTION_POLICY_REQUIRED = "required";
    public static final String ENCRYPTION_POLICY_OPTIONAL = "optional";
    public static final String ENCRYPTION_POLICY_NONE = "none";
    public static final String ENCRYPTION_CONTENT_ALL = "all";
    public static final String ENCRYPTION_CONTENT_AUTHENTICATION = "authentication";
    public static final String ENCRYPTION_ALGORITHM_SASPROPRIETARY = "sasproprietary";
    public static final String ENCRYPTION_ALGORITHM_RC2 = "rc2";
    public static final String ENCRYPTION_ALGORITHM_RC4 = "rc4";
    public static final String ENCRYPTION_ALGORITHM_DES = "des";
    public static final String ENCRYPTION_ALGORITHM_TRIPLEDES = "tripledes";
    public static final String ENCRYPTION_ALGORITHM_AES = "aes";
    public static final byte CURRENT_MAJOR_PROTOCOL_VERSION = 2;
    public static final byte CURRENT_MINOR_PROTOCOL_VERSION = 0;
    private static final long serialVersionUID = 7325217805525243858L;
    private static final String[] encryptionPolicyEnum = new String[]{"none", "optional", "required"};
    private static final String[] encryptionContentEnum = new String[]{"all", "authentication"};
    private static final Logger _logger = LogManager.getLogger(BridgeServer.class);
    private String _encryptionPolicy;
    private String _encryptionContent;
    private String _origEncryptionAlgorithms;
    private String _normEncryptionAlgorithms;
    private Byte _major;
    private Byte _minor;
    private String _serverName;
    private String _sasVersionID;

    public BridgeServer(String classID, String host, int port) {
        super(classID, host, port);
        this.setEncryptionPolicy(ENCRYPTION_POLICY_REQUIRED);
        this.setEncryptionContent(ENCRYPTION_CONTENT_AUTHENTICATION);
        this.setAuthService("Host");
    }

    public synchronized void setEncryptionPolicy(String encryptionPolicy) {
        BridgeServer.validateEncryptionPolicy(encryptionPolicy);
        this._encryptionPolicy = encryptionPolicy;
    }

    public synchronized String getEncryptionPolicy() {
        return this._encryptionPolicy;
    }

    public synchronized void setEncryptionContent(String encryptionContent) {
        BridgeServer.validateEncryptionContent(encryptionContent);
        this._encryptionContent = encryptionContent;
    }

    public synchronized String getEncryptionContent() {
        return this._encryptionContent;
    }

    public synchronized void setEncryptionAlgorithms(String encryptionAlgorithms) {
        this._origEncryptionAlgorithms = encryptionAlgorithms;
        this._normEncryptionAlgorithms = BridgeServer.normalizeEncryptionAlgorithms(encryptionAlgorithms);
    }

    public synchronized String getEncryptionAlgorithms() {
        return this._origEncryptionAlgorithms;
    }

    public synchronized String getNormalizedEncryptionAlgorithms() {
        return this._normEncryptionAlgorithms;
    }

    public synchronized Byte getMajor() {
        return this._major;
    }

    public synchronized void setMajor(Byte major) {
        this._major = major;
    }

    public synchronized Byte getMinor() {
        return this._minor;
    }

    public synchronized void setMinor(Byte minor) {
        this._minor = minor;
    }

    public synchronized String getServerName() {
        return this._serverName;
    }

    public synchronized void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public synchronized String getSASVersionID() {
        return this._sasVersionID;
    }

    public synchronized void setSASVersionID(String sasVersionID) {
        this._sasVersionID = sasVersionID;
    }

    @Override
    public synchronized String setOption(String name, String value) {
        String previousValue = null;
        if ("encryptionpolicy".equals(name)) {
            previousValue = this.getEncryptionPolicy();
            this.setEncryptionPolicy(value);
        } else if ("encryptioncontent".equals(name)) {
            previousValue = this.getEncryptionContent();
            this.setEncryptionContent(value);
        } else if ("encryptionalgorithms".equals(name)) {
            previousValue = this.getEncryptionAlgorithms();
            this.setEncryptionAlgorithms(value);
        } else if ("major".equals(name)) {
            Byte previousMajor = this.getMajor();
            previousValue = previousMajor != null ? Byte.toString(previousMajor) : null;
            this.setMajor(Byte.parseByte(value));
        } else if ("minor".equals(name)) {
            Byte previousMinor = this.getMinor();
            previousValue = previousMinor != null ? Byte.toString(previousMinor) : null;
            this.setMinor(Byte.parseByte(value));
        } else if ("svid".equals(name)) {
            previousValue = this.getSASVersionID();
            this.setSASVersionID(value);
        } else if ("servername".equals(name)) {
            previousValue = this.getServerName();
            this.setServerName(value);
        } else {
            previousValue = super.setOption(name, value);
        }
        return previousValue;
    }

    @Override
    public synchronized String getOption(String name) {
        Byte minor;
        Byte major;
        String value = null;
        value = "encryptionpolicy".equals(name) ? this.getEncryptionPolicy() : ("encryptioncontent".equals(name) ? this.getEncryptionContent() : ("encryptionalgorithms".equals(name) ? this.getEncryptionAlgorithms() : ("major".equals(name) ? ((major = this.getMajor()) != null ? Byte.toString(major) : null) : ("minor".equals(name) ? ((minor = this.getMinor()) != null ? Byte.toString(minor) : null) : ("svid".equals(name) ? this.getSASVersionID() : ("servername".equals(name) ? this.getServerName() : super.getOption(name)))))));
        return value;
    }

    @Override
    public synchronized String removeOption(String name) {
        return null;
    }

    @Override
    @SASScope
    public synchronized SASURI toURI(Credential credential, String cxID) {
        String authService;
        TenantIdentifier tenant;
        String sasVersionID;
        String srvName;
        Byte pvMinor;
        Byte pvMajor;
        String cryptoPolicy;
        String cryptoAlgs;
        HashMap<String, Object> attrMap = new HashMap<String, Object>(16);
        Map optionMap = this.getOptionMap();
        if (optionMap != null) {
            attrMap.putAll(optionMap);
        }
        String classID = this.getClassID();
        attrMap.put("classfactory", classID);
        String host = this.getHost();
        attrMap.put("host", host);
        int port = this.getPort();
        Integer portI = new Integer(port);
        attrMap.put("port", portI);
        String domain = this.getDomain();
        attrMap.put("domain", domain);
        if (credential != null) {
            if (credential instanceof PasswordCredential) {
                SealedString sealedPassword;
                PasswordCredential login = (PasswordCredential)credential;
                String userName = login.getUserName();
                if (userName != null) {
                    attrMap.put("username", userName);
                }
                if ((sealedPassword = login.getPasswordAsSealedString()) != null) {
                    attrMap.put("sealedpassword", sealedPassword);
                }
            } else if (credential instanceof TrustedPeerCredential) {
                attrMap.put("trustedsas", Boolean.TRUE);
            } else if (credential instanceof SecurityPackageCredential) {
                String spn;
                String securityPackageList;
                String securityPackage = this.getNormalizedSecurityPackage();
                if (securityPackage != null) {
                    attrMap.put("securitypackage", securityPackage);
                }
                if ((securityPackageList = this.getNormalizedSecurityPackageList()) != null) {
                    attrMap.put("securitypackagelist", securityPackageList);
                }
                if ((spn = this.getSPN()) != null) {
                    attrMap.put("spn", spn);
                }
            } else if (credential instanceof AuthenticationTicketCredential) {
                attrMap.put("ticketauthentication", Boolean.TRUE);
            } else {
                String msg = this.getClass().getName() + " does not support authorization for credential type " + credential.getClass().getName() + ".";
                throw new IllegalArgumentException(msg);
            }
            Locale locale = credential.getLocale();
            if (locale != null) {
                attrMap.put("locale", locale);
            }
        }
        if (cxID != null) {
            attrMap.put("connectionid", cxID);
        }
        if ((cryptoAlgs = this.getNormalizedEncryptionAlgorithms()) != null) {
            attrMap.put("encryptionalgorithms", cryptoAlgs);
        }
        if (!ENCRYPTION_POLICY_NONE.equals(cryptoPolicy = this.getEncryptionPolicy())) {
            attrMap.put("encryptionpolicy", cryptoPolicy);
            String cryptoContent = this.getEncryptionContent();
            attrMap.put("encryptioncontent", cryptoContent);
        }
        if ((pvMajor = this.getMajor()) != null) {
            attrMap.put("major", pvMajor);
        }
        if ((pvMinor = this.getMinor()) != null) {
            attrMap.put("minor", pvMinor);
        }
        if ((srvName = this.getServerName()) != null) {
            attrMap.put("servername", srvName);
        }
        if ((sasVersionID = this.getSASVersionID()) != null) {
            attrMap.put("svid", sasVersionID);
        }
        if (!optionMap.containsKey("applicationname")) {
            String applicationName = ClientApplicationNameHolder.getName();
            if (applicationName == null) {
                String version = BridgeServer.class.getPackage().getSpecificationVersion();
                applicationName = version != null ? "ConnectionService " + version : "ConnectionService (unknown)";
            }
            attrMap.put("applicationname", applicationName);
        }
        if (!optionMap.containsKey("tenantid") && (tenant = TenantHolder.get()) != null && !tenant.equals(TenantIdentifier._default)) {
            String tenantMoniker = tenant.getMoniker();
            attrMap.put("tenantid", tenantMoniker);
        }
        String proxyList = null;
        try {
            proxyList = System.getenv("SAS_IOM_PROXYLIST");
        }
        catch (SecurityException tenantMoniker) {
            // empty catch block
        }
        if (proxyList != null) {
            String oldProxyList = (String)attrMap.get("proxylist");
            if (oldProxyList != null) {
                String msg;
                if (_logger.isDebugEnabled()) {
                    msg = "merging SAS_IOM_PROXYLIST value " + proxyList + " with existing proxy list value " + oldProxyList;
                    if (cxID != null) {
                        msg = cxID + " " + msg;
                    }
                    _logger.debug(msg);
                }
                proxyList = BridgeServer.mergeProxyLists(proxyList, oldProxyList);
                if (_logger.isDebugEnabled()) {
                    msg = "merged proxy list is " + proxyList;
                    if (cxID != null) {
                        msg = cxID + " " + msg;
                    }
                    _logger.debug(msg);
                }
            }
            attrMap.put("proxylist", proxyList);
        }
        if ((authService = this.getAuthService()) != null) {
            attrMap.put("authservice", authService);
        }
        SASURI uri = new SASURI("BRIDGE", attrMap);
        return uri;
    }

    @Override
    public synchronized boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        BridgeServer thatBridgeServer = (BridgeServer)that;
        String thatEncryptionPolicy = thatBridgeServer.getEncryptionPolicy();
        if (this._encryptionPolicy != null ? !this._encryptionPolicy.equals(thatEncryptionPolicy) : thatEncryptionPolicy != null) {
            return false;
        }
        String thatEncryptionContent = thatBridgeServer.getEncryptionContent();
        if (this._encryptionContent != null ? !this._encryptionContent.equals(thatEncryptionContent) : thatEncryptionContent != null) {
            return false;
        }
        String thoseNormEncryptionAlgorithms = thatBridgeServer.getNormalizedEncryptionAlgorithms();
        if (this._normEncryptionAlgorithms == null ? thoseNormEncryptionAlgorithms != null : !this._normEncryptionAlgorithms.equals(thoseNormEncryptionAlgorithms)) {
            return false;
        }
        Byte thatMajor = thatBridgeServer.getMajor();
        if (this._major != null ? !this._major.equals(thatMajor) : thatMajor != null) {
            return false;
        }
        Byte thatMinor = thatBridgeServer.getMinor();
        if (this._minor != null ? !this._minor.equals(thatMinor) : thatMinor != null) {
            return false;
        }
        String thatServerName = thatBridgeServer.getServerName();
        if (this._serverName == null ? thatServerName != null : !this._serverName.equals(thatServerName)) {
            return false;
        }
        String thatSASVersionID = thatBridgeServer.getSASVersionID();
        return !(this._sasVersionID != null ? !this._sasVersionID.equals(thatSASVersionID) : thatSASVersionID != null);
    }

    @Override
    public synchronized int hashCode() {
        int hc = super.hashCode();
        if (this._encryptionPolicy != null) {
            hc ^= this._encryptionPolicy.hashCode();
        }
        if (this._encryptionContent != null) {
            hc ^= this._encryptionContent.hashCode();
        }
        if (this._normEncryptionAlgorithms != null) {
            hc ^= this._normEncryptionAlgorithms.hashCode();
        }
        if (this._major != null) {
            hc ^= this._major.hashCode();
        }
        if (this._minor != null) {
            hc ^= this._minor.hashCode();
        }
        if (this._serverName != null) {
            hc ^= this._serverName.hashCode();
        }
        if (this._sasVersionID != null) {
            hc ^= this._sasVersionID.hashCode();
        }
        return hc;
    }

    public static String normalizeEncryptionAlgorithms(String encryptionAlgorithms) {
        if (encryptionAlgorithms == null) {
            return null;
        }
        String result = (String)SASURI.normalizeAttribute("encryptionalgorithms", encryptionAlgorithms);
        return result;
    }

    public static void validateEncryptionPolicy(String encryptionPolicy) {
        String name = "encryptionPolicy";
        BridgeServer.enumArgumentCheck(name, encryptionPolicy, encryptionPolicyEnum, true);
    }

    public static void validateEncryptionContent(String encryptionContent) {
        String name = "encryptionContent";
        BridgeServer.enumArgumentCheck(name, encryptionContent, encryptionContentEnum, true);
    }

    @SASScope
    protected static BridgeServer bridgeServerFromURI(SASURI uri) {
        String classID = uri.getClassFactory();
        if (classID == null) {
            classID = "440196d4-90f0-11d0-9f41-00a024bb830c";
        }
        String host = uri.getHost();
        int port = uri.getPort();
        BridgeServer server = new BridgeServer(classID, host, port);
        Map attrMap = uri.getSecureAttributesForScheme("BRIDGE");
        Set entrySet = attrMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            String val = value != null ? value.toString() : null;
            server.setOption(name, val);
        }
        return server;
    }

    protected static String mergeProxyLists(String list1, String list2) {
        int i;
        String[] arr1 = list1.split(";");
        int arr1L = arr1.length;
        String[] arr2 = list2.split(";");
        int arr2L = arr2.length;
        int firstElementFromArray2 = BridgeServer.countOverlappingElements(arr1, arr2);
        int mergedBufL = list1.length() + list2.length() + SASURI.semiL;
        StringBuffer mergedBuf = new StringBuffer(mergedBufL);
        for (i = 0; i < arr1L; ++i) {
            if (i > 0) {
                mergedBuf.append(";");
            }
            mergedBuf.append(arr1[i]);
        }
        for (i = firstElementFromArray2; i < arr2L; ++i) {
            mergedBuf.append(";");
            mergedBuf.append(arr2[i]);
        }
        return mergedBuf.toString();
    }

    protected static int countOverlappingElements(String[] arr1, String[] arr2) {
        int arr1L = arr1.length;
        int arr2L = arr2.length;
        URL[] urlArr1 = BridgeServer.createUrlArray(arr1);
        URL[] urlArr2 = BridgeServer.createUrlArray(arr2);
        int window = Math.min(arr1L, arr2L);
        boolean matched = false;
        block0: do {
            matched = true;
            for (int i = 0; i < window; ++i) {
                String addr1 = arr1[arr1L - window + i].toLowerCase(Locale.US);
                String addr2 = arr2[i].toLowerCase(Locale.US);
                URL url1 = urlArr1[arr1L - window + i];
                URL url2 = urlArr2[i];
                if (addr1.equals(addr2) || BridgeServer.urlsEqual(url1, url2)) continue;
                matched = false;
                --window;
                continue block0;
            }
        } while (window > 0 && !matched);
        return window;
    }

    protected static URL[] createUrlArray(String[] addrArr) {
        URL[] urlArr = new URL[addrArr.length];
        for (int i = 0; i < addrArr.length; ++i) {
            try {
                urlArr[i] = new URL(addrArr[i]);
                continue;
            }
            catch (MalformedURLException e) {
                _logger.warn("malformed proxy URL " + addrArr[i], (Throwable)e);
            }
        }
        return urlArr;
    }

    protected static boolean urlsEqual(URL url1, URL url2) {
        return url1 != null && url2 != null && url1.equals(url2);
    }

    @SASScope
    private static class ClientApplicationNameHolder {
        private static final String _className = "com.sas.framework.commons.holders.ClientApplicationNameHolder";
        private static final String _mthName = "getFullApplicationName";
        private static Method _getMth;

        private ClientApplicationNameHolder() {
        }

        private static String getName() {
            String name = null;
            if (_getMth != null) {
                try {
                    name = (String)_getMth.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException iae) {
                    String msg = "could not access getFullApplicationName";
                    _logger.warn(msg, (Throwable)iae);
                }
                catch (InvocationTargetException ite) {
                    String msg = "getFullApplicationName method threw exception";
                    Throwable t = ite.getCause();
                    _logger.warn(msg, t);
                }
            }
            return name;
        }

        static {
            try {
                Class<?> clazz = Class.forName(_className);
                _getMth = clazz.getMethod(_mthName, new Class[0]);
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (NoSuchMethodException nsme) {
                String msg = "getFullApplicationName method not found on com.sas.framework.commons.holders.ClientApplicationNameHolder";
                _logger.warn(msg, (Throwable)nsme);
            }
        }
    }

    @SASScope
    private static class TenantHolder {
        private static final String _className = "com.sas.framework.commons.holders.TenantHolder";
        private static final String _mthName = "get";
        private static Method _getMth;

        private TenantHolder() {
        }

        private static TenantIdentifier get() {
            TenantIdentifier tenant = null;
            if (_getMth != null) {
                try {
                    Object delegate = _getMth.invoke(null, new Object[0]);
                    tenant = delegate == null ? null : (TenantIdentifier._default._delegate.equals(delegate) ? TenantIdentifier._default : new TenantIdentifier(delegate));
                }
                catch (IllegalAccessException iae) {
                    String msg = "could not access get";
                    _logger.warn(msg, (Throwable)iae);
                }
                catch (InvocationTargetException ite) {
                    String msg = "get method threw exception";
                    Throwable t = ite.getCause();
                    _logger.warn(msg, t);
                }
            }
            return tenant;
        }

        static {
            try {
                Class<?> clazz = Class.forName(_className);
                _getMth = clazz.getMethod(_mthName, new Class[0]);
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (NoSuchMethodException nsme) {
                String msg = "get method not found on com.sas.framework.commons.holders.TenantHolder";
                _logger.warn(msg, (Throwable)nsme);
            }
        }
    }

    private static class TenantIdentifier {
        private static final String _className = "com.sas.framework.commons.TenantIdentifier";
        private static final String _getMonikerMthName = "getMoniker";
        private static final String _defaultFldName = "DEFAULT";
        private static Method _getMonikerMth;
        private static TenantIdentifier _default;
        private Object _delegate;

        private TenantIdentifier(Object delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this._delegate = delegate;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (!this.getClass().equals(that.getClass())) {
                return false;
            }
            return this._delegate.equals(((TenantIdentifier)that)._delegate);
        }

        public int hashCode() {
            return this._delegate.hashCode();
        }

        private String getMoniker() {
            String moniker = null;
            if (_getMonikerMth != null) {
                try {
                    moniker = (String)_getMonikerMth.invoke(this._delegate, new Object[0]);
                }
                catch (IllegalAccessException iae) {
                    String msg = "could not access getMoniker";
                    _logger.warn(msg, (Throwable)iae);
                }
                catch (InvocationTargetException ite) {
                    String msg = "getMoniker method threw exception";
                    Throwable t = ite.getCause();
                    _logger.warn(msg, t);
                }
            }
            return moniker;
        }

        static {
            try {
                Class<?> tenantIdClass = Class.forName(_className);
                _getMonikerMth = tenantIdClass.getMethod(_getMonikerMthName, new Class[0]);
                Field defaultDelegateFld = tenantIdClass.getField(_defaultFldName);
                _default = new TenantIdentifier(defaultDelegateFld.get(null));
            }
            catch (ClassNotFoundException tenantIdClass) {
            }
            catch (NoSuchMethodException nsme) {
                String msg = "getMoniker method not found on com.sas.framework.commons.TenantIdentifier";
                _logger.warn(msg, (Throwable)nsme);
            }
            catch (NoSuchFieldException nsfe) {
                String msg = "DEFAULT field not found on com.sas.framework.commons.TenantIdentifier";
                _logger.warn(msg, (Throwable)nsfe);
            }
            catch (IllegalAccessException iae) {
                String msg = "DEFAULT field cannot be accessed on com.sas.framework.commons.TenantIdentifier";
                _logger.warn(msg, (Throwable)iae);
            }
        }
    }
}

