/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.RB;
import com.sas.net.crypto.SealedString;
import com.sas.security.sspi.SSPIAuth;
import com.sas.text.Message;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class SASURI {
    public static final String schemeIOM = "IOM";
    public static final String schemeIOMS = "IOMS";
    public static final String schemeOMA = "SAS-OMA";
    @SASScope
    public static final String schemeBRG = "BRIDGE";
    public static final String schemeBRGS = "BRIDGES";
    public static final String protocolBRG = "BRIDGE";
    public static final String protocolINT = "INTERNAL";
    public static final String protocolCOM = "COM";
    public static final String encrLevelEverything = "everything";
    public static final String encrLevelCredentials = "credentials";
    public static final String encrLevelNone = "none";
    @SASScope
    public static final String encryptionContentAll = "all";
    @SASScope
    public static final String encryptionContentAuthentication = "authentication";
    @SASScope
    public static final String encryptionPolicyRequired = "required";
    @SASScope
    public static final String encryptionPolicyOptional = "optional";
    @SASScope
    public static final String encryptionPolicyNone = "none";
    @SASScope
    public static final String transcodingPreferenceClient = "client";
    @SASScope
    public static final String transcodingPreferenceServer = "server";
    public static final String hostKey = "host";
    public static final String portKey = "port";
    public static final String protocolKey = "protocol";
    public static final String majorKey = "major";
    public static final String minorKey = "minor";
    public static final String localeKey = "locale";
    public static final String encrKey = "encr";
    public static final String encrLevelKey = "encrlvl";
    @SASScope
    public static final String debugLevelKey = "debuglevel";
    @SASScope
    public static final String logFileKey = "logfile";
    @SASScope
    public static final String encryptionAlgorithmsKey = "encryptionalgorithms";
    @SASScope
    public static final String encryptionContentKey = "encryptioncontent";
    @SASScope
    public static final String encryptionPolicyKey = "encryptionpolicy";
    @SASScope
    public static final String userNameKey = "username";
    @SASScope
    public static final String passwordKey = "password";
    public static final String sealedPasswordKey = "sealedpassword";
    public static final String userKey = "user";
    public static final String passKey = "pass";
    public static final String sealedPassKey = "sealedpass";
    public static final String classFactoryKey = "classfactory";
    public static final String clsidKey = "clsid";
    @SASScope
    public static final String transcodingPreferenceKey = "transcodingpreference";
    public static final String serverNameKey = "servername";
    public static final String interfaceIIDKey = "interfaceiid";
    public static final String timeoutKey = "timeout";
    public static final String trustedSASKey = "trustedsas";
    public static final String iidKey = "iid";
    public static final String classNameKey = "classname";
    public static final String domainKey = "domain";
    public static final String securityPackageKey = "securitypackage";
    public static final String securityPackageListKey = "securitypackagelist";
    public static final String spnKey = "spn";
    @SASScope
    public static final String connectionIDKey = "connectionid";
    public static final String svidKey = "svid";
    public static final String noRedirectKey = "noredirect";
    public static final String zeroConfigKey = "zeroconfig";
    public static final String applicationNameKey = "applicationname";
    public static final String sasCommandKey = "sascommand";
    public static final String tenantIDKey = "tenantid";
    public static final String proxyListKey = "proxylist";
    public static final String ticketAuthenticationKey = "ticketauthentication";
    public static final String authServiceKey = "authservice";
    @SASScope
    public static final String blot = "xxxxxxxx";
    @SASScope
    public static final String amper = "&";
    @SASScope
    public static final String eql = "=";
    @SASScope
    public static final String hook = "?";
    @SASScope
    public static final String semi = ";";
    @SASScope
    public static final String colon = ":";
    @SASScope
    public static final String slash = "/";
    @SASScope
    public static final String comma = ",";
    @SASScope
    public static final String css = "://";
    @SASScope
    public static final String empty = "";
    @SASScope
    public static final String space = " ";
    @SASScope
    public static final String ubar = "_";
    @SASScope
    public static final String dot = ".";
    @SASScope
    public static final String lParen = "(";
    @SASScope
    public static final String rParen = ")";
    @SASScope
    public static final String lSquare = "[";
    @SASScope
    public static final String rSquare = "]";
    @SASScope
    public static final int iidKeyL = "iid".length();
    @SASScope
    public static final int classNameKeyL = "classname".length();
    @SASScope
    public static final int blotL = "xxxxxxxx".length();
    @SASScope
    public static final int amperL = "&".length();
    @SASScope
    public static final int eqlL = "=".length();
    @SASScope
    public static final int hookL = "?".length();
    @SASScope
    public static final int semiL = ";".length();
    @SASScope
    public static final int colonL = ":".length();
    @SASScope
    public static final int slashL = "/".length();
    @SASScope
    public static final int commaL = ",".length();
    @SASScope
    public static final int cssL = "://".length();
    @SASScope
    public static final int emptyL = "".length();
    @SASScope
    public static final int spaceL = " ".length();
    @SASScope
    public static final int ubarL = "_".length();
    @SASScope
    public static final int dotL = ".".length();
    @SASScope
    public static final int lParenL = "(".length();
    @SASScope
    public static final int rParenL = ")".length();
    @SASScope
    public static final int lSquareL = "[".length();
    @SASScope
    public static final int rSquareL = "]".length();
    private static final String _urlEncoding = "UTF8";
    private static final String[] _iomInvalidAttrNameArr = new String[]{"debuglevel", "logfile", "encryptionalgorithms", "encryptioncontent", "encryptionpolicy", "sealedpassword", "username", "password", "transcodingpreference", "connectionid"};
    private static final String[] _brgInvalidAttrNameArr = new String[]{"encr", "encrlvl", "user", "pass", "interfaceiid", "iid", "sealedpass", "timeout", "classname", "protocol"};
    private static final String[] _schemeEnumArr = new String[]{"BRIDGE", "BRIDGES", "IOM", "IOMS", "SAS-OMA"};
    private static final String[] _protocolEnumArr = new String[]{"BRIDGE", "INTERNAL", "COM"};
    private static final String[] _encryptionPolicyEnumArr = new String[]{"none", "optional", "required"};
    private static final String[] _encryptionContentEnumArr = new String[]{"all", "authentication"};
    private static final String[] _encrLevelEnumArr = new String[]{"everything", "credentials", "none"};
    private static final String[] _transcodingPreferenceEnumArr = new String[]{"client", "server"};
    private static Pattern _localeDelim;
    private static Pattern _listDelim;
    private static BitSet _doNotEncode;
    private String _orig;
    private Map _attributes = new HashMap(32);
    private Map _roAttrs = Collections.unmodifiableMap(this._attributes);
    private String _scheme;
    private boolean _brgURI;

    public SASURI(String str) throws URISyntaxException {
        this();
        this._orig = str.trim();
        this.parse(this._orig.toCharArray());
    }

    public SASURI(char[] uriChars) throws URISyntaxException {
        this();
        this.parse(uriChars);
    }

    @SASScope
    public SASURI(String scheme, Map attrMap) {
        this();
        SASURI.validateScheme(scheme);
        this.setScheme(scheme);
        attrMap = SASURI.selectAttributes(this._brgURI, attrMap);
        Set attrEntrySet = attrMap.entrySet();
        for (Map.Entry attrEntry : attrEntrySet) {
            String name = (String)attrEntry.getKey();
            Object val = attrEntry.getValue();
            if (passKey.equals(name) || passwordKey.equals(name)) {
                String sealedName;
                String string = sealedName = passKey.equals(name) ? sealedPassKey : sealedPasswordKey;
                if (attrMap.containsKey(sealedName)) {
                    throw new IllegalArgumentException("attrMap cannot contain both " + name + " and " + sealedName + dot);
                }
                name = sealedName;
                if (val != null) {
                    val = new SealedString((String)val);
                }
            }
            this.addParm(name, val);
        }
    }

    private SASURI() {
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        SASURI thatURI = (SASURI)that;
        HashMap thisAttrMap = new HashMap(this._attributes);
        SealedString thisSealedPass = (SealedString)thisAttrMap.remove(sealedPassKey);
        SealedString thisSealedPassword = (SealedString)thisAttrMap.remove(sealedPasswordKey);
        HashMap thatAttrMap = new HashMap(thatURI.getSecureAttributes());
        SealedString thatSealedPass = (SealedString)thatAttrMap.remove(sealedPassKey);
        SealedString thatSealedPassword = (SealedString)thatAttrMap.remove(sealedPasswordKey);
        if (!thisAttrMap.equals(thatAttrMap)) {
            return false;
        }
        if (!SASURI.sealedStringEquals(thisSealedPass, thatSealedPass)) {
            return false;
        }
        return SASURI.sealedStringEquals(thisSealedPassword, thatSealedPassword);
    }

    public int hashCode() {
        int hc = this.getClass().hashCode();
        HashMap attrMap = new HashMap(this._attributes);
        SealedString sealedPass = (SealedString)attrMap.remove(sealedPassKey);
        SealedString sealedPassword = (SealedString)attrMap.remove(sealedPasswordKey);
        hc ^= attrMap.hashCode();
        hc ^= SASURI.sealedStringHashCode(sealedPass);
        return hc ^= SASURI.sealedStringHashCode(sealedPassword);
    }

    public String toString() {
        String str = this._orig != null ? this._orig : SASURI.compose(this._scheme, this._attributes);
        return str;
    }

    public char[] toCharArray() {
        return SASURI.composeToCharArray(this._scheme, this._attributes);
    }

    public String toBlottedString() {
        String str = this.toString();
        String key = null;
        String delim = null;
        if (!this._brgURI) {
            key = passKey;
            delim = comma;
        } else {
            key = passwordKey;
            delim = amper;
        }
        boolean done = false;
        int passStrt = 0;
        int passStop = 0;
        do {
            int keyx;
            if ((keyx = str.indexOf(key, passStrt)) < 0) {
                return str;
            }
            passStrt = keyx + key.length();
            if (str.indexOf(eql, passStrt) != passStrt) continue;
            passStop = str.indexOf(delim, passStrt += eql.length());
            done = true;
        } while (!done);
        int l = str.length() + blot.length();
        StringBuffer blotBuf = new StringBuffer(l);
        String blotStrt = str.substring(0, passStrt);
        blotBuf.append(blotStrt);
        blotBuf.append(blot);
        if (passStop >= 0) {
            String blotStop = str.substring(passStop);
            blotBuf.append(blotStop);
        }
        String blot = blotBuf.toString();
        return blot;
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getHost() {
        String h = (String)this._attributes.get(hostKey);
        return h;
    }

    public int getPort() {
        Integer _port = (Integer)this._attributes.get(portKey);
        int port = _port != null ? _port : -1;
        return port;
    }

    public Integer getPortNumber() {
        Integer portNumber = (Integer)this._attributes.get(portKey);
        return portNumber;
    }

    public String getProtocol() {
        return (String)this._attributes.get(protocolKey);
    }

    public byte getMajor() {
        Byte _major = (Byte)this._attributes.get(majorKey);
        byte major = _major != null ? (byte)_major : (byte)-1;
        return major;
    }

    public byte getMinor() {
        Byte _minor = (Byte)this._attributes.get(minorKey);
        byte minor = _minor != null ? (byte)_minor : (byte)-1;
        return minor;
    }

    public Locale getLocale() {
        return (Locale)this._attributes.get(localeKey);
    }

    public String getEncrLevel() {
        return (String)this._attributes.get(encrLevelKey);
    }

    @SASScope
    public String getEncryptionContent() {
        return (String)this._attributes.get(encryptionContentKey);
    }

    public String getEncr() {
        return (String)this._attributes.get(encrKey);
    }

    @SASScope
    public String getEncryptionAlgorithms() {
        return (String)this._attributes.get(encryptionAlgorithmsKey);
    }

    @SASScope
    public String getEncryptionPolicy() {
        return (String)this._attributes.get(encryptionPolicyKey);
    }

    @SASScope
    public int getDebugLevel() {
        Integer _dl = (Integer)this._attributes.get(debugLevelKey);
        int dl = _dl != null ? _dl : 0;
        return dl;
    }

    @SASScope
    public String getLogFileName() {
        return (String)this._attributes.get(logFileKey);
    }

    public String getUser() {
        return (String)this._attributes.get(userKey);
    }

    @SASScope
    public String getUserName() {
        return (String)this._attributes.get(userNameKey);
    }

    public String getPass() {
        return SASURI.unsealPassword(sealedPassKey, this._attributes);
    }

    @SASScope
    public String getPassword() {
        return SASURI.unsealPassword(sealedPasswordKey, this._attributes);
    }

    public SealedString getSealedPass() {
        return (SealedString)this._attributes.get(sealedPassKey);
    }

    public SealedString getSealedPassword() {
        return (SealedString)this._attributes.get(sealedPasswordKey);
    }

    public String getClassFactory() {
        return (String)this._attributes.get(classFactoryKey);
    }

    public String getClsid() {
        return (String)this._attributes.get(clsidKey);
    }

    @SASScope
    public String getTranscodingPreference() {
        return (String)this._attributes.get(transcodingPreferenceKey);
    }

    public String getServerName() {
        return (String)this._attributes.get(serverNameKey);
    }

    public String getInterfaceIID() {
        return (String)this._attributes.get(interfaceIIDKey);
    }

    public String getIID() {
        return (String)this._attributes.get(iidKey);
    }

    public int getTimeout() {
        Integer _to = (Integer)this._attributes.get(timeoutKey);
        int to = _to != null ? _to : -1;
        return to;
    }

    public boolean isTrustedSAS() {
        Boolean _ts = (Boolean)this._attributes.get(trustedSASKey);
        boolean ts = _ts != null ? _ts : false;
        return ts;
    }

    public String getClassName() {
        return (String)this._attributes.get(classNameKey);
    }

    public String getSecurityPackage() {
        return (String)this._attributes.get(securityPackageKey);
    }

    public String getSecurityPackageList() {
        return (String)this._attributes.get(securityPackageListKey);
    }

    public String getSPN() {
        return (String)this._attributes.get(spnKey);
    }

    public String getDomain() {
        return (String)this._attributes.get(domainKey);
    }

    @SASScope
    public String getConnectionID() {
        return (String)this._attributes.get(connectionIDKey);
    }

    public String getSVID() {
        return (String)this._attributes.get(svidKey);
    }

    public boolean isNoRedirect() {
        Boolean _ts = (Boolean)this._attributes.get(noRedirectKey);
        boolean ts = _ts != null ? _ts : false;
        return ts;
    }

    public boolean isZeroConfig() {
        Boolean _ts = (Boolean)this._attributes.get(zeroConfigKey);
        boolean ts = _ts != null ? _ts : false;
        return ts;
    }

    public String getApplicationName() {
        return (String)this._attributes.get(applicationNameKey);
    }

    public String getSasCommand() {
        return (String)this._attributes.get(sasCommandKey);
    }

    public String getTenantID() {
        return (String)this._attributes.get(tenantIDKey);
    }

    public String getProxyList() {
        return (String)this._attributes.get(proxyListKey);
    }

    public boolean isTicketAuthentication() {
        Boolean taBool = (Boolean)this._attributes.get(ticketAuthenticationKey);
        boolean ta = taBool != null ? taBool : false;
        return ta;
    }

    public String getAuthService() {
        return (String)this._attributes.get(authServiceKey);
    }

    public Map getAttributes() {
        if (this._attributes.containsKey(sealedPassKey) || this._attributes.containsKey(sealedPasswordKey)) {
            Map attrs = SASURI.unsealPasswordAttributes(this._attributes);
            return Collections.unmodifiableMap(attrs);
        }
        return this._roAttrs;
    }

    public Map getSecureAttributes() {
        return this._roAttrs;
    }

    public Map getAttributesForScheme(String scheme) {
        Map secureAttrs = this.getSecureAttributesForScheme(scheme);
        if (secureAttrs.containsKey(sealedPassKey) || secureAttrs.containsKey(sealedPasswordKey)) {
            return SASURI.unsealPasswordAttributes(secureAttrs);
        }
        return secureAttrs;
    }

    public Map getSecureAttributesForScheme(String scheme) {
        SASURI.validateScheme(scheme);
        boolean brgUri = "BRIDGE".equals(scheme) || schemeBRGS.equals(scheme);
        Map attrMap = SASURI.selectAttributes(brgUri, this._attributes);
        return attrMap;
    }

    @SASScope
    public static Object normalizeAttribute(String name, Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        String valS = (String)value;
        String nrm = null;
        if (classFactoryKey.equals(name) || clsidKey.equals(name) || interfaceIIDKey.equals(name) || iidKey.equals(name) || transcodingPreferenceKey.equals(name) || encryptionPolicyKey.equals(name) || encrLevelKey.equals(name)) {
            nrm = valS.toLowerCase(Locale.US);
        } else if (encryptionContentKey.equals(name)) {
            nrm = valS.toLowerCase(Locale.US);
            if (encrLevelEverything.equals(nrm)) {
                nrm = encryptionContentAll;
            } else if (encrLevelCredentials.equals(nrm)) {
                nrm = encryptionContentAuthentication;
            }
        } else if (encrKey.equals(name) || encryptionAlgorithmsKey.equals(name)) {
            Pattern delim = SASURI.getListDelim();
            String[] encrArr = delim.split(valS);
            int valSL = valS.length();
            StringBuffer buf = new StringBuffer(valSL);
            for (int i = 0; i < encrArr.length; ++i) {
                String rawEncr = encrArr[i];
                if (rawEncr == null || rawEncr.length() <= 0) continue;
                String nrmEncr = rawEncr.toUpperCase(Locale.US);
                buf.append(nrmEncr).append(comma);
            }
            int bufL = buf.length();
            if (bufL > 0) {
                buf.setLength(bufL - 1);
            }
            nrm = buf.toString();
        } else {
            nrm = securityPackageKey.equals(name) ? SSPIAuth.normalizeSecurityPackage((String)valS) : (securityPackageListKey.equals(name) ? SSPIAuth.normalizeSecurityPackageList((String)valS) : (protocolKey.equals(name) ? valS.toUpperCase(Locale.US) : valS));
        }
        return nrm;
    }

    public static void updateAttribute(String name, Object value, Map attrMap) {
        try {
            SASURI.validateParm(name, value, 0);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use);
        }
        SASURI.updateParm(name, value, attrMap);
        if (classFactoryKey.equals(name)) {
            SASURI.updateParm(clsidKey, value, attrMap);
        } else if (clsidKey.equals(name)) {
            SASURI.updateParm(classFactoryKey, value, attrMap);
        } else if (userKey.equals(name)) {
            SASURI.updateParm(userNameKey, value, attrMap);
        } else if (passKey.equals(name)) {
            SASURI.updateParm(passwordKey, value, attrMap);
        } else if (sealedPassKey.equals(name)) {
            SASURI.updateParm(sealedPasswordKey, value, attrMap);
        } else if (encrKey.equals(name)) {
            SASURI.updateParm(encryptionAlgorithmsKey, value, attrMap);
        } else if (encrLevelKey.equals(name)) {
            if (encrLevelEverything.equals(value)) {
                SASURI.updateParm(encryptionPolicyKey, encryptionPolicyRequired, attrMap);
                SASURI.updateParm(encryptionContentKey, encryptionContentAll, attrMap);
            } else if (encrLevelCredentials.equals(value)) {
                SASURI.updateParm(encryptionPolicyKey, encryptionPolicyRequired, attrMap);
                SASURI.updateParm(encryptionContentKey, encryptionContentAuthentication, attrMap);
            } else {
                SASURI.updateParm(encryptionPolicyKey, "none", attrMap);
            }
        } else if (interfaceIIDKey.equals(name)) {
            SASURI.updateParm(iidKey, value, attrMap);
        } else if (iidKey.equals(name)) {
            SASURI.updateParm(interfaceIIDKey, value, attrMap);
        } else if (encryptionAlgorithmsKey.equals(name)) {
            SASURI.updateParm(encrKey, value, attrMap);
        } else if (encryptionContentKey.equals(name)) {
            boolean policyNone;
            String policy = (String)attrMap.get(encryptionPolicyKey);
            boolean bl = policyNone = policy == null || "none".equals(policy);
            String encrLevel = policyNone ? "none" : (encryptionContentAll.equals(value) ? encrLevelEverything : encrLevelCredentials);
            SASURI.updateParm(encrLevelKey, encrLevel, attrMap);
        } else if (encryptionPolicyKey.equals(name)) {
            String content;
            String encrLevel = null;
            encrLevel = "none".equals(value) ? "none" : ((content = (String)attrMap.get(encryptionContentKey)) == null || encryptionContentAll.equals(content) ? encrLevelEverything : encrLevelCredentials);
            SASURI.updateParm(encrLevelKey, encrLevel, attrMap);
        } else if (userNameKey.equals(name)) {
            SASURI.updateParm(userKey, value, attrMap);
        } else if (passwordKey.equals(name)) {
            SASURI.updateParm(passKey, value, attrMap);
        } else if (sealedPasswordKey.equals(name)) {
            SASURI.updateParm(sealedPassKey, value, attrMap);
        }
    }

    @SASScope
    public static String urlEncode(String plain) {
        return new String(SASURI.urlEncodeChars(plain.toCharArray()));
    }

    public static char[] urlEncodeChars(char[] plainChars) {
        BitSet doNotEncode = SASURI.getDoNotEncodeSet();
        int plainCharsL = plainChars.length;
        CharBuffer cb = CharBuffer.allocate(plainCharsL * 3);
        int i = 0;
        while (i < plainCharsL) {
            int j;
            char c = plainChars[i];
            if (doNotEncode.get(c)) {
                cb.append(c);
                ++i;
                continue;
            }
            CharBuffer encodeBuf = CharBuffer.allocate(plainCharsL - i);
            do {
                encodeBuf.put(c);
            } while (++i < plainCharsL && !doNotEncode.get(c = plainChars[i]));
            encodeBuf.flip();
            ByteBuffer bb = Charset.forName(_urlEncoding).encode(encodeBuf);
            for (j = 0; j < encodeBuf.limit(); ++j) {
                encodeBuf.put(0, '\u0000');
            }
            while (bb.hasRemaining()) {
                cb.put('%');
                byte b = bb.get();
                char ch = Character.forDigit(b >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = Character.toUpperCase(ch);
                }
                cb.put(ch);
                ch = Character.forDigit(b & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = Character.toUpperCase(ch);
                }
                cb.put(ch);
            }
            for (j = 0; j < bb.limit(); ++j) {
                bb.put(0, (byte)0);
            }
        }
        cb.flip();
        int cbL = cb.remaining();
        char[] encChars = new char[cbL];
        cb.get(encChars);
        for (int j = 0; j < cb.limit(); ++j) {
            cb.put(0, '\u0000');
        }
        return encChars;
    }

    @SASScope
    public static String urlDecode(String enc) {
        return new String(SASURI.urlDecodeChars(enc.toCharArray()));
    }

    public static char[] urlDecodeChars(char[] encChars) {
        int encCharsL = encChars.length;
        int cbCap = encCharsL > 500 ? encCharsL / 2 : encCharsL;
        CharBuffer cb = CharBuffer.allocate(cbCap);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < encCharsL) {
            switch (encChars[i]) {
                case '+': {
                    cb.append(' ');
                    ++i;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            int bytesL = (encCharsL - i) / 3;
                            bytes = new byte[bytesL];
                        }
                        int pos = 0;
                        while (i + 2 < encCharsL && encChars[i] == '%') {
                            String s = new String(encChars, i + 1, 2);
                            int v = Integer.parseInt(s, 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            i += 3;
                        }
                        if (i < encCharsL && encChars[i] == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        ByteBuffer escapeBytes = ByteBuffer.wrap(bytes, 0, pos);
                        CharBuffer escapeChars = Charset.forName(_urlEncoding).decode(escapeBytes);
                        Arrays.fill(bytes, (byte)0);
                        cb.append(escapeChars);
                        for (int j = 0; j < escapeChars.limit(); ++j) {
                            escapeChars.put(j, '\u0000');
                        }
                        continue block6;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + nfe.getMessage());
                    }
                }
            }
            cb.append(encChars[i++]);
        }
        cb.flip();
        int cbL = cb.remaining();
        char[] dec = new char[cbL];
        cb.get(dec);
        for (int j = 0; j < cb.limit(); ++j) {
            cb.put(j, '\u0000');
        }
        return dec;
    }

    @SASScope
    public static Locale parseLocaleName(String localeName) {
        Pattern delim = SASURI.getLocaleDelim();
        String[] localeArray = delim.split(localeName, 3);
        Locale locale = null;
        locale = localeArray.length == 1 ? new Locale(localeArray[0]) : (localeArray.length == 2 ? new Locale(localeArray[0], localeArray[1]) : new Locale(localeArray[0], localeArray[1], localeArray[2]));
        return locale;
    }

    public static SASURI create(String str) {
        SASURI uri = null;
        try {
            uri = new SASURI(str);
        }
        catch (URISyntaxException use) {
            IllegalArgumentException iae = new IllegalArgumentException(use);
            throw iae;
        }
        return uri;
    }

    public static SASURI create(char[] uriChars) {
        SASURI uri = null;
        try {
            uri = new SASURI(uriChars);
        }
        catch (URISyntaxException use) {
            IllegalArgumentException iae = new IllegalArgumentException(use);
            throw iae;
        }
        return uri;
    }

    @SASScope
    public static String compose(String scheme, Map attrMap) {
        return new String(SASURI.composeToCharArray(scheme, attrMap));
    }

    public static char[] composeToCharArray(String scheme, Map attrMap) {
        String schemeU = scheme.toUpperCase(Locale.US);
        SASURI.validateScheme(scheme);
        boolean brgURI = "BRIDGE".equals(schemeU) || schemeBRGS.equals(schemeU);
        attrMap = SASURI.selectAttributes(brgURI, attrMap);
        int bufL = scheme.length();
        bufL += cssL;
        String host = (String)attrMap.remove(hostKey);
        if (host != null) {
            bufL += host.length();
            bufL += lSquareL + rSquareL;
        }
        Integer port = (Integer)attrMap.remove(portKey);
        String portS = null;
        if (port != null) {
            portS = port.toString();
            bufL += colonL;
            bufL += portS.length();
        }
        bufL += slashL;
        String classID = null;
        String protocol = null;
        String attrDelim = null;
        if (brgURI) {
            attrDelim = amper;
            bufL += hookL;
            classID = (String)attrMap.remove(classFactoryKey);
            String altClassID = (String)attrMap.remove(clsidKey);
            if (classID == null) {
                classID = altClassID;
            }
            if (classID != null) {
                bufL += classID.length();
            }
        } else {
            attrDelim = comma;
            bufL += semiL * 2;
            protocol = (String)attrMap.remove(protocolKey);
            if (protocol != null) {
                bufL += protocol.length();
            }
        }
        int attrMapL = attrMap.size();
        HashMap<String, char[]> encodedAttrMap = new HashMap<String, char[]>(attrMapL);
        Set attrEntrySet = attrMap.entrySet();
        for (Map.Entry attrEntry : attrEntrySet) {
            String key = (String)attrEntry.getKey();
            Object val = attrEntry.getValue();
            char[] valE = null;
            if (val instanceof Boolean) {
                if (!((Boolean)val).booleanValue()) {
                    continue;
                }
            } else if (val instanceof SealedString) {
                char[] valChars = ((SealedString)val).getCharacters();
                valE = SASURI.urlEncodeChars(valChars);
                Arrays.fill(valChars, '\u0000');
                if (sealedPassKey.equals(key)) {
                    key = passKey;
                } else if (sealedPasswordKey.equals(key)) {
                    key = passwordKey;
                }
            } else {
                String valS = val.toString();
                valE = SASURI.urlEncode(valS).toCharArray();
            }
            String keyE = SASURI.urlEncode(key);
            encodedAttrMap.put(keyE, valE);
            bufL += attrDelim.length();
            bufL += keyE.length();
            if (valE == null) continue;
            bufL += eqlL;
            bufL += valE.length;
        }
        CharBuffer buf = CharBuffer.allocate(bufL);
        buf.append(scheme).append(css);
        if (host != null) {
            boolean ipv6Literal;
            boolean bl = ipv6Literal = host.indexOf(colon) >= 0;
            if (ipv6Literal) {
                buf.append(lSquare);
            }
            buf.append(host);
            if (ipv6Literal) {
                buf.append(rSquare);
            }
        }
        if (portS != null) {
            buf.append(colon).append(portS);
        }
        int encodedAttrMapL = encodedAttrMap.size();
        if (brgURI) {
            buf.append(slash);
            if (classID != null) {
                buf.append(classID);
            }
            if (encodedAttrMapL > 0) {
                buf.append(hook);
            }
        } else {
            buf.append(semi);
            if (protocol != null) {
                buf.append(protocol);
            }
            buf.append(semi);
        }
        if (encodedAttrMapL > 0) {
            Set encodedAttrEntrySet = encodedAttrMap.entrySet();
            Iterator encodedAttrEntryItr = encodedAttrEntrySet.iterator();
            while (encodedAttrEntryItr.hasNext()) {
                Map.Entry encodedAttrEntry = encodedAttrEntryItr.next();
                String keyE = (String)encodedAttrEntry.getKey();
                buf.append(keyE);
                char[] valE = (char[])encodedAttrEntry.getValue();
                if (valE != null) {
                    buf.append(eql).put(valE);
                    Arrays.fill(valE, '\u0000');
                }
                if (!encodedAttrEntryItr.hasNext()) continue;
                buf.append(attrDelim);
            }
        }
        if (!brgURI) {
            buf.append(slash);
        }
        buf.flip();
        int urlCharsL = buf.remaining();
        char[] urlChars = new char[urlCharsL];
        buf.get(urlChars);
        for (int i = 0; i < urlCharsL; ++i) {
            buf.put(i, '\u0000');
        }
        return urlChars;
    }

    protected static String unsealString(SealedString sealed) {
        if (sealed == null) {
            return null;
        }
        char[] chars = sealed.getCharacters();
        if (chars == null) {
            return null;
        }
        String s = new String(chars);
        Arrays.fill(chars, '\u0000');
        return s;
    }

    private static int caIndexOf(char[] ca, String str, int startIndex) {
        int strL = str.length();
        if (strL > ca.length) {
            return -1;
        }
        for (int i = startIndex; i < ca.length - strL + 1; ++i) {
            boolean maybeFound = true;
            for (int j = 0; j < strL && maybeFound; ++j) {
                if (ca[i + j] == str.charAt(j)) continue;
                maybeFound = false;
            }
            if (!maybeFound) continue;
            return i;
        }
        return -1;
    }

    private static char[] caSubArray(char[] ca, int start, int end) {
        if (start < 0 || end < 0 || start > end || end > ca.length) {
            throw new IndexOutOfBoundsException();
        }
        int subArrayL = end - start;
        char[] subArray = new char[subArrayL];
        System.arraycopy(ca, start, subArray, 0, subArrayL);
        return subArray;
    }

    private static synchronized BitSet getDoNotEncodeSet() {
        if (_doNotEncode == null) {
            int i;
            _doNotEncode = new BitSet(256);
            for (i = 97; i <= 122; i = (int)((char)(i + 1))) {
                _doNotEncode.set(i);
            }
            for (i = 65; i <= 90; i = (int)((char)(i + 1))) {
                _doNotEncode.set(i);
            }
            for (i = 48; i <= 57; i = (int)((char)(i + 1))) {
                _doNotEncode.set(i);
            }
            _doNotEncode.set(45);
            _doNotEncode.set(95);
            _doNotEncode.set(46);
            _doNotEncode.set(42);
        }
        return _doNotEncode;
    }

    private static boolean sealedStringEquals(SealedString s1, SealedString s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        char[] c1 = s1.getCharacters();
        char[] c2 = s2.getCharacters();
        boolean result = Arrays.equals(c1, c2);
        Arrays.fill(c1, '\u0000');
        Arrays.fill(c2, '\u0000');
        return result;
    }

    private static int sealedStringHashCode(SealedString s) {
        if (s == null) {
            return 0;
        }
        int hc = SealedString.class.hashCode();
        char[] c = s.getCharacters();
        Arrays.fill(c, '\u0000');
        return hc ^= Arrays.hashCode(c);
    }

    private static Map unsealPasswordAttributes(Map attrs) {
        if ((attrs = new HashMap<String, String>(attrs)).containsKey(sealedPassKey)) {
            String pass = SASURI.unsealPassword(sealedPassKey, attrs);
            attrs.remove(sealedPassKey);
            attrs.put(passKey, pass);
        }
        if (attrs.containsKey(sealedPasswordKey)) {
            String password = SASURI.unsealPassword(sealedPasswordKey, attrs);
            attrs.remove(sealedPasswordKey);
            attrs.put(passwordKey, password);
        }
        return attrs;
    }

    private static String unsealPassword(String key, Map attrs) {
        SealedString sealedPassword = (SealedString)attrs.get(key);
        return SASURI.unsealString(sealedPassword);
    }

    private void setScheme(String scheme) {
        this._scheme = scheme;
        if ("BRIDGE".equals(scheme) || schemeBRGS.equals(scheme)) {
            this._brgURI = true;
            this.addParm(protocolKey, "BRIDGE");
        }
    }

    private void parse(char[] uriChars) throws URISyntaxException {
        int ndx = SASURI.caIndexOf(uriChars, css, 0);
        String rawScheme = ndx >= 0 ? new String(uriChars, 0, ndx) : new String(uriChars);
        String scheme = rawScheme.toUpperCase(Locale.US);
        try {
            SASURI.validateScheme(scheme);
        }
        catch (IllegalArgumentException iae) {
            String msgIndex = "SASURI.007.ex.fmt";
            String msgPattern = RB.getStringResource(msgIndex);
            String msg = Message.format((String)msgPattern, (Object)rawScheme, (Object)Integer.toString(0));
            throw new LocalizableURISyntaxException(msg, 0);
        }
        this.setScheme(scheme);
        int off = ndx + cssL;
        if (this._brgURI) {
            this.parseBRG(uriChars, off, uriChars.length);
        } else {
            this.parseIOM(uriChars, off, uriChars.length);
        }
    }

    private void parseIOM(char[] uriChars, int specStart, int specEnd) throws URISyntaxException {
        char[] protocolVal;
        int semi1Ndx = SASURI.caIndexOf(uriChars, semi, specStart);
        String hostPort = semi1Ndx >= 0 ? new String(uriChars, specStart, semi1Ndx - specStart) : new String(uriChars, specStart, specEnd - specStart);
        this.parseHostPort(hostPort, specStart);
        int protocolNdx = semi1Ndx + semiL;
        if (semi1Ndx < 0 || protocolNdx >= specEnd) {
            return;
        }
        int semi2Ndx = SASURI.caIndexOf(uriChars, semi, protocolNdx);
        char[] cArray = protocolVal = semi2Ndx >= 0 ? SASURI.caSubArray(uriChars, protocolNdx, semi2Ndx) : SASURI.caSubArray(uriChars, protocolNdx, specEnd);
        if (protocolVal.length > 0) {
            this.addEncodedParm(protocolKey.toCharArray(), protocolVal, protocolNdx);
        }
        int nvPairsNdx = semi2Ndx + semiL;
        if (semi2Ndx < 0 || nvPairsNdx >= specEnd) {
            return;
        }
        int slashNdx = SASURI.caIndexOf(uriChars, slash, nvPairsNdx);
        int nvPairsEnd = slashNdx >= 0 ? slashNdx : specEnd;
        this.parseNameValuePairs(uriChars, nvPairsNdx, nvPairsEnd);
    }

    private void parseBRG(char[] uriChars, int specStart, int specEnd) throws URISyntaxException {
        char[] classIDValChars;
        int slashNdx = SASURI.caIndexOf(uriChars, slash, specStart);
        String hostPort = slashNdx >= 0 ? new String(uriChars, specStart, slashNdx - specStart) : new String(uriChars, specStart, specEnd - specStart);
        this.parseHostPort(hostPort, specStart);
        int classIDNdx = slashNdx + slashL;
        if (slashNdx < 0 || classIDNdx >= specEnd) {
            return;
        }
        int hookNdx = SASURI.caIndexOf(uriChars, hook, classIDNdx);
        char[] cArray = classIDValChars = hookNdx >= 0 ? SASURI.caSubArray(uriChars, classIDNdx, hookNdx) : SASURI.caSubArray(uriChars, classIDNdx, specEnd);
        if (classIDValChars.length > 0) {
            this.addEncodedParm(classFactoryKey.toCharArray(), classIDValChars, classIDNdx);
        }
        int nvPairsNdx = hookNdx + hookL;
        if (hookNdx < 0 || nvPairsNdx >= specEnd) {
            return;
        }
        this.parseNameValuePairs(uriChars, nvPairsNdx, specEnd);
    }

    private void parseHostPort(String hostPort, int off) throws URISyntaxException {
        int colonNdx;
        int hostStrt = 0;
        int hostStop = 0;
        int hostPortL = hostPort.length();
        if (hostPort.startsWith(lSquare)) {
            hostStop = hostPort.indexOf(rSquare);
            if (hostStop >= 0) {
                hostStrt = lSquareL;
            }
        } else {
            hostStop = hostPort.indexOf(colon);
            if (hostStop < 0) {
                hostStop = hostPortL;
            }
        }
        off += hostStrt;
        String host = hostPort.substring(hostStrt, hostStop);
        int hostL = host.length();
        if (hostL > 0) {
            this.addEncodedParm(hostKey.toCharArray(), host.toCharArray(), off);
        }
        if ((colonNdx = hostPort.indexOf(colon, hostStop)) >= 0) {
            int portNdx = colonNdx + colonL;
            String port = portNdx < hostPortL ? hostPort.substring(portNdx) : null;
            char[] portChars = port != null ? port.toCharArray() : null;
            this.addEncodedParm(portKey.toCharArray(), portChars, off += portNdx);
        }
    }

    private void parseNameValuePairs(char[] uriChars, int nvPairsStart, int nvPairsEnd) throws URISyntaxException {
        String nvSep = eql;
        char[] nvSepChars = nvSep.toCharArray();
        String pairSep = this._brgURI ? amper : comma;
        char[] pairSepChars = pairSep.toCharArray();
        String delim = nvSep + pairSep;
        CharArrayTokenizer izr = new CharArrayTokenizer(uriChars, nvPairsStart, nvPairsEnd, delim);
        int state = 0;
        char[] name = null;
        char[] val = null;
        int ndx = nvPairsStart;
        int nameIndex = 0;
        while (izr.hasMoreTokens()) {
            char[] tok = izr.nextToken();
            switch (state) {
                case 0: {
                    if (name != null) {
                        this.addEncodedParm(name, val, nameIndex);
                        if (val != null) {
                            Arrays.fill(val, '\u0000');
                            val = null;
                        }
                    }
                    if (Arrays.equals(nvSepChars, tok)) {
                        name = empty.toCharArray();
                        state = 2;
                    } else {
                        if (Arrays.equals(pairSepChars, tok)) {
                            throw this.nvPairSyntaxException(ndx, tok, nvSep);
                        }
                        name = tok;
                        state = 1;
                    }
                    nameIndex = ndx;
                    break;
                }
                case 1: {
                    if (Arrays.equals(nvSepChars, tok)) {
                        state = 2;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if (Arrays.equals(pairSepChars, tok)) {
                        state = 0;
                        break;
                    }
                    if (Arrays.equals(nvSepChars, tok)) {
                        throw SASURI.syntaxException(ndx, tok, nvSep, name);
                    }
                    val = tok;
                    state = 3;
                    break;
                }
                case 3: {
                    if (!Arrays.equals(pairSepChars, tok)) {
                        throw SASURI.syntaxException(ndx, tok, pairSep, null);
                    }
                    state = 0;
                }
            }
            ndx += tok.length;
        }
        if (name != null) {
            this.addEncodedParm(name, val, nameIndex);
            if (val != null) {
                Arrays.fill(val, '\u0000');
            }
        }
    }

    private void addEncodedParm(char[] encodedNameChars, char[] encodedValChars, int nameIndex) throws URISyntaxException {
        String[] invalidAttrNameArr;
        String name = new String(SASURI.urlDecodeChars(encodedNameChars)).toLowerCase(Locale.US);
        boolean validAttr = SASURI.validateAttrName(name, invalidAttrNameArr = this._brgURI ? _brgInvalidAttrNameArr : _iomInvalidAttrNameArr);
        if (validAttr) {
            Object val = this.decodeParm(name, encodedValChars, nameIndex);
            Object nrm = SASURI.normalizeAttribute(name, val);
            if (passKey.equals(name) || passwordKey.equals(name)) {
                char[] passwordChars = (char[])val;
                nrm = new SealedString(passwordChars);
                Arrays.fill(passwordChars, '\u0000');
                name = passKey.equals(name) ? sealedPassKey : sealedPasswordKey;
            }
            SASURI.validateParm(name, nrm, nameIndex);
            this.addParm(name, nrm);
        }
    }

    private Object decodeParm(String name, char[] encodedValChars, int nameIndex) throws URISyntaxException {
        char[] valChars;
        char[] cArray = valChars = encodedValChars != null ? SASURI.urlDecodeChars(encodedValChars) : empty.toCharArray();
        if (passKey.equals(name) || passwordKey.equals(name)) {
            return valChars;
        }
        String valStr = new String(valChars);
        Object val = null;
        if (majorKey.equals(name) || minorKey.equals(name)) {
            try {
                val = Byte.valueOf(valStr);
            }
            catch (NumberFormatException nfe) {
                throw this.numericSyntaxException(nameIndex, name, valStr, nfe);
            }
        } else if (portKey.equals(name) || timeoutKey.equals(name) || debugLevelKey.equals(name)) {
            try {
                val = Integer.valueOf(valStr);
            }
            catch (NumberFormatException nfe) {
                throw this.numericSyntaxException(nameIndex, name, valStr, nfe);
            }
        } else {
            val = localeKey.equals(name) ? SASURI.parseLocaleName(valStr) : (trustedSASKey.equals(name) || noRedirectKey.equals(name) || zeroConfigKey.equals(name) || ticketAuthenticationKey.equals(name) ? Boolean.TRUE : valStr);
        }
        return val;
    }

    private static void validateParm(String name, Object val, int nameIndex) throws URISyntaxException {
        if (transcodingPreferenceKey.equals(name)) {
            SASURI.validateEnumValue(name, val, _transcodingPreferenceEnumArr, nameIndex);
        } else if (encryptionPolicyKey.equals(name)) {
            SASURI.validateEnumValue(name, val, _encryptionPolicyEnumArr, nameIndex);
        } else if (encryptionContentKey.equals(name)) {
            SASURI.validateEnumValue(name, val, _encryptionContentEnumArr, nameIndex);
        } else if (encrLevelKey.equals(name)) {
            SASURI.validateEnumValue(name, val, _encrLevelEnumArr, nameIndex);
        } else if (protocolKey.equals(name)) {
            SASURI.validateEnumValue(name, val, _protocolEnumArr, nameIndex);
        }
    }

    private void addParm(String name, Object val) {
        SASURI.updateAttribute(name, val, this._attributes);
    }

    private static void updateParm(String name, Object val, Map attrMap) {
        if (val != null) {
            attrMap.put(name, val);
        } else {
            attrMap.remove(name);
        }
    }

    private static Map selectAttributes(boolean brgURI, Map attrMap) {
        String[] invalidAttrNameArr = brgURI ? _brgInvalidAttrNameArr : _iomInvalidAttrNameArr;
        HashMap<String, Object> selectedAttrMap = new HashMap<String, Object>(32);
        Set attrEntrySet = attrMap.entrySet();
        for (Map.Entry attrEntry : attrEntrySet) {
            Object val;
            String key = (String)attrEntry.getKey();
            boolean validAttr = SASURI.validateAttrName(key, invalidAttrNameArr);
            if (!validAttr || (val = attrMap.get(key)) == null) continue;
            Object nrm = SASURI.normalizeAttribute(key, val);
            selectedAttrMap.put(key, nrm);
        }
        if (selectedAttrMap.containsKey(classFactoryKey) && selectedAttrMap.containsKey(clsidKey)) {
            selectedAttrMap.remove(clsidKey);
        }
        if (selectedAttrMap.containsKey(iidKey) && selectedAttrMap.containsKey(interfaceIIDKey)) {
            selectedAttrMap.remove(iidKey);
        }
        return selectedAttrMap;
    }

    private static void validateScheme(String scheme) {
        if (!SASURI.arrayContains(scheme, _schemeEnumArr)) {
            throw new IllegalArgumentException(scheme);
        }
    }

    private static boolean validateAttrName(String name, String[] invalidNameArr) {
        for (String invalidName : invalidNameArr) {
            if (!invalidName.equals(name)) continue;
            return false;
        }
        return true;
    }

    private static void validateEnumValue(String name, Object value, String[] enumArr, int nameIndex) throws URISyntaxException {
        if (SASURI.arrayContains(value, enumArr)) {
            return;
        }
        int bufL = 0;
        for (int i = 0; i < enumArr.length; ++i) {
            bufL += enumArr[i].length();
            ++bufL;
        }
        StringBuffer buf = new StringBuffer(bufL);
        for (int i = 0; i < enumArr.length; ++i) {
            buf.append(enumArr[i]).append(comma);
        }
        buf.setLength(bufL - 1);
        String enumValues = buf.toString();
        String ndx = Integer.toString(nameIndex);
        String messageIndex = "SASURI.005.ex.fmt";
        String messagePattern = RB.getStringResource(messageIndex);
        String message = Message.format((String)messagePattern, (Object)name, (Object)enumValues, (Object)value, (Object)ndx);
        throw new LocalizableURISyntaxException(message, nameIndex);
    }

    private static boolean arrayContains(Object val, Object[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            Object item = arr[i];
            if (!(val != null ? val.equals(item) : item == null)) continue;
            return true;
        }
        return false;
    }

    private static synchronized Pattern getLocaleDelim() {
        if (_localeDelim == null) {
            _localeDelim = Pattern.compile(ubar);
        }
        return _localeDelim;
    }

    private static synchronized Pattern getListDelim() {
        if (_listDelim == null) {
            _listDelim = Pattern.compile("([\\s]*,[\\s]*)+");
        }
        return _listDelim;
    }

    private static URISyntaxException syntaxException(int ndx, char[] err, String exDelims, char[] exName) {
        String _ndx = Integer.toString(ndx);
        String message = null;
        if (exDelims != null) {
            if (exName == null) {
                String messageIndex = "SASURI.000.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                message = Message.format((String)messagePattern, (Object)exDelims, (Object)new String(err), (Object)_ndx);
            } else {
                String messageIndex = "SASURI.001.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex);
                message = Message.format((String)messagePattern, (Object)exDelims, (Object)new String(exName), (Object)new String(err), (Object)_ndx);
            }
        } else {
            String messageIndex = "SASURI.002.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex);
            message = Message.format((String)messagePattern, (Object)new String(exName), (Object)new String(err), (Object)_ndx);
        }
        return new LocalizableURISyntaxException(message, ndx);
    }

    private URISyntaxException nvPairSyntaxException(int ndx, char[] err, String exDelims) {
        String _ndx = Integer.toString(ndx);
        String messageIndex = "SASURI.003.ex.fmt";
        String messagePattern = RB.getStringResource(messageIndex);
        String message = Message.format((String)messagePattern, (Object)exDelims, (Object)new String(err), (Object)_ndx);
        return new LocalizableURISyntaxException(message, ndx);
    }

    private URISyntaxException numericSyntaxException(int ndx, String name, Object val, NumberFormatException nfe) {
        String _ndx = Integer.toString(ndx);
        String messageIndex = "SASURI.004.ex.fmt";
        String messagePattern = RB.getStringResource(messageIndex);
        String message = Message.format((String)messagePattern, (Object)name, (Object)val, (Object)_ndx);
        LocalizableURISyntaxException use = new LocalizableURISyntaxException(message, ndx);
        use.initCause(nfe);
        return use;
    }

    @SASScope
    private static class LocalizableURISyntaxException
    extends URISyntaxException {
        private static final long serialVersionUID = -8779270928912084502L;
        private int _index;

        private LocalizableURISyntaxException(String reason, int index) {
            super(SASURI.empty, reason);
            this._index = index;
        }

        @Override
        public int getIndex() {
            return this._index;
        }
    }

    private static class CharArrayTokenizer {
        private char[] _ca;
        private int _ndx;
        private int _end;
        private String _delim;

        private CharArrayTokenizer(char[] ca, int start, int end, String delim) {
            if (start < 0 || end < 0 || start > end || start >= ca.length || end > ca.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this._ca = ca;
            this._ndx = start;
            this._end = end;
            this._delim = delim;
        }

        private boolean hasMoreTokens() {
            return this._ndx < this._end;
        }

        private char[] nextToken() {
            if (this._ndx >= this._end) {
                throw new IllegalStateException();
            }
            int tokenEnd = -1;
            for (int i = this._ndx; i < this._end; ++i) {
                char c = this._ca[i];
                if (this._delim.indexOf(c) < 0) continue;
                if (i > this._ndx) {
                    tokenEnd = i;
                    break;
                }
                tokenEnd = i + 1;
                break;
            }
            if (tokenEnd < 0) {
                tokenEnd = this._end;
            }
            char[] token = SASURI.caSubArray(this._ca, this._ndx, tokenEnd);
            this._ndx = tokenEnd;
            return token;
        }
    }
}

