/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.themes.dao.registry;

import com.sas.framework.themes.dao.registry.ThemeRegistrationDAOInterface;
import com.sas.svcs.config.client.ApplicationRegistration;
import com.sas.svcs.themes.client.Theme;
import com.sas.svcs.themes.client.ThemeRegistration;
import com.sas.svcs.themes.client.ThemeService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class ThemeRegistrationDao
implements ThemeRegistrationDAOInterface {
    ThemeService themeService;

    @Autowired
    public void setThemeService(ThemeService themeService) {
        this.themeService = themeService;
    }

    @Override
    public ApplicationRegistration getTheme(String name) {
        Theme theme = this.themeService.getTheme(name);
        return this.convertThemeToApplicationRegistration(theme);
    }

    private ApplicationRegistration convertThemeToApplicationRegistration(Theme theme) {
        ThemeRegistration registration = theme.getRegistration();
        ApplicationRegistration appReg = new ApplicationRegistration();
        appReg.setName(theme.getName());
        appReg.setProtocol(registration.getInternalProtocol());
        appReg.setHost(registration.getInternalHost());
        appReg.setPort(registration.getInternalPort());
        appReg.setContext(registration.getInternalContext());
        appReg.setSubnet(registration.getNetworkInterface());
        appReg.setExternalProtocol(registration.getProtocol());
        appReg.setExternalHost(registration.getHost());
        appReg.setExternalPort(registration.getPort());
        appReg.setExternalContext(registration.getContext());
        return appReg;
    }

    @Override
    public List<ApplicationRegistration> getAllThemes() {
        ArrayList<ApplicationRegistration> results = new ArrayList<ApplicationRegistration>();
        List all = this.themeService.getAll();
        for (Theme theme : all) {
            results.add(this.convertThemeToApplicationRegistration(theme));
        }
        return results;
    }

    @Override
    public void reload() {
    }
}

