/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.themes.dao.builder;

import com.sas.framework.annotation.WriteOperation;
import com.sas.framework.themes.dao.builder.AbstractXmlThemeDAO;
import com.sas.framework.themes.dao.builder.ThemeDAOInterface;
import com.sas.framework.themes.dao.builder.ThemeDescriptorFetcher;
import com.sas.framework.themes.dao.registry.ThemeRegistrationDAOInterface;
import com.sas.svcs.config.client.ApplicationRegistration;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UrlThemeDAO
extends AbstractXmlThemeDAO
implements ThemeDAOInterface {
    private static final String SLEEP_TIME_SYSTEM_PROPERTY = "theme.sleep.time";
    private static final String MAX_TRIES_SYSTEM_PROPERTY = "theme.max.tries";
    private static final Logger logger = LogManager.getLogger(UrlThemeDAO.class);
    private static final int STATE_INIT = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_COMPLETE = 2;
    private int state = 0;
    private static final int MAX_TRIES_DEFAULT = 450;
    private static final int SLEEP_TIME_DEFAULT = 4000;
    private int maxTries;
    private int sleepTime;
    private int fetcherCount = 0;

    public UrlThemeDAO() {
        try {
            this.maxTries = System.getProperty(MAX_TRIES_SYSTEM_PROPERTY) == null ? 450 : Integer.parseInt(System.getProperty(MAX_TRIES_SYSTEM_PROPERTY));
            this.sleepTime = System.getProperty(SLEEP_TIME_SYSTEM_PROPERTY) == null ? 4000 : Integer.parseInt(System.getProperty(SLEEP_TIME_SYSTEM_PROPERTY));
        }
        catch (Throwable t) {
            logger.error("Failed to convert system property to integer. Verify the values for theme.sleep.time and theme.max.tries.", t);
            this.maxTries = 450;
            this.sleepTime = 4000;
        }
    }

    public void setMaxTries(int tries) {
        this.maxTries = tries;
    }

    public void setSleepTime(int sleep) {
        this.sleepTime = sleep;
    }

    @Override
    @WriteOperation
    public void reload() {
        ThemeRegistrationDAOInterface registration = this.getThemeRegistrationDAO();
        if (null != registration) {
            registration.reload();
        }
        this.init(true);
    }

    @WriteOperation
    public void init() {
        this.init(false);
    }

    private void init(boolean synch) {
        this.state = 1;
        List<ApplicationRegistration> registrations = this.getThemeRegistrations();
        if (registrations.isEmpty()) {
            logger.fatal("Unable to find theme registrations; theme data load will be attempted on initial calls.");
            this.state = 2;
        } else {
            for (ApplicationRegistration r : registrations) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting fetcher with maxTries: " + this.maxTries + " and sleep: " + this.sleepTime + ".");
                }
                ThemeDescriptorFetcher fetcher = new ThemeDescriptorFetcher(this, r, this.maxTries, this.sleepTime);
                if (!synch) {
                    Thread t = new Thread(fetcher);
                    t.start();
                } else {
                    fetcher.run();
                }
                ++this.fetcherCount;
            }
        }
        if (synch) {
            this.state = 2;
        }
    }

    public void complete() {
        --this.fetcherCount;
        if (0 == this.fetcherCount) {
            this.state = 2;
        }
    }

    @Override
    public void finish() {
        long totalAllowedTime = this.maxTries * this.sleepTime;
        long startTime = System.currentTimeMillis();
        if (this.state == 0) {
            return;
        }
        while (this.state != 2 && System.currentTimeMillis() - startTime < totalAllowedTime) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

