/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.themes.dao.builder;

import com.sas.framework.commons.AbstractEnum;
import com.sas.framework.themes.client.BrowserType;
import com.sas.framework.themes.client.Image;
import com.sas.framework.themes.client.Style;
import com.sas.framework.themes.client.Template;
import com.sas.framework.themes.client.Theme;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ThemeDocumentHandler
extends DefaultHandler {
    private static final Logger logger = LogManager.getLogger(ThemeDocumentHandler.class);
    private static final String TEMPLATE_ELEMENT = "template";
    private static final String TEMPLATES_ELEMENT = "templates";
    private static final String IMAGE_ELEMENT = "image";
    private static final String IMAGES_ELEMENT = "images";
    private static final String STYLESHEET_ELEMENT = "stylesheet";
    private static final String BROWSER_STYLESHEET_ELEMENT = "browserStyle";
    private static final String STYLES_ELEMENT = "styles";
    private static final String THEME_ELEMENT = "theme";
    private static final String TEMPLATE_MARKUP = "markup";
    private static final String TEMPLATE_DESCRIPTION = "description";
    private static final String TEMPLATE_NAME = "name";
    private static final String TEMPLATE_FILE = "file";
    private static final String TEMPLATES_DIRECTORY = "directory";
    private static final String IMAGE_DESCRIPTION = "description";
    private static final String IMAGE_NAME = "name";
    private static final String IMAGE_FILE = "file";
    private static final String IMAGE_PATH = "path";
    private static final String IMAGE_HEIGHT = "height";
    private static final String IMAGE_WIDTH = "width";
    private static final String IMAGE_ALTTEXTKEY = "altTextKey";
    private static final String IMAGE_APPLIESTO = "appliesTo";
    private static final String IMAGES_DIRECTORY = "directory";
    private static final String IMAGE_RTLFILE = "rightToLeftFile";
    private static final String STYLE_ORDER = "order";
    private static final String STYLE_MEDIA = "media";
    private static final String STYLE_FILE = "file";
    private static final String STYLE_FILE_RTL = "rightToLeftFile";
    private static final String STYLE_DESCRIPTION = "description";
    private static final String STYLE_NAME = "name";
    private static final String STYLE_PRODUCT = "product";
    private static final String STYLE_BROWSER = "browser";
    private static final String STYLES_DIRECTORY = "directory";
    private static final String THEME_NAME = "name";
    private static final String THEME_LABEL = "label";
    private static final String THEME_DESCRIPTION = "description";
    private static final String THEME_DEVICE = "device";
    private static final String THEME_URIPATH = "URIPath";
    private static final String THEME_BUNDLE = "bundle";
    private static final String THEME_VERSION = "version";
    private static final String THEME_RTLSUPPORT = "rightToLeftSupported";
    private Theme theme = new Theme();
    private Style currentStyle = null;
    private String styleDirectory;
    private String imageDirectory;
    private String templateDirectory;
    private boolean rtlSupported;

    public ThemeDocumentHandler(String urlPrefix) {
        this(urlPrefix, urlPrefix);
    }

    public ThemeDocumentHandler(String urlPrefix, String internalUri) {
        this.theme.setUrlPrefix(urlPrefix);
        this.theme.setInternalUrlPrefix(internalUri);
    }

    public Theme getTheme() {
        return this.theme;
    }

    private void parseTheme(Attributes atts) {
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String attValue = atts.getValue(i);
            String attName = atts.getLocalName(i);
            if (attName.equalsIgnoreCase("name")) {
                this.theme.setName(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase(THEME_LABEL)) {
                this.theme.setLabel(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase("description")) {
                this.theme.setDescription(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase(THEME_DEVICE)) {
                this.theme.setDevice(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase(THEME_URIPATH)) {
                this.theme.setPath(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase(THEME_BUNDLE)) {
                this.theme.setBundle(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase(THEME_VERSION)) {
                this.theme.setVersion(attValue.trim());
                continue;
            }
            if (!attName.equalsIgnoreCase(THEME_RTLSUPPORT) || null == attValue) continue;
            this.rtlSupported = Boolean.parseBoolean(attValue.trim());
            this.theme.setRightToLeftSupported(this.rtlSupported);
        }
    }

    private void parseStyles(Attributes atts) {
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String attValue = atts.getValue(i);
            String attName = atts.getLocalName(i);
            if (!attName.equalsIgnoreCase("directory")) continue;
            this.styleDirectory = attValue.trim();
            this.theme.addDirectory("STYLE", this.styleDirectory);
            break;
        }
    }

    private void parseStyleSheet(Attributes atts) {
        Style style = new Style();
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String attValue = atts.getValue(i);
            String attName = atts.getLocalName(i);
            if (attName.equalsIgnoreCase("name")) {
                style.setName(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase("description")) {
                style.setDescription(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase("file")) {
                logger.info("File elements specified directly on the Stylesheet element are ignored by the updated theme processing in favor of multiple BrowserStyle sub-elements. Please see the documentation on multiple browser type support for information on conversion.");
                continue;
            }
            if (attName.equalsIgnoreCase(STYLE_MEDIA)) {
                style.setMediaType(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase(STYLE_PRODUCT)) {
                style.setProduct(attValue.trim());
                continue;
            }
            if (!attName.equalsIgnoreCase(STYLE_ORDER)) continue;
            int order = Integer.parseInt(attValue.trim());
            style.setOrder(order);
        }
        this.currentStyle = style;
        this.theme.addStyleSheet(style);
    }

    private void parseImages(Attributes atts) {
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String attValue = atts.getValue(i);
            String attName = atts.getLocalName(i);
            if (!attName.equalsIgnoreCase("directory")) continue;
            this.imageDirectory = attValue.trim();
            this.theme.addDirectory("IMAGE", this.imageDirectory);
            break;
        }
    }

    private void parseImage(Attributes atts) {
        String standardPath = this.theme.getURIPath() + "/" + this.imageDirectory + "/";
        Image image = new Image();
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String attValue = atts.getValue(i);
            String attName = atts.getLocalName(i);
            if (attName.equalsIgnoreCase("name")) {
                image.setName(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase("description")) {
                image.setDescription(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase(IMAGE_APPLIESTO)) {
                image.setAppliesTo(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase(IMAGE_ALTTEXTKEY)) {
                image.setAltTextKey(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase(IMAGE_WIDTH)) {
                image.setWidth(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase(IMAGE_HEIGHT)) {
                image.setHeight(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase("file")) {
                image.setFileName(attValue.trim());
                image.setFile(standardPath + attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase("rightToLeftFile")) {
                image.setRightToLeftFileName(attValue.trim());
                image.setStandardPath(standardPath);
                continue;
            }
            if (!attName.equalsIgnoreCase(IMAGE_PATH) || this.rtlSupported) continue;
            image.setPath(attValue.trim());
        }
        this.theme.addImage(image);
    }

    private void parseTemplates(Attributes atts) {
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String attValue = atts.getValue(i);
            String attName = atts.getLocalName(i);
            if (!attName.equalsIgnoreCase("directory")) continue;
            this.templateDirectory = attValue.trim();
            this.theme.addDirectory("TEMPLATE", this.templateDirectory);
            break;
        }
    }

    private void parseTemplate(Attributes atts) {
        Template template = new Template();
        int length = atts.getLength();
        for (int i = 0; i < length; ++i) {
            String attValue = atts.getValue(i);
            String attName = atts.getLocalName(i);
            if (attName.equalsIgnoreCase("name")) {
                template.setName(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase("description")) {
                template.setDescription(attValue.trim());
                continue;
            }
            if (attName.equalsIgnoreCase(TEMPLATE_MARKUP)) {
                template.setMarkupLanguage(attValue.trim());
                continue;
            }
            if (!attName.equalsIgnoreCase("file")) continue;
            String filePath = "/" + this.templateDirectory + "/" + attValue.trim();
            template.setFile(this.theme.getURIPath() + filePath);
            template.setInternalFile(this.theme.getInternalURIPath() + filePath);
        }
        this.theme.addTemplate(template);
    }

    private void parseBrowserStyle(Attributes atts) {
        if (null == this.currentStyle) {
            throw new IllegalStateException("Attempt to parse browser style when a stylesheet element is not active. Check the theme definition.");
        }
        String browser = atts.getValue(STYLE_BROWSER);
        String file = atts.getValue("file");
        String fileRTL = atts.getValue("rightToLeftFile");
        BrowserType bType = (BrowserType)AbstractEnum.getInstance((String)browser, (AbstractEnum[])BrowserType.OPTIONS);
        if (null == bType) {
            logger.error("Unable to add stylesheet for browser to theme, '" + this.theme.getName() + "'. It contains an invalid Browser definition. Browser=" + browser + ",file=" + file + ". This may result in an inconsistent display.");
        } else {
            this.currentStyle.addBrowserFile(bType, this.theme.getURIPath() + "/" + this.styleDirectory + "/" + file);
            if (null != fileRTL) {
                this.currentStyle.addBrowserRightToLeftFile(bType, this.theme.getURIPath() + "/" + this.styleDirectory + "/" + fileRTL);
            }
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        if (localName.equalsIgnoreCase(THEME_ELEMENT)) {
            this.parseTheme(atts);
        } else if (localName.equalsIgnoreCase(STYLES_ELEMENT)) {
            this.parseStyles(atts);
        } else if (localName.equalsIgnoreCase(STYLESHEET_ELEMENT)) {
            this.parseStyleSheet(atts);
        } else if (localName.equalsIgnoreCase(BROWSER_STYLESHEET_ELEMENT)) {
            this.parseBrowserStyle(atts);
        } else if (localName.equalsIgnoreCase(IMAGES_ELEMENT)) {
            this.parseImages(atts);
        } else if (localName.equalsIgnoreCase(IMAGE_ELEMENT)) {
            this.parseImage(atts);
        } else if (localName.equalsIgnoreCase(TEMPLATES_ELEMENT)) {
            this.parseTemplates(atts);
        } else if (localName.equalsIgnoreCase(TEMPLATE_ELEMENT)) {
            this.parseTemplate(atts);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        if (localName.equals(STYLESHEET_ELEMENT)) {
            this.currentStyle = null;
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource retval = null;
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("themes.dtd");
        retval = new InputSource(stream);
        return retval;
    }

    public final Theme[] getThemeArray() {
        Theme rtlTheme = null;
        if (this.theme.isRightToLeftSupported()) {
            rtlTheme = this.theme.newRightToLeftTheme();
        }
        Theme[] themes = new Theme[]{this.theme, rtlTheme};
        return themes;
    }
}

