/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.themes.dao.builder;

import com.sas.framework.commons.util.HttpUtil;
import com.sas.framework.themes.dao.builder.UrlThemeDAO;
import com.sas.svcs.config.client.ApplicationRegistration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;

public class ThemeDescriptorFetcher
implements Runnable {
    private static final Logger logger = LogManager.getLogger(ThemeDescriptorFetcher.class);
    private static final String THEMES_DIRECTORY = "/themes/";
    private ApplicationRegistration registration;
    private int maxTries;
    private int sleepTime;
    private UrlThemeDAO dao;

    public ThemeDescriptorFetcher(UrlThemeDAO d, ApplicationRegistration r, int maxTries, int sleepTime) {
        this.registration = r;
        this.maxTries = maxTries;
        this.sleepTime = sleepTime;
        this.dao = d;
        if (logger.isDebugEnabled()) {
            logger.debug("maxTries is: " + maxTries);
            logger.debug("sleep time is: " + sleepTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String uri = this.registration.getUrl();
        String subnet = this.registration.getSubnet();
        BufferedReader bf = null;
        InputSource in = null;
        if (null != uri) {
            try {
                StringBuffer baseURL = new StringBuffer().append(uri);
                baseURL.append(THEMES_DIRECTORY);
                String base = baseURL.toString();
                baseURL.append("ThemeXMLFiles.config");
                URL url = new URL(baseURL.toString());
                String baseFile = HttpUtil.readUrl((URL)url, (int)this.maxTries, (int)this.sleepTime, (String)subnet, (String)"sas.theme.");
                if (null == baseFile) {
                    return;
                }
                bf = new BufferedReader(new StringReader(baseFile));
                String line = bf.readLine();
                URL u = null;
                String body = null;
                while (null != line) {
                    u = new URL(base + line);
                    logger.info("Reading file: " + String.valueOf(u));
                    body = HttpUtil.readUrl((URL)u, (int)this.maxTries, (int)this.sleepTime, (String)subnet, (String)"sas.theme.");
                    if (null != body) {
                        in = new InputSource(new StringReader(body));
                        this.dao.addTheme(in, this.registration.getExternalUrl(), uri);
                        logger.info("Finished reading file: " + String.valueOf(u));
                    }
                    line = bf.readLine();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.dao.complete();
                if (null != bf) {
                    try {
                        bf.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

