/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.themes.dao.builder;

import com.sas.framework.themes.dao.builder.AbstractXmlThemeDAO;
import com.sas.framework.themes.dao.builder.ThemeDAOInterface;
import com.sas.framework.themes.dao.registry.ThemeRegistrationDAOInterface;
import com.sas.svcs.config.client.ApplicationRegistration;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;

public class FileThemeDAO
extends AbstractXmlThemeDAO
implements ThemeDAOInterface {
    private static final Logger logger = LogManager.getLogger(FileThemeDAO.class);
    private static final String THEMES_DIRECTORY = "/themes/";

    @Override
    public void reload() {
        ThemeRegistrationDAOInterface registration = this.getThemeRegistrationDAO();
        if (null != registration) {
            registration.reload();
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        for (ApplicationRegistration registration : this.getThemeRegistrations()) {
            String uri = registration.getContext();
            BufferedReader bf = null;
            InputSource in = null;
            if (null == uri) continue;
            try {
                StringBuffer baseUri = new StringBuffer(uri);
                baseUri.append(THEMES_DIRECTORY);
                String baseUriStr = baseUri.toString();
                baseUri.append("ThemeXMLFiles.config");
                bf = new BufferedReader(new FileReader(baseUri.toString()));
                String line = bf.readLine();
                while (null != line) {
                    String f = baseUriStr + line;
                    logger.info("Reading file: " + f);
                    in = new InputSource(new FileReader(f));
                    this.addTheme(in, uri, uri);
                    logger.info("Finished reading file: " + f);
                    line = bf.readLine();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (null == bf) continue;
                try {
                    bf.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

