/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.themes.dao.builder;

import com.sas.framework.annotation.ReadOperation;
import com.sas.framework.themes.client.Theme;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.themes.dao.builder.ThemeDAOInterface;
import com.sas.framework.themes.dao.builder.ThemeDocumentHandler;
import com.sas.framework.themes.dao.registry.ThemeRegistrationDAOInterface;
import com.sas.svcs.config.client.ApplicationRegistration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXmlThemeDAO
implements ThemeDAOInterface {
    private static Map<String, Theme> themes = new HashMap<String, Theme>();
    private static Map<String, Theme> rtlThemes = new HashMap<String, Theme>();
    private ThemeRegistrationDAOInterface registrationDAO;

    public void setThemeRegistrationDAO(ThemeRegistrationDAOInterface r) {
        this.registrationDAO = r;
    }

    protected ThemeRegistrationDAOInterface getThemeRegistrationDAO() {
        return this.registrationDAO;
    }

    protected void finish() {
    }

    @ReadOperation
    public List<ApplicationRegistration> getThemeRegistrations() {
        return this.registrationDAO.getAllThemes();
    }

    @Override
    @ReadOperation
    public List<Theme> getThemes() {
        this.finish();
        ArrayList<Theme> themeList = new ArrayList<Theme>();
        for (Theme theme : this.getThemesMap().values()) {
            themeList.add(theme);
        }
        return themeList;
    }

    @Override
    @ReadOperation
    public List<String> getThemeNames() {
        this.finish();
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : this.getThemesMap().keySet()) {
            nameList.add(name);
        }
        return nameList;
    }

    @Override
    @ReadOperation
    public List<String> getThemeNamesRightToLeft() {
        this.finish();
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : this.getRtlThemesMap().keySet()) {
            nameList.add(name);
        }
        return nameList;
    }

    @Override
    @ReadOperation
    public Theme getTheme(String name) {
        this.finish();
        return this.getThemesMap().get(name);
    }

    @Override
    @ReadOperation
    public Theme getTheme(String name, boolean rtlEnvironment) {
        this.finish();
        if (rtlEnvironment) {
            return this.getRtlThemesMap().get(name);
        }
        return this.getThemesMap().get(name);
    }

    protected void addTheme(InputSource in, String uri, String internalUri) {
        ThemeDocumentHandler handler = new ThemeDocumentHandler(uri, internalUri);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new ThemeException("Error parsing theme definition, " + uri, e);
        }
        Theme[] themeArray = handler.getThemeArray();
        Theme theme = themeArray[0];
        this.merge(theme, themes);
        Theme rtlTheme = themeArray[1];
        if (null != rtlTheme) {
            this.merge(rtlTheme, rtlThemes);
        }
    }

    private void merge(Theme theme, Map<String, Theme> map) {
        Theme old = map.get(theme.getName());
        if (null != old) {
            theme.merge(old);
            map.remove(theme.getName());
        }
        map.put(theme.getName(), theme);
    }

    protected final void removeTheme(String name) {
        themes.remove(name);
        rtlThemes.remove(name);
    }

    protected Map<String, Theme> getThemesMap() {
        if (themes.isEmpty()) {
            this.reload();
        }
        return themes;
    }

    protected Map<String, Theme> getRtlThemesMap() {
        if (rtlThemes.isEmpty()) {
            this.reload();
        }
        return rtlThemes;
    }
}

