/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.themes.client;

import com.sas.framework.commons.AbstractEnum;
import com.sas.framework.themes.client.BaseThemeElement;
import com.sas.framework.themes.client.BrowserType;
import com.sas.framework.themes.client.MediaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Style
extends BaseThemeElement {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(Style.class);
    private MediaType mediaType;
    private int order;
    private Map browserMap = new HashMap();
    private Map<String, String> browserStringMap = new HashMap<String, String>();
    private Map browserRtlMap = new HashMap();
    private Map<String, String> browserStringRtlMap = new HashMap<String, String>();
    private String product = "";

    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public void setFile(String f) {
        throw new UnsupportedOperationException("setFile is not supported for Style objects. Use addBrowserStyle(...) instead.");
    }

    @Override
    public String getFile() {
        throw new UnsupportedOperationException("getFile is not supported for Style objects. Use getStylesheets(...) instead.");
    }

    public void setMediaType(String type) {
        this.mediaType = (MediaType)AbstractEnum.getInstance((String)type, (AbstractEnum[])MediaType.OPTIONS);
        if (null == this.mediaType) {
            logger.error("Unable to determine media type for " + type + "; Using all.");
            this.mediaType = MediaType.ALL;
        }
    }

    public void addBrowserFile(BrowserType browser, String file) {
        if (browser != BrowserType.FF5) {
            this.browserMap.put(browser, file);
        }
        this.browserStringMap.put(browser.getKey(), file);
    }

    @Deprecated
    public List getStyleSheets(BrowserType browser) {
        return this.getStyleSheets(browser.getKey());
    }

    public List getStyleSheets(String browser) {
        if (this.isRtlEnvironment()) {
            return this.getOrientedStyleSheets(this.browserStringRtlMap, browser);
        }
        return this.getOrientedStyleSheets(this.browserStringMap, browser);
    }

    private List<String> getOrientedStyleSheets(Map<String, String> map, String browser) {
        ArrayList<String> values;
        block3: {
            block5: {
                block4: {
                    values = new ArrayList<String>();
                    String all = map.get(BrowserType.ALL.getKey());
                    if (null != all) {
                        values.add(all);
                    }
                    if (!BrowserType.UNKNOWN.getKey().equals(browser)) break block4;
                    for (int i = 0; i < BrowserType.COMPLIANCE_ORDER.length; ++i) {
                        String css = map.get(BrowserType.COMPLIANCE_ORDER[i].getKey());
                        if (null == css) continue;
                        values.add(css);
                        if (!logger.isDebugEnabled()) break block3;
                        logger.debug("getStyleSheets() returning: " + css);
                        break block3;
                    }
                    break block3;
                }
                String value = map.get(browser);
                if (null == value) break block5;
                values.add(value);
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("getStyleSheets() returning: " + value);
                break block3;
            }
            BrowserType browserType = (BrowserType)BrowserType.getInstance((String)browser, (AbstractEnum[])BrowserType.OPTIONS);
            for (String mapKey : map.keySet()) {
                BrowserType bType = (BrowserType)BrowserType.getInstance((String)mapKey, (AbstractEnum[])BrowserType.OPTIONS);
                if (!browserType.getFamily().equals(bType.getFamily())) continue;
                values.add(map.get(bType.getKey()));
                if (!logger.isDebugEnabled()) break;
                logger.debug("getStyleSheets() returning: " + map.get((Object)bType));
                break;
            }
        }
        return values;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = null == product ? "" : product.toUpperCase();
    }

    public void addBrowserRightToLeftFile(BrowserType browser, String file) {
        if (browser != BrowserType.FF5) {
            this.browserRtlMap.put(browser, file);
        }
        this.browserStringRtlMap.put(browser.getKey(), file);
    }

    Style newRightToLeftInstance() {
        Style rtl = new Style();
        rtl.setRtlEnvironment(true);
        rtl.browserRtlMap.putAll(this.browserRtlMap);
        rtl.browserStringRtlMap.putAll(this.browserStringRtlMap);
        rtl.mediaType = this.getMediaType();
        rtl.setOrder(this.order);
        rtl.setName(this.getName());
        rtl.setDescription(this.getDescription());
        rtl.setProduct(this.getProduct());
        if (logger.isInfoEnabled()) {
            logger.info("newRightToLeftInstance() for: " + rtl.getName() + ", RTL browser map size= " + this.browserRtlMap.size());
        }
        return rtl;
    }
}

