/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.reportrepository.proxy;

import com.sas.svcs.commons.webservice.client.ProxyHelper;
import com.sas.svcs.commons.webservice.client.SecurityTokenServiceClient;
import com.sas.svcs.commons.webservice.client.ServiceRegistryClient;
import com.sas.svcs.reportrepository.client.ProjectContentServiceInterface;
import com.sas.svcs.reportrepository.client.domain.ContentExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.ContentFileExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.ContentMalformedNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.ContentNameNotFoundExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.DeleteProjectContentServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.ExceptionType;
import com.sas.svcs.reportrepository.client.domain.ExistsProjectContentServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.ExistsProjectContentServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.GetProjectContentServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetProjectContentServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.ObjectFactory;
import com.sas.svcs.reportrepository.client.domain.RenameToProjectContentServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.WriteProjectContentServiceInterfaceRequestType;
import jakarta.xml.bind.JAXBElement;
import java.io.Serializable;
import javax.xml.namespace.QName;

public class ProjectContentServiceInterfaceProxy
implements Serializable,
ProjectContentServiceInterface {
    private static final long serialVersionUID = 1L;
    private String url;
    private SecurityTokenServiceClient stsClient;

    public ProjectContentServiceInterfaceProxy(String serviceRegistryUrl) {
        ServiceRegistryClient srClient = new ServiceRegistryClient(serviceRegistryUrl);
        srClient.obtainServices();
        this.url = srClient.getServiceURL("ReportRepositoryService");
    }

    public ProjectContentServiceInterfaceProxy(String serviceUrl, SecurityTokenServiceClient stsClient) {
        this.url = serviceUrl;
        this.stsClient = stsClient;
    }

    public void setStsClient(SecurityTokenServiceClient stsClient) {
        this.stsClient = stsClient;
    }

    public void setServiceUrl(String serviceUrl) {
        this.url = serviceUrl;
    }

    public byte[] get(String projectPathUrl, String projectName) throws ContentNameNotFoundExceptionHolder, ContentFileExceptionHolder, ContentExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/ProjectContentServiceInterface/get";
        GetProjectContentServiceInterfaceRequestType arg = new ObjectFactory().createGetProjectContentServiceInterfaceRequestType();
        arg.setProjectPathUrl(projectPathUrl);
        arg.setProjectName(projectName);
        JAXBElement argDoc = new ObjectFactory().createGetProjectContentServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbAttachmentMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetProjectContentServiceInterfaceResponseType retType = (GetProjectContentServiceInterfaceResponseType)retDocType.getValue();
            byte[] retArg = retType.getContent();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentNameNotFoundException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            ContentNameNotFoundExceptionHolder e = new ContentNameNotFoundExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentFileException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            ContentFileExceptionHolder e = new ContentFileExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            ContentExceptionHolder e = new ContentExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public void write(String projectPathUrl, String projectName, byte[] content) throws ContentNameNotFoundExceptionHolder, ContentFileExceptionHolder, ContentExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/ProjectContentServiceInterface/write";
        WriteProjectContentServiceInterfaceRequestType arg = new ObjectFactory().createWriteProjectContentServiceInterfaceRequestType();
        arg.setProjectPathUrl(projectPathUrl);
        arg.setProjectName(projectName);
        arg.setContent(content);
        JAXBElement argDoc = new ObjectFactory().createWriteProjectContentServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbAttachmentMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentNameNotFoundException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                ContentNameNotFoundExceptionHolder e = new ContentNameNotFoundExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentFileException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                ContentFileExceptionHolder e = new ContentFileExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                ContentExceptionHolder e = new ContentExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public void delete(String projectPathUrl, String projectName) throws ContentNameNotFoundExceptionHolder, ContentFileExceptionHolder, ContentExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/ProjectContentServiceInterface/delete";
        DeleteProjectContentServiceInterfaceRequestType arg = new ObjectFactory().createDeleteProjectContentServiceInterfaceRequestType();
        arg.setProjectPathUrl(projectPathUrl);
        arg.setProjectName(projectName);
        JAXBElement argDoc = new ObjectFactory().createDeleteProjectContentServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentNameNotFoundException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                ContentNameNotFoundExceptionHolder e = new ContentNameNotFoundExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentFileException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                ContentFileExceptionHolder e = new ContentFileExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                ContentExceptionHolder e = new ContentExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public boolean exists(String projectPathUrl, String projectName) throws ContentExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/ProjectContentServiceInterface/exists";
        ExistsProjectContentServiceInterfaceRequestType arg = new ObjectFactory().createExistsProjectContentServiceInterfaceRequestType();
        arg.setProjectPathUrl(projectPathUrl);
        arg.setProjectName(projectName);
        JAXBElement argDoc = new ObjectFactory().createExistsProjectContentServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbAttachmentMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            ExistsProjectContentServiceInterfaceResponseType retType = (ExistsProjectContentServiceInterfaceResponseType)retDocType.getValue();
            boolean retArg = retType.isProjectExists();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            ContentExceptionHolder e = new ContentExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public void renameTo(String projectPathUrl, String projectName, String newName) throws ContentMalformedNameExceptionHolder, ContentNameNotFoundExceptionHolder, ContentExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/ProjectContentServiceInterface/renameTo";
        RenameToProjectContentServiceInterfaceRequestType arg = new ObjectFactory().createRenameToProjectContentServiceInterfaceRequestType();
        arg.setProjectPathUrl(projectPathUrl);
        arg.setProjectName(projectName);
        arg.setNewName(newName);
        JAXBElement argDoc = new ObjectFactory().createRenameToProjectContentServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbAttachmentMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentMalformedNameException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                ContentMalformedNameExceptionHolder e = new ContentMalformedNameExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentNameNotFoundException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                ContentNameNotFoundExceptionHolder e = new ContentNameNotFoundExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "ContentException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                ContentExceptionHolder e = new ContentExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }
}

