/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.reportrepository.proxy;

import com.sas.svcs.commons.webservice.client.ProxyHelper;
import com.sas.svcs.commons.webservice.client.SecurityTokenServiceClient;
import com.sas.svcs.commons.webservice.client.ServiceRegistryClient;
import com.sas.svcs.reportrepository.client.EntryServiceInterface;
import com.sas.svcs.reportrepository.client.domain.AttributesType;
import com.sas.svcs.reportrepository.client.domain.DeleteContentEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.DeleteEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.EntryExistsEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.EntryExistsEntryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.ExceptionType;
import com.sas.svcs.reportrepository.client.domain.GetAttributeEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetAttributeEntryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.GetAttributesEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetContentEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetContentEntryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.GetNameEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetNameEntryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.GetParentEntryEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetParentEntryEntryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.GetSizeOfContentEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetSizeOfContentEntryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.IllegalArgumentExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.IsDirectoryEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.IsDirectoryEntryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.IsEmptyEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.IsEmptyEntryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.ObjectFactory;
import com.sas.svcs.reportrepository.client.domain.RenameToEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.RenameToEntryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.RepositoryDuplicateNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryIOExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryIllegalNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryLockedExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryNotFoundExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.SecurityExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.SetAttributeEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.SetAttributesEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.SetContentEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.SetContentWithOptionEntryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.UnsupportedOperationExceptionHolder;
import jakarta.xml.bind.JAXBElement;
import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;

public class EntryServiceInterfaceProxy
implements Serializable,
EntryServiceInterface {
    private static final long serialVersionUID = 1L;
    private String url;
    private SecurityTokenServiceClient stsClient;

    public EntryServiceInterfaceProxy(String serviceRegistryUrl) {
        ServiceRegistryClient srClient = new ServiceRegistryClient(serviceRegistryUrl);
        srClient.obtainServices();
        this.url = srClient.getServiceURL("ReportRepositoryService");
    }

    public EntryServiceInterfaceProxy(String serviceUrl, SecurityTokenServiceClient stsClient) {
        this.url = serviceUrl;
        this.stsClient = stsClient;
    }

    public void setStsClient(SecurityTokenServiceClient stsClient) {
        this.stsClient = stsClient;
    }

    public void setServiceUrl(String serviceUrl) {
        this.url = serviceUrl;
    }

    public String getName(String entryPathUrl) {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/getName";
        GetNameEntryServiceInterfaceRequestType arg = new ObjectFactory().createGetNameEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        JAXBElement argDoc = new ObjectFactory().createGetNameEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetNameEntryServiceInterfaceResponseType retType = (GetNameEntryServiceInterfaceResponseType)retDocType.getValue();
            String retArg = retType.getEntryName();
            return retArg;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public String getParentEntry(String entryPathUrl) throws RepositoryNotFoundExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/getParentEntry";
        GetParentEntryEntryServiceInterfaceRequestType arg = new ObjectFactory().createGetParentEntryEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        JAXBElement argDoc = new ObjectFactory().createGetParentEntryEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetParentEntryEntryServiceInterfaceResponseType retType = (GetParentEntryEntryServiceInterfaceResponseType)retDocType.getValue();
            String retArg = retType.getDirPathUrl();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryNotFoundException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryNotFoundExceptionHolder e = new RepositoryNotFoundExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public boolean isEmpty(String entryPathUrl) throws RepositoryExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/isEmpty";
        IsEmptyEntryServiceInterfaceRequestType arg = new ObjectFactory().createIsEmptyEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        JAXBElement argDoc = new ObjectFactory().createIsEmptyEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            IsEmptyEntryServiceInterfaceResponseType retType = (IsEmptyEntryServiceInterfaceResponseType)retDocType.getValue();
            boolean retArg = retType.isEmpty();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public boolean isDirectory(String entryPathUrl) {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/isDirectory";
        IsDirectoryEntryServiceInterfaceRequestType arg = new ObjectFactory().createIsDirectoryEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        JAXBElement argDoc = new ObjectFactory().createIsDirectoryEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            IsDirectoryEntryServiceInterfaceResponseType retType = (IsDirectoryEntryServiceInterfaceResponseType)retDocType.getValue();
            boolean retArg = retType.isIsDirectory();
            return retArg;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public boolean entryExists(String entryPathUrl, String entryName) throws RepositoryIllegalNameExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/entryExists";
        EntryExistsEntryServiceInterfaceRequestType arg = new ObjectFactory().createEntryExistsEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setEntryName(entryName);
        JAXBElement argDoc = new ObjectFactory().createEntryExistsEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            EntryExistsEntryServiceInterfaceResponseType retType = (EntryExistsEntryServiceInterfaceResponseType)retDocType.getValue();
            boolean retArg = retType.isEntryExists();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIllegalNameException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryIllegalNameExceptionHolder e = new RepositoryIllegalNameExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public long getSizeOfContent(String entryPathUrl) throws RepositoryExceptionHolder, UnsupportedOperationExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/getSizeOfContent";
        GetSizeOfContentEntryServiceInterfaceRequestType arg = new ObjectFactory().createGetSizeOfContentEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        JAXBElement argDoc = new ObjectFactory().createGetSizeOfContentEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetSizeOfContentEntryServiceInterfaceResponseType retType = (GetSizeOfContentEntryServiceInterfaceResponseType)retDocType.getValue();
            long retArg = retType.getSizeOfContent();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "UnsupportedOperationException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            UnsupportedOperationExceptionHolder e = new UnsupportedOperationExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public byte[] getContent(String entryPathUrl) throws RepositoryIOExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/getContent";
        GetContentEntryServiceInterfaceRequestType arg = new ObjectFactory().createGetContentEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        JAXBElement argDoc = new ObjectFactory().createGetContentEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbAttachmentMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetContentEntryServiceInterfaceResponseType retType = (GetContentEntryServiceInterfaceResponseType)retDocType.getValue();
            byte[] retArg = retType.getContent();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIOException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryIOExceptionHolder e = new RepositoryIOExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public void setContent(String entryPathUrl, byte[] content) throws RepositoryIOExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/setContent";
        SetContentEntryServiceInterfaceRequestType arg = new ObjectFactory().createSetContentEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setContent(content);
        JAXBElement argDoc = new ObjectFactory().createSetContentEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbAttachmentMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIOException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryIOExceptionHolder e = new RepositoryIOExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public void setContentWithOption(String entryPathUrl, byte[] content, boolean deleteCaches) throws RepositoryIOExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/setContentWithOption";
        SetContentWithOptionEntryServiceInterfaceRequestType arg = new ObjectFactory().createSetContentWithOptionEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setContent(content);
        arg.setDeleteCaches(deleteCaches);
        JAXBElement argDoc = new ObjectFactory().createSetContentWithOptionEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbAttachmentMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIOException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryIOExceptionHolder e = new RepositoryIOExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public String renameTo(String entryPathUrl, String newName) throws RepositoryIllegalNameExceptionHolder, RepositoryDuplicateNameExceptionHolder, RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder, IllegalArgumentExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/renameTo";
        RenameToEntryServiceInterfaceRequestType arg = new ObjectFactory().createRenameToEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setNewName(newName);
        JAXBElement argDoc = new ObjectFactory().createRenameToEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            RenameToEntryServiceInterfaceResponseType retType = (RenameToEntryServiceInterfaceResponseType)retDocType.getValue();
            String retArg = retType.getEntryPathUrl();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIllegalNameException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryIllegalNameExceptionHolder e = new RepositoryIllegalNameExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryDuplicateNameException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryDuplicateNameExceptionHolder e = new RepositoryDuplicateNameExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "IllegalArgumentException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            IllegalArgumentExceptionHolder e = new IllegalArgumentExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public void delete(String entryPathUrl) throws RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/delete";
        DeleteEntryServiceInterfaceRequestType arg = new ObjectFactory().createDeleteEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        JAXBElement argDoc = new ObjectFactory().createDeleteEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public void deleteContent(String entryPathUrl) throws RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/deleteContent";
        DeleteContentEntryServiceInterfaceRequestType arg = new ObjectFactory().createDeleteContentEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        JAXBElement argDoc = new ObjectFactory().createDeleteContentEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public List getAttributes(String entryPathUrl) throws RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/getAttributes";
        GetAttributesEntryServiceInterfaceRequestType arg = new ObjectFactory().createGetAttributesEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        JAXBElement argDoc = new ObjectFactory().createGetAttributesEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            AttributesType retType = (AttributesType)retDocType.getValue();
            List retArg = retType.getAttributeEntry();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public Object getAttribute(String entryPathUrl, String attrName) throws RepositoryNotFoundExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/getAttribute";
        GetAttributeEntryServiceInterfaceRequestType arg = new ObjectFactory().createGetAttributeEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setAttrName(attrName);
        JAXBElement argDoc = new ObjectFactory().createGetAttributeEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetAttributeEntryServiceInterfaceResponseType retType = (GetAttributeEntryServiceInterfaceResponseType)retDocType.getValue();
            Object retArg = retType.getAttrValue();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryNotFoundException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryNotFoundExceptionHolder e = new RepositoryNotFoundExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public void setAttributes(String entryPathUrl, AttributesType attributes) throws RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder, IllegalArgumentExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/setAttributes";
        SetAttributesEntryServiceInterfaceRequestType arg = new ObjectFactory().createSetAttributesEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setAttributes(attributes);
        JAXBElement argDoc = new ObjectFactory().createSetAttributesEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "IllegalArgumentException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                IllegalArgumentExceptionHolder e = new IllegalArgumentExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public void setAttribute(String entryPathUrl, String attrName, Object attrValue) throws RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder, IllegalArgumentExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/EntryServiceInterface/setAttribute";
        SetAttributeEntryServiceInterfaceRequestType arg = new ObjectFactory().createSetAttributeEntryServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setAttrName(attrName);
        arg.setAttrValue(attrValue);
        JAXBElement argDoc = new ObjectFactory().createSetAttributeEntryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "IllegalArgumentException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                IllegalArgumentExceptionHolder e = new IllegalArgumentExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }
}

