/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.reportrepository.proxy;

import com.sas.svcs.commons.webservice.client.ProxyHelper;
import com.sas.svcs.commons.webservice.client.SecurityTokenServiceClient;
import com.sas.svcs.commons.webservice.client.ServiceRegistryClient;
import com.sas.svcs.reportrepository.client.DirectoryServiceInterface;
import com.sas.svcs.reportrepository.client.domain.CreateDirectoryDirectoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.CreateDirectoryDirectoryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.CreateEntryDirectoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.CreateEntryDirectoryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.DeleteDirectoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.DeleteWithNoFilterDirectoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.EntryExistsDirectoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.EntryExistsDirectoryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.ExceptionType;
import com.sas.svcs.reportrepository.client.domain.GetDirectoryDirectoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetDirectoryDirectoryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.GetEntryDirectoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetEntryDirectoryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.GetNameDirectoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetNameDirectoryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.IllegalArgumentExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.IsDirectoryDirectoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.IsDirectoryDirectoryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.MoveToDirectoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.ObjectFactory;
import com.sas.svcs.reportrepository.client.domain.RenameToDirectoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.RenameToDirectoryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.RepositoryCreateExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryDeleteExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryDuplicateNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryIllegalNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryLockedExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryNotDirectoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryNotFoundExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.SecurityExceptionHolder;
import jakarta.xml.bind.JAXBElement;
import java.io.Serializable;
import javax.xml.namespace.QName;

public class DirectoryServiceInterfaceProxy
implements Serializable,
DirectoryServiceInterface {
    private static final long serialVersionUID = 1L;
    private String url;
    private SecurityTokenServiceClient stsClient;

    public DirectoryServiceInterfaceProxy(String serviceRegistryUrl) {
        ServiceRegistryClient srClient = new ServiceRegistryClient(serviceRegistryUrl);
        srClient.obtainServices();
        this.url = srClient.getServiceURL("ReportRepositoryService");
    }

    public DirectoryServiceInterfaceProxy(String serviceUrl, SecurityTokenServiceClient stsClient) {
        this.url = serviceUrl;
        this.stsClient = stsClient;
    }

    public void setStsClient(SecurityTokenServiceClient stsClient) {
        this.stsClient = stsClient;
    }

    public void setServiceUrl(String serviceUrl) {
        this.url = serviceUrl;
    }

    public String createEntry(String dirPathUrl, String entryName) throws RepositoryIllegalNameExceptionHolder, RepositoryNotDirectoryExceptionHolder, RepositoryLockedExceptionHolder, RepositoryDuplicateNameExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder, IllegalArgumentExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/DirectoryServiceInterface/createEntry";
        CreateEntryDirectoryServiceInterfaceRequestType arg = new ObjectFactory().createCreateEntryDirectoryServiceInterfaceRequestType();
        arg.setDirPathUrl(dirPathUrl);
        arg.setEntryName(entryName);
        JAXBElement argDoc = new ObjectFactory().createCreateEntryDirectoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            CreateEntryDirectoryServiceInterfaceResponseType retType = (CreateEntryDirectoryServiceInterfaceResponseType)retDocType.getValue();
            String retArg = retType.getEntryPathUrl();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIllegalNameException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryIllegalNameExceptionHolder e = new RepositoryIllegalNameExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryNotDirectoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryNotDirectoryExceptionHolder e = new RepositoryNotDirectoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryDuplicateNameException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryDuplicateNameExceptionHolder e = new RepositoryDuplicateNameExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "IllegalArgumentException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            IllegalArgumentExceptionHolder e = new IllegalArgumentExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public String getEntry(String dirPathUrl, String entryName) throws RepositoryIllegalNameExceptionHolder, RepositoryNotFoundExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/DirectoryServiceInterface/getEntry";
        GetEntryDirectoryServiceInterfaceRequestType arg = new ObjectFactory().createGetEntryDirectoryServiceInterfaceRequestType();
        arg.setDirPathUrl(dirPathUrl);
        arg.setEntryName(entryName);
        JAXBElement argDoc = new ObjectFactory().createGetEntryDirectoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetEntryDirectoryServiceInterfaceResponseType retType = (GetEntryDirectoryServiceInterfaceResponseType)retDocType.getValue();
            String retArg = retType.getEntryPathUrl();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIllegalNameException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryIllegalNameExceptionHolder e = new RepositoryIllegalNameExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryNotFoundException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryNotFoundExceptionHolder e = new RepositoryNotFoundExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public String getDirectory(String dirPathUrl, String dirName) throws RepositoryNotFoundExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/DirectoryServiceInterface/getDirectory";
        GetDirectoryDirectoryServiceInterfaceRequestType arg = new ObjectFactory().createGetDirectoryDirectoryServiceInterfaceRequestType();
        arg.setDirPathUrl(dirPathUrl);
        arg.setDirName(dirName);
        JAXBElement argDoc = new ObjectFactory().createGetDirectoryDirectoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetDirectoryDirectoryServiceInterfaceResponseType retType = (GetDirectoryDirectoryServiceInterfaceResponseType)retDocType.getValue();
            String retArg = retType.getDirPathUrl();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryNotFoundException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryNotFoundExceptionHolder e = new RepositoryNotFoundExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public String getName(String dirPathUrl) {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/DirectoryServiceInterface/getName";
        GetNameDirectoryServiceInterfaceRequestType arg = new ObjectFactory().createGetNameDirectoryServiceInterfaceRequestType();
        arg.setDirPathUrl(dirPathUrl);
        JAXBElement argDoc = new ObjectFactory().createGetNameDirectoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetNameDirectoryServiceInterfaceResponseType retType = (GetNameDirectoryServiceInterfaceResponseType)retDocType.getValue();
            String retArg = retType.getEntryName();
            return retArg;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public boolean entryExists(String dirPathUrl, String entryName) throws RepositoryIllegalNameExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/DirectoryServiceInterface/entryExists";
        EntryExistsDirectoryServiceInterfaceRequestType arg = new ObjectFactory().createEntryExistsDirectoryServiceInterfaceRequestType();
        arg.setDirPathUrl(dirPathUrl);
        arg.setEntryName(entryName);
        JAXBElement argDoc = new ObjectFactory().createEntryExistsDirectoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            EntryExistsDirectoryServiceInterfaceResponseType retType = (EntryExistsDirectoryServiceInterfaceResponseType)retDocType.getValue();
            boolean retArg = retType.isEntryExists();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIllegalNameException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryIllegalNameExceptionHolder e = new RepositoryIllegalNameExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public boolean isDirectory(String dirPathUrl) {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/DirectoryServiceInterface/isDirectory";
        IsDirectoryDirectoryServiceInterfaceRequestType arg = new ObjectFactory().createIsDirectoryDirectoryServiceInterfaceRequestType();
        arg.setDirPathUrl(dirPathUrl);
        JAXBElement argDoc = new ObjectFactory().createIsDirectoryDirectoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            IsDirectoryDirectoryServiceInterfaceResponseType retType = (IsDirectoryDirectoryServiceInterfaceResponseType)retDocType.getValue();
            boolean retArg = retType.isIsDirectory();
            return retArg;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public String renameTo(String dirPathUrl, String newName) throws RepositoryIllegalNameExceptionHolder, RepositoryDuplicateNameExceptionHolder, RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder, IllegalArgumentExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/DirectoryServiceInterface/renameTo";
        RenameToDirectoryServiceInterfaceRequestType arg = new ObjectFactory().createRenameToDirectoryServiceInterfaceRequestType();
        arg.setDirPathUrl(dirPathUrl);
        arg.setNewName(newName);
        JAXBElement argDoc = new ObjectFactory().createRenameToDirectoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            RenameToDirectoryServiceInterfaceResponseType retType = (RenameToDirectoryServiceInterfaceResponseType)retDocType.getValue();
            String retArg = retType.getDirPathUrl();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIllegalNameException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryIllegalNameExceptionHolder e = new RepositoryIllegalNameExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryDuplicateNameException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryDuplicateNameExceptionHolder e = new RepositoryDuplicateNameExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "IllegalArgumentException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            IllegalArgumentExceptionHolder e = new IllegalArgumentExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public void moveTo(String dirPathUrl, String moveToDirPathUrl) throws RepositoryIllegalNameExceptionHolder, RepositoryDuplicateNameExceptionHolder, RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/DirectoryServiceInterface/moveTo";
        MoveToDirectoryServiceInterfaceRequestType arg = new ObjectFactory().createMoveToDirectoryServiceInterfaceRequestType();
        arg.setDirPathUrl(dirPathUrl);
        arg.setMoveToDirPathUrl(moveToDirPathUrl);
        JAXBElement argDoc = new ObjectFactory().createMoveToDirectoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIllegalNameException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryIllegalNameExceptionHolder e = new RepositoryIllegalNameExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryDuplicateNameException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryDuplicateNameExceptionHolder e = new RepositoryDuplicateNameExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public void delete(String dirPathUrl) throws RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/DirectoryServiceInterface/delete";
        DeleteDirectoryServiceInterfaceRequestType arg = new ObjectFactory().createDeleteDirectoryServiceInterfaceRequestType();
        arg.setDirPathUrl(dirPathUrl);
        JAXBElement argDoc = new ObjectFactory().createDeleteDirectoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public void deleteWithNoFilter(String dirPathUrl) throws RepositoryDeleteExceptionHolder, RepositoryExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/DirectoryServiceInterface/deleteWithNoFilter";
        DeleteWithNoFilterDirectoryServiceInterfaceRequestType arg = new ObjectFactory().createDeleteWithNoFilterDirectoryServiceInterfaceRequestType();
        arg.setDirPathUrl(dirPathUrl);
        JAXBElement argDoc = new ObjectFactory().createDeleteWithNoFilterDirectoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryDeleteException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryDeleteExceptionHolder e = new RepositoryDeleteExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public String createDirectory(String dirPathUrl, String dirName) throws RepositoryCreateExceptionHolder, RepositoryIllegalNameExceptionHolder, RepositoryLockedExceptionHolder, RepositoryDuplicateNameExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder, IllegalArgumentExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/DirectoryServiceInterface/createDirectory";
        CreateDirectoryDirectoryServiceInterfaceRequestType arg = new ObjectFactory().createCreateDirectoryDirectoryServiceInterfaceRequestType();
        arg.setDirPathUrl(dirPathUrl);
        arg.setDirName(dirName);
        JAXBElement argDoc = new ObjectFactory().createCreateDirectoryDirectoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            CreateDirectoryDirectoryServiceInterfaceResponseType retType = (CreateDirectoryDirectoryServiceInterfaceResponseType)retDocType.getValue();
            String retArg = retType.getDirPathUrl();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryCreateException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryCreateExceptionHolder e = new RepositoryCreateExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIllegalNameException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryIllegalNameExceptionHolder e = new RepositoryIllegalNameExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryDuplicateNameException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryDuplicateNameExceptionHolder e = new RepositoryDuplicateNameExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "IllegalArgumentException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            IllegalArgumentExceptionHolder e = new IllegalArgumentExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }
}

