/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.reportrepository.proxy;

import com.sas.svcs.commons.webservice.client.ProxyHelper;
import com.sas.svcs.commons.webservice.client.SecurityTokenServiceClient;
import com.sas.svcs.commons.webservice.client.ServiceRegistryClient;
import com.sas.svcs.reportrepository.client.CacheItemServiceInterface;
import com.sas.svcs.reportrepository.client.domain.AttributesType;
import com.sas.svcs.reportrepository.client.domain.DeleteCacheItemServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.ExceptionType;
import com.sas.svcs.reportrepository.client.domain.GetAttributeCacheItemServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetAttributeCacheItemServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.GetAttributesCacheItemServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetContentCacheItemServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetContentCacheItemServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.GetSizeOfContentsCacheItemServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetSizeOfContentsCacheItemServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.LockCacheItemServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.ObjectFactory;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryIOExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryLockedExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryNotFoundExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.SecurityExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.SetAttributeCacheItemServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.SetAttributesCacheItemServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.SetContentCacheItemServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.UnlockCacheItemServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.UnsupportedOperationExceptionHolder;
import jakarta.xml.bind.JAXBElement;
import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;

public class CacheItemServiceInterfaceProxy
implements Serializable,
CacheItemServiceInterface {
    private static final long serialVersionUID = 1L;
    private String url;
    private SecurityTokenServiceClient stsClient;

    public CacheItemServiceInterfaceProxy(String serviceRegistryUrl) {
        ServiceRegistryClient srClient = new ServiceRegistryClient(serviceRegistryUrl);
        srClient.obtainServices();
        this.url = srClient.getServiceURL("ReportRepositoryService");
    }

    public CacheItemServiceInterfaceProxy(String serviceUrl, SecurityTokenServiceClient stsClient) {
        this.url = serviceUrl;
        this.stsClient = stsClient;
    }

    public void setStsClient(SecurityTokenServiceClient stsClient) {
        this.stsClient = stsClient;
    }

    public void setServiceUrl(String serviceUrl) {
        this.url = serviceUrl;
    }

    public byte[] getContent(String entryPathUrl, String cacheName, String cacheItemName) throws RepositoryIOExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheItemServiceInterface/getContent";
        GetContentCacheItemServiceInterfaceRequestType arg = new ObjectFactory().createGetContentCacheItemServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        arg.setCacheItemName(cacheItemName);
        JAXBElement argDoc = new ObjectFactory().createGetContentCacheItemServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbAttachmentMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetContentCacheItemServiceInterfaceResponseType retType = (GetContentCacheItemServiceInterfaceResponseType)retDocType.getValue();
            byte[] retArg = retType.getContent();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIOException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryIOExceptionHolder e = new RepositoryIOExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public void setContent(String entryPathUrl, String cacheName, String cacheItemName, byte[] content) throws RepositoryIOExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheItemServiceInterface/setContent";
        SetContentCacheItemServiceInterfaceRequestType arg = new ObjectFactory().createSetContentCacheItemServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        arg.setCacheItemName(cacheItemName);
        arg.setContent(content);
        JAXBElement argDoc = new ObjectFactory().createSetContentCacheItemServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbAttachmentMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIOException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryIOExceptionHolder e = new RepositoryIOExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public long getSizeOfContents(String entryPathUrl, String cacheName, String cacheItemName) throws RepositoryExceptionHolder, UnsupportedOperationExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheItemServiceInterface/getSizeOfContents";
        GetSizeOfContentsCacheItemServiceInterfaceRequestType arg = new ObjectFactory().createGetSizeOfContentsCacheItemServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        arg.setCacheItemName(cacheItemName);
        JAXBElement argDoc = new ObjectFactory().createGetSizeOfContentsCacheItemServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetSizeOfContentsCacheItemServiceInterfaceResponseType retType = (GetSizeOfContentsCacheItemServiceInterfaceResponseType)retDocType.getValue();
            long retArg = retType.getSizeOfContent();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "UnsupportedOperationException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            UnsupportedOperationExceptionHolder e = new UnsupportedOperationExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public void delete(String entryPathUrl, String cacheName, String cacheItemName) throws RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheItemServiceInterface/delete";
        DeleteCacheItemServiceInterfaceRequestType arg = new ObjectFactory().createDeleteCacheItemServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        arg.setCacheItemName(cacheItemName);
        JAXBElement argDoc = new ObjectFactory().createDeleteCacheItemServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public Object getAttribute(String entryPathUrl, String cacheName, String cacheItemName, String attrName) throws RepositoryLockedExceptionHolder, RepositoryNotFoundExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheItemServiceInterface/getAttribute";
        GetAttributeCacheItemServiceInterfaceRequestType arg = new ObjectFactory().createGetAttributeCacheItemServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        arg.setCacheItemName(cacheItemName);
        arg.setAttrName(attrName);
        JAXBElement argDoc = new ObjectFactory().createGetAttributeCacheItemServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetAttributeCacheItemServiceInterfaceResponseType retType = (GetAttributeCacheItemServiceInterfaceResponseType)retDocType.getValue();
            Object retArg = retType.getAttrValue();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryNotFoundException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryNotFoundExceptionHolder e = new RepositoryNotFoundExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public List getAttributes(String entryPathUrl, String cacheName, String cacheItemName) throws RepositoryLockedExceptionHolder, RepositoryNotFoundExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheItemServiceInterface/getAttributes";
        GetAttributesCacheItemServiceInterfaceRequestType arg = new ObjectFactory().createGetAttributesCacheItemServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        arg.setCacheItemName(cacheItemName);
        JAXBElement argDoc = new ObjectFactory().createGetAttributesCacheItemServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            AttributesType retType = (AttributesType)retDocType.getValue();
            List retArg = retType.getAttributeEntry();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryNotFoundException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryNotFoundExceptionHolder e = new RepositoryNotFoundExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            SecurityExceptionHolder e = new SecurityExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public void setAttribute(String entryPathUrl, String cacheName, String cacheItemName, String attrName, Object attrValue) throws RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheItemServiceInterface/setAttribute";
        SetAttributeCacheItemServiceInterfaceRequestType arg = new ObjectFactory().createSetAttributeCacheItemServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        arg.setCacheItemName(cacheItemName);
        arg.setAttrName(attrName);
        arg.setAttrValue(attrValue);
        JAXBElement argDoc = new ObjectFactory().createSetAttributeCacheItemServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public void setAttributes(String entryPathUrl, String cacheName, String cacheItemName, AttributesType attributes) throws RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheItemServiceInterface/setAttributes";
        SetAttributesCacheItemServiceInterfaceRequestType arg = new ObjectFactory().createSetAttributesCacheItemServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        arg.setCacheItemName(cacheItemName);
        arg.setAttributes(attributes);
        JAXBElement argDoc = new ObjectFactory().createSetAttributesCacheItemServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public void lock(String entryPathUrl, String cacheName, String cacheItemName) throws RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheItemServiceInterface/lock";
        LockCacheItemServiceInterfaceRequestType arg = new ObjectFactory().createLockCacheItemServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        arg.setCacheItemName(cacheItemName);
        JAXBElement argDoc = new ObjectFactory().createLockCacheItemServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public void unlock(String entryPathUrl, String cacheName, String cacheItemName) throws RepositoryLockedExceptionHolder, RepositoryExceptionHolder, SecurityExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheItemServiceInterface/unlock";
        UnlockCacheItemServiceInterfaceRequestType arg = new ObjectFactory().createUnlockCacheItemServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        arg.setCacheItemName(cacheItemName);
        JAXBElement argDoc = new ObjectFactory().createUnlockCacheItemServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "SecurityException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                SecurityExceptionHolder e = new SecurityExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }
}

