/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.xml.data;

import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.StringCompare;
import com.sas.graphics.xml.GraphParserUtils;
import com.sas.graphics.xml.data.Mapping;
import com.sas.text.PictureFormatDescription;
import com.sas.text.PictureOptions;
import com.sas.text.PictureRangeSegment;
import com.sas.text.SASPictureFormat;
import com.sas.text.SASValueFormat;
import com.sas.text.ValueFormatDescription;
import com.sas.util.MissingValueRangeSegment;
import com.sas.util.NumericRangeSegment;
import com.sas.util.RangeSegment;
import com.sas.util.StringRangeSegment;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

class FormatStruct {
    private static ResourceBundle rb = ResourceLoader.loadBundle("com.sas.graphics.xml.data.graph_xml_data_NLS");
    private static String[] keywords = new String[]{"low", "high", "other", "picture", "value", "Invalue"};
    private static int KW_LOW = 0;
    private static int KW_HIGH = 1;
    private static int KW_OTHER = 2;
    String name = null;
    boolean setValueFormat = false;
    String min = null;
    String max = null;
    String defaultWidth = null;
    boolean round = false;
    boolean notsorted = false;
    Vector mappings = new Vector();

    FormatStruct() {
    }

    public void addMapping(Mapping m) {
        if (m != null) {
            this.mappings.addElement(m);
        }
    }

    public void registerFormat() {
        ValueFormatDescription vf = null;
        PictureFormatDescription pf = null;
        if (this.setValueFormat) {
            vf = SASValueFormat.createValueFormat((String)this.name);
            if (this.min != null) {
                vf.setMinWidth(GraphParserUtils.getIntValue(this.min));
            }
            if (this.max != null) {
                vf.setMaxWidth(GraphParserUtils.getIntValue(this.max));
            }
            if (this.defaultWidth != null) {
                vf.setDefaultWidth(GraphParserUtils.getIntValue(this.defaultWidth));
            }
            vf.setNotSorted(this.notsorted);
        } else {
            pf = SASPictureFormat.createPictureFormat((String)this.name);
            if (this.min != null) {
                pf.setMinWidth(GraphParserUtils.getIntValue(this.min));
            }
            if (this.max != null) {
                pf.setMaxWidth(GraphParserUtils.getIntValue(this.max));
            }
            if (this.defaultWidth != null) {
                pf.setDefaultWidth(GraphParserUtils.getIntValue(this.defaultWidth));
            }
            pf.setRound(this.round);
            pf.setNotSorted(this.notsorted);
        }
        for (int i = 0; i < this.mappings.size(); ++i) {
            FormatStruct.setRangeSegment((Mapping)this.mappings.elementAt(i), pf, vf);
        }
    }

    private static void setRangeSegment(Mapping mapping, PictureFormatDescription pf, ValueFormatDescription vf) {
        boolean sexcl = false;
        boolean eexcl = false;
        boolean negative = false;
        boolean pushBack = false;
        StringTokenizer parser = new StringTokenizer(mapping.range, ",-<", true);
        int tokenCount = parser.countTokens();
        String token = "";
        String lastToken = "";
        if (tokenCount != 1) {
            Vector<String> v = new Vector<String>();
            block5: while (parser.hasMoreTokens()) {
                char c1;
                if (!pushBack) {
                    lastToken = token;
                    token = parser.nextToken().trim();
                } else {
                    pushBack = false;
                }
                if (token.length() == 1) {
                    switch (token.charAt(0)) {
                        case ',': {
                            if (v.size() == 1) {
                                FormatStruct.addSegment(v.elementAt(0), v.elementAt(0), sexcl, eexcl, mapping.label, pf, vf, mapping.pictureOptions);
                            } else {
                                FormatStruct.addSegment(v.elementAt(0), v.elementAt(1), sexcl, eexcl, mapping.label, pf, vf, mapping.pictureOptions);
                            }
                            v.removeAllElements();
                            eexcl = false;
                            sexcl = false;
                            continue block5;
                        }
                        case '-': {
                            negative = true;
                            continue block5;
                        }
                        case '<': {
                            if (lastToken.equals("-")) {
                                eexcl = true;
                                continue block5;
                            }
                            sexcl = true;
                            if (!parser.hasMoreTokens()) continue block5;
                            lastToken = token;
                            token = parser.nextToken().trim();
                            if (token.equals("-")) continue block5;
                            pushBack = true;
                            continue block5;
                        }
                    }
                    if (negative) {
                        c1 = token.charAt(0);
                        if (Character.isDigit(c1) || c1 == '.' && token.length() >= 2 && Character.isDigit(token.charAt(1))) {
                            v.addElement('-' + token);
                        }
                        negative = false;
                    } else {
                        v.addElement(token);
                    }
                    if (!parser.hasMoreTokens()) continue;
                    lastToken = token;
                    token = parser.nextToken().trim();
                    if (token.equals("-")) continue;
                    pushBack = true;
                    continue;
                }
                if (negative) {
                    c1 = token.charAt(0);
                    if (Character.isDigit(c1) || c1 == '.' && token.length() >= 2 && Character.isDigit(token.charAt(1))) {
                        v.addElement('-' + token);
                    }
                    negative = false;
                } else {
                    v.addElement(token);
                }
                if (!parser.hasMoreTokens()) continue;
                lastToken = token;
                token = parser.nextToken().trim();
                if (token.equals("-")) continue;
                pushBack = true;
            }
            if (v.size() == 1) {
                FormatStruct.addSegment(v.elementAt(0), v.elementAt(0), sexcl, eexcl, mapping.label, pf, vf, mapping.pictureOptions);
            } else {
                FormatStruct.addSegment(v.elementAt(0), v.elementAt(1), sexcl, eexcl, mapping.label, pf, vf, mapping.pictureOptions);
            }
        } else {
            token = parser.nextToken();
            if (token.equalsIgnoreCase(keywords[KW_OTHER])) {
                if (pf != null) {
                    pf.setOtherValue(mapping.label);
                } else {
                    vf.setOtherValue(mapping.label);
                }
                if (mapping.pictureOptions != null) {
                    pf.setPictureOptions(mapping.pictureOptions);
                }
            } else {
                FormatStruct.addSegment(token, token, false, false, mapping.label, pf, vf, mapping.pictureOptions);
            }
        }
    }

    private static void addSegment(Object min, Object max, boolean sexcl, boolean eexcl, String value, PictureFormatDescription pf, ValueFormatDescription vf, PictureOptions po) {
        RangeSegment segment = null;
        String start = (String)min;
        String end = (String)max;
        if (start.charAt(0) != '.' && end.charAt(0) != '.') {
            if (pf != null && pf.isCharacterFormat()) {
                segment = FormatStruct.addCharacterRange(start, end);
            } else if (vf != null && vf.isCharacterFormat()) {
                segment = FormatStruct.addCharacterRange(start, end);
            } else {
                segment = FormatStruct.addNumericRange(start, end);
                if (po != null) {
                    segment = new PictureRangeSegment((NumericRangeSegment)segment, po);
                }
            }
        } else if (start.charAt(0) == '.' && end.charAt(0) == '.') {
            segment = new MissingValueRangeSegment(start, end);
            if (po != null) {
                segment = new PictureRangeSegment((MissingValueRangeSegment)segment, po);
            }
        }
        segment.setValue((Object)value);
        segment.setMinExclude(sexcl);
        segment.setMaxExclude(eexcl);
        if (pf != null) {
            pf.addRangeSegment(segment);
        } else {
            vf.addRangeSegment(segment);
        }
    }

    private static RangeSegment addCharacterRange(String min, String max) {
        if (min.equalsIgnoreCase(keywords[KW_HIGH]) || max.equalsIgnoreCase(keywords[KW_LOW]) || StringCompare.compareTo(min, max) > 0) {
            throw new RuntimeException(ResourceLoader.getResourceString(rb, "FormatParser.Error.BadRange.txt", "Error: Start value is greater then end value"));
        }
        String end = max.equalsIgnoreCase(keywords[KW_HIGH]) ? null : (max.charAt(0) == '\'' && max.charAt(max.length() - 1) == '\'' ? max.substring(1, max.length() - 1) : max);
        String start = min.equalsIgnoreCase(keywords[KW_LOW]) ? null : (min.charAt(0) == '\'' && min.charAt(min.length() - 1) == '\'' ? min.substring(1, min.length() - 1) : min);
        return new StringRangeSegment(start, end);
    }

    private static RangeSegment addNumericRange(String min, String max) {
        double end;
        double start;
        char c = min.charAt(0);
        if (min.equalsIgnoreCase(keywords[KW_LOW])) {
            start = Double.NEGATIVE_INFINITY;
        } else if (min.equalsIgnoreCase(keywords[KW_HIGH])) {
            start = Double.POSITIVE_INFINITY;
        } else if (c == '-' || Character.isDigit(c)) {
            start = Double.valueOf(min);
        } else {
            throw new RuntimeException(FormatStruct.getMessage("FormatParser.Error.NumericFormatErr.msg.txt", "Error: The quoted string {0} is not acceptable to a numeric format", new Object[]{min}));
        }
        c = max.charAt(0);
        if (max.equalsIgnoreCase(keywords[KW_LOW])) {
            end = Double.NEGATIVE_INFINITY;
        } else if (max.equalsIgnoreCase(keywords[KW_HIGH])) {
            end = Double.POSITIVE_INFINITY;
        } else if (c == '-' || Character.isDigit(c)) {
            end = Double.valueOf(max);
        } else {
            throw new RuntimeException(FormatStruct.getMessage("FormatParser.Error.NumericFormatErr.msg.txt", "Error: The quoted string {0} is not acceptable to a numeric format", new Object[]{max}));
        }
        return new NumericRangeSegment(start, end);
    }

    private static String getMessage(String key, String defaultValue, Object[] arguments) {
        String msg = ResourceLoader.getResourceString(rb, key, defaultValue);
        return MessageFormat.format(msg, arguments);
    }
}

