/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.ods.data;

import com.sas.graphics.util.ods.data.BaseDataVariable;
import com.sas.graphics.util.ods.data.DataVariableInterface;
import com.sas.text.FormatDescription;
import com.sas.text.SASUserDefinedFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;

public class BaseData {
    protected Locale locale;
    protected Vector columns;

    public BaseData(Locale localeIn) {
        this.locale = localeIn;
        this.columns = new Vector();
    }

    public int GetNumberColumns() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.size();
    }

    public DataVariableInterface GetColumn(int index) {
        DataVariableInterface dv = null;
        if (this.columns == null || index < 0 || index >= this.columns.size()) {
            return null;
        }
        dv = (DataVariableInterface)this.columns.elementAt(index);
        return dv;
    }

    public DataVariableInterface GetColumn(String varName) {
        DataVariableInterface dv = null;
        if (varName == null || varName.length() <= 0) {
            return null;
        }
        int i = 0;
        while ((dv = this.GetColumn(i)) != null && !varName.equals(dv.GetName())) {
            ++i;
        }
        return dv;
    }

    public String GetColumnName(int index) {
        DataVariableInterface dv = this.GetColumn(index);
        if (dv == null) {
            return null;
        }
        return dv.GetName();
    }

    public String GetColumnDescription(int index) {
        DataVariableInterface dv = this.GetColumn(index);
        if (dv == null) {
            return null;
        }
        return dv.GetDescription();
    }

    public Class GetColumnObjectClass(int index) {
        DataVariableInterface dv = this.GetColumn(index);
        if (dv == null) {
            return null;
        }
        return dv.GetObjectClass();
    }

    public DataVariableInterface AddVariable(Class classType, String varName, String varDescription) {
        return this.AddVariable(classType, varName, varDescription, null);
    }

    public DataVariableInterface AddVariable(Class classType, String varName, String varDescription, Object dataIn) {
        BaseDataVariable dv = null;
        dv = new BaseDataVariable(this.locale, classType, varName, varDescription, dataIn);
        if (dv == null) {
            return null;
        }
        this.columns.addElement(dv);
        return dv;
    }

    public void AddVariable(DataVariableInterface var) {
        if (var != null) {
            this.columns.addElement(var);
        }
    }

    public boolean DeleteColumn(Object obj) {
        boolean status = false;
        int count = this.GetNumberColumns();
        if (this.columns == null || count <= 0 || obj == null || !(obj instanceof DataVariableInterface)) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (obj != this.columns.elementAt(i)) continue;
            this.columns.removeElementAt(i);
            status = true;
            break;
        }
        return status;
    }

    public int GetNumberRows() {
        int min = -1;
        int count = this.GetNumberColumns();
        DataVariableInterface dv = null;
        if (count <= 0) {
            return 0;
        }
        for (int i = 0; i < count; ++i) {
            dv = this.GetColumn(i);
            if (dv == null) continue;
            int n = dv.GetNumberValues();
            if (min >= 0 && n >= min) continue;
            min = n;
        }
        if (min < 0) {
            return 0;
        }
        return min;
    }

    public Object GetCell(int irow, int icol) {
        int nRows = this.GetNumberRows();
        int nCols = this.GetNumberColumns();
        Object cell = null;
        DataVariableInterface dv = this.GetColumn(icol);
        if (irow < 0 || irow >= nRows || icol < 0 || icol >= nCols || dv == null) {
            return null;
        }
        return dv.GetValue(irow);
    }

    public Object[] GetRow(int idx) {
        int nRows = this.GetNumberRows();
        int nCols = this.GetNumberColumns();
        Object[] row = null;
        if (idx < 0 || idx >= nRows || nCols == 0) {
            return null;
        }
        row = new Object[nCols];
        if (row == null) {
            return null;
        }
        for (int i = 0; i < nCols; ++i) {
            row[i] = this.GetCell(idx, i);
        }
        return row;
    }

    public boolean DefineUserFormat(String definition) {
        FormatDescription fd = null;
        if (definition == null) {
            return false;
        }
        try {
            fd = SASUserDefinedFormat.createFormat((String)definition);
            if (fd == null) {
                return false;
            }
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }
}

