/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.ComparatorFactory;
import java.util.Comparator;
import java.util.Locale;

public class StringCompare {
    protected static boolean keepCase = ResourceLoader.getPropertyBoolean("Graph.config", "Global.VariablesAreCaseSensitive", false);
    protected static Comparator comparatorCaseSensitive = ComparatorFactory.createComparator((Locale)Locale.getDefault());
    protected static Comparator comparatorCaseInsensitive = ComparatorFactory.createCaseInsensitiveComparator();

    public static int compareTo(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        if (!keepCase) {
            return comparatorCaseInsensitive.compare(s1, s2);
        }
        return comparatorCaseSensitive.compare(s1, s2);
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (keepCase) {
            return s1.equals(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }
}

