/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.CompareInterface;
import com.sas.graphics.util.StringCompare;
import java.util.List;

public class Sort {
    protected static final int NUMERIC = 0;
    protected static final int STRING = 1;

    public static void heapsort(int[] sortlist, int n_in) {
        int n = n_in;
        if (sortlist == null || sortlist.length == 0) {
            return;
        }
        if (n < 0) {
            n = sortlist.length;
        }
        int parent = n / 2 + 1;
        int curlen = n;
        while (true) {
            int holder;
            if (parent > 1) {
                holder = sortlist[--parent - 1];
            } else {
                holder = sortlist[curlen - 1];
                sortlist[curlen - 1] = sortlist[0];
                if (--curlen == 0) {
                    sortlist[0] = holder;
                    return;
                }
            }
            int curnode = parent;
            int largest_child = parent + parent;
            while (largest_child <= curlen) {
                if (largest_child < curlen && sortlist[largest_child - 1] < sortlist[largest_child]) {
                    ++largest_child;
                }
                if (holder < sortlist[largest_child - 1]) {
                    sortlist[curnode - 1] = sortlist[largest_child - 1];
                    curnode = largest_child;
                    largest_child += largest_child;
                    continue;
                }
                largest_child = curlen + 1;
            }
            sortlist[curnode - 1] = holder;
        }
    }

    protected static int intValue(List v, int idx) {
        return (Integer)v.get(idx);
    }

    public static int compare(int type, CompareInterface ci, Object value, Object vecEntry) {
        switch (type) {
            default: {
                if (ci == null) {
                    return Sort.compare((Number)value, (Number)vecEntry);
                }
                return Sort.compare(ci.getNumericElement(value), ci.getNumericElement(vecEntry));
            }
            case 1: 
        }
        if (ci == null) {
            return Sort.compare((String)value, (String)vecEntry);
        }
        return Sort.compare(ci.getStringElement(value), ci.getStringElement(vecEntry));
    }

    public static int compare(String value, String vecEntry) {
        String s1 = value;
        String s2 = vecEntry;
        int compare = StringCompare.compareTo(s1, s2);
        if (compare < 0) {
            return -1;
        }
        if (compare > 0) {
            return 1;
        }
        return 0;
    }

    public static int compare(Number value, Number vecEntry) {
        return Sort.compare(value.doubleValue(), vecEntry.doubleValue());
    }

    public static int compare(double value, double vecEntry) {
        boolean valMiss = Double.isNaN(value);
        boolean vecMiss = Double.isNaN(vecEntry);
        if (valMiss || vecMiss) {
            if (valMiss && !vecMiss) {
                return -1;
            }
            if (vecMiss && !valMiss) {
                return 1;
            }
            return 0;
        }
        if (value < vecEntry) {
            return -1;
        }
        if (value > vecEntry) {
            return 1;
        }
        return 0;
    }

    protected static final int getListType(Class listType, List v) {
        int out = 0;
        if (listType == null) {
            Object o = v.get(0);
            if (o == null) {
                return 0;
            }
            if (o instanceof String) {
                return 1;
            }
            return 0;
        }
        if (listType == String.class) {
            return 1;
        }
        return out;
    }

    public static boolean heapsort(Class listType, List sortlist, List indicies, int n_in, CompareInterface ci) {
        int type = Sort.getListType(listType, sortlist);
        int n = n_in;
        if (sortlist == null || indicies == null) {
            return false;
        }
        if (n < 0) {
            n = sortlist.size();
        }
        if (n < 1 || indicies.size() < n) {
            return false;
        }
        int parent = n / 2 + 1;
        int curlen = n;
        while (true) {
            Integer holder;
            if (parent > 1) {
                holder = (Integer)indicies.get(--parent - 1);
            } else {
                holder = (Integer)indicies.get(curlen - 1);
                indicies.set(curlen - 1, indicies.get(0));
                if (--curlen == 0) {
                    indicies.set(0, holder);
                    return true;
                }
            }
            int curnode = parent;
            int largest_child = parent + parent;
            while (largest_child <= curlen) {
                if (largest_child < curlen && Sort.compare(type, ci, sortlist.get(Sort.intValue(indicies, largest_child - 1)), sortlist.get(Sort.intValue(indicies, largest_child))) < 0) {
                    ++largest_child;
                }
                if (Sort.compare(type, ci, sortlist.get(holder), sortlist.get(Sort.intValue(indicies, largest_child - 1))) < 0) {
                    indicies.set(curnode - 1, indicies.get(largest_child - 1));
                    curnode = largest_child;
                    largest_child += largest_child;
                    continue;
                }
                largest_child = curlen + 1;
            }
            indicies.set(curnode - 1, holder);
        }
    }

    public static boolean heapsort(Class listType, List sortlist, int[] indicies, int n_in, CompareInterface ci) {
        int type = Sort.getListType(listType, sortlist);
        int n = n_in;
        if (sortlist == null || indicies == null) {
            return false;
        }
        if (n < 0) {
            n = sortlist.size();
        }
        if (n < 1 || indicies.length < n) {
            return false;
        }
        int parent = n / 2 + 1;
        int curlen = n;
        while (true) {
            int holder;
            if (parent > 1) {
                holder = indicies[--parent - 1];
            } else {
                holder = indicies[curlen - 1];
                indicies[curlen - 1] = indicies[0];
                if (--curlen == 0) {
                    indicies[0] = holder;
                    return true;
                }
            }
            int curnode = parent;
            int largest_child = parent + parent;
            while (largest_child <= curlen) {
                if (largest_child < curlen && Sort.compare(type, ci, sortlist.get(indicies[largest_child - 1]), sortlist.get(indicies[largest_child])) < 0) {
                    ++largest_child;
                }
                if (Sort.compare(type, ci, sortlist.get(holder), sortlist.get(indicies[largest_child - 1])) < 0) {
                    indicies[curnode - 1] = indicies[largest_child - 1];
                    curnode = largest_child;
                    largest_child += largest_child;
                    continue;
                }
                largest_child = curlen + 1;
            }
            indicies[curnode - 1] = holder;
        }
    }
}

