/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.util.PropertyMulticaster;
import java.util.Vector;
import javax.swing.JComponent;

public class PropertyUtils {
    public static Object getPropertyValue(Vector interfaces, int property) {
        Object retVal = null;
        if (interfaces == null || interfaces.size() < 1) {
            return null;
        }
        retVal = ((PropertyInterface)interfaces.elementAt(0)).getPropertyValue(property);
        if (retVal == null) {
            return null;
        }
        if (retVal instanceof PropertyInterface) {
            if (interfaces.size() == 1) {
                return retVal;
            }
            PropertyMulticaster pm = new PropertyMulticaster();
            for (int i = 0; i < interfaces.size(); ++i) {
                Object o = ((PropertyInterface)interfaces.elementAt(i)).getPropertyValue(property);
                if (!(o instanceof PropertyInterface)) continue;
                pm.addListener((PropertyInterface)o);
            }
            return pm;
        }
        for (int i = 1; i < interfaces.size(); ++i) {
            if (retVal.equals(((PropertyInterface)interfaces.elementAt(i)).getPropertyValue(property))) continue;
            retVal = null;
            break;
        }
        return retVal;
    }

    public static void setPropertyValue(Vector interfaces, int property, Object value) {
        if (interfaces == null || interfaces.size() < 1) {
            return;
        }
        for (int i = 0; i < interfaces.size(); ++i) {
            ((PropertyInterface)interfaces.elementAt(i)).setPropertyValue(property, value);
        }
    }

    public static final JComponent getJComponent(Vector interfaces) {
        if (interfaces == null) {
            return null;
        }
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            if (!(interfaces.elementAt(i) instanceof JComponent)) continue;
            return (JComponent)interfaces.elementAt(i);
        }
        return null;
    }

    public static boolean addPropertyListener(Vector interfaces, PropertyInterface prop) {
        if (interfaces == null || prop == null) {
            return false;
        }
        if (interfaces.contains(prop)) {
            return true;
        }
        interfaces.addElement(prop);
        return true;
    }

    public static boolean applyChanges(Vector interfaces) {
        if (interfaces == null) {
            return false;
        }
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            ((PropertyInterface)interfaces.elementAt(i)).applyPropertyChanges();
        }
        return true;
    }

    public static boolean cancelChanges(Vector interfaces) {
        if (interfaces == null) {
            return false;
        }
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            ((PropertyInterface)interfaces.elementAt(i)).cancelPropertyChanges();
        }
        return true;
    }

    public static boolean removePropertyListener(Vector interfaces, PropertyInterface prop) {
        if (interfaces == null || prop == null) {
            return false;
        }
        int idx = interfaces.indexOf(prop);
        if (idx < 0) {
            return false;
        }
        interfaces.removeElementAt(idx);
        return true;
    }

    public static PropertyInterface getPropertyMulticaster(Vector interfaces) {
        PropertyMulticaster pm = new PropertyMulticaster();
        if (interfaces == null) {
            return pm;
        }
        for (int i = 0; i < interfaces.size(); ++i) {
            if (!(interfaces.elementAt(i) instanceof PropertyInterface)) continue;
            pm.addListener((PropertyInterface)interfaces.elementAt(i));
        }
        return pm;
    }
}

