/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.util.Extract;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PropertyMulticaster
implements PropertyInterface {
    private Vector listeners = new Vector();
    private Hashtable subPropertyMulticasters = new Hashtable();

    public PropertyMulticaster() {
        this(null);
    }

    public PropertyMulticaster(PropertyInterface base) {
        if (base != null) {
            this.listeners.addElement(base);
        }
    }

    public PropertyMulticaster(Object listenerList) {
        this(null);
        Enumeration e = Extract.elements(listenerList);
        while (e.hasMoreElements()) {
            Object l = e.nextElement();
            if (!(l instanceof PropertyInterface)) continue;
            this.addListener((PropertyInterface)l);
        }
    }

    public boolean addListener(PropertyInterface prop) {
        if (prop == null) {
            return false;
        }
        this.listeners.addElement(prop);
        return true;
    }

    public boolean removeListener(PropertyInterface prop) {
        if (prop == null) {
            return false;
        }
        return this.listeners.remove(prop);
    }

    public boolean contains(PropertyInterface prop) {
        if (prop == null) {
            return false;
        }
        return this.listeners.contains(prop);
    }

    public void removeAllListeners() {
        this.listeners.removeAllElements();
        Enumeration e = this.subPropertyMulticasters.elements();
        while (e.hasMoreElements()) {
            PropertyMulticaster pm = (PropertyMulticaster)e.nextElement();
            pm.removeAllListeners();
        }
    }

    @Override
    public boolean applyPropertyChanges() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyInterface)this.listeners.elementAt(i)).applyPropertyChanges();
        }
        return true;
    }

    @Override
    public void cancelPropertyChanges() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyInterface)this.listeners.elementAt(i)).cancelPropertyChanges();
        }
    }

    @Override
    public int getNumberPendingProperties() {
        if (this.listeners.isEmpty()) {
            return 0;
        }
        return ((PropertyInterface)this.listeners.elementAt(0)).getNumberPendingProperties();
    }

    @Override
    public int[] getPendingChanges() {
        if (this.listeners.isEmpty()) {
            return null;
        }
        return ((PropertyInterface)this.listeners.elementAt(0)).getPendingChanges();
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.listeners.isEmpty()) {
            return null;
        }
        Object rc = ((PropertyInterface)this.listeners.elementAt(0)).getPropertyValue(id);
        if (rc instanceof PropertyInterface) {
            Integer ID = new Integer(id);
            if (this.subPropertyMulticasters.containsKey(ID)) {
                return (PropertyMulticaster)this.subPropertyMulticasters.get(ID);
            }
            PropertyMulticaster pm = new PropertyMulticaster((PropertyInterface)rc);
            for (int i = 1; i < this.listeners.size(); ++i) {
                Object obj = ((PropertyInterface)this.listeners.elementAt(i)).getPropertyValue(id);
                if (!(obj instanceof PropertyInterface)) continue;
                pm.addListener((PropertyInterface)obj);
            }
            this.subPropertyMulticasters.put(ID, pm);
            return pm;
        }
        return rc;
    }

    @Override
    public boolean isPropertyPending(int id) {
        if (this.listeners.isEmpty()) {
            return false;
        }
        return ((PropertyInterface)this.listeners.elementAt(0)).isPropertyPending(id);
    }

    @Override
    public boolean isPropertySupported(int id) {
        if (this.listeners.isEmpty()) {
            return false;
        }
        return ((PropertyInterface)this.listeners.elementAt(0)).isPropertySupported(id);
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyInterface)this.listeners.elementAt(i)).setPropertyValue(id, value);
        }
        return true;
    }

    @Override
    public int[] getPendingChanges(Object source) {
        if (this.listeners.isEmpty()) {
            return null;
        }
        return ((PropertyInterface)this.listeners.elementAt(0)).getPendingChanges(source);
    }

    @Override
    public void cancelPropertyChanges(Object source) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyInterface)this.listeners.elementAt(i)).cancelPropertyChanges(source);
        }
    }

    @Override
    public boolean applyPropertyChanges(Object source) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyInterface)this.listeners.elementAt(i)).applyPropertyChanges(source);
        }
        return true;
    }

    @Override
    public boolean hasUserSetValue(int id) {
        boolean rc = ((PropertyInterface)this.listeners.elementAt(0)).hasUserSetValue(id);
        for (int i = 0; i < this.listeners.size(); ++i) {
            rc |= ((PropertyInterface)this.listeners.elementAt(i)).hasUserSetValue(id);
        }
        return rc;
    }

    public PropertyInterface[] getPropertyInterfaces() {
        Object[] rc = new PropertyInterface[this.listeners.size()];
        this.listeners.copyInto(rc);
        return rc;
    }

    public int numPropertyInterfaces() {
        return this.listeners.size();
    }
}

