/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.PropertyEvent;
import java.util.Vector;

public class PropertyList {
    protected Vector list = new Vector();

    public int getNumberPending(Object source) {
        int count = 0;
        if (this.list == null) {
            return 0;
        }
        if (source == null) {
            return this.list.size();
        }
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            PropertyEvent pe = (PropertyEvent)this.list.elementAt(i);
            if (pe == null || pe.source != source && pe.source != null) continue;
            ++count;
        }
        return count;
    }

    public int getIndex(int id) {
        int n = 0;
        PropertyEvent pe = null;
        if (this.list == null) {
            return -1;
        }
        n = this.list.size();
        for (int i = n - 1; i >= 0; --i) {
            pe = (PropertyEvent)this.list.elementAt(i);
            if (pe == null || pe.id != id) continue;
            return i;
        }
        return -1;
    }

    public Object getValueById(int id) {
        PropertyEvent pe;
        int idx = this.getIndex(id);
        if (idx < 0 || (pe = (PropertyEvent)this.list.elementAt(idx)) == null) {
            return null;
        }
        return pe.value;
    }

    public boolean isPending(int id) {
        return this.getIndex(id) >= 0;
    }

    public boolean store(int id, Object value) {
        if (this.list == null) {
            return false;
        }
        PropertyEvent pe = value instanceof PropertyEvent ? new PropertyEvent(id, ((PropertyEvent)value).source, ((PropertyEvent)value).value) : new PropertyEvent(id, value);
        if (pe == null) {
            return false;
        }
        this.list.addElement(pe);
        return true;
    }

    public Vector getChangesBySource(Object source) {
        if (source == null) {
            return this.list;
        }
        Vector<PropertyEvent> v = new Vector<PropertyEvent>();
        if (v == null) {
            return null;
        }
        int n = this.getNumberPending(null);
        for (int i = 0; i < n; ++i) {
            PropertyEvent pe = (PropertyEvent)this.list.elementAt(i);
            if (pe == null || pe.source != source && pe.source != null) continue;
            v.addElement(pe);
        }
        return v;
    }

    public void removeChangesBySource(Object source) {
        if (source == null) {
            if (this.list != null) {
                this.list.removeAllElements();
            }
            return;
        }
        int n = this.getNumberPending(null);
        for (int i = n - 1; i >= 0; --i) {
            PropertyEvent pe = (PropertyEvent)this.list.elementAt(i);
            if (pe == null || pe.source != source && pe.source != null) continue;
            this.list.removeElementAt(i);
        }
    }

    public int[] getPending(Object source) {
        int i;
        int n;
        int nFound = 0;
        if (this.list == null || (n = this.getNumberPending(source)) <= 0) {
            return null;
        }
        int[] out = new int[n];
        if (out == null) {
            return null;
        }
        for (i = 0; i < this.list.size(); ++i) {
            PropertyEvent pe = (PropertyEvent)this.list.elementAt(i);
            if (pe == null || pe.source != source && pe.source != null && source != null) continue;
            out[nFound++] = pe.id;
        }
        for (i = nFound; i < n; ++i) {
            out[i] = -1;
        }
        return out;
    }
}

