/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DataFilterStatisticsInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.util.ColumnStats;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;

public class DefaultStatistics
implements DataFilterStatisticsInterface,
DataFilterListenerInterface {
    private DataFilterReadInterface filter = null;
    private SortContext sortContext = null;
    private Hashtable columnStats = new Hashtable();
    public static final int BASIC_STATISTICS = 1;
    public static final int BOX_STATISTICS = 2;
    static final String NULL_SUMMARY_VAR_KEY = "___NULL_SUMMARY_VAR_KEY___";
    static final String NULL_RESPONSE_KEY = "___NULL_RESPONSE_KEY___";
    public static final String STATISTIC_NAME_N = "N";
    public static final String STATISTIC_NAME_SUM = "SUM";
    public static final String STATISTIC_NAME_MEAN = "MEAN";
    public static final String STATISTIC_NAME_MEDIAN = "MEDIAN";
    public static final String STATISTIC_NAME_MODE = "MODE";
    public static final String STATISTIC_NAME_STD = "STD";
    public static final String STATISTIC_NAME_MIN = "MIN";
    public static final String STATISTIC_NAME_MAX = "MAX";
    public static final String STATISTIC_NAME_NMISS = "NMISS";
    public static final String STATISTIC_NAME_RANGE = "RANGE";
    public static final String STATISTIC_NAME_VARIANCE = "VARIANCE";
    public static final String STATISTIC_NAME_PERCENT = "PERCENT";
    public static final String STATISTIC_NAME_FREQUENCY = "FREQUENCY";
    public static final String STATISTIC_NAME_LOW_WHISKER = "LOW_WHISKER";
    public static final String STATISTIC_NAME_HIGH_WHISKER = "HIGH_WHISKER";
    public static final String STATISTIC_NAME_Q1 = "Q1";
    public static final String STATISTIC_NAME_Q3 = "Q3";
    public static final String DEFAULT_SUMMARY_VAR = "NONE";
    private Vector summaryStats = new Vector(2);
    private SummaryStatsNode globalSummaryStats = null;
    int whichStatistics = 1;

    public DefaultStatistics(Object data) {
        this(data, 1);
    }

    public DefaultStatistics(Object data, int whichStatistics) {
        this.filter = FilterFactory.getDataSourceFilter(data);
        if (this.filter != null) {
            this.filter.addDataFilterListener(this);
        }
        this.whichStatistics = whichStatistics;
    }

    @Override
    public void dispose() {
        this.clearAllStatistics();
        FilterFactory.detachFilter(this.filter);
        if (this.filter != null) {
            this.filter.removeDataFilterListener(this);
            this.filter.removeSource();
        }
        this.filter = null;
        this.sortContext = null;
        this.columnStats = null;
        this.summaryStats = null;
        this.globalSummaryStats = null;
    }

    @Override
    public Object getStatistic(Object statistic, Object variable) {
        ColumnStats col = (ColumnStats)this.columnStats.get(variable);
        if (col == null) {
            col = new ColumnStats();
            this.columnStats.put(variable, col);
        }
        if (!col.statisticsValid) {
            this.computeStats(col, variable);
        }
        int stat = DefaultStatistics.getStatisticIndex(statistic);
        Object rc = col.retrieveStatistic(stat);
        return rc;
    }

    public double getSummaryStatistic(Object[] summaryVariables, Object variable, Object[] summaryVariableValues, int statistic) {
        return this.getSummaryStatistic(summaryVariables, variable, null, summaryVariableValues, statistic);
    }

    public double getSummaryStatistic(Object[] summaryVariables, Object variable, Object freqVar, Object[] summaryVariableValues, int statistic) {
        double d = Double.NaN;
        if (this.whichStatistics != 2 && (summaryVariables == null || summaryVariables.length <= 0 || summaryVariableValues == null || summaryVariables.length != summaryVariables.length)) {
            return d;
        }
        switch (statistic) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                if (this.whichStatistics == 2) break;
                return d;
            }
            default: {
                return d;
            }
        }
        SummaryStatsNode statsNode = this.getSummaryStatsNode(summaryVariables, variable, freqVar, true);
        if (statsNode == null) {
            return Double.NaN;
        }
        return statsNode.getSummaryStatistic(summaryVariableValues, variable, statistic);
    }

    public double[] getSummaryOutliers(Object[] summaryVariables, Object variable, Object[] summaryVariableValues, boolean farOutliers) {
        return this.getSummaryOutliers(summaryVariables, variable, null, summaryVariableValues, farOutliers);
    }

    public double[] getSummaryOutliers(Object[] summaryVariables, Object variable, Object freqVar, Object[] summaryVariableValues, boolean farOutliers) {
        SummaryStatsNode statsNode = this.getSummaryStatsNode(summaryVariables, variable, freqVar, true);
        if (statsNode == null) {
            return null;
        }
        return statsNode.getSummaryOutliers(summaryVariableValues, variable, farOutliers);
    }

    public Vector getSummaryVarsTuples(Object[] summaryVariables, Object variable) {
        return this.getSummaryVarsTuples(summaryVariables, variable, null);
    }

    public Vector getSummaryVarsTuples(Object[] summaryVariables, Object variable, Object freqVar) {
        SummaryStatsNode statsNode = this.getSummaryStatsNode(summaryVariables, variable, freqVar, true);
        if (statsNode == null) {
            return null;
        }
        return statsNode.getSummaryVarsTuples();
    }

    private SummaryStatsNode getSummaryStatsNode(Object[] summaryVariables, Object variable, Object freqVar, boolean create) {
        SummaryStatsNode statsNode = null;
        if (summaryVariables == null) {
            statsNode = this.globalSummaryStats;
        } else {
            for (int i = 0; i < this.summaryStats.size(); ++i) {
                SummaryStatsNode ssn = (SummaryStatsNode)this.summaryStats.elementAt(i);
                if (!ssn.isEqual(summaryVariables, freqVar)) continue;
                statsNode = ssn;
                break;
            }
        }
        if (statsNode == null && create) {
            statsNode = new SummaryStatsNode(summaryVariables);
            statsNode.addFrequencyVariable(freqVar);
            if (summaryVariables == null) {
                this.globalSummaryStats = statsNode;
            } else {
                this.summaryStats.addElement(statsNode);
            }
        }
        if (statsNode == null) {
            return null;
        }
        if (!statsNode.containsResponse(variable)) {
            statsNode.addResponseVariable(variable);
            statsNode.computeSummaryStatistics(this.filter, this.sortContext, variable, freqVar);
        }
        return statsNode;
    }

    protected void computeStats(ColumnStats col, Object variable) {
        if (this.filter == null || this.filter.getVariableIndex(variable) < 0) {
            col.statisticsValid = false;
            return;
        }
        col.reset();
        int varIndex = this.filter.getVariableIndex(variable);
        col.n = this.filter.getNumberObservations(varIndex);
        HashMap<Object, Integer> uniqueValues = new HashMap<Object, Integer>();
        int most = 0;
        if (this.filter.isNumericVariable(varIndex)) {
            double[] values = new double[(int)col.n];
            int i = 0;
            while ((long)i < col.n) {
                double dVal;
                Object o = this.filter.getValue(varIndex, (long)i);
                values[i] = dVal = this.filter.getNumericValue(varIndex, (long)i);
                int freqVal = 0;
                freqVal = uniqueValues.containsKey(o) ? ((Number)uniqueValues.get(o)).intValue() + 1 : 1;
                uniqueValues.put(o, new Integer(freqVal));
                if (most < freqVal) {
                    most = freqVal;
                    col.mode = o;
                }
                if (Double.isNaN(dVal)) {
                    ++col.nmiss;
                } else {
                    col.sum += dVal;
                    if (col.max < dVal) {
                        col.max = dVal;
                    }
                    if (col.min > dVal) {
                        col.min = dVal;
                    }
                }
                ++i;
            }
            col.mean = col.sum / (double)col.n;
            double sumOfSquares = 0.0;
            int i2 = 0;
            while ((long)i2 < col.n) {
                double distance = values[i2] - col.mean;
                double distanceSquared = distance * distance;
                sumOfSquares += distanceSquared;
                ++i2;
            }
            col.variance = sumOfSquares / (double)(col.n - 1L);
            col.std = Math.sqrt(col.variance);
            col.median = this.quickSelect(values, Math.round(values.length / 2));
            col.statisticsValid = true;
        } else {
            int i = 0;
            while ((long)i < col.n) {
                Object o = this.filter.getValue(varIndex, (long)i);
                int freqVal = 0;
                freqVal = uniqueValues.containsKey(o) ? ((Number)uniqueValues.get(o)).intValue() + 1 : 1;
                uniqueValues.put(o, new Integer(freqVal));
                if (most < freqVal) {
                    most = freqVal;
                    col.mode = o;
                }
                if (this.filter.isMissing(variable, o)) {
                    ++col.nmiss;
                }
                ++i;
            }
            col.std = Double.NaN;
            col.median = Double.NaN;
            col.mean = Double.NaN;
            col.sum = Double.NaN;
            col.max = Double.NaN;
            col.min = Double.NaN;
            col.statisticsValid = true;
        }
    }

    public double quickSelect(double[] array, int n) {
        int low = 0;
        int high = n - 1;
        int median = (low + high) / 2;
        while (high > low) {
            if (high == low + 1) {
                if (array[low] > array[high]) {
                    this.swap(array, low, high);
                }
                return array[median];
            }
            int middle = (low + high) / 2;
            if (array[middle] > array[high]) {
                this.swap(array, middle, high);
            }
            if (array[low] > array[high]) {
                this.swap(array, low, high);
            }
            if (array[middle] > array[low]) {
                this.swap(array, middle, low);
            }
            this.swap(array, middle, low + 1);
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (array[low] > array[++ll]) {
                    continue;
                }
                while (array[--hh] > array[low]) {
                }
                if (hh < ll) break;
                this.swap(array, hh, ll);
            }
            this.swap(array, low, hh);
            if (hh <= median) {
                low = ll;
            }
            if (hh < median) continue;
            high = hh - 1;
        }
        return array[median];
    }

    private void swap(double[] array, int i, int j) {
        double temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    @Override
    public String getStatisticName(int stat) {
        String rc = "";
        if (stat == 7) {
            rc = STATISTIC_NAME_MAX;
        } else if (stat == 2) {
            rc = STATISTIC_NAME_MEAN;
        } else if (stat == 3) {
            rc = STATISTIC_NAME_MEDIAN;
        } else if (stat == 6) {
            rc = STATISTIC_NAME_MIN;
        } else if (stat == 4) {
            rc = STATISTIC_NAME_MODE;
        } else if (stat == 0) {
            rc = STATISTIC_NAME_N;
        } else if (stat == 8) {
            rc = STATISTIC_NAME_NMISS;
        } else if (stat == 9) {
            rc = STATISTIC_NAME_RANGE;
        } else if (stat == 5) {
            rc = STATISTIC_NAME_STD;
        } else if (stat == 1) {
            rc = STATISTIC_NAME_SUM;
        } else if (stat == 10) {
            rc = STATISTIC_NAME_VARIANCE;
        } else if (stat == 11) {
            rc = STATISTIC_NAME_PERCENT;
        } else if (stat == 12) {
            rc = STATISTIC_NAME_FREQUENCY;
        } else if (stat == 13) {
            rc = STATISTIC_NAME_LOW_WHISKER;
        } else if (stat == 14) {
            rc = STATISTIC_NAME_HIGH_WHISKER;
        } else if (stat == 15) {
            rc = STATISTIC_NAME_Q1;
        } else if (stat == 16) {
            rc = STATISTIC_NAME_Q3;
        }
        return rc;
    }

    public static int getStatisticIndex(Object stat) {
        if (stat == null) {
            return -1;
        }
        if (stat instanceof Number) {
            return ((Number)stat).intValue();
        }
        String s = stat.toString();
        if (STATISTIC_NAME_MAX.equalsIgnoreCase(s)) {
            return 7;
        }
        if (STATISTIC_NAME_MEAN.equalsIgnoreCase(s)) {
            return 2;
        }
        if (STATISTIC_NAME_MEDIAN.equalsIgnoreCase(s)) {
            return 3;
        }
        if (STATISTIC_NAME_MIN.equalsIgnoreCase(s)) {
            return 6;
        }
        if (STATISTIC_NAME_MODE.equalsIgnoreCase(s)) {
            return 4;
        }
        if (STATISTIC_NAME_N.equalsIgnoreCase(s)) {
            return 0;
        }
        if (STATISTIC_NAME_NMISS.equalsIgnoreCase(s)) {
            return 8;
        }
        if (STATISTIC_NAME_RANGE.equalsIgnoreCase(s)) {
            return 9;
        }
        if (STATISTIC_NAME_STD.equalsIgnoreCase(s)) {
            return 5;
        }
        if (STATISTIC_NAME_SUM.equalsIgnoreCase(s)) {
            return 1;
        }
        if (STATISTIC_NAME_VARIANCE.equalsIgnoreCase(s)) {
            return 10;
        }
        if (STATISTIC_NAME_PERCENT.equalsIgnoreCase(s)) {
            return 11;
        }
        if (STATISTIC_NAME_FREQUENCY.equalsIgnoreCase(s)) {
            return 12;
        }
        if (STATISTIC_NAME_LOW_WHISKER.equalsIgnoreCase(s)) {
            return 13;
        }
        if (STATISTIC_NAME_HIGH_WHISKER.equalsIgnoreCase(s)) {
            return 14;
        }
        if (STATISTIC_NAME_Q1.equalsIgnoreCase(s)) {
            return 15;
        }
        if (STATISTIC_NAME_Q3.equalsIgnoreCase(s)) {
            return 16;
        }
        return -1;
    }

    public void clearAllStatistics() {
        if (this.columnStats != null) {
            this.columnStats.clear();
        }
        if (this.globalSummaryStats != null) {
            this.globalSummaryStats.clear();
        }
        this.clearAllSummaryStatistics();
    }

    public void clearSummaryStatistic(Object[] summaryVars, Object variable, Object freqVar) {
        SummaryStatsNode statsNode = this.getSummaryStatsNode(summaryVars, variable, freqVar, false);
        if (statsNode != null) {
            statsNode.clear();
            this.summaryStats.remove(statsNode);
        }
    }

    private void clearAllSummaryStatistics() {
        if (this.summaryStats != null) {
            for (int i = 0; i < this.summaryStats.size(); ++i) {
                Object o = this.summaryStats.elementAt(i);
                if (!(o instanceof SummaryStatsNode)) continue;
                ((SummaryStatsNode)o).clear();
            }
            this.summaryStats.clear();
        }
    }

    public SortContext getSortContext() {
        return this.sortContext;
    }

    public void setSortContext(SortContext sortContext) {
        if (this.sortContext != sortContext) {
            this.clearAllStatistics();
        }
        this.sortContext = sortContext;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 1: 
            case 3: 
            case 6: {
                this.clearAllStatistics();
                break;
            }
        }
    }

    class SummaryStatsNode {
        private Object[] summaryVars;
        private Object frequencyVar;
        private Vector responseVars;
        private LinkedHashMap children = null;
        private Vector allSummaryVarTuples = null;
        long totalFrequency = 0L;

        SummaryStatsNode(Object[] summVars) {
            if (summVars != null) {
                this.summaryVars = new Object[summVars.length];
                for (int i = 0; i < summVars.length; ++i) {
                    this.summaryVars[i] = summVars[i];
                }
            }
        }

        void addResponseVariable(Object variable) {
            Object r = variable;
            if (variable == null) {
                r = DefaultStatistics.NULL_RESPONSE_KEY;
            }
            if (this.responseVars == null) {
                this.responseVars = new Vector();
            }
            if (!this.responseVars.contains(r)) {
                this.responseVars.addElement(r);
            }
        }

        boolean containsResponse(Object responseVar) {
            if (this.responseVars == null) {
                return false;
            }
            Object r = responseVar;
            if (responseVar == null) {
                r = DefaultStatistics.NULL_RESPONSE_KEY;
            }
            return this.responseVars.contains(r);
        }

        void addFrequencyVariable(Object variable) {
            this.frequencyVar = variable;
        }

        boolean areFrequencyVarsEqual(Object variable) {
            if (this.frequencyVar == null && variable == null) {
                return true;
            }
            if (this.frequencyVar == null || variable == null) {
                return false;
            }
            return this.frequencyVar.toString().equalsIgnoreCase(variable.toString());
        }

        public SummaryValuesNode getChild(String value) {
            if (value != null && this.children != null) {
                return (SummaryValuesNode)this.children.get(value);
            }
            return null;
        }

        private boolean addChild(SummaryValuesNode svn) {
            if (svn == null || svn.getValue() == null) {
                return false;
            }
            if (this.children == null) {
                this.children = new LinkedHashMap();
            }
            this.children.put(svn.getValue(), svn);
            return true;
        }

        public SummaryValuesNode[] getAllChildren() {
            if (this.children == null) {
                return null;
            }
            SummaryValuesNode[] allChildren = new SummaryValuesNode[this.children.size()];
            Collection values = this.children.values();
            if (values == null) {
                return null;
            }
            Iterator it = values.iterator();
            if (it == null) {
                return null;
            }
            int i = 0;
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof SummaryValuesNode)) continue;
                allChildren[i++] = (SummaryValuesNode)o;
            }
            return allChildren;
        }

        public boolean isEqual(Object[] summVars, Object freqVar) {
            if (summVars == null && this.summaryVars == null) {
                return true;
            }
            if (summVars == null || this.summaryVars == null) {
                return false;
            }
            if (this.summaryVars.length != summVars.length) {
                return false;
            }
            for (int i = 0; i < this.summaryVars.length; ++i) {
                if (this.summaryVars[i] == null && summVars[i] == null) {
                    return true;
                }
                if (this.summaryVars[i] == null || summVars[i] == null) {
                    return false;
                }
                if (this.summaryVars[i].toString().equalsIgnoreCase(summVars[i].toString())) continue;
                return false;
            }
            return this.areFrequencyVarsEqual(freqVar);
        }

        void computeSummaryStatistics(DataFilterReadInterface filter, SortContext sortContext, Object responseVar, Object freqVar) {
            if (filter == null) {
                return;
            }
            if (this.summaryVars == null || this.summaryVars.length <= 0) {
                this.computeGlobalStatistics(sortContext, responseVar, freqVar);
                return;
            }
            this.totalFrequency = 0L;
            Object[] summaryVarValues = new Object[this.summaryVars.length];
            double respValue = Double.NaN;
            for (int i = 0; i < filter.getNumberObservations(-1); ++i) {
                for (int j = 0; j < this.summaryVars.length; ++j) {
                    summaryVarValues[j] = DefaultStatistics.DEFAULT_SUMMARY_VAR.equals(this.summaryVars[j]) ? DefaultStatistics.DEFAULT_SUMMARY_VAR : filter.getFormattedValue(this.summaryVars[j], i, sortContext, null);
                }
                if (responseVar != null) {
                    respValue = filter.getNumericValue(responseVar, (long)i, sortContext);
                }
                double freqValue = 1.0;
                if (freqVar != null) {
                    freqValue = filter.getNumericValue(freqVar, (long)i, sortContext);
                }
                this.updateStats(summaryVarValues, responseVar, respValue, freqValue);
            }
            Vector tuples = this.getSummaryVarsTuples();
            if (tuples != null) {
                for (int i = 0; i < tuples.size(); ++i) {
                    SummaryValuesNode svn;
                    Object o = tuples.elementAt(i);
                    if (!(o instanceof Object[]) || (svn = this.getSummaryValuesNode((Object[])o)) == null) continue;
                    svn.getSummaryStats(responseVar).postCalculateStatistics(this.totalFrequency);
                }
            }
        }

        private void computeGlobalStatistics(SortContext sortContext, Object responseVar, Object freqVar) {
            SummaryValuesNode svn = new SummaryValuesNode(DefaultStatistics.NULL_SUMMARY_VAR_KEY);
            this.addChild(svn);
            for (int i = 0; i < DefaultStatistics.this.filter.getNumberObservations(-1); ++i) {
                double respValue = Double.NaN;
                if (responseVar != null) {
                    respValue = DefaultStatistics.this.filter.getNumericValue(responseVar, (long)i, sortContext);
                }
                double freqValue = 1.0;
                if (freqVar != null) {
                    freqValue = DefaultStatistics.this.filter.getNumericValue(freqVar, (long)i, sortContext);
                }
                this.totalFrequency = svn.getSummaryStats(responseVar).updateStats(responseVar != null, freqValue, respValue, this.totalFrequency);
            }
            svn.getSummaryStats(responseVar).postCalculateStatistics(this.totalFrequency);
        }

        private void updateStats(Object[] summaryVarValues, Object responseVar, double respValue, double freqValue) {
            SummaryValuesNode svn = null;
            boolean first = true;
            for (int i = 0; i < summaryVarValues.length; ++i) {
                if (summaryVarValues[i] == null) continue;
                boolean newValue = false;
                String s = summaryVarValues[i].toString();
                if (first) {
                    svn = this.getChild(s);
                    if (svn == null) {
                        svn = new SummaryValuesNode(s);
                        this.addChild(svn);
                        newValue = true;
                    }
                    first = false;
                } else {
                    SummaryValuesNode child = svn.getChild(s);
                    if (child == null) {
                        child = new SummaryValuesNode(s);
                        svn.addChild(child);
                        newValue = true;
                    }
                    svn = child;
                }
                if (i != summaryVarValues.length - 1 || !newValue) continue;
                if (this.allSummaryVarTuples == null) {
                    this.allSummaryVarTuples = new Vector();
                }
                Object[] vals = new Object[summaryVarValues.length];
                for (int j = 0; j < summaryVarValues.length; ++j) {
                    vals[j] = summaryVarValues[j];
                }
                this.allSummaryVarTuples.addElement(vals);
            }
            if (svn != null) {
                this.totalFrequency = svn.getSummaryStats(responseVar).updateStats(responseVar != null, freqValue, respValue, this.totalFrequency);
            }
        }

        public double getSummaryStatistic(Object[] summaryVarValues, Object responseVariable, int statistic) {
            SummaryValuesNode svn;
            if (summaryVarValues == null || summaryVarValues.length <= 0) {
                summaryVarValues = new Object[]{DefaultStatistics.NULL_SUMMARY_VAR_KEY};
            }
            if ((svn = this.getSummaryValuesNode(summaryVarValues)) != null) {
                return svn.getSummaryStats(responseVariable).getStatistic(statistic);
            }
            return Double.NaN;
        }

        public double[] getSummaryOutliers(Object[] summaryVarValues, Object responseVariable, boolean farOutliers) {
            SummaryValuesNode svn;
            if (summaryVarValues == null || summaryVarValues.length <= 0) {
                summaryVarValues = new Object[]{DefaultStatistics.NULL_SUMMARY_VAR_KEY};
            }
            if ((svn = this.getSummaryValuesNode(summaryVarValues)) != null) {
                return svn.getSummaryStats(responseVariable).getOutliers(farOutliers);
            }
            return null;
        }

        private SummaryValuesNode getSummaryValuesNode(Object[] summaryVarValues) {
            if (summaryVarValues == null || summaryVarValues.length <= 0) {
                summaryVarValues = new Object[]{DefaultStatistics.NULL_SUMMARY_VAR_KEY};
            }
            SummaryValuesNode svn = null;
            boolean first = true;
            for (int i = 0; i < summaryVarValues.length; ++i) {
                if (summaryVarValues[i] == null) continue;
                String s = summaryVarValues[i].toString();
                if (first) {
                    svn = this.getChild(s);
                    first = false;
                    continue;
                }
                if (svn == null) continue;
                svn = svn.getChild(s);
            }
            return svn;
        }

        Vector getSummaryVarsTuples() {
            return this.allSummaryVarTuples;
        }

        void clear() {
            if (this.children != null && this.children.size() > 0) {
                Iterator it;
                Collection c = this.children.values();
                if (c != null && (it = c.iterator()) != null) {
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof SummaryValuesNode)) continue;
                        ((SummaryValuesNode)o).clear();
                    }
                }
                this.children.clear();
            }
            this.children = null;
            if (this.allSummaryVarTuples != null) {
                this.allSummaryVarTuples.clear();
            }
            this.allSummaryVarTuples = null;
            if (this.responseVars != null) {
                this.responseVars.clear();
            }
            this.responseVars = null;
            if (this.summaryVars != null) {
                for (int i = 0; i < this.summaryVars.length; ++i) {
                    this.summaryVars[i] = null;
                }
            }
            this.summaryVars = null;
        }
    }

    class SummaryValuesNode {
        private String value = null;
        private LinkedHashMap stats = null;
        private LinkedHashMap children = null;

        SummaryValuesNode(String value) {
            this.setValue(value);
        }

        SummaryStats getSummaryStats(Object response) {
            Object r;
            if (this.stats == null) {
                this.stats = new LinkedHashMap();
            }
            if ((r = response) == null) {
                r = DefaultStatistics.NULL_RESPONSE_KEY;
            }
            if (!this.stats.containsKey(r)) {
                this.stats.put(r, new SummaryStats());
            }
            return (SummaryStats)this.stats.get(r);
        }

        String getValue() {
            return this.value;
        }

        private void setValue(String value) {
            this.value = value;
        }

        public int hashCode() {
            if (this.value != null) {
                return this.value.hashCode();
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SummaryValuesNode) {
                SummaryValuesNode ssn = (SummaryValuesNode)obj;
                if (this.value != null && this.value.equalsIgnoreCase(ssn.getValue())) {
                    return true;
                }
            }
            return false;
        }

        SummaryValuesNode getChild(String value) {
            if (value != null && this.children != null) {
                return (SummaryValuesNode)this.children.get(value);
            }
            return null;
        }

        boolean addChild(SummaryValuesNode svn) {
            if (svn == null || svn.getValue() == null) {
                return false;
            }
            if (this.children == null) {
                this.children = new LinkedHashMap();
            }
            this.children.put(svn.getValue(), svn);
            return true;
        }

        void clear() {
            Iterator it;
            Collection c;
            if (this.children != null) {
                c = this.children.values();
                if (c != null && (it = c.iterator()) != null) {
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof SummaryValuesNode)) continue;
                        ((SummaryValuesNode)o).clear();
                    }
                }
                this.children.clear();
            }
            if (this.stats != null) {
                c = this.stats.values();
                if (c != null && (it = c.iterator()) != null) {
                    while (it.hasNext()) {
                        SummaryStats ss = (SummaryStats)it.next();
                        ss.resetStats();
                    }
                }
                this.stats.clear();
                this.stats = null;
            }
            this.value = null;
            this.children = null;
        }
    }

    class SummaryStats {
        long frequency;
        double sum;
        double mean;
        double percent;
        double min;
        double max;
        double[] boxStatistics = null;
        double[] outliers = null;
        double[] farOutliers = null;
        private static final int BOX_MIN = 0;
        private static final int BOX_MAX = 1;
        private static final int Q1 = 2;
        private static final int MEDIAN = 3;
        private static final int Q3 = 4;
        private static final int NUM_BOX_STATS = 5;
        Vector respValues = null;

        SummaryStats() {
            this.resetStats();
        }

        public void resetStats() {
            this.frequency = 0L;
            this.percent = Double.NaN;
            this.sum = Double.NaN;
            this.mean = Double.NaN;
            this.min = Double.POSITIVE_INFINITY;
            this.max = Double.NEGATIVE_INFINITY;
            this.boxStatistics = null;
            this.outliers = null;
            this.farOutliers = null;
        }

        public double getStatistic(int statistic) {
            switch (statistic) {
                default: {
                    return Double.NaN;
                }
                case 12: {
                    return this.frequency;
                }
                case 11: {
                    return this.percent;
                }
                case 1: {
                    return this.sum;
                }
                case 2: {
                    return this.mean;
                }
                case 6: {
                    return this.min;
                }
                case 7: {
                    return this.max;
                }
                case 13: {
                    return this.getBoxStatistic(0);
                }
                case 14: {
                    return this.getBoxStatistic(1);
                }
                case 3: {
                    return this.getBoxStatistic(3);
                }
                case 15: {
                    return this.getBoxStatistic(2);
                }
                case 16: 
            }
            return this.getBoxStatistic(4);
        }

        public double[] getOutliers(boolean far) {
            if (far) {
                return this.farOutliers;
            }
            return this.outliers;
        }

        private double getBoxStatistic(int statistic) {
            if (this.boxStatistics != null) {
                return this.boxStatistics[statistic];
            }
            return Double.NaN;
        }

        public long updateStats(boolean response, double freq, double value, long total) {
            if (Double.isNaN(freq) || freq < 1.0) {
                return total;
            }
            int f = (int)freq;
            if (response) {
                if (!Double.isNaN(value)) {
                    switch (DefaultStatistics.this.whichStatistics) {
                        case 2: {
                            if (this.respValues == null) {
                                this.respValues = new Vector();
                            }
                            this.respValues.addElement(new Double(value));
                            break;
                        }
                    }
                    this.frequency += (long)f;
                    total += (long)f;
                    if (Double.isNaN(this.sum)) {
                        this.sum = 0.0;
                    }
                    this.sum += (double)f * value;
                    this.mean = this.sum / (double)this.frequency;
                    this.min = Math.min(this.min, value);
                    this.max = Math.max(this.max, value);
                }
            } else {
                this.frequency += (long)f;
                total += (long)f;
            }
            return total;
        }

        public void postCalculateStatistics(long total) {
            if (total != 0L) {
                this.percent = 100.0 * (double)this.frequency / (double)total;
            }
            switch (DefaultStatistics.this.whichStatistics) {
                case 2: {
                    this.computeBoxStatistics();
                    break;
                }
            }
        }

        private void computeBoxStatistics() {
            int i;
            if (DefaultStatistics.this.whichStatistics != 2) {
                return;
            }
            if (this.respValues == null || this.respValues.size() == 0) {
                return;
            }
            double[] values = new double[this.respValues.size()];
            for (int i2 = 0; i2 < this.respValues.size(); ++i2) {
                values[i2] = ((Number)this.respValues.elementAt(i2)).doubleValue();
            }
            this.boxStatistics = new double[5];
            this.boxStatistics[0] = Double.POSITIVE_INFINITY;
            this.boxStatistics[1] = Double.NEGATIVE_INFINITY;
            Arrays.sort(values);
            int medianIndex1 = -1;
            int medianIndex2 = -1;
            if (values.length % 2 == 1) {
                medianIndex1 = medianIndex2 = values.length / 2;
                this.boxStatistics[3] = values[values.length / 2];
            } else {
                medianIndex1 = values.length / 2 - 1;
                medianIndex2 = values.length / 2;
                this.boxStatistics[3] = (values[values.length / 2] + values[values.length / 2 - 1]) / 2.0;
            }
            this.boxStatistics[2] = this.getSubListMedian(values, 0, medianIndex1);
            this.boxStatistics[4] = this.getSubListMedian(values, medianIndex2, values.length - 1);
            double iqr = this.boxStatistics[4] - this.boxStatistics[2];
            double upperFence = this.boxStatistics[4] + 1.5 * iqr;
            double lowerFence = this.boxStatistics[2] - 1.5 * iqr;
            double upperFarFence = this.boxStatistics[4] + 3.0 * iqr;
            double lowerFarFence = this.boxStatistics[2] - 3.0 * iqr;
            Vector<Double> out = new Vector<Double>();
            Vector<Double> far = new Vector<Double>();
            double noise = iqr / 1000.0;
            for (i = 0; i < values.length; ++i) {
                if (values[i] >= lowerFence || Math.abs(values[i] - lowerFence) < noise) {
                    this.boxStatistics[0] = Math.min(this.boxStatistics[0], values[i]);
                }
                if (values[i] <= upperFence || Math.abs(values[i] - upperFence) < noise) {
                    this.boxStatistics[1] = Math.max(this.boxStatistics[1], values[i]);
                }
                if (values[i] > upperFence && Math.abs(values[i] - upperFence) > noise) {
                    out.addElement(new Double(values[i]));
                } else if (values[i] < lowerFence && Math.abs(values[i] - lowerFence) > noise) {
                    out.addElement(new Double(values[i]));
                }
                if (values[i] > upperFarFence) {
                    far.addElement(new Double(values[i]));
                    continue;
                }
                if (!(values[i] < lowerFarFence)) continue;
                far.addElement(new Double(values[i]));
            }
            if (out.size() > 0) {
                this.outliers = new double[out.size()];
                for (i = 0; i < out.size(); ++i) {
                    this.outliers[i] = ((Number)out.elementAt(i)).doubleValue();
                }
            }
            if (far.size() > 0) {
                this.farOutliers = new double[far.size()];
                for (i = 0; i < far.size(); ++i) {
                    this.farOutliers[i] = ((Number)far.elementAt(i)).doubleValue();
                }
            }
        }

        private double getSubListMedian(double[] values, int startIndex, int endIndex) {
            int length = endIndex - startIndex + 1;
            if (length % 2 == 1) {
                return values[startIndex + length / 2];
            }
            return (values[startIndex - 1 + length / 2] + values[startIndex + length / 2]) / 2.0;
        }
    }
}

