/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

class ColumnStats {
    long n;
    double sum;
    double mean;
    double median;
    Object mode;
    double variance;
    double std;
    double min;
    double max;
    long nmiss;
    boolean statisticsValid = false;

    public ColumnStats() {
        this.reset();
    }

    public void reset() {
        this.n = 0L;
        this.sum = 0.0;
        this.median = 0.0;
        this.mode = null;
        this.std = 0.0;
        this.variance = 0.0;
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        this.nmiss = 0L;
        this.statisticsValid = false;
    }

    public Object retrieveStatistic(int statistic) {
        Object rc = null;
        if (!this.statisticsValid) {
            return null;
        }
        switch (statistic) {
            case 7: {
                rc = new Double(this.max);
                break;
            }
            case 2: {
                rc = new Double(this.mean);
                break;
            }
            case 3: {
                rc = new Double(this.median);
                break;
            }
            case 6: {
                rc = new Double(this.min);
                break;
            }
            case 4: {
                rc = this.mode;
                break;
            }
            case 0: {
                rc = new Long(this.n);
                break;
            }
            case 5: {
                rc = new Double(this.std);
                break;
            }
            case 1: {
                rc = new Double(this.sum);
                break;
            }
            case 8: {
                rc = new Long(this.nmiss);
                break;
            }
            case 9: {
                rc = new Double(this.max - this.min);
                break;
            }
            case 10: {
                rc = new Double(this.variance);
            }
        }
        return rc;
    }
}

