/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui.swatch;

import com.sas.graphics.styles.ui.swatch.SwatchComboBox;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class UIUtil {
    public static final int NUM_COLOR_ROWS = 4;
    public static final int NUM_COLOR_COLS = 8;
    private static Color[] colors = new Color[]{Color.BLACK, Color.WHITE, new Color(0, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 0, 0), new Color(255, 0, 255), new Color(255, 255, 0), new Color(232, 230, 232), new Color(198, 195, 198), new Color(164, 165, 164), new Color(132, 130, 132), new Color(96, 98, 96), new Color(74, 77, 74), new Color(66, 65, 66), new Color(24, 24, 24), new Color(165, 40, 41), new Color(255, 130, 115), new Color(57, 130, 140), new Color(222, 182, 140), new Color(239, 130, 139), new Color(99, 113, 173), new Color(140, 166, 66), new Color(156, 52, 24), new Color(255, 203, 99), new Color(140, 166, 206), new Color(107, 117, 0), new Color(189, 125, 49), new Color(214, 199, 107), new Color(90, 81, 140), new Color(99, 154, 33), new Color(206, 85, 57)};
    public static String[] stipNames = new String[]{"Default", "Solid", "Dash1", "Dash2", "Dash3", "Dash4", "Dash5", "Dash6", "Dash3Dash1", "Dash4Dash1", "Dash5Dash1", "Dash6Dash1", "Dash5Dash3", "Dash6Dash3", "Dash3Dash1Dash1", "Dash4Dash1Dash1", "Dash5Dash1Dash1", "Dash6Dash1Dash1", "Dash5Dash3Dash3", "Dash6Dash3Dash3", "Dash2Space", "Dash3Space", "Dash4Space", "Dash5Space", "Dash6Space", "Dash3Dash2", "Dash4Dash2", "Dash5Dash2", "Dash6Dash2", "Dash3Dash2Dash2", "Dash4Dash2Dash2", "Dash5Dash2Dash2", "Dash6Dash2Dash2", "Dot1", "Dot1Space", "Dot1Space2", "Dot2", "Dot3", "Dot2Dot1", "Dot3Dot1", "Dot3Dot2", "Dash3Dot1", "Dash3Dot2", "Dash3Dot3", "Dash3Dot2Dash3Dot1", "Dash3Dot3Dash3Dot1", "Dash3Dot3Dash3Dot2"};
    private static String[] lines = new String[]{stipNames[1], stipNames[2], stipNames[4], stipNames[8], stipNames[10], stipNames[14], stipNames[17], stipNames[20], stipNames[22], stipNames[30], stipNames[33], stipNames[44]};
    public static final String[] PretyNames = new String[]{"-DEFAULT-", "-NONE-", "Circle", "Plus", "X", "Triangle", "Tilde", "Ibeam", "Square", "Asterisk", "Y", "Diamond", "Z", "Union", "Hash", "Tack", "HomeDown", "GreaterThan", "ArrowDown", "Star", "CircleFilled", "TriangleFilled", "SquareFilled", "DiamondFilled", "HomedownFilled", "StarFilled"};
    private static String[] markers = new String[]{PretyNames[2], PretyNames[3], PretyNames[4], PretyNames[5], PretyNames[6], PretyNames[7], PretyNames[8], PretyNames[9], PretyNames[10], PretyNames[11], PretyNames[12], PretyNames[13], PretyNames[14], PretyNames[15], PretyNames[16], PretyNames[17], PretyNames[18], PretyNames[19], PretyNames[20], PretyNames[21], PretyNames[22], PretyNames[23], PretyNames[24], PretyNames[25]};
    private static String[] markerSizes = new String[]{Integer.toString(1), Integer.toString(3), Integer.toString(5), Integer.toString(7), Integer.toString(9), Integer.toString(10), Integer.toString(11), Integer.toString(13), Integer.toString(15), Integer.toString(17), Integer.toString(19), Integer.toString(20), Integer.toString(25), Integer.toString(30), Integer.toString(35), Integer.toString(40), Integer.toString(45), Integer.toString(50), Integer.toString(55), Integer.toString(60), Integer.toString(65), Integer.toString(75), Integer.toString(100)};
    private static String[] lineThickness = new String[]{Integer.toString(1), Integer.toString(2), Integer.toString(3), Integer.toString(4), Integer.toString(5), Integer.toString(6), Integer.toString(7), Integer.toString(8), Integer.toString(9), Integer.toString(10)};
    public static final int DLU = Math.max(1, UIManager.getFont("ComboBox.font").getSize() / 8);
    public static final Border emptyBorder = BorderFactory.createEmptyBorder(DLU * 7, DLU * 7, DLU * 7, DLU * 7);
    public static final Border lineBorder = BorderFactory.createLineBorder(new Color(0, 0, 132), 1);
    public static final Border line2Border = BorderFactory.createMatteBorder(2, 2, 0, 0, Color.white);
    public static final Border emptyItemBorder = BorderFactory.createEmptyBorder(4 * DLU, 3 * DLU, 4 * DLU, 2 * DLU);
    public static final int POSITION_TOP = 0;
    public static final int POSITION_BOTTOM = 1;
    public static final int POSITION_LEFT = 2;
    public static final int POSITION_RIGHT = 3;
    public static final int POSITION_CENTER = 4;
    public static final int POSITION_TOP_LEFT = 5;
    public static final int POSITION_TOP_RIGHT = 6;
    public static final int POSITION_BOTTOM_LEFT = 7;
    public static final int POSITION_BOTTOM_RIGHT = 8;
    public static JColorChooser colorChooser = new JColorChooser();
    public static int DEFAULT_WIDGET_WIDTH = 144 * DLU;
    public static int DEFAULT_WIDGET_HEIGHT = 14 * DLU;
    public static int DEFAULT_LABEL_WIDTH = 20 * DLU;
    public static int DEFAULT_LABEL_HEIGHT = 14 * DLU;

    public static void setColors(Color[] colorlist) {
        colors = colorlist;
    }

    public static Color[] getColors() {
        return colors;
    }

    public static void setLines(String[] linelist) {
        lines = linelist;
    }

    public static String[] getLines() {
        return lines;
    }

    public static void setLineThickness(String[] list) {
        lineThickness = list;
    }

    public static String[] getLineThickness() {
        return lineThickness;
    }

    public static void setMarkers(String[] markerlist) {
        markers = markerlist;
    }

    public static String[] getMarkerSizes() {
        return markerSizes;
    }

    public static void setMarkerSizes(String[] list) {
        markerSizes = list;
    }

    public static String[] getMarkers() {
        return markers;
    }

    public static void selectColor(SwatchComboBox cb, Color newColor) {
        int i;
        int insert = -1;
        for (i = 0; i < colors.length; ++i) {
            if (!newColor.equals(colors[i])) continue;
            cb.setSelectedIndex(i);
            insert = i;
            break;
        }
        if (insert == -1) {
            for (i = colors.length - 2; i >= 0; --i) {
                UIUtil.colors[i + 1] = colors[i];
            }
            UIUtil.colors[0] = newColor;
            cb.setModel(colors);
            cb.setSelectedIndex(0);
        }
    }

    public static int swingToList(int swingConstant) {
        int li = 0;
        switch (swingConstant) {
            case 1: {
                li = 0;
                break;
            }
            case 5: {
                li = 1;
                break;
            }
            case 7: {
                li = 2;
                break;
            }
            case 3: {
                li = 3;
                break;
            }
            case 8: {
                li = 5;
                break;
            }
            case 2: {
                li = 6;
                break;
            }
            case 6: {
                li = 7;
                break;
            }
            case 4: {
                li = 8;
                break;
            }
            case 0: {
                li = 4;
            }
        }
        return li;
    }

    public static int listToSwing(int listIndex) {
        int li = 0;
        switch (listIndex) {
            case 0: {
                li = 1;
                break;
            }
            case 1: {
                li = 5;
                break;
            }
            case 2: {
                li = 7;
                break;
            }
            case 3: {
                li = 3;
                break;
            }
            case 5: {
                li = 8;
                break;
            }
            case 6: {
                li = 2;
                break;
            }
            case 7: {
                li = 6;
                break;
            }
            case 8: {
                li = 4;
                break;
            }
            case 4: {
                li = 0;
            }
        }
        return li;
    }

    public static void insertMarkerSize(int value) {
        int mlen;
        int index = mlen = markerSizes.length;
        for (int i = 0; i < mlen; ++i) {
            int avalue = Integer.parseInt(markerSizes[i]);
            if (value == avalue) {
                return;
            }
            if (value >= avalue) continue;
            index = i;
            break;
        }
        String[] temp = new String[mlen + 1];
        System.arraycopy(markerSizes, 0, temp, 0, index);
        temp[index] = Integer.toString(value);
        if (index < mlen) {
            System.arraycopy(markerSizes, index, temp, index + 1, mlen - index);
        }
        markerSizes = temp;
    }

    public static void insertLineThickness(int value) {
        int llen;
        int index = llen = lineThickness.length;
        for (int i = 0; i < llen; ++i) {
            int avalue = Integer.parseInt(lineThickness[i]);
            if (value == avalue) {
                return;
            }
            if (value >= avalue) continue;
            index = i;
            break;
        }
        String[] temp = new String[llen + 1];
        System.arraycopy(lineThickness, 0, temp, 0, index);
        temp[index] = Integer.toString(value);
        if (index < llen) {
            System.arraycopy(lineThickness, index, temp, index + 1, llen - index);
        }
        lineThickness = temp;
    }

    public static final Cursor createCursor(String name, Point point, String file) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        Image im = UIUtil.getImage(null, file);
        return Toolkit.getDefaultToolkit().createCustomCursor(im, point, name);
    }

    public static Image getImage(Class theClass, String name) {
        Image image;
        if (theClass == null) {
            theClass = UIUtil.class;
        }
        try {
            image = Toolkit.getDefaultToolkit().getImage(theClass.getResource(name));
        }
        catch (Exception e) {
            image = null;
        }
        return image;
    }
}

