/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui.swatch;

import com.sas.graphics.styles.ui.Messages;
import com.sas.graphics.styles.ui.swatch.ColorGrabber;
import com.sas.graphics.styles.ui.swatch.SwatchActionEvent;
import com.sas.graphics.styles.ui.swatch.SwatchFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;

public class SwatchPopup
implements ComboPopup,
MouseMotionListener,
MouseListener,
KeyListener,
PopupMenuListener {
    protected JComboBox comboBox;
    protected JPopupMenu popup;
    protected Object[] list;
    protected Color selectedBackground;
    protected Color selectedForeground;
    protected Color background;
    protected Color foreground;
    SwatchFrame swatchFrame;
    private int cols;
    private int rows;
    private String more;
    private String auto;
    private Object autoValue;
    private ColorGrabber cg;
    private boolean moreSelected = false;
    boolean colorGrabberSelected = false;
    protected boolean mouseInside = false;
    protected boolean hideNext = false;

    public SwatchPopup(JComboBox combo, Object[] list, int cols, int rows, ColorGrabber cg, String auto, Object value, String more) {
        this.comboBox = combo;
        this.list = list;
        this.cols = cols;
        this.rows = rows;
        this.cg = cg;
        this.more = more;
        this.auto = auto;
        this.autoValue = value;
        this.background = UIManager.getColor("ComboBox.background");
        this.foreground = UIManager.getColor("ComboBox.foreground");
        this.selectedBackground = UIManager.getColor("ComboBox.selectionBackground");
        this.selectedForeground = UIManager.getColor("ComboBox.selectionForeground");
        this.initializePopup();
    }

    public void setGrid(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
        this.swatchFrame.setGrid(cols, rows);
    }

    public void setAutomatic(String label, Object value) {
        this.auto = label;
        this.autoValue = value;
        this.swatchFrame.setAutomatic(label, value);
    }

    @Override
    public void show() {
        this.swatchFrame.pickingDone = false;
        this.popup.show(this.comboBox, 0, this.comboBox.getHeight());
    }

    @Override
    public void hide() {
        this.popup.setVisible(false);
        this.swatchFrame.pickingDone = false;
    }

    public Object[] getItems() {
        return this.list;
    }

    @Override
    public MouseListener getMouseListener() {
        return this;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return this;
    }

    @Override
    public KeyListener getKeyListener() {
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.popup.isVisible();
    }

    @Override
    public void uninstallingUI() {
        this.popup.removePopupMenuListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String title;
        String message;
        int returnVal;
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (!this.comboBox.isEnabled()) {
            return;
        }
        if (!this.swatchFrame.isColorGrabberSelected() && !this.moreSelected) {
            this.togglePopup();
        }
        this.moreSelected = false;
        boolean on = this.swatchFrame.isColorGrabberSelected();
        if (on && this.colorGrabberSelected && this.cg != null && (returnVal = JOptionPane.showConfirmDialog(null, message = Messages.getString("pickerwarning.txt"), title = Messages.getString("colorPicker.txt"), 0, 2)) != 0) {
            this.cg.mouseEventGenerator.dispatchEvent(new MouseEvent(this.cg.mouseEventGenerator, e.getID(), e.getWhen(), e.getModifiers(), Integer.MAX_VALUE, Integer.MAX_VALUE, e.getClickCount(), e.isPopupTrigger()));
        }
        this.colorGrabberSelected = on;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseInside = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseInside = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
            this.togglePopup();
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.hideNext = this.mouseInside;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.hideNext = false;
    }

    protected void togglePopup() {
        if (this.isVisible() || this.hideNext) {
            this.hide();
        } else {
            this.show();
        }
        this.hideNext = false;
    }

    protected void initializePopup() {
        this.swatchFrame = new SwatchFrame(this.list, this.cols, this.rows, this.cg, this.auto, this.autoValue, this.more);
        SwatchActionListener sal = new SwatchActionListener();
        this.swatchFrame.addActionListener(sal);
        this.popup = new JPopupMenu();
        this.popup.setSize(this.swatchFrame.getPreferredSize());
        this.popup.setLayout(new BorderLayout());
        this.popup.setBackground(this.background);
        this.popup.addPopupMenuListener(this);
        this.popup.add((Component)this.swatchFrame, "Center");
        this.popup.addMouseMotionListener(this.swatchFrame);
        this.popup.addMouseListener(this.swatchFrame);
        this.popup.addMouseListener(this);
    }

    protected void updatePopup() {
        if (this.list != null) {
            this.swatchFrame.setList(this.list);
        }
    }

    public JList getList() {
        return new JList<Object>(this.list);
    }

    class SwatchActionListener
    implements ActionListener {
        SwatchActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt instanceof SwatchActionEvent) {
                Object value = ((SwatchActionEvent)evt).getValue();
                String command = evt.getActionCommand();
                if (command.equalsIgnoreCase("update")) {
                    int id = evt.getID();
                    if (id == 2) {
                        SwatchPopup.this.comboBox.setSelectedItem(((SwatchFrame)evt.getSource()).more.getText());
                        SwatchPopup.this.moreSelected = true;
                    } else if (id == 4) {
                        SwatchPopup.this.comboBox.setSelectedItem(Messages.getString("colorPicker.txt"));
                        SwatchPopup.this.swatchFrame.pickingDone = true;
                    } else if (id == 3) {
                        SwatchPopup.this.comboBox.setSelectedItem(SwatchPopup.this.auto);
                    } else if (id == 1) {
                        SwatchPopup.this.comboBox.setSelectedItem(value);
                    }
                }
            }
        }
    }
}

