/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.styles.PredefinedStyles;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.styles.ui.DefaultHistogramPreview;
import com.sas.graphics.styles.ui.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SingleDirectoryStyleChooser
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    private JLabel filenameLabel = null;
    private int dialogType = 0;
    private JDialog dialog = null;
    private int returnValue = -1;
    private File directory = null;
    private JPanel centerPane = null;
    private JPanel southPane = null;
    private JList styleList = null;
    private JPanel fileNamePane = null;
    private JPanel buttonPane = null;
    private JTextField nameTextField = null;
    private JButton cancelButton = null;
    private JButton acceptButton = null;
    private javax.swing.filechooser.FileFilter filter = null;
    private File selectedFile = null;
    private DefaultHistogramPreview renderer = null;
    private StyleCollection loadedStyles = new StyleCollection();
    private JPanel rendererWrapper = null;

    public SingleDirectoryStyleChooser() {
        this.init();
    }

    public SingleDirectoryStyleChooser(File directory) {
        this.directory = directory;
        this.init();
    }

    public void setFileFilter(javax.swing.filechooser.FileFilter filter) {
        this.filter = filter;
        this.rescanCurrentDirectory();
    }

    private void init() {
        this.filter = new AcceptAllFileFilter();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.add((Component)this.getCenterPane(), "Center");
        this.add((Component)this.getSouthPane(), "South");
        this.rescanCurrentDirectory();
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JPanel(new BorderLayout());
            JScrollPane scroll = new JScrollPane(this.getFileList());
            scroll.setPreferredSize(new Dimension(425, 175));
            this.centerPane.add((Component)scroll, "Center");
        }
        return this.centerPane;
    }

    private JList getFileList() {
        if (this.styleList == null) {
            this.styleList = new JList();
            this.styleList.setSelectionMode(0);
            this.styleList.setLayoutOrientation(1);
            this.styleList.setVisibleRowCount(-1);
            this.styleList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SingleDirectoryStyleChooser.this.selectedFile = (File)SingleDirectoryStyleChooser.this.styleList.getSelectedValue();
                    SingleDirectoryStyleChooser.this.getAcceptButton().setEnabled(SingleDirectoryStyleChooser.this.getNameTextField().getText().trim().length() > 0);
                    if (SingleDirectoryStyleChooser.this.selectedFile != null) {
                        SingleDirectoryStyleChooser.this.getNameTextField().setText(SingleDirectoryStyleChooser.this.selectedFile.getName().substring(0, SingleDirectoryStyleChooser.this.selectedFile.getName().lastIndexOf(46)));
                    }
                }
            });
            this.styleList.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Style s;
                    if (SingleDirectoryStyleChooser.this.renderer == null) {
                        SingleDirectoryStyleChooser.this.renderer = new DefaultHistogramPreview();
                        SingleDirectoryStyleChooser.this.renderer.setUseStyleNameAsTitle(true);
                        SingleDirectoryStyleChooser.this.renderer.setPreferredSize(new Dimension(200, 100));
                        SingleDirectoryStyleChooser.this.rendererWrapper = new JPanel(new BorderLayout());
                        SingleDirectoryStyleChooser.this.rendererWrapper.setOpaque(true);
                        SingleDirectoryStyleChooser.this.rendererWrapper.setBackground(Color.white);
                        Border outsideBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);
                        Border insideBorder = BorderFactory.createLineBorder(Color.black);
                        SingleDirectoryStyleChooser.this.rendererWrapper.setBorder(BorderFactory.createCompoundBorder(outsideBorder, insideBorder));
                        SingleDirectoryStyleChooser.this.rendererWrapper.add((Component)SingleDirectoryStyleChooser.this.renderer, "Center");
                    }
                    if ((s = SingleDirectoryStyleChooser.this.loadedStyles.getStyleForSource(value)) == null) {
                        try {
                            s = Style.getStyle((InputStream)new FileInputStream((File)value));
                            SingleDirectoryStyleChooser.this.loadedStyles.addStyle(s, value);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    SingleDirectoryStyleChooser.this.renderer.setStyle(s);
                    return SingleDirectoryStyleChooser.this.rendererWrapper;
                }
            });
        }
        return this.styleList;
    }

    private JPanel getSouthPane() {
        if (this.southPane == null) {
            this.southPane = new JPanel(new BorderLayout());
            this.southPane.add((Component)this.getFileNamePane(), "North");
            this.southPane.add((Component)this.getButtonPane(), "South");
        }
        return this.southPane;
    }

    private JPanel getFileNamePane() {
        if (this.fileNamePane == null) {
            this.fileNamePane = new JPanel(new BorderLayout());
            this.fileNamePane.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.filenameLabel = new JLabel(Messages.getString("FileName.txt"));
            this.fileNamePane.add((Component)this.filenameLabel, "West");
            this.fileNamePane.add((Component)this.getNameTextField(), "Center");
        }
        return this.fileNamePane;
    }

    private JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
            this.nameTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SingleDirectoryStyleChooser.this.selectedFile = null;
                    boolean b = SingleDirectoryStyleChooser.this.nameTextField.getText().trim().length() > 0;
                    SingleDirectoryStyleChooser.this.getAcceptButton().setEnabled(b);
                }
            });
        }
        this.nameTextField.requestFocus();
        return this.nameTextField;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel(new FlowLayout(2));
            this.buttonPane.add(this.getAcceptButton());
            this.buttonPane.add(this.getCancelButton());
        }
        return this.buttonPane;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(Messages.getString("Cancel.txt"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SingleDirectoryStyleChooser.this.returnValue = 1;
                    if (SingleDirectoryStyleChooser.this.dialog != null) {
                        SingleDirectoryStyleChooser.this.dialog.setVisible(false);
                    }
                }
            });
        }
        return this.cancelButton;
    }

    private JButton getAcceptButton() {
        if (this.acceptButton == null) {
            this.acceptButton = new JButton();
            this.acceptButton.setEnabled(false);
            if (this.dialogType == 0) {
                this.acceptButton.setText(Messages.getString("Open.txt"));
            } else if (this.dialogType == 1) {
                this.acceptButton.setText(Messages.getString("Save.txt"));
            }
            this.acceptButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SingleDirectoryStyleChooser.this.returnValue = 0;
                    if (!PredefinedStyles.isPredefinedStyle((String)SingleDirectoryStyleChooser.this.nameTextField.getText().trim())) {
                        if (SingleDirectoryStyleChooser.this.dialog != null) {
                            SingleDirectoryStyleChooser.this.dialog.setVisible(false);
                        }
                    } else {
                        JOptionPane.showMessageDialog(SingleDirectoryStyleChooser.this.acceptButton, Messages.getString("predefinedStyleName.txt"));
                        SingleDirectoryStyleChooser.this.nameTextField.setText("");
                        SingleDirectoryStyleChooser.this.nameTextField.requestFocus();
                        SingleDirectoryStyleChooser.this.acceptButton.setEnabled(false);
                    }
                }
            });
        }
        return this.acceptButton;
    }

    public int showOpenDialog(Component parent) throws HeadlessException {
        this.setDialogType(0);
        return this.showDialog(parent);
    }

    public int showSaveDialog(Component parent) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(parent);
    }

    public void setDialogType(int dialogType) {
        if (this.dialogType == dialogType) {
            return;
        }
        if (dialogType != 0 && dialogType != 1) {
            throw new IllegalArgumentException("Incorrect Dialog Type: " + dialogType);
        }
        this.dialogType = dialogType;
    }

    public String getDialogTitle() {
        if (this.dialogType == 0) {
            return Messages.getString("OpenStyle.txt");
        }
        if (this.dialogType == 1) {
            return Messages.getString("SaveStyle.txt");
        }
        return "";
    }

    public int showDialog(Component parent) throws HeadlessException {
        this.dialog = this.createDialog(parent);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (SingleDirectoryStyleChooser.this.nameTextField != null) {
                    SingleDirectoryStyleChooser.this.nameTextField.setText("");
                    SingleDirectoryStyleChooser.this.nameTextField.requestFocus();
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SingleDirectoryStyleChooser.this.returnValue = 1;
            }
        });
        this.returnValue = -1;
        this.rescanCurrentDirectory();
        this.dialog.setVisible(true);
        this.dialog.dispose();
        this.dialog = null;
        return this.returnValue;
    }

    protected void rescanCurrentDirectory() {
        if (this.directory == null || !this.directory.exists()) {
            return;
        }
        this.getFileList().setListData(this.directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return SingleDirectoryStyleChooser.this.filter.accept(pathname);
            }
        }));
    }

    static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return SingleDirectoryStyleChooser.getWindowForComponent(parentComponent.getParent());
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        boolean supportsWindowDecorations;
        String title = this.getDialogTitle();
        Window window = SingleDirectoryStyleChooser.getWindowForComponent(parent);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        if (this.dialogType == 0) {
            this.getAcceptButton().setText(Messages.getString("Open.txt"));
        } else if (this.dialogType == 1) {
            this.getAcceptButton().setText(Messages.getString("Save.txt"));
        }
        dialog.setComponentOrientation(this.getComponentOrientation());
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.getRootPane().setWindowDecorationStyle(6);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public static void main(String[] args) {
        SingleDirectoryStyleChooser fileChooser = new SingleDirectoryStyleChooser(new File("C:/temp"));
        fileChooser.showOpenDialog(null);
        System.exit(0);
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
        this.rescanCurrentDirectory();
    }

    public File getSelectedXMLFile() {
        if (this.selectedFile != null) {
            return this.selectedFile;
        }
        String fileName = this.getNameTextField().getText();
        fileName = fileName + ".sty";
        return new File(this.directory, fileName);
    }

    public File getSelectedSASFile() {
        if (this.selectedFile != null) {
            return this.selectedFile;
        }
        String fileName = this.getNameTextField().getText();
        fileName = fileName + ".sas";
        return new File(this.directory, fileName);
    }

    protected class AcceptAllFileFilter
    extends javax.swing.filechooser.FileFilter {
        @Override
        public boolean accept(File f) {
            return true;
        }

        @Override
        public String getDescription() {
            return UIManager.getString("FileChooser.acceptAllFileFilterText");
        }
    }
}

